/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.IMultipassModel;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelBoat
extends ModelBase
implements IMultipassModel {
    public ModelRenderer[] boatSides = new ModelRenderer[5];
    public ModelRenderer[] paddles = new ModelRenderer[2];
    public ModelRenderer noWater;
    private final int patchList = GLAllocation.generateDisplayLists(1);

    public ModelBoat() {
        this.boatSides[0] = new ModelRenderer(this, 0, 0).setTextureSize(128, 64);
        this.boatSides[1] = new ModelRenderer(this, 0, 19).setTextureSize(128, 64);
        this.boatSides[2] = new ModelRenderer(this, 0, 27).setTextureSize(128, 64);
        this.boatSides[3] = new ModelRenderer(this, 0, 35).setTextureSize(128, 64);
        this.boatSides[4] = new ModelRenderer(this, 0, 43).setTextureSize(128, 64);
        int lvt_1_1_ = 32;
        int lvt_2_1_ = 6;
        int lvt_3_1_ = 20;
        int lvt_4_1_ = 4;
        int lvt_5_1_ = 28;
        this.boatSides[0].addBox(-14.0f, -9.0f, -3.0f, 28, 16, 3, 0.0f);
        this.boatSides[0].setRotationPoint(0.0f, 3.0f, 1.0f);
        this.boatSides[1].addBox(-13.0f, -7.0f, -1.0f, 18, 6, 2, 0.0f);
        this.boatSides[1].setRotationPoint(-15.0f, 4.0f, 4.0f);
        this.boatSides[2].addBox(-8.0f, -7.0f, -1.0f, 16, 6, 2, 0.0f);
        this.boatSides[2].setRotationPoint(15.0f, 4.0f, 0.0f);
        this.boatSides[3].addBox(-14.0f, -7.0f, -1.0f, 28, 6, 2, 0.0f);
        this.boatSides[3].setRotationPoint(0.0f, 4.0f, -9.0f);
        this.boatSides[4].addBox(-14.0f, -7.0f, -1.0f, 28, 6, 2, 0.0f);
        this.boatSides[4].setRotationPoint(0.0f, 4.0f, 9.0f);
        this.boatSides[0].rotateAngleX = 1.5707964f;
        this.boatSides[1].rotateAngleY = 4.712389f;
        this.boatSides[2].rotateAngleY = 1.5707964f;
        this.boatSides[3].rotateAngleY = (float)Math.PI;
        this.paddles[0] = this.makePaddle(true);
        this.paddles[0].setRotationPoint(3.0f, -5.0f, 9.0f);
        this.paddles[1] = this.makePaddle(false);
        this.paddles[1].setRotationPoint(3.0f, -5.0f, -9.0f);
        this.paddles[1].rotateAngleY = (float)Math.PI;
        this.paddles[0].rotateAngleZ = 0.19634955f;
        this.paddles[1].rotateAngleZ = 0.19634955f;
        this.noWater = new ModelRenderer(this, 0, 0).setTextureSize(128, 64);
        this.noWater.addBox(-14.0f, -9.0f, -3.0f, 28, 16, 3, 0.0f);
        this.noWater.setRotationPoint(0.0f, -3.0f, 1.0f);
        this.noWater.rotateAngleX = 1.5707964f;
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        EntityBoat lvt_8_1_ = (EntityBoat)p_render_1_;
        this.setRotationAngles(p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_, p_render_1_);
        for (int lvt_9_1_ = 0; lvt_9_1_ < 5; ++lvt_9_1_) {
            this.boatSides[lvt_9_1_].render(p_render_7_);
        }
        this.renderPaddle(lvt_8_1_, 0, p_render_7_, p_render_2_);
        this.renderPaddle(lvt_8_1_, 1, p_render_7_, p_render_2_);
    }

    @Override
    public void renderMultipass(Entity p_renderMultipass_1_, float p_renderMultipass_2_, float p_renderMultipass_3_, float p_renderMultipass_4_, float p_renderMultipass_5_, float p_renderMultipass_6_, float p_renderMultipass_7_) {
        GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.colorMask(false, false, false, false);
        this.noWater.render(p_renderMultipass_7_);
        GlStateManager.colorMask(true, true, true, true);
    }

    protected ModelRenderer makePaddle(boolean p_makePaddle_1_) {
        ModelRenderer lvt_2_1_ = new ModelRenderer(this, 62, p_makePaddle_1_ ? 0 : 20).setTextureSize(128, 64);
        int lvt_3_1_ = 20;
        int lvt_4_1_ = 7;
        int lvt_5_1_ = 6;
        float lvt_6_1_ = -5.0f;
        lvt_2_1_.addBox(-1.0f, 0.0f, -5.0f, 2, 2, 18);
        lvt_2_1_.addBox(p_makePaddle_1_ ? -1.001f : 0.001f, -3.0f, 8.0f, 1, 6, 7);
        return lvt_2_1_;
    }

    protected void renderPaddle(EntityBoat p_renderPaddle_1_, int p_renderPaddle_2_, float p_renderPaddle_3_, float p_renderPaddle_4_) {
        float lvt_5_1_ = 40.0f;
        float lvt_6_1_ = p_renderPaddle_1_.getRowingTime(p_renderPaddle_2_, p_renderPaddle_4_) * 40.0f;
        ModelRenderer lvt_7_1_ = this.paddles[p_renderPaddle_2_];
        lvt_7_1_.rotateAngleX = (float)MathHelper.clampedLerp(-1.0471975803375244, -0.2617993950843811, (MathHelper.sin(-lvt_6_1_) + 1.0f) / 2.0f);
        lvt_7_1_.rotateAngleY = (float)MathHelper.clampedLerp(-0.7853981852531433, 0.7853981852531433, (MathHelper.sin(-lvt_6_1_ + 1.0f) + 1.0f) / 2.0f);
        if (p_renderPaddle_2_ == 1) {
            lvt_7_1_.rotateAngleY = (float)Math.PI - lvt_7_1_.rotateAngleY;
        }
        lvt_7_1_.render(p_renderPaddle_3_);
    }
}

