/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelBook
extends ModelBase {
    public ModelRenderer coverRight = new ModelRenderer(this).setTextureOffset(0, 0).addBox(-6.0f, -5.0f, 0.0f, 6, 10, 0);
    public ModelRenderer coverLeft = new ModelRenderer(this).setTextureOffset(16, 0).addBox(0.0f, -5.0f, 0.0f, 6, 10, 0);
    public ModelRenderer pagesRight;
    public ModelRenderer pagesLeft;
    public ModelRenderer flippingPageRight;
    public ModelRenderer flippingPageLeft;
    public ModelRenderer bookSpine = new ModelRenderer(this).setTextureOffset(12, 0).addBox(-1.0f, -5.0f, 0.0f, 2, 10, 0);

    public ModelBook() {
        this.pagesRight = new ModelRenderer(this).setTextureOffset(0, 10).addBox(0.0f, -4.0f, -0.99f, 5, 8, 1);
        this.pagesLeft = new ModelRenderer(this).setTextureOffset(12, 10).addBox(0.0f, -4.0f, -0.01f, 5, 8, 1);
        this.flippingPageRight = new ModelRenderer(this).setTextureOffset(24, 10).addBox(0.0f, -4.0f, 0.0f, 5, 8, 0);
        this.flippingPageLeft = new ModelRenderer(this).setTextureOffset(24, 10).addBox(0.0f, -4.0f, 0.0f, 5, 8, 0);
        this.coverRight.setRotationPoint(0.0f, 0.0f, -1.0f);
        this.coverLeft.setRotationPoint(0.0f, 0.0f, 1.0f);
        this.bookSpine.rotateAngleY = 1.5707964f;
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        this.setRotationAngles(p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_, p_render_1_);
        this.coverRight.render(p_render_7_);
        this.coverLeft.render(p_render_7_);
        this.bookSpine.render(p_render_7_);
        this.pagesRight.render(p_render_7_);
        this.pagesLeft.render(p_render_7_);
        this.flippingPageRight.render(p_render_7_);
        this.flippingPageLeft.render(p_render_7_);
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        float lvt_8_1_ = (MathHelper.sin(p_setRotationAngles_1_ * 0.02f) * 0.1f + 1.25f) * p_setRotationAngles_4_;
        this.coverRight.rotateAngleY = (float)Math.PI + lvt_8_1_;
        this.coverLeft.rotateAngleY = -lvt_8_1_;
        this.pagesRight.rotateAngleY = lvt_8_1_;
        this.pagesLeft.rotateAngleY = -lvt_8_1_;
        this.flippingPageRight.rotateAngleY = lvt_8_1_ - lvt_8_1_ * 2.0f * p_setRotationAngles_2_;
        this.flippingPageLeft.rotateAngleY = lvt_8_1_ - lvt_8_1_ * 2.0f * p_setRotationAngles_3_;
        this.pagesRight.rotationPointX = MathHelper.sin(lvt_8_1_);
        this.pagesLeft.rotationPointX = MathHelper.sin(lvt_8_1_);
        this.flippingPageRight.rotationPointX = MathHelper.sin(lvt_8_1_);
        this.flippingPageLeft.rotationPointX = MathHelper.sin(lvt_8_1_);
    }
}

