/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelDragon
extends ModelBase {
    private final ModelRenderer head;
    private final ModelRenderer spine;
    private final ModelRenderer jaw;
    private final ModelRenderer body;
    private final ModelRenderer rearLeg;
    private final ModelRenderer frontLeg;
    private final ModelRenderer rearLegTip;
    private final ModelRenderer frontLegTip;
    private final ModelRenderer rearFoot;
    private final ModelRenderer frontFoot;
    private final ModelRenderer wing;
    private final ModelRenderer wingTip;
    private float partialTicks;

    public ModelDragon(float p_i46360_1_) {
        this.textureWidth = 256;
        this.textureHeight = 256;
        this.setTextureOffset("body.body", 0, 0);
        this.setTextureOffset("wing.skin", -56, 88);
        this.setTextureOffset("wingtip.skin", -56, 144);
        this.setTextureOffset("rearleg.main", 0, 0);
        this.setTextureOffset("rearfoot.main", 112, 0);
        this.setTextureOffset("rearlegtip.main", 196, 0);
        this.setTextureOffset("head.upperhead", 112, 30);
        this.setTextureOffset("wing.bone", 112, 88);
        this.setTextureOffset("head.upperlip", 176, 44);
        this.setTextureOffset("jaw.jaw", 176, 65);
        this.setTextureOffset("frontleg.main", 112, 104);
        this.setTextureOffset("wingtip.bone", 112, 136);
        this.setTextureOffset("frontfoot.main", 144, 104);
        this.setTextureOffset("neck.box", 192, 104);
        this.setTextureOffset("frontlegtip.main", 226, 138);
        this.setTextureOffset("body.scale", 220, 53);
        this.setTextureOffset("head.scale", 0, 0);
        this.setTextureOffset("neck.scale", 48, 0);
        this.setTextureOffset("head.nostril", 112, 0);
        float lvt_2_1_ = -16.0f;
        this.head = new ModelRenderer(this, "head");
        this.head.addBox("upperlip", -6.0f, -1.0f, -24.0f, 12, 5, 16);
        this.head.addBox("upperhead", -8.0f, -8.0f, -10.0f, 16, 16, 16);
        this.head.mirror = true;
        this.head.addBox("scale", -5.0f, -12.0f, -4.0f, 2, 4, 6);
        this.head.addBox("nostril", -5.0f, -3.0f, -22.0f, 2, 2, 4);
        this.head.mirror = false;
        this.head.addBox("scale", 3.0f, -12.0f, -4.0f, 2, 4, 6);
        this.head.addBox("nostril", 3.0f, -3.0f, -22.0f, 2, 2, 4);
        this.jaw = new ModelRenderer(this, "jaw");
        this.jaw.setRotationPoint(0.0f, 4.0f, -8.0f);
        this.jaw.addBox("jaw", -6.0f, 0.0f, -16.0f, 12, 4, 16);
        this.head.addChild(this.jaw);
        this.spine = new ModelRenderer(this, "neck");
        this.spine.addBox("box", -5.0f, -5.0f, -5.0f, 10, 10, 10);
        this.spine.addBox("scale", -1.0f, -9.0f, -3.0f, 2, 4, 6);
        this.body = new ModelRenderer(this, "body");
        this.body.setRotationPoint(0.0f, 4.0f, 8.0f);
        this.body.addBox("body", -12.0f, 0.0f, -16.0f, 24, 24, 64);
        this.body.addBox("scale", -1.0f, -6.0f, -10.0f, 2, 6, 12);
        this.body.addBox("scale", -1.0f, -6.0f, 10.0f, 2, 6, 12);
        this.body.addBox("scale", -1.0f, -6.0f, 30.0f, 2, 6, 12);
        this.wing = new ModelRenderer(this, "wing");
        this.wing.setRotationPoint(-12.0f, 5.0f, 2.0f);
        this.wing.addBox("bone", -56.0f, -4.0f, -4.0f, 56, 8, 8);
        this.wing.addBox("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56);
        this.wingTip = new ModelRenderer(this, "wingtip");
        this.wingTip.setRotationPoint(-56.0f, 0.0f, 0.0f);
        this.wingTip.addBox("bone", -56.0f, -2.0f, -2.0f, 56, 4, 4);
        this.wingTip.addBox("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56);
        this.wing.addChild(this.wingTip);
        this.frontLeg = new ModelRenderer(this, "frontleg");
        this.frontLeg.setRotationPoint(-12.0f, 20.0f, 2.0f);
        this.frontLeg.addBox("main", -4.0f, -4.0f, -4.0f, 8, 24, 8);
        this.frontLegTip = new ModelRenderer(this, "frontlegtip");
        this.frontLegTip.setRotationPoint(0.0f, 20.0f, -1.0f);
        this.frontLegTip.addBox("main", -3.0f, -1.0f, -3.0f, 6, 24, 6);
        this.frontLeg.addChild(this.frontLegTip);
        this.frontFoot = new ModelRenderer(this, "frontfoot");
        this.frontFoot.setRotationPoint(0.0f, 23.0f, 0.0f);
        this.frontFoot.addBox("main", -4.0f, 0.0f, -12.0f, 8, 4, 16);
        this.frontLegTip.addChild(this.frontFoot);
        this.rearLeg = new ModelRenderer(this, "rearleg");
        this.rearLeg.setRotationPoint(-16.0f, 16.0f, 42.0f);
        this.rearLeg.addBox("main", -8.0f, -4.0f, -8.0f, 16, 32, 16);
        this.rearLegTip = new ModelRenderer(this, "rearlegtip");
        this.rearLegTip.setRotationPoint(0.0f, 32.0f, -4.0f);
        this.rearLegTip.addBox("main", -6.0f, -2.0f, 0.0f, 12, 32, 12);
        this.rearLeg.addChild(this.rearLegTip);
        this.rearFoot = new ModelRenderer(this, "rearfoot");
        this.rearFoot.setRotationPoint(0.0f, 31.0f, 4.0f);
        this.rearFoot.addBox("main", -9.0f, 0.0f, -20.0f, 18, 6, 24);
        this.rearLegTip.addChild(this.rearFoot);
    }

    @Override
    public void setLivingAnimations(EntityLivingBase p_setLivingAnimations_1_, float p_setLivingAnimations_2_, float p_setLivingAnimations_3_, float p_setLivingAnimations_4_) {
        this.partialTicks = p_setLivingAnimations_4_;
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        GlStateManager.pushMatrix();
        EntityDragon lvt_8_1_ = (EntityDragon)p_render_1_;
        float lvt_9_1_ = lvt_8_1_.prevAnimTime + (lvt_8_1_.animTime - lvt_8_1_.prevAnimTime) * this.partialTicks;
        this.jaw.rotateAngleX = (float)(Math.sin(lvt_9_1_ * ((float)Math.PI * 2)) + 1.0) * 0.2f;
        float lvt_10_1_ = (float)(Math.sin(lvt_9_1_ * ((float)Math.PI * 2) - 1.0f) + 1.0);
        lvt_10_1_ = (lvt_10_1_ * lvt_10_1_ + lvt_10_1_ * 2.0f) * 0.05f;
        GlStateManager.translate(0.0f, lvt_10_1_ - 2.0f, -3.0f);
        GlStateManager.rotate(lvt_10_1_ * 2.0f, 1.0f, 0.0f, 0.0f);
        float lvt_11_1_ = -30.0f;
        float lvt_13_1_ = 0.0f;
        float lvt_14_1_ = 1.5f;
        double[] lvt_15_1_ = lvt_8_1_.getMovementOffsets(6, this.partialTicks);
        float lvt_16_1_ = this.updateRotations(lvt_8_1_.getMovementOffsets(5, this.partialTicks)[0] - lvt_8_1_.getMovementOffsets(10, this.partialTicks)[0]);
        float lvt_17_1_ = this.updateRotations(lvt_8_1_.getMovementOffsets(5, this.partialTicks)[0] + (double)(lvt_16_1_ / 2.0f));
        float lvt_18_1_ = lvt_9_1_ * ((float)Math.PI * 2);
        lvt_11_1_ = 20.0f;
        float lvt_12_1_ = -12.0f;
        for (int lvt_19_1_ = 0; lvt_19_1_ < 5; ++lvt_19_1_) {
            double[] lvt_20_1_ = lvt_8_1_.getMovementOffsets(5 - lvt_19_1_, this.partialTicks);
            float lvt_21_1_ = (float)Math.cos((float)lvt_19_1_ * 0.45f + lvt_18_1_) * 0.15f;
            this.spine.rotateAngleY = this.updateRotations(lvt_20_1_[0] - lvt_15_1_[0]) * ((float)Math.PI / 180) * 1.5f;
            this.spine.rotateAngleX = lvt_21_1_ + lvt_8_1_.getHeadPartYOffset(lvt_19_1_, lvt_15_1_, lvt_20_1_) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            this.spine.rotateAngleZ = -this.updateRotations(lvt_20_1_[0] - (double)lvt_17_1_) * ((float)Math.PI / 180) * 1.5f;
            this.spine.rotationPointY = lvt_11_1_;
            this.spine.rotationPointZ = lvt_12_1_;
            this.spine.rotationPointX = lvt_13_1_;
            lvt_11_1_ = (float)((double)lvt_11_1_ + Math.sin(this.spine.rotateAngleX) * 10.0);
            lvt_12_1_ = (float)((double)lvt_12_1_ - Math.cos(this.spine.rotateAngleY) * Math.cos(this.spine.rotateAngleX) * 10.0);
            lvt_13_1_ = (float)((double)lvt_13_1_ - Math.sin(this.spine.rotateAngleY) * Math.cos(this.spine.rotateAngleX) * 10.0);
            this.spine.render(p_render_7_);
        }
        this.head.rotationPointY = lvt_11_1_;
        this.head.rotationPointZ = lvt_12_1_;
        this.head.rotationPointX = lvt_13_1_;
        double[] lvt_19_2_ = lvt_8_1_.getMovementOffsets(0, this.partialTicks);
        this.head.rotateAngleY = this.updateRotations(lvt_19_2_[0] - lvt_15_1_[0]) * ((float)Math.PI / 180);
        this.head.rotateAngleX = this.updateRotations(lvt_8_1_.getHeadPartYOffset(6, lvt_15_1_, lvt_19_2_)) * ((float)Math.PI / 180) * 1.5f * 5.0f;
        this.head.rotateAngleZ = -this.updateRotations(lvt_19_2_[0] - (double)lvt_17_1_) * ((float)Math.PI / 180);
        this.head.render(p_render_7_);
        GlStateManager.pushMatrix();
        GlStateManager.translate(0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(-lvt_16_1_ * 1.5f, 0.0f, 0.0f, 1.0f);
        GlStateManager.translate(0.0f, -1.0f, 0.0f);
        this.body.rotateAngleZ = 0.0f;
        this.body.render(p_render_7_);
        for (int lvt_20_2_ = 0; lvt_20_2_ < 2; ++lvt_20_2_) {
            GlStateManager.enableCull();
            float lvt_21_2_ = lvt_9_1_ * ((float)Math.PI * 2);
            this.wing.rotateAngleX = 0.125f - (float)Math.cos(lvt_21_2_) * 0.2f;
            this.wing.rotateAngleY = 0.25f;
            this.wing.rotateAngleZ = (float)(Math.sin(lvt_21_2_) + 0.125) * 0.8f;
            this.wingTip.rotateAngleZ = -((float)(Math.sin(lvt_21_2_ + 2.0f) + 0.5)) * 0.75f;
            this.rearLeg.rotateAngleX = 1.0f + lvt_10_1_ * 0.1f;
            this.rearLegTip.rotateAngleX = 0.5f + lvt_10_1_ * 0.1f;
            this.rearFoot.rotateAngleX = 0.75f + lvt_10_1_ * 0.1f;
            this.frontLeg.rotateAngleX = 1.3f + lvt_10_1_ * 0.1f;
            this.frontLegTip.rotateAngleX = -0.5f - lvt_10_1_ * 0.1f;
            this.frontFoot.rotateAngleX = 0.75f + lvt_10_1_ * 0.1f;
            this.wing.render(p_render_7_);
            this.frontLeg.render(p_render_7_);
            this.rearLeg.render(p_render_7_);
            GlStateManager.scale(-1.0f, 1.0f, 1.0f);
            if (lvt_20_2_ != 0) continue;
            GlStateManager.cullFace(GlStateManager.CullFace.FRONT);
        }
        GlStateManager.popMatrix();
        GlStateManager.cullFace(GlStateManager.CullFace.BACK);
        GlStateManager.disableCull();
        float lvt_20_3_ = -((float)Math.sin(lvt_9_1_ * ((float)Math.PI * 2))) * 0.0f;
        lvt_18_1_ = lvt_9_1_ * ((float)Math.PI * 2);
        lvt_11_1_ = 10.0f;
        lvt_12_1_ = 60.0f;
        lvt_13_1_ = 0.0f;
        lvt_15_1_ = lvt_8_1_.getMovementOffsets(11, this.partialTicks);
        for (int lvt_21_3_ = 0; lvt_21_3_ < 12; ++lvt_21_3_) {
            lvt_19_2_ = lvt_8_1_.getMovementOffsets(12 + lvt_21_3_, this.partialTicks);
            lvt_20_3_ = (float)((double)lvt_20_3_ + Math.sin((float)lvt_21_3_ * 0.45f + lvt_18_1_) * (double)0.05f);
            this.spine.rotateAngleY = (this.updateRotations(lvt_19_2_[0] - lvt_15_1_[0]) * 1.5f + 180.0f) * ((float)Math.PI / 180);
            this.spine.rotateAngleX = lvt_20_3_ + (float)(lvt_19_2_[1] - lvt_15_1_[1]) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            this.spine.rotateAngleZ = this.updateRotations(lvt_19_2_[0] - (double)lvt_17_1_) * ((float)Math.PI / 180) * 1.5f;
            this.spine.rotationPointY = lvt_11_1_;
            this.spine.rotationPointZ = lvt_12_1_;
            this.spine.rotationPointX = lvt_13_1_;
            lvt_11_1_ = (float)((double)lvt_11_1_ + Math.sin(this.spine.rotateAngleX) * 10.0);
            lvt_12_1_ = (float)((double)lvt_12_1_ - Math.cos(this.spine.rotateAngleY) * Math.cos(this.spine.rotateAngleX) * 10.0);
            lvt_13_1_ = (float)((double)lvt_13_1_ - Math.sin(this.spine.rotateAngleY) * Math.cos(this.spine.rotateAngleX) * 10.0);
            this.spine.render(p_render_7_);
        }
        GlStateManager.popMatrix();
    }

    private float updateRotations(double p_updateRotations_1_) {
        while (p_updateRotations_1_ >= 180.0) {
            p_updateRotations_1_ -= 360.0;
        }
        while (p_updateRotations_1_ < -180.0) {
            p_updateRotations_1_ += 360.0;
        }
        return (float)p_updateRotations_1_;
    }
}

