/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelEnderMite
extends ModelBase {
    private static final int[][] BODY_SIZES = new int[][]{{4, 3, 2}, {6, 4, 5}, {3, 3, 1}, {1, 2, 1}};
    private static final int[][] BODY_TEXS = new int[][]{{0, 0}, {0, 5}, {0, 14}, {0, 18}};
    private static final int BODY_COUNT = BODY_SIZES.length;
    private final ModelRenderer[] bodyParts = new ModelRenderer[BODY_COUNT];

    public ModelEnderMite() {
        float lvt_1_1_ = -3.5f;
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.bodyParts.length; ++lvt_2_1_) {
            this.bodyParts[lvt_2_1_] = new ModelRenderer(this, BODY_TEXS[lvt_2_1_][0], BODY_TEXS[lvt_2_1_][1]);
            this.bodyParts[lvt_2_1_].addBox((float)BODY_SIZES[lvt_2_1_][0] * -0.5f, 0.0f, (float)BODY_SIZES[lvt_2_1_][2] * -0.5f, BODY_SIZES[lvt_2_1_][0], BODY_SIZES[lvt_2_1_][1], BODY_SIZES[lvt_2_1_][2]);
            this.bodyParts[lvt_2_1_].setRotationPoint(0.0f, 24 - BODY_SIZES[lvt_2_1_][1], lvt_1_1_);
            if (lvt_2_1_ >= this.bodyParts.length - 1) continue;
            lvt_1_1_ += (float)(BODY_SIZES[lvt_2_1_][2] + BODY_SIZES[lvt_2_1_ + 1][2]) * 0.5f;
        }
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        this.setRotationAngles(p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_, p_render_1_);
        for (ModelRenderer lvt_11_1_ : this.bodyParts) {
            lvt_11_1_.render(p_render_7_);
        }
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        for (int lvt_8_1_ = 0; lvt_8_1_ < this.bodyParts.length; ++lvt_8_1_) {
            this.bodyParts[lvt_8_1_].rotateAngleY = MathHelper.cos(p_setRotationAngles_3_ * 0.9f + (float)lvt_8_1_ * 0.15f * (float)Math.PI) * (float)Math.PI * 0.01f * (float)(1 + Math.abs(lvt_8_1_ - 2));
            this.bodyParts[lvt_8_1_].rotationPointX = MathHelper.sin(p_setRotationAngles_3_ * 0.9f + (float)lvt_8_1_ * 0.15f * (float)Math.PI) * (float)Math.PI * 0.1f * (float)Math.abs(lvt_8_1_ - 2);
        }
    }
}

