/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelGuardian
extends ModelBase {
    private final ModelRenderer guardianBody;
    private final ModelRenderer guardianEye;
    private final ModelRenderer[] guardianSpines;
    private final ModelRenderer[] guardianTail;

    public ModelGuardian() {
        this.textureWidth = 64;
        this.textureHeight = 64;
        this.guardianSpines = new ModelRenderer[12];
        this.guardianBody = new ModelRenderer(this);
        this.guardianBody.setTextureOffset(0, 0).addBox(-6.0f, 10.0f, -8.0f, 12, 12, 16);
        this.guardianBody.setTextureOffset(0, 28).addBox(-8.0f, 10.0f, -6.0f, 2, 12, 12);
        this.guardianBody.setTextureOffset(0, 28).addBox(6.0f, 10.0f, -6.0f, 2, 12, 12, true);
        this.guardianBody.setTextureOffset(16, 40).addBox(-6.0f, 8.0f, -6.0f, 12, 2, 12);
        this.guardianBody.setTextureOffset(16, 40).addBox(-6.0f, 22.0f, -6.0f, 12, 2, 12);
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.guardianSpines.length; ++lvt_1_1_) {
            this.guardianSpines[lvt_1_1_] = new ModelRenderer(this, 0, 0);
            this.guardianSpines[lvt_1_1_].addBox(-1.0f, -4.5f, -1.0f, 2, 9, 2);
            this.guardianBody.addChild(this.guardianSpines[lvt_1_1_]);
        }
        this.guardianEye = new ModelRenderer(this, 8, 0);
        this.guardianEye.addBox(-1.0f, 15.0f, 0.0f, 2, 2, 1);
        this.guardianBody.addChild(this.guardianEye);
        this.guardianTail = new ModelRenderer[3];
        this.guardianTail[0] = new ModelRenderer(this, 40, 0);
        this.guardianTail[0].addBox(-2.0f, 14.0f, 7.0f, 4, 4, 8);
        this.guardianTail[1] = new ModelRenderer(this, 0, 54);
        this.guardianTail[1].addBox(0.0f, 14.0f, 0.0f, 3, 3, 7);
        this.guardianTail[2] = new ModelRenderer(this);
        this.guardianTail[2].setTextureOffset(41, 32).addBox(0.0f, 14.0f, 0.0f, 2, 2, 6);
        this.guardianTail[2].setTextureOffset(25, 19).addBox(1.0f, 10.5f, 3.0f, 1, 9, 9);
        this.guardianBody.addChild(this.guardianTail[0]);
        this.guardianTail[0].addChild(this.guardianTail[1]);
        this.guardianTail[1].addChild(this.guardianTail[2]);
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        this.setRotationAngles(p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_, p_render_1_);
        this.guardianBody.render(p_render_7_);
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        EntityGuardian lvt_8_1_ = (EntityGuardian)p_setRotationAngles_7_;
        float lvt_9_1_ = p_setRotationAngles_3_ - (float)lvt_8_1_.ticksExisted;
        this.guardianBody.rotateAngleY = p_setRotationAngles_4_ * ((float)Math.PI / 180);
        this.guardianBody.rotateAngleX = p_setRotationAngles_5_ * ((float)Math.PI / 180);
        float[] lvt_10_1_ = new float[]{1.75f, 0.25f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f, 1.25f, 0.75f, 0.0f, 0.0f};
        float[] lvt_11_1_ = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.25f, 1.75f, 1.25f, 0.75f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] lvt_12_1_ = new float[]{0.0f, 0.0f, 0.25f, 1.75f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.75f, 1.25f};
        float[] lvt_13_1_ = new float[]{0.0f, 0.0f, 8.0f, -8.0f, -8.0f, 8.0f, 8.0f, -8.0f, 0.0f, 0.0f, 8.0f, -8.0f};
        float[] lvt_14_1_ = new float[]{-8.0f, -8.0f, -8.0f, -8.0f, 0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f};
        float[] lvt_15_1_ = new float[]{8.0f, -8.0f, 0.0f, 0.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, -8.0f, 0.0f, 0.0f};
        float lvt_16_1_ = (1.0f - lvt_8_1_.getSpikesAnimation(lvt_9_1_)) * 0.55f;
        for (int lvt_17_1_ = 0; lvt_17_1_ < 12; ++lvt_17_1_) {
            this.guardianSpines[lvt_17_1_].rotateAngleX = (float)Math.PI * lvt_10_1_[lvt_17_1_];
            this.guardianSpines[lvt_17_1_].rotateAngleY = (float)Math.PI * lvt_11_1_[lvt_17_1_];
            this.guardianSpines[lvt_17_1_].rotateAngleZ = (float)Math.PI * lvt_12_1_[lvt_17_1_];
            this.guardianSpines[lvt_17_1_].rotationPointX = lvt_13_1_[lvt_17_1_] * (1.0f + MathHelper.cos(p_setRotationAngles_3_ * 1.5f + (float)lvt_17_1_) * 0.01f - lvt_16_1_);
            this.guardianSpines[lvt_17_1_].rotationPointY = 16.0f + lvt_14_1_[lvt_17_1_] * (1.0f + MathHelper.cos(p_setRotationAngles_3_ * 1.5f + (float)lvt_17_1_) * 0.01f - lvt_16_1_);
            this.guardianSpines[lvt_17_1_].rotationPointZ = lvt_15_1_[lvt_17_1_] * (1.0f + MathHelper.cos(p_setRotationAngles_3_ * 1.5f + (float)lvt_17_1_) * 0.01f - lvt_16_1_);
        }
        this.guardianEye.rotationPointZ = -8.25f;
        Entity lvt_17_2_ = Minecraft.getMinecraft().getRenderViewEntity();
        if (lvt_8_1_.hasTargetedEntity()) {
            lvt_17_2_ = lvt_8_1_.getTargetedEntity();
        }
        if (lvt_17_2_ != null) {
            Vec3d lvt_18_1_ = lvt_17_2_.getPositionEyes(0.0f);
            Vec3d lvt_19_1_ = p_setRotationAngles_7_.getPositionEyes(0.0f);
            double lvt_20_1_ = lvt_18_1_.yCoord - lvt_19_1_.yCoord;
            this.guardianEye.rotationPointY = lvt_20_1_ > 0.0 ? 0.0f : 1.0f;
            Vec3d lvt_22_1_ = p_setRotationAngles_7_.getLook(0.0f);
            lvt_22_1_ = new Vec3d(lvt_22_1_.xCoord, 0.0, lvt_22_1_.zCoord);
            Vec3d lvt_23_1_ = new Vec3d(lvt_19_1_.xCoord - lvt_18_1_.xCoord, 0.0, lvt_19_1_.zCoord - lvt_18_1_.zCoord).normalize().rotateYaw(1.5707964f);
            double lvt_24_1_ = lvt_22_1_.dotProduct(lvt_23_1_);
            this.guardianEye.rotationPointX = MathHelper.sqrt((float)Math.abs(lvt_24_1_)) * 2.0f * (float)Math.signum(lvt_24_1_);
        }
        this.guardianEye.showModel = true;
        float lvt_18_2_ = lvt_8_1_.getTailAnimation(lvt_9_1_);
        this.guardianTail[0].rotateAngleY = MathHelper.sin(lvt_18_2_) * (float)Math.PI * 0.05f;
        this.guardianTail[1].rotateAngleY = MathHelper.sin(lvt_18_2_) * (float)Math.PI * 0.1f;
        this.guardianTail[1].rotationPointX = -1.5f;
        this.guardianTail[1].rotationPointY = 0.5f;
        this.guardianTail[1].rotationPointZ = 14.0f;
        this.guardianTail[2].rotateAngleY = MathHelper.sin(lvt_18_2_) * (float)Math.PI * 0.15f;
        this.guardianTail[2].rotationPointX = 0.5f;
        this.guardianTail[2].rotationPointY = 0.5f;
        this.guardianTail[2].rotationPointZ = 6.0f;
    }
}

