/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelHorse
extends ModelBase {
    private final ModelRenderer head;
    private final ModelRenderer upperMouth;
    private final ModelRenderer lowerMouth;
    private final ModelRenderer horseLeftEar;
    private final ModelRenderer horseRightEar;
    private final ModelRenderer muleLeftEar;
    private final ModelRenderer muleRightEar;
    private final ModelRenderer neck;
    private final ModelRenderer horseFaceRopes;
    private final ModelRenderer mane;
    private final ModelRenderer body;
    private final ModelRenderer tailBase;
    private final ModelRenderer tailMiddle;
    private final ModelRenderer tailTip;
    private final ModelRenderer backLeftLeg;
    private final ModelRenderer backLeftShin;
    private final ModelRenderer backLeftHoof;
    private final ModelRenderer backRightLeg;
    private final ModelRenderer backRightShin;
    private final ModelRenderer backRightHoof;
    private final ModelRenderer frontLeftLeg;
    private final ModelRenderer frontLeftShin;
    private final ModelRenderer frontLeftHoof;
    private final ModelRenderer frontRightLeg;
    private final ModelRenderer frontRightShin;
    private final ModelRenderer frontRightHoof;
    private final ModelRenderer muleLeftChest;
    private final ModelRenderer muleRightChest;
    private final ModelRenderer horseSaddleBottom;
    private final ModelRenderer horseSaddleFront;
    private final ModelRenderer horseSaddleBack;
    private final ModelRenderer horseLeftSaddleRope;
    private final ModelRenderer horseLeftSaddleMetal;
    private final ModelRenderer horseRightSaddleRope;
    private final ModelRenderer horseRightSaddleMetal;
    private final ModelRenderer horseLeftFaceMetal;
    private final ModelRenderer horseRightFaceMetal;
    private final ModelRenderer horseLeftRein;
    private final ModelRenderer horseRightRein;

    public ModelHorse() {
        this.textureWidth = 128;
        this.textureHeight = 128;
        this.body = new ModelRenderer(this, 0, 34);
        this.body.addBox(-5.0f, -8.0f, -19.0f, 10, 10, 24);
        this.body.setRotationPoint(0.0f, 11.0f, 9.0f);
        this.tailBase = new ModelRenderer(this, 44, 0);
        this.tailBase.addBox(-1.0f, -1.0f, 0.0f, 2, 2, 3);
        this.tailBase.setRotationPoint(0.0f, 3.0f, 14.0f);
        this.tailBase.rotateAngleX = -1.134464f;
        this.tailMiddle = new ModelRenderer(this, 38, 7);
        this.tailMiddle.addBox(-1.5f, -2.0f, 3.0f, 3, 4, 7);
        this.tailMiddle.setRotationPoint(0.0f, 3.0f, 14.0f);
        this.tailMiddle.rotateAngleX = -1.134464f;
        this.tailTip = new ModelRenderer(this, 24, 3);
        this.tailTip.addBox(-1.5f, -4.5f, 9.0f, 3, 4, 7);
        this.tailTip.setRotationPoint(0.0f, 3.0f, 14.0f);
        this.tailTip.rotateAngleX = -1.3962634f;
        this.backLeftLeg = new ModelRenderer(this, 78, 29);
        this.backLeftLeg.addBox(-2.5f, -2.0f, -2.5f, 4, 9, 5);
        this.backLeftLeg.setRotationPoint(4.0f, 9.0f, 11.0f);
        this.backLeftShin = new ModelRenderer(this, 78, 43);
        this.backLeftShin.addBox(-2.0f, 0.0f, -1.5f, 3, 5, 3);
        this.backLeftShin.setRotationPoint(4.0f, 16.0f, 11.0f);
        this.backLeftHoof = new ModelRenderer(this, 78, 51);
        this.backLeftHoof.addBox(-2.5f, 5.1f, -2.0f, 4, 3, 4);
        this.backLeftHoof.setRotationPoint(4.0f, 16.0f, 11.0f);
        this.backRightLeg = new ModelRenderer(this, 96, 29);
        this.backRightLeg.addBox(-1.5f, -2.0f, -2.5f, 4, 9, 5);
        this.backRightLeg.setRotationPoint(-4.0f, 9.0f, 11.0f);
        this.backRightShin = new ModelRenderer(this, 96, 43);
        this.backRightShin.addBox(-1.0f, 0.0f, -1.5f, 3, 5, 3);
        this.backRightShin.setRotationPoint(-4.0f, 16.0f, 11.0f);
        this.backRightHoof = new ModelRenderer(this, 96, 51);
        this.backRightHoof.addBox(-1.5f, 5.1f, -2.0f, 4, 3, 4);
        this.backRightHoof.setRotationPoint(-4.0f, 16.0f, 11.0f);
        this.frontLeftLeg = new ModelRenderer(this, 44, 29);
        this.frontLeftLeg.addBox(-1.9f, -1.0f, -2.1f, 3, 8, 4);
        this.frontLeftLeg.setRotationPoint(4.0f, 9.0f, -8.0f);
        this.frontLeftShin = new ModelRenderer(this, 44, 41);
        this.frontLeftShin.addBox(-1.9f, 0.0f, -1.6f, 3, 5, 3);
        this.frontLeftShin.setRotationPoint(4.0f, 16.0f, -8.0f);
        this.frontLeftHoof = new ModelRenderer(this, 44, 51);
        this.frontLeftHoof.addBox(-2.4f, 5.1f, -2.1f, 4, 3, 4);
        this.frontLeftHoof.setRotationPoint(4.0f, 16.0f, -8.0f);
        this.frontRightLeg = new ModelRenderer(this, 60, 29);
        this.frontRightLeg.addBox(-1.1f, -1.0f, -2.1f, 3, 8, 4);
        this.frontRightLeg.setRotationPoint(-4.0f, 9.0f, -8.0f);
        this.frontRightShin = new ModelRenderer(this, 60, 41);
        this.frontRightShin.addBox(-1.1f, 0.0f, -1.6f, 3, 5, 3);
        this.frontRightShin.setRotationPoint(-4.0f, 16.0f, -8.0f);
        this.frontRightHoof = new ModelRenderer(this, 60, 51);
        this.frontRightHoof.addBox(-1.6f, 5.1f, -2.1f, 4, 3, 4);
        this.frontRightHoof.setRotationPoint(-4.0f, 16.0f, -8.0f);
        this.head = new ModelRenderer(this, 0, 0);
        this.head.addBox(-2.5f, -10.0f, -1.5f, 5, 5, 7);
        this.head.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.head.rotateAngleX = 0.5235988f;
        this.upperMouth = new ModelRenderer(this, 24, 18);
        this.upperMouth.addBox(-2.0f, -10.0f, -7.0f, 4, 3, 6);
        this.upperMouth.setRotationPoint(0.0f, 3.95f, -10.0f);
        this.upperMouth.rotateAngleX = 0.5235988f;
        this.lowerMouth = new ModelRenderer(this, 24, 27);
        this.lowerMouth.addBox(-2.0f, -7.0f, -6.5f, 4, 2, 5);
        this.lowerMouth.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.lowerMouth.rotateAngleX = 0.5235988f;
        this.head.addChild(this.upperMouth);
        this.head.addChild(this.lowerMouth);
        this.horseLeftEar = new ModelRenderer(this, 0, 0);
        this.horseLeftEar.addBox(0.45f, -12.0f, 4.0f, 2, 3, 1);
        this.horseLeftEar.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.horseLeftEar.rotateAngleX = 0.5235988f;
        this.horseRightEar = new ModelRenderer(this, 0, 0);
        this.horseRightEar.addBox(-2.45f, -12.0f, 4.0f, 2, 3, 1);
        this.horseRightEar.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.horseRightEar.rotateAngleX = 0.5235988f;
        this.muleLeftEar = new ModelRenderer(this, 0, 12);
        this.muleLeftEar.addBox(-2.0f, -16.0f, 4.0f, 2, 7, 1);
        this.muleLeftEar.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.muleLeftEar.rotateAngleX = 0.5235988f;
        this.muleLeftEar.rotateAngleZ = 0.2617994f;
        this.muleRightEar = new ModelRenderer(this, 0, 12);
        this.muleRightEar.addBox(0.0f, -16.0f, 4.0f, 2, 7, 1);
        this.muleRightEar.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.muleRightEar.rotateAngleX = 0.5235988f;
        this.muleRightEar.rotateAngleZ = -0.2617994f;
        this.neck = new ModelRenderer(this, 0, 12);
        this.neck.addBox(-2.05f, -9.8f, -2.0f, 4, 14, 8);
        this.neck.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.neck.rotateAngleX = 0.5235988f;
        this.muleLeftChest = new ModelRenderer(this, 0, 34);
        this.muleLeftChest.addBox(-3.0f, 0.0f, 0.0f, 8, 8, 3);
        this.muleLeftChest.setRotationPoint(-7.5f, 3.0f, 10.0f);
        this.muleLeftChest.rotateAngleY = 1.5707964f;
        this.muleRightChest = new ModelRenderer(this, 0, 47);
        this.muleRightChest.addBox(-3.0f, 0.0f, 0.0f, 8, 8, 3);
        this.muleRightChest.setRotationPoint(4.5f, 3.0f, 10.0f);
        this.muleRightChest.rotateAngleY = 1.5707964f;
        this.horseSaddleBottom = new ModelRenderer(this, 80, 0);
        this.horseSaddleBottom.addBox(-5.0f, 0.0f, -3.0f, 10, 1, 8);
        this.horseSaddleBottom.setRotationPoint(0.0f, 2.0f, 2.0f);
        this.horseSaddleFront = new ModelRenderer(this, 106, 9);
        this.horseSaddleFront.addBox(-1.5f, -1.0f, -3.0f, 3, 1, 2);
        this.horseSaddleFront.setRotationPoint(0.0f, 2.0f, 2.0f);
        this.horseSaddleBack = new ModelRenderer(this, 80, 9);
        this.horseSaddleBack.addBox(-4.0f, -1.0f, 3.0f, 8, 1, 2);
        this.horseSaddleBack.setRotationPoint(0.0f, 2.0f, 2.0f);
        this.horseLeftSaddleMetal = new ModelRenderer(this, 74, 0);
        this.horseLeftSaddleMetal.addBox(-0.5f, 6.0f, -1.0f, 1, 2, 2);
        this.horseLeftSaddleMetal.setRotationPoint(5.0f, 3.0f, 2.0f);
        this.horseLeftSaddleRope = new ModelRenderer(this, 70, 0);
        this.horseLeftSaddleRope.addBox(-0.5f, 0.0f, -0.5f, 1, 6, 1);
        this.horseLeftSaddleRope.setRotationPoint(5.0f, 3.0f, 2.0f);
        this.horseRightSaddleMetal = new ModelRenderer(this, 74, 4);
        this.horseRightSaddleMetal.addBox(-0.5f, 6.0f, -1.0f, 1, 2, 2);
        this.horseRightSaddleMetal.setRotationPoint(-5.0f, 3.0f, 2.0f);
        this.horseRightSaddleRope = new ModelRenderer(this, 80, 0);
        this.horseRightSaddleRope.addBox(-0.5f, 0.0f, -0.5f, 1, 6, 1);
        this.horseRightSaddleRope.setRotationPoint(-5.0f, 3.0f, 2.0f);
        this.horseLeftFaceMetal = new ModelRenderer(this, 74, 13);
        this.horseLeftFaceMetal.addBox(1.5f, -8.0f, -4.0f, 1, 2, 2);
        this.horseLeftFaceMetal.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.horseLeftFaceMetal.rotateAngleX = 0.5235988f;
        this.horseRightFaceMetal = new ModelRenderer(this, 74, 13);
        this.horseRightFaceMetal.addBox(-2.5f, -8.0f, -4.0f, 1, 2, 2);
        this.horseRightFaceMetal.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.horseRightFaceMetal.rotateAngleX = 0.5235988f;
        this.horseLeftRein = new ModelRenderer(this, 44, 10);
        this.horseLeftRein.addBox(2.6f, -6.0f, -6.0f, 0, 3, 16);
        this.horseLeftRein.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.horseRightRein = new ModelRenderer(this, 44, 5);
        this.horseRightRein.addBox(-2.6f, -6.0f, -6.0f, 0, 3, 16);
        this.horseRightRein.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.mane = new ModelRenderer(this, 58, 0);
        this.mane.addBox(-1.0f, -11.5f, 5.0f, 2, 16, 4);
        this.mane.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.mane.rotateAngleX = 0.5235988f;
        this.horseFaceRopes = new ModelRenderer(this, 80, 12);
        this.horseFaceRopes.addBox(-2.5f, -10.1f, -7.0f, 5, 5, 12, 0.2f);
        this.horseFaceRopes.setRotationPoint(0.0f, 4.0f, -10.0f);
        this.horseFaceRopes.rotateAngleX = 0.5235988f;
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        AbstractHorse lvt_8_1_ = (AbstractHorse)p_render_1_;
        float lvt_9_1_ = lvt_8_1_.getGrassEatingAmount(0.0f);
        boolean lvt_10_1_ = lvt_8_1_.isChild();
        boolean lvt_11_1_ = !lvt_10_1_ && lvt_8_1_.isHorseSaddled();
        boolean lvt_12_1_ = lvt_8_1_ instanceof AbstractChestHorse;
        boolean lvt_13_1_ = !lvt_10_1_ && lvt_12_1_ && ((AbstractChestHorse)lvt_8_1_).hasChest();
        float lvt_14_1_ = lvt_8_1_.getHorseSize();
        boolean lvt_15_1_ = lvt_8_1_.isBeingRidden();
        if (lvt_11_1_) {
            this.horseFaceRopes.render(p_render_7_);
            this.horseSaddleBottom.render(p_render_7_);
            this.horseSaddleFront.render(p_render_7_);
            this.horseSaddleBack.render(p_render_7_);
            this.horseLeftSaddleRope.render(p_render_7_);
            this.horseLeftSaddleMetal.render(p_render_7_);
            this.horseRightSaddleRope.render(p_render_7_);
            this.horseRightSaddleMetal.render(p_render_7_);
            this.horseLeftFaceMetal.render(p_render_7_);
            this.horseRightFaceMetal.render(p_render_7_);
            if (lvt_15_1_) {
                this.horseLeftRein.render(p_render_7_);
                this.horseRightRein.render(p_render_7_);
            }
        }
        if (lvt_10_1_) {
            GlStateManager.pushMatrix();
            GlStateManager.scale(lvt_14_1_, 0.5f + lvt_14_1_ * 0.5f, lvt_14_1_);
            GlStateManager.translate(0.0f, 0.95f * (1.0f - lvt_14_1_), 0.0f);
        }
        this.backLeftLeg.render(p_render_7_);
        this.backLeftShin.render(p_render_7_);
        this.backLeftHoof.render(p_render_7_);
        this.backRightLeg.render(p_render_7_);
        this.backRightShin.render(p_render_7_);
        this.backRightHoof.render(p_render_7_);
        this.frontLeftLeg.render(p_render_7_);
        this.frontLeftShin.render(p_render_7_);
        this.frontLeftHoof.render(p_render_7_);
        this.frontRightLeg.render(p_render_7_);
        this.frontRightShin.render(p_render_7_);
        this.frontRightHoof.render(p_render_7_);
        if (lvt_10_1_) {
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.scale(lvt_14_1_, lvt_14_1_, lvt_14_1_);
            GlStateManager.translate(0.0f, 1.35f * (1.0f - lvt_14_1_), 0.0f);
        }
        this.body.render(p_render_7_);
        this.tailBase.render(p_render_7_);
        this.tailMiddle.render(p_render_7_);
        this.tailTip.render(p_render_7_);
        this.neck.render(p_render_7_);
        this.mane.render(p_render_7_);
        if (lvt_10_1_) {
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            float lvt_16_1_ = 0.5f + lvt_14_1_ * lvt_14_1_ * 0.5f;
            GlStateManager.scale(lvt_16_1_, lvt_16_1_, lvt_16_1_);
            if (lvt_9_1_ <= 0.0f) {
                GlStateManager.translate(0.0f, 1.35f * (1.0f - lvt_14_1_), 0.0f);
            } else {
                GlStateManager.translate(0.0f, 0.9f * (1.0f - lvt_14_1_) * lvt_9_1_ + 1.35f * (1.0f - lvt_14_1_) * (1.0f - lvt_9_1_), 0.15f * (1.0f - lvt_14_1_) * lvt_9_1_);
            }
        }
        if (lvt_12_1_) {
            this.muleLeftEar.render(p_render_7_);
            this.muleRightEar.render(p_render_7_);
        } else {
            this.horseLeftEar.render(p_render_7_);
            this.horseRightEar.render(p_render_7_);
        }
        this.head.render(p_render_7_);
        if (lvt_10_1_) {
            GlStateManager.popMatrix();
        }
        if (lvt_13_1_) {
            this.muleLeftChest.render(p_render_7_);
            this.muleRightChest.render(p_render_7_);
        }
    }

    private float updateHorseRotation(float p_updateHorseRotation_1_, float p_updateHorseRotation_2_, float p_updateHorseRotation_3_) {
        float lvt_4_1_;
        for (lvt_4_1_ = p_updateHorseRotation_2_ - p_updateHorseRotation_1_; lvt_4_1_ < -180.0f; lvt_4_1_ += 360.0f) {
        }
        while (lvt_4_1_ >= 180.0f) {
            lvt_4_1_ -= 360.0f;
        }
        return p_updateHorseRotation_1_ + p_updateHorseRotation_3_ * lvt_4_1_;
    }

    @Override
    public void setLivingAnimations(EntityLivingBase p_setLivingAnimations_1_, float p_setLivingAnimations_2_, float p_setLivingAnimations_3_, float p_setLivingAnimations_4_) {
        float lvt_21_2_;
        super.setLivingAnimations(p_setLivingAnimations_1_, p_setLivingAnimations_2_, p_setLivingAnimations_3_, p_setLivingAnimations_4_);
        float lvt_5_1_ = this.updateHorseRotation(p_setLivingAnimations_1_.prevRenderYawOffset, p_setLivingAnimations_1_.renderYawOffset, p_setLivingAnimations_4_);
        float lvt_6_1_ = this.updateHorseRotation(p_setLivingAnimations_1_.prevRotationYawHead, p_setLivingAnimations_1_.rotationYawHead, p_setLivingAnimations_4_);
        float lvt_7_1_ = p_setLivingAnimations_1_.prevRotationPitch + (p_setLivingAnimations_1_.rotationPitch - p_setLivingAnimations_1_.prevRotationPitch) * p_setLivingAnimations_4_;
        float lvt_8_1_ = lvt_6_1_ - lvt_5_1_;
        float lvt_9_1_ = lvt_7_1_ * ((float)Math.PI / 180);
        if (lvt_8_1_ > 20.0f) {
            lvt_8_1_ = 20.0f;
        }
        if (lvt_8_1_ < -20.0f) {
            lvt_8_1_ = -20.0f;
        }
        if (p_setLivingAnimations_3_ > 0.2f) {
            lvt_9_1_ += MathHelper.cos(p_setLivingAnimations_2_ * 0.4f) * 0.15f * p_setLivingAnimations_3_;
        }
        AbstractHorse lvt_10_1_ = (AbstractHorse)p_setLivingAnimations_1_;
        float lvt_11_1_ = lvt_10_1_.getGrassEatingAmount(p_setLivingAnimations_4_);
        float lvt_12_1_ = lvt_10_1_.getRearingAmount(p_setLivingAnimations_4_);
        float lvt_13_1_ = 1.0f - lvt_12_1_;
        float lvt_14_1_ = lvt_10_1_.getMouthOpennessAngle(p_setLivingAnimations_4_);
        boolean lvt_15_1_ = lvt_10_1_.tailCounter != 0;
        boolean lvt_16_1_ = lvt_10_1_.isHorseSaddled();
        boolean lvt_17_1_ = lvt_10_1_.isBeingRidden();
        float lvt_18_1_ = (float)p_setLivingAnimations_1_.ticksExisted + p_setLivingAnimations_4_;
        float lvt_19_1_ = MathHelper.cos(p_setLivingAnimations_2_ * 0.6662f + (float)Math.PI);
        float lvt_20_1_ = lvt_19_1_ * 0.8f * p_setLivingAnimations_3_;
        this.head.rotationPointY = 4.0f;
        this.head.rotationPointZ = -10.0f;
        this.tailBase.rotationPointY = 3.0f;
        this.tailMiddle.rotationPointZ = 14.0f;
        this.muleRightChest.rotationPointY = 3.0f;
        this.muleRightChest.rotationPointZ = 10.0f;
        this.body.rotateAngleX = 0.0f;
        this.head.rotateAngleX = 0.5235988f + lvt_9_1_;
        this.head.rotateAngleY = lvt_8_1_ * ((float)Math.PI / 180);
        this.head.rotateAngleX = lvt_12_1_ * (0.2617994f + lvt_9_1_) + lvt_11_1_ * 2.1816616f + (1.0f - Math.max(lvt_12_1_, lvt_11_1_)) * this.head.rotateAngleX;
        this.head.rotateAngleY = lvt_12_1_ * lvt_8_1_ * ((float)Math.PI / 180) + (1.0f - Math.max(lvt_12_1_, lvt_11_1_)) * this.head.rotateAngleY;
        this.head.rotationPointY = lvt_12_1_ * -6.0f + lvt_11_1_ * 11.0f + (1.0f - Math.max(lvt_12_1_, lvt_11_1_)) * this.head.rotationPointY;
        this.head.rotationPointZ = lvt_12_1_ * -1.0f + lvt_11_1_ * -10.0f + (1.0f - Math.max(lvt_12_1_, lvt_11_1_)) * this.head.rotationPointZ;
        this.tailBase.rotationPointY = lvt_12_1_ * 9.0f + lvt_13_1_ * this.tailBase.rotationPointY;
        this.tailMiddle.rotationPointZ = lvt_12_1_ * 18.0f + lvt_13_1_ * this.tailMiddle.rotationPointZ;
        this.muleRightChest.rotationPointY = lvt_12_1_ * 5.5f + lvt_13_1_ * this.muleRightChest.rotationPointY;
        this.muleRightChest.rotationPointZ = lvt_12_1_ * 15.0f + lvt_13_1_ * this.muleRightChest.rotationPointZ;
        this.body.rotateAngleX = lvt_12_1_ * -0.7853982f + lvt_13_1_ * this.body.rotateAngleX;
        this.horseLeftEar.rotationPointY = this.head.rotationPointY;
        this.horseRightEar.rotationPointY = this.head.rotationPointY;
        this.muleLeftEar.rotationPointY = this.head.rotationPointY;
        this.muleRightEar.rotationPointY = this.head.rotationPointY;
        this.neck.rotationPointY = this.head.rotationPointY;
        this.upperMouth.rotationPointY = 0.02f;
        this.lowerMouth.rotationPointY = 0.0f;
        this.mane.rotationPointY = this.head.rotationPointY;
        this.horseLeftEar.rotationPointZ = this.head.rotationPointZ;
        this.horseRightEar.rotationPointZ = this.head.rotationPointZ;
        this.muleLeftEar.rotationPointZ = this.head.rotationPointZ;
        this.muleRightEar.rotationPointZ = this.head.rotationPointZ;
        this.neck.rotationPointZ = this.head.rotationPointZ;
        this.upperMouth.rotationPointZ = 0.02f - lvt_14_1_;
        this.lowerMouth.rotationPointZ = lvt_14_1_;
        this.mane.rotationPointZ = this.head.rotationPointZ;
        this.horseLeftEar.rotateAngleX = this.head.rotateAngleX;
        this.horseRightEar.rotateAngleX = this.head.rotateAngleX;
        this.muleLeftEar.rotateAngleX = this.head.rotateAngleX;
        this.muleRightEar.rotateAngleX = this.head.rotateAngleX;
        this.neck.rotateAngleX = this.head.rotateAngleX;
        this.upperMouth.rotateAngleX = -0.09424778f * lvt_14_1_;
        this.lowerMouth.rotateAngleX = 0.15707964f * lvt_14_1_;
        this.mane.rotateAngleX = this.head.rotateAngleX;
        this.horseLeftEar.rotateAngleY = this.head.rotateAngleY;
        this.horseRightEar.rotateAngleY = this.head.rotateAngleY;
        this.muleLeftEar.rotateAngleY = this.head.rotateAngleY;
        this.muleRightEar.rotateAngleY = this.head.rotateAngleY;
        this.neck.rotateAngleY = this.head.rotateAngleY;
        this.upperMouth.rotateAngleY = 0.0f;
        this.lowerMouth.rotateAngleY = 0.0f;
        this.mane.rotateAngleY = this.head.rotateAngleY;
        this.muleLeftChest.rotateAngleX = lvt_20_1_ / 5.0f;
        this.muleRightChest.rotateAngleX = -lvt_20_1_ / 5.0f;
        float lvt_21_1_ = 0.2617994f * lvt_12_1_;
        float lvt_22_1_ = MathHelper.cos(lvt_18_1_ * 0.6f + (float)Math.PI);
        this.frontLeftLeg.rotationPointY = -2.0f * lvt_12_1_ + 9.0f * lvt_13_1_;
        this.frontLeftLeg.rotationPointZ = -2.0f * lvt_12_1_ + -8.0f * lvt_13_1_;
        this.frontRightLeg.rotationPointY = this.frontLeftLeg.rotationPointY;
        this.frontRightLeg.rotationPointZ = this.frontLeftLeg.rotationPointZ;
        this.backLeftShin.rotationPointY = this.backLeftLeg.rotationPointY + MathHelper.sin(1.5707964f + lvt_21_1_ + lvt_13_1_ * -lvt_19_1_ * 0.5f * p_setLivingAnimations_3_) * 7.0f;
        this.backLeftShin.rotationPointZ = this.backLeftLeg.rotationPointZ + MathHelper.cos(-1.5707964f + lvt_21_1_ + lvt_13_1_ * -lvt_19_1_ * 0.5f * p_setLivingAnimations_3_) * 7.0f;
        this.backRightShin.rotationPointY = this.backRightLeg.rotationPointY + MathHelper.sin(1.5707964f + lvt_21_1_ + lvt_13_1_ * lvt_19_1_ * 0.5f * p_setLivingAnimations_3_) * 7.0f;
        this.backRightShin.rotationPointZ = this.backRightLeg.rotationPointZ + MathHelper.cos(-1.5707964f + lvt_21_1_ + lvt_13_1_ * lvt_19_1_ * 0.5f * p_setLivingAnimations_3_) * 7.0f;
        float lvt_23_1_ = (-1.0471976f + lvt_22_1_) * lvt_12_1_ + lvt_20_1_ * lvt_13_1_;
        float lvt_24_1_ = (-1.0471976f - lvt_22_1_) * lvt_12_1_ + -lvt_20_1_ * lvt_13_1_;
        this.frontLeftShin.rotationPointY = this.frontLeftLeg.rotationPointY + MathHelper.sin(1.5707964f + lvt_23_1_) * 7.0f;
        this.frontLeftShin.rotationPointZ = this.frontLeftLeg.rotationPointZ + MathHelper.cos(-1.5707964f + lvt_23_1_) * 7.0f;
        this.frontRightShin.rotationPointY = this.frontRightLeg.rotationPointY + MathHelper.sin(1.5707964f + lvt_24_1_) * 7.0f;
        this.frontRightShin.rotationPointZ = this.frontRightLeg.rotationPointZ + MathHelper.cos(-1.5707964f + lvt_24_1_) * 7.0f;
        this.backLeftLeg.rotateAngleX = lvt_21_1_ + -lvt_19_1_ * 0.5f * p_setLivingAnimations_3_ * lvt_13_1_;
        this.backLeftHoof.rotateAngleX = this.backLeftShin.rotateAngleX = -0.08726646f * lvt_12_1_ + (-lvt_19_1_ * 0.5f * p_setLivingAnimations_3_ - Math.max(0.0f, lvt_19_1_ * 0.5f * p_setLivingAnimations_3_)) * lvt_13_1_;
        this.backRightLeg.rotateAngleX = lvt_21_1_ + lvt_19_1_ * 0.5f * p_setLivingAnimations_3_ * lvt_13_1_;
        this.backRightHoof.rotateAngleX = this.backRightShin.rotateAngleX = -0.08726646f * lvt_12_1_ + (lvt_19_1_ * 0.5f * p_setLivingAnimations_3_ - Math.max(0.0f, -lvt_19_1_ * 0.5f * p_setLivingAnimations_3_)) * lvt_13_1_;
        this.frontLeftLeg.rotateAngleX = lvt_23_1_;
        this.frontLeftHoof.rotateAngleX = this.frontLeftShin.rotateAngleX = (this.frontLeftLeg.rotateAngleX + (float)Math.PI * Math.max(0.0f, 0.2f + lvt_22_1_ * 0.2f)) * lvt_12_1_ + (lvt_20_1_ + Math.max(0.0f, lvt_19_1_ * 0.5f * p_setLivingAnimations_3_)) * lvt_13_1_;
        this.frontRightLeg.rotateAngleX = lvt_24_1_;
        this.frontRightHoof.rotateAngleX = this.frontRightShin.rotateAngleX = (this.frontRightLeg.rotateAngleX + (float)Math.PI * Math.max(0.0f, 0.2f - lvt_22_1_ * 0.2f)) * lvt_12_1_ + (-lvt_20_1_ + Math.max(0.0f, -lvt_19_1_ * 0.5f * p_setLivingAnimations_3_)) * lvt_13_1_;
        this.backLeftHoof.rotationPointY = this.backLeftShin.rotationPointY;
        this.backLeftHoof.rotationPointZ = this.backLeftShin.rotationPointZ;
        this.backRightHoof.rotationPointY = this.backRightShin.rotationPointY;
        this.backRightHoof.rotationPointZ = this.backRightShin.rotationPointZ;
        this.frontLeftHoof.rotationPointY = this.frontLeftShin.rotationPointY;
        this.frontLeftHoof.rotationPointZ = this.frontLeftShin.rotationPointZ;
        this.frontRightHoof.rotationPointY = this.frontRightShin.rotationPointY;
        this.frontRightHoof.rotationPointZ = this.frontRightShin.rotationPointZ;
        if (lvt_16_1_) {
            this.horseSaddleBottom.rotationPointY = lvt_12_1_ * 0.5f + lvt_13_1_ * 2.0f;
            this.horseSaddleBottom.rotationPointZ = lvt_12_1_ * 11.0f + lvt_13_1_ * 2.0f;
            this.horseSaddleFront.rotationPointY = this.horseSaddleBottom.rotationPointY;
            this.horseSaddleBack.rotationPointY = this.horseSaddleBottom.rotationPointY;
            this.horseLeftSaddleRope.rotationPointY = this.horseSaddleBottom.rotationPointY;
            this.horseRightSaddleRope.rotationPointY = this.horseSaddleBottom.rotationPointY;
            this.horseLeftSaddleMetal.rotationPointY = this.horseSaddleBottom.rotationPointY;
            this.horseRightSaddleMetal.rotationPointY = this.horseSaddleBottom.rotationPointY;
            this.muleLeftChest.rotationPointY = this.muleRightChest.rotationPointY;
            this.horseSaddleFront.rotationPointZ = this.horseSaddleBottom.rotationPointZ;
            this.horseSaddleBack.rotationPointZ = this.horseSaddleBottom.rotationPointZ;
            this.horseLeftSaddleRope.rotationPointZ = this.horseSaddleBottom.rotationPointZ;
            this.horseRightSaddleRope.rotationPointZ = this.horseSaddleBottom.rotationPointZ;
            this.horseLeftSaddleMetal.rotationPointZ = this.horseSaddleBottom.rotationPointZ;
            this.horseRightSaddleMetal.rotationPointZ = this.horseSaddleBottom.rotationPointZ;
            this.muleLeftChest.rotationPointZ = this.muleRightChest.rotationPointZ;
            this.horseSaddleBottom.rotateAngleX = this.body.rotateAngleX;
            this.horseSaddleFront.rotateAngleX = this.body.rotateAngleX;
            this.horseSaddleBack.rotateAngleX = this.body.rotateAngleX;
            this.horseLeftRein.rotationPointY = this.head.rotationPointY;
            this.horseRightRein.rotationPointY = this.head.rotationPointY;
            this.horseFaceRopes.rotationPointY = this.head.rotationPointY;
            this.horseLeftFaceMetal.rotationPointY = this.head.rotationPointY;
            this.horseRightFaceMetal.rotationPointY = this.head.rotationPointY;
            this.horseLeftRein.rotationPointZ = this.head.rotationPointZ;
            this.horseRightRein.rotationPointZ = this.head.rotationPointZ;
            this.horseFaceRopes.rotationPointZ = this.head.rotationPointZ;
            this.horseLeftFaceMetal.rotationPointZ = this.head.rotationPointZ;
            this.horseRightFaceMetal.rotationPointZ = this.head.rotationPointZ;
            this.horseLeftRein.rotateAngleX = lvt_9_1_;
            this.horseRightRein.rotateAngleX = lvt_9_1_;
            this.horseFaceRopes.rotateAngleX = this.head.rotateAngleX;
            this.horseLeftFaceMetal.rotateAngleX = this.head.rotateAngleX;
            this.horseRightFaceMetal.rotateAngleX = this.head.rotateAngleX;
            this.horseFaceRopes.rotateAngleY = this.head.rotateAngleY;
            this.horseLeftFaceMetal.rotateAngleY = this.head.rotateAngleY;
            this.horseLeftRein.rotateAngleY = this.head.rotateAngleY;
            this.horseRightFaceMetal.rotateAngleY = this.head.rotateAngleY;
            this.horseRightRein.rotateAngleY = this.head.rotateAngleY;
            if (lvt_17_1_) {
                this.horseLeftSaddleRope.rotateAngleX = -1.0471976f;
                this.horseLeftSaddleMetal.rotateAngleX = -1.0471976f;
                this.horseRightSaddleRope.rotateAngleX = -1.0471976f;
                this.horseRightSaddleMetal.rotateAngleX = -1.0471976f;
                this.horseLeftSaddleRope.rotateAngleZ = 0.0f;
                this.horseLeftSaddleMetal.rotateAngleZ = 0.0f;
                this.horseRightSaddleRope.rotateAngleZ = 0.0f;
                this.horseRightSaddleMetal.rotateAngleZ = 0.0f;
            } else {
                this.horseLeftSaddleRope.rotateAngleX = lvt_20_1_ / 3.0f;
                this.horseLeftSaddleMetal.rotateAngleX = lvt_20_1_ / 3.0f;
                this.horseRightSaddleRope.rotateAngleX = lvt_20_1_ / 3.0f;
                this.horseRightSaddleMetal.rotateAngleX = lvt_20_1_ / 3.0f;
                this.horseLeftSaddleRope.rotateAngleZ = lvt_20_1_ / 5.0f;
                this.horseLeftSaddleMetal.rotateAngleZ = lvt_20_1_ / 5.0f;
                this.horseRightSaddleRope.rotateAngleZ = -lvt_20_1_ / 5.0f;
                this.horseRightSaddleMetal.rotateAngleZ = -lvt_20_1_ / 5.0f;
            }
        }
        if ((lvt_21_2_ = -1.3089969f + p_setLivingAnimations_3_ * 1.5f) > 0.0f) {
            lvt_21_2_ = 0.0f;
        }
        if (lvt_15_1_) {
            this.tailBase.rotateAngleY = MathHelper.cos(lvt_18_1_ * 0.7f);
            lvt_21_2_ = 0.0f;
        } else {
            this.tailBase.rotateAngleY = 0.0f;
        }
        this.tailMiddle.rotateAngleY = this.tailBase.rotateAngleY;
        this.tailTip.rotateAngleY = this.tailBase.rotateAngleY;
        this.tailMiddle.rotationPointY = this.tailBase.rotationPointY;
        this.tailTip.rotationPointY = this.tailBase.rotationPointY;
        this.tailMiddle.rotationPointZ = this.tailBase.rotationPointZ;
        this.tailTip.rotationPointZ = this.tailBase.rotationPointZ;
        this.tailBase.rotateAngleX = lvt_21_2_;
        this.tailMiddle.rotateAngleX = lvt_21_2_;
        this.tailTip.rotateAngleX = -0.2617994f + lvt_21_2_;
    }
}

