/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelIllager
extends ModelBase {
    public ModelRenderer head;
    public ModelRenderer body;
    public ModelRenderer arms;
    public ModelRenderer leg0;
    public ModelRenderer leg1;
    public ModelRenderer nose;
    public ModelRenderer rightArm;
    public ModelRenderer leftArm;

    public ModelIllager(float p_i47227_1_, float p_i47227_2_, int p_i47227_3_, int p_i47227_4_) {
        this.head = new ModelRenderer(this).setTextureSize(p_i47227_3_, p_i47227_4_);
        this.head.setRotationPoint(0.0f, 0.0f + p_i47227_2_, 0.0f);
        this.head.setTextureOffset(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8, 10, 8, p_i47227_1_);
        this.nose = new ModelRenderer(this).setTextureSize(p_i47227_3_, p_i47227_4_);
        this.nose.setRotationPoint(0.0f, p_i47227_2_ - 2.0f, 0.0f);
        this.nose.setTextureOffset(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2, 4, 2, p_i47227_1_);
        this.head.addChild(this.nose);
        this.body = new ModelRenderer(this).setTextureSize(p_i47227_3_, p_i47227_4_);
        this.body.setRotationPoint(0.0f, 0.0f + p_i47227_2_, 0.0f);
        this.body.setTextureOffset(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8, 12, 6, p_i47227_1_);
        this.body.setTextureOffset(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8, 18, 6, p_i47227_1_ + 0.5f);
        this.arms = new ModelRenderer(this).setTextureSize(p_i47227_3_, p_i47227_4_);
        this.arms.setRotationPoint(0.0f, 0.0f + p_i47227_2_ + 2.0f, 0.0f);
        this.arms.setTextureOffset(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4, 8, 4, p_i47227_1_);
        this.arms.setTextureOffset(44, 22).addBox(4.0f, -2.0f, -2.0f, 4, 8, 4, p_i47227_1_);
        this.arms.setTextureOffset(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8, 4, 4, p_i47227_1_);
        this.leg0 = new ModelRenderer(this, 0, 22).setTextureSize(p_i47227_3_, p_i47227_4_);
        this.leg0.setRotationPoint(-2.0f, 12.0f + p_i47227_2_, 0.0f);
        this.leg0.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, p_i47227_1_);
        this.leg1 = new ModelRenderer(this, 0, 22).setTextureSize(p_i47227_3_, p_i47227_4_);
        this.leg1.mirror = true;
        this.leg1.setRotationPoint(2.0f, 12.0f + p_i47227_2_, 0.0f);
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, p_i47227_1_);
        this.rightArm = new ModelRenderer(this, 40, 46).setTextureSize(p_i47227_3_, p_i47227_4_);
        this.rightArm.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, p_i47227_1_);
        this.rightArm.setRotationPoint(-5.0f, 2.0f + p_i47227_2_, 0.0f);
        this.leftArm = new ModelRenderer(this, 40, 46).setTextureSize(p_i47227_3_, p_i47227_4_);
        this.leftArm.mirror = true;
        this.leftArm.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, p_i47227_1_);
        this.leftArm.setRotationPoint(5.0f, 2.0f + p_i47227_2_, 0.0f);
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        this.setRotationAngles(p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_, p_render_1_);
        this.head.render(p_render_7_);
        this.body.render(p_render_7_);
        this.leg0.render(p_render_7_);
        this.leg1.render(p_render_7_);
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        this.head.rotateAngleY = p_setRotationAngles_4_ * ((float)Math.PI / 180);
        this.head.rotateAngleX = p_setRotationAngles_5_ * ((float)Math.PI / 180);
        this.arms.rotationPointY = 3.0f;
        this.arms.rotationPointZ = -1.0f;
        this.arms.rotateAngleX = -0.75f;
        this.leg0.rotateAngleX = MathHelper.cos(p_setRotationAngles_1_ * 0.6662f) * 1.4f * p_setRotationAngles_2_ * 0.5f;
        this.leg1.rotateAngleX = MathHelper.cos(p_setRotationAngles_1_ * 0.6662f + (float)Math.PI) * 1.4f * p_setRotationAngles_2_ * 0.5f;
        this.leg0.rotateAngleY = 0.0f;
        this.leg1.rotateAngleY = 0.0f;
    }

    public ModelRenderer getArm(EnumHandSide p_getArm_1_) {
        if (p_getArm_1_ == EnumHandSide.LEFT) {
            return this.leftArm;
        }
        return this.rightArm;
    }
}

