/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelPlayer
extends ModelBiped {
    public ModelRenderer bipedLeftArmwear;
    public ModelRenderer bipedRightArmwear;
    public ModelRenderer bipedLeftLegwear;
    public ModelRenderer bipedRightLegwear;
    public ModelRenderer bipedBodyWear;
    private final ModelRenderer bipedCape;
    private final ModelRenderer bipedDeadmau5Head;
    private final boolean smallArms;

    public ModelPlayer(float p_i46304_1_, boolean p_i46304_2_) {
        super(p_i46304_1_, 0.0f, 64, 64);
        this.smallArms = p_i46304_2_;
        this.bipedDeadmau5Head = new ModelRenderer(this, 24, 0);
        this.bipedDeadmau5Head.addBox(-3.0f, -6.0f, -1.0f, 6, 6, 1, p_i46304_1_);
        this.bipedCape = new ModelRenderer(this, 0, 0);
        this.bipedCape.setTextureSize(64, 32);
        this.bipedCape.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, p_i46304_1_);
        if (p_i46304_2_) {
            this.bipedLeftArm = new ModelRenderer(this, 32, 48);
            this.bipedLeftArm.addBox(-1.0f, -2.0f, -2.0f, 3, 12, 4, p_i46304_1_);
            this.bipedLeftArm.setRotationPoint(5.0f, 2.5f, 0.0f);
            this.bipedRightArm = new ModelRenderer(this, 40, 16);
            this.bipedRightArm.addBox(-2.0f, -2.0f, -2.0f, 3, 12, 4, p_i46304_1_);
            this.bipedRightArm.setRotationPoint(-5.0f, 2.5f, 0.0f);
            this.bipedLeftArmwear = new ModelRenderer(this, 48, 48);
            this.bipedLeftArmwear.addBox(-1.0f, -2.0f, -2.0f, 3, 12, 4, p_i46304_1_ + 0.25f);
            this.bipedLeftArmwear.setRotationPoint(5.0f, 2.5f, 0.0f);
            this.bipedRightArmwear = new ModelRenderer(this, 40, 32);
            this.bipedRightArmwear.addBox(-2.0f, -2.0f, -2.0f, 3, 12, 4, p_i46304_1_ + 0.25f);
            this.bipedRightArmwear.setRotationPoint(-5.0f, 2.5f, 10.0f);
        } else {
            this.bipedLeftArm = new ModelRenderer(this, 32, 48);
            this.bipedLeftArm.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, p_i46304_1_);
            this.bipedLeftArm.setRotationPoint(5.0f, 2.0f, 0.0f);
            this.bipedLeftArmwear = new ModelRenderer(this, 48, 48);
            this.bipedLeftArmwear.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, p_i46304_1_ + 0.25f);
            this.bipedLeftArmwear.setRotationPoint(5.0f, 2.0f, 0.0f);
            this.bipedRightArmwear = new ModelRenderer(this, 40, 32);
            this.bipedRightArmwear.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, p_i46304_1_ + 0.25f);
            this.bipedRightArmwear.setRotationPoint(-5.0f, 2.0f, 10.0f);
        }
        this.bipedLeftLeg = new ModelRenderer(this, 16, 48);
        this.bipedLeftLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, p_i46304_1_);
        this.bipedLeftLeg.setRotationPoint(1.9f, 12.0f, 0.0f);
        this.bipedLeftLegwear = new ModelRenderer(this, 0, 48);
        this.bipedLeftLegwear.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, p_i46304_1_ + 0.25f);
        this.bipedLeftLegwear.setRotationPoint(1.9f, 12.0f, 0.0f);
        this.bipedRightLegwear = new ModelRenderer(this, 0, 32);
        this.bipedRightLegwear.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, p_i46304_1_ + 0.25f);
        this.bipedRightLegwear.setRotationPoint(-1.9f, 12.0f, 0.0f);
        this.bipedBodyWear = new ModelRenderer(this, 16, 32);
        this.bipedBodyWear.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, p_i46304_1_ + 0.25f);
        this.bipedBodyWear.setRotationPoint(0.0f, 0.0f, 0.0f);
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        super.render(p_render_1_, p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_);
        GlStateManager.pushMatrix();
        if (this.isChild) {
            float lvt_8_1_ = 2.0f;
            GlStateManager.scale(0.5f, 0.5f, 0.5f);
            GlStateManager.translate(0.0f, 24.0f * p_render_7_, 0.0f);
            this.bipedLeftLegwear.render(p_render_7_);
            this.bipedRightLegwear.render(p_render_7_);
            this.bipedLeftArmwear.render(p_render_7_);
            this.bipedRightArmwear.render(p_render_7_);
            this.bipedBodyWear.render(p_render_7_);
        } else {
            if (p_render_1_.isSneaking()) {
                GlStateManager.translate(0.0f, 0.2f, 0.0f);
            }
            this.bipedLeftLegwear.render(p_render_7_);
            this.bipedRightLegwear.render(p_render_7_);
            this.bipedLeftArmwear.render(p_render_7_);
            this.bipedRightArmwear.render(p_render_7_);
            this.bipedBodyWear.render(p_render_7_);
        }
        GlStateManager.popMatrix();
    }

    public void renderDeadmau5Head(float p_renderDeadmau5Head_1_) {
        ModelPlayer.copyModelAngles(this.bipedHead, this.bipedDeadmau5Head);
        this.bipedDeadmau5Head.rotationPointX = 0.0f;
        this.bipedDeadmau5Head.rotationPointY = 0.0f;
        this.bipedDeadmau5Head.render(p_renderDeadmau5Head_1_);
    }

    public void renderCape(float p_renderCape_1_) {
        this.bipedCape.render(p_renderCape_1_);
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        super.setRotationAngles(p_setRotationAngles_1_, p_setRotationAngles_2_, p_setRotationAngles_3_, p_setRotationAngles_4_, p_setRotationAngles_5_, p_setRotationAngles_6_, p_setRotationAngles_7_);
        ModelPlayer.copyModelAngles(this.bipedLeftLeg, this.bipedLeftLegwear);
        ModelPlayer.copyModelAngles(this.bipedRightLeg, this.bipedRightLegwear);
        ModelPlayer.copyModelAngles(this.bipedLeftArm, this.bipedLeftArmwear);
        ModelPlayer.copyModelAngles(this.bipedRightArm, this.bipedRightArmwear);
        ModelPlayer.copyModelAngles(this.bipedBody, this.bipedBodyWear);
        this.bipedCape.rotationPointY = p_setRotationAngles_7_.isSneaking() ? 2.0f : 0.0f;
    }

    @Override
    public void setInvisible(boolean p_setInvisible_1_) {
        super.setInvisible(p_setInvisible_1_);
        this.bipedLeftArmwear.showModel = p_setInvisible_1_;
        this.bipedRightArmwear.showModel = p_setInvisible_1_;
        this.bipedLeftLegwear.showModel = p_setInvisible_1_;
        this.bipedRightLegwear.showModel = p_setInvisible_1_;
        this.bipedBodyWear.showModel = p_setInvisible_1_;
        this.bipedCape.showModel = p_setInvisible_1_;
        this.bipedDeadmau5Head.showModel = p_setInvisible_1_;
    }

    @Override
    public void postRenderArm(float p_postRenderArm_1_, EnumHandSide p_postRenderArm_2_) {
        ModelRenderer lvt_3_1_ = this.getArmForSide(p_postRenderArm_2_);
        if (this.smallArms) {
            float lvt_4_1_ = 0.5f * (float)(p_postRenderArm_2_ == EnumHandSide.RIGHT ? 1 : -1);
            lvt_3_1_.rotationPointX += lvt_4_1_;
            lvt_3_1_.postRender(p_postRenderArm_1_);
            lvt_3_1_.rotationPointX -= lvt_4_1_;
        } else {
            lvt_3_1_.postRender(p_postRenderArm_1_);
        }
    }
}

