/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelRabbit
extends ModelBase {
    private final ModelRenderer rabbitLeftFoot;
    private final ModelRenderer rabbitRightFoot;
    private final ModelRenderer rabbitLeftThigh;
    private final ModelRenderer rabbitRightThigh;
    private final ModelRenderer rabbitBody;
    private final ModelRenderer rabbitLeftArm;
    private final ModelRenderer rabbitRightArm;
    private final ModelRenderer rabbitHead;
    private final ModelRenderer rabbitRightEar;
    private final ModelRenderer rabbitLeftEar;
    private final ModelRenderer rabbitTail;
    private final ModelRenderer rabbitNose;
    private float jumpRotation;

    public ModelRabbit() {
        this.setTextureOffset("head.main", 0, 0);
        this.setTextureOffset("head.nose", 0, 24);
        this.setTextureOffset("head.ear1", 0, 10);
        this.setTextureOffset("head.ear2", 6, 10);
        this.rabbitLeftFoot = new ModelRenderer(this, 26, 24);
        this.rabbitLeftFoot.addBox(-1.0f, 5.5f, -3.7f, 2, 1, 7);
        this.rabbitLeftFoot.setRotationPoint(3.0f, 17.5f, 3.7f);
        this.rabbitLeftFoot.mirror = true;
        this.setRotationOffset(this.rabbitLeftFoot, 0.0f, 0.0f, 0.0f);
        this.rabbitRightFoot = new ModelRenderer(this, 8, 24);
        this.rabbitRightFoot.addBox(-1.0f, 5.5f, -3.7f, 2, 1, 7);
        this.rabbitRightFoot.setRotationPoint(-3.0f, 17.5f, 3.7f);
        this.rabbitRightFoot.mirror = true;
        this.setRotationOffset(this.rabbitRightFoot, 0.0f, 0.0f, 0.0f);
        this.rabbitLeftThigh = new ModelRenderer(this, 30, 15);
        this.rabbitLeftThigh.addBox(-1.0f, 0.0f, 0.0f, 2, 4, 5);
        this.rabbitLeftThigh.setRotationPoint(3.0f, 17.5f, 3.7f);
        this.rabbitLeftThigh.mirror = true;
        this.setRotationOffset(this.rabbitLeftThigh, -0.34906584f, 0.0f, 0.0f);
        this.rabbitRightThigh = new ModelRenderer(this, 16, 15);
        this.rabbitRightThigh.addBox(-1.0f, 0.0f, 0.0f, 2, 4, 5);
        this.rabbitRightThigh.setRotationPoint(-3.0f, 17.5f, 3.7f);
        this.rabbitRightThigh.mirror = true;
        this.setRotationOffset(this.rabbitRightThigh, -0.34906584f, 0.0f, 0.0f);
        this.rabbitBody = new ModelRenderer(this, 0, 0);
        this.rabbitBody.addBox(-3.0f, -2.0f, -10.0f, 6, 5, 10);
        this.rabbitBody.setRotationPoint(0.0f, 19.0f, 8.0f);
        this.rabbitBody.mirror = true;
        this.setRotationOffset(this.rabbitBody, -0.34906584f, 0.0f, 0.0f);
        this.rabbitLeftArm = new ModelRenderer(this, 8, 15);
        this.rabbitLeftArm.addBox(-1.0f, 0.0f, -1.0f, 2, 7, 2);
        this.rabbitLeftArm.setRotationPoint(3.0f, 17.0f, -1.0f);
        this.rabbitLeftArm.mirror = true;
        this.setRotationOffset(this.rabbitLeftArm, -0.17453292f, 0.0f, 0.0f);
        this.rabbitRightArm = new ModelRenderer(this, 0, 15);
        this.rabbitRightArm.addBox(-1.0f, 0.0f, -1.0f, 2, 7, 2);
        this.rabbitRightArm.setRotationPoint(-3.0f, 17.0f, -1.0f);
        this.rabbitRightArm.mirror = true;
        this.setRotationOffset(this.rabbitRightArm, -0.17453292f, 0.0f, 0.0f);
        this.rabbitHead = new ModelRenderer(this, 32, 0);
        this.rabbitHead.addBox(-2.5f, -4.0f, -5.0f, 5, 4, 5);
        this.rabbitHead.setRotationPoint(0.0f, 16.0f, -1.0f);
        this.rabbitHead.mirror = true;
        this.setRotationOffset(this.rabbitHead, 0.0f, 0.0f, 0.0f);
        this.rabbitRightEar = new ModelRenderer(this, 52, 0);
        this.rabbitRightEar.addBox(-2.5f, -9.0f, -1.0f, 2, 5, 1);
        this.rabbitRightEar.setRotationPoint(0.0f, 16.0f, -1.0f);
        this.rabbitRightEar.mirror = true;
        this.setRotationOffset(this.rabbitRightEar, 0.0f, -0.2617994f, 0.0f);
        this.rabbitLeftEar = new ModelRenderer(this, 58, 0);
        this.rabbitLeftEar.addBox(0.5f, -9.0f, -1.0f, 2, 5, 1);
        this.rabbitLeftEar.setRotationPoint(0.0f, 16.0f, -1.0f);
        this.rabbitLeftEar.mirror = true;
        this.setRotationOffset(this.rabbitLeftEar, 0.0f, 0.2617994f, 0.0f);
        this.rabbitTail = new ModelRenderer(this, 52, 6);
        this.rabbitTail.addBox(-1.5f, -1.5f, 0.0f, 3, 3, 2);
        this.rabbitTail.setRotationPoint(0.0f, 20.0f, 7.0f);
        this.rabbitTail.mirror = true;
        this.setRotationOffset(this.rabbitTail, -0.3490659f, 0.0f, 0.0f);
        this.rabbitNose = new ModelRenderer(this, 32, 9);
        this.rabbitNose.addBox(-0.5f, -2.5f, -5.5f, 1, 1, 1);
        this.rabbitNose.setRotationPoint(0.0f, 16.0f, -1.0f);
        this.rabbitNose.mirror = true;
        this.setRotationOffset(this.rabbitNose, 0.0f, 0.0f, 0.0f);
    }

    private void setRotationOffset(ModelRenderer p_setRotationOffset_1_, float p_setRotationOffset_2_, float p_setRotationOffset_3_, float p_setRotationOffset_4_) {
        p_setRotationOffset_1_.rotateAngleX = p_setRotationOffset_2_;
        p_setRotationOffset_1_.rotateAngleY = p_setRotationOffset_3_;
        p_setRotationOffset_1_.rotateAngleZ = p_setRotationOffset_4_;
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        this.setRotationAngles(p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_, p_render_1_);
        if (this.isChild) {
            float lvt_8_1_ = 1.5f;
            GlStateManager.pushMatrix();
            GlStateManager.scale(0.56666666f, 0.56666666f, 0.56666666f);
            GlStateManager.translate(0.0f, 22.0f * p_render_7_, 2.0f * p_render_7_);
            this.rabbitHead.render(p_render_7_);
            this.rabbitLeftEar.render(p_render_7_);
            this.rabbitRightEar.render(p_render_7_);
            this.rabbitNose.render(p_render_7_);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.scale(0.4f, 0.4f, 0.4f);
            GlStateManager.translate(0.0f, 36.0f * p_render_7_, 0.0f);
            this.rabbitLeftFoot.render(p_render_7_);
            this.rabbitRightFoot.render(p_render_7_);
            this.rabbitLeftThigh.render(p_render_7_);
            this.rabbitRightThigh.render(p_render_7_);
            this.rabbitBody.render(p_render_7_);
            this.rabbitLeftArm.render(p_render_7_);
            this.rabbitRightArm.render(p_render_7_);
            this.rabbitTail.render(p_render_7_);
            GlStateManager.popMatrix();
        } else {
            GlStateManager.pushMatrix();
            GlStateManager.scale(0.6f, 0.6f, 0.6f);
            GlStateManager.translate(0.0f, 16.0f * p_render_7_, 0.0f);
            this.rabbitLeftFoot.render(p_render_7_);
            this.rabbitRightFoot.render(p_render_7_);
            this.rabbitLeftThigh.render(p_render_7_);
            this.rabbitRightThigh.render(p_render_7_);
            this.rabbitBody.render(p_render_7_);
            this.rabbitLeftArm.render(p_render_7_);
            this.rabbitRightArm.render(p_render_7_);
            this.rabbitHead.render(p_render_7_);
            this.rabbitRightEar.render(p_render_7_);
            this.rabbitLeftEar.render(p_render_7_);
            this.rabbitTail.render(p_render_7_);
            this.rabbitNose.render(p_render_7_);
            GlStateManager.popMatrix();
        }
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        float lvt_8_1_ = p_setRotationAngles_3_ - (float)p_setRotationAngles_7_.ticksExisted;
        EntityRabbit lvt_9_1_ = (EntityRabbit)p_setRotationAngles_7_;
        this.rabbitNose.rotateAngleX = p_setRotationAngles_5_ * ((float)Math.PI / 180);
        this.rabbitHead.rotateAngleX = p_setRotationAngles_5_ * ((float)Math.PI / 180);
        this.rabbitRightEar.rotateAngleX = p_setRotationAngles_5_ * ((float)Math.PI / 180);
        this.rabbitLeftEar.rotateAngleX = p_setRotationAngles_5_ * ((float)Math.PI / 180);
        this.rabbitNose.rotateAngleY = p_setRotationAngles_4_ * ((float)Math.PI / 180);
        this.rabbitHead.rotateAngleY = p_setRotationAngles_4_ * ((float)Math.PI / 180);
        this.rabbitRightEar.rotateAngleY = this.rabbitNose.rotateAngleY - 0.2617994f;
        this.rabbitLeftEar.rotateAngleY = this.rabbitNose.rotateAngleY + 0.2617994f;
        this.jumpRotation = MathHelper.sin(lvt_9_1_.setJumpCompletion(lvt_8_1_) * (float)Math.PI);
        this.rabbitLeftThigh.rotateAngleX = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rabbitRightThigh.rotateAngleX = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rabbitLeftFoot.rotateAngleX = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rabbitRightFoot.rotateAngleX = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rabbitLeftArm.rotateAngleX = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.rabbitRightArm.rotateAngleX = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    @Override
    public void setLivingAnimations(EntityLivingBase p_setLivingAnimations_1_, float p_setLivingAnimations_2_, float p_setLivingAnimations_3_, float p_setLivingAnimations_4_) {
        super.setLivingAnimations(p_setLivingAnimations_1_, p_setLivingAnimations_2_, p_setLivingAnimations_3_, p_setLivingAnimations_4_);
        this.jumpRotation = MathHelper.sin(((EntityRabbit)p_setLivingAnimations_1_).setJumpCompletion(p_setLivingAnimations_4_) * (float)Math.PI);
    }
}

