/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelRenderer {
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled;
    private int displayList;
    public boolean mirror;
    public boolean showModel = true;
    public boolean isHidden;
    public List<ModelBox> cubeList = Lists.newArrayList();
    public List<ModelRenderer> childModels;
    public final String boxName;
    private final ModelBase baseModel;
    public float offsetX;
    public float offsetY;
    public float offsetZ;

    public ModelRenderer(ModelBase p_i1172_1_, String p_i1172_2_) {
        this.baseModel = p_i1172_1_;
        p_i1172_1_.boxList.add(this);
        this.boxName = p_i1172_2_;
        this.setTextureSize(p_i1172_1_.textureWidth, p_i1172_1_.textureHeight);
    }

    public ModelRenderer(ModelBase p_i1173_1_) {
        this(p_i1173_1_, null);
    }

    public ModelRenderer(ModelBase p_i46358_1_, int p_i46358_2_, int p_i46358_3_) {
        this(p_i46358_1_);
        this.setTextureOffset(p_i46358_2_, p_i46358_3_);
    }

    public void addChild(ModelRenderer p_addChild_1_) {
        if (this.childModels == null) {
            this.childModels = Lists.newArrayList();
        }
        this.childModels.add(p_addChild_1_);
    }

    public ModelRenderer setTextureOffset(int p_setTextureOffset_1_, int p_setTextureOffset_2_) {
        this.textureOffsetX = p_setTextureOffset_1_;
        this.textureOffsetY = p_setTextureOffset_2_;
        return this;
    }

    public ModelRenderer addBox(String p_addBox_1_, float p_addBox_2_, float p_addBox_3_, float p_addBox_4_, int p_addBox_5_, int p_addBox_6_, int p_addBox_7_) {
        p_addBox_1_ = this.boxName + "." + p_addBox_1_;
        TextureOffset textureoffset = this.baseModel.getTextureOffset(p_addBox_1_);
        this.setTextureOffset(textureoffset.textureOffsetX, textureoffset.textureOffsetY);
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, p_addBox_2_, p_addBox_3_, p_addBox_4_, p_addBox_5_, p_addBox_6_, p_addBox_7_, 0.0f).setBoxName(p_addBox_1_));
        return this;
    }

    public ModelRenderer addBox(float p_addBox_1_, float p_addBox_2_, float p_addBox_3_, int p_addBox_4_, int p_addBox_5_, int p_addBox_6_) {
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, p_addBox_1_, p_addBox_2_, p_addBox_3_, p_addBox_4_, p_addBox_5_, p_addBox_6_, 0.0f));
        return this;
    }

    public ModelRenderer addBox(float p_addBox_1_, float p_addBox_2_, float p_addBox_3_, int p_addBox_4_, int p_addBox_5_, int p_addBox_6_, boolean p_addBox_7_) {
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, p_addBox_1_, p_addBox_2_, p_addBox_3_, p_addBox_4_, p_addBox_5_, p_addBox_6_, 0.0f, p_addBox_7_));
        return this;
    }

    public void addBox(float p_addBox_1_, float p_addBox_2_, float p_addBox_3_, int p_addBox_4_, int p_addBox_5_, int p_addBox_6_, float p_addBox_7_) {
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, p_addBox_1_, p_addBox_2_, p_addBox_3_, p_addBox_4_, p_addBox_5_, p_addBox_6_, p_addBox_7_));
    }

    public void setRotationPoint(float p_setRotationPoint_1_, float p_setRotationPoint_2_, float p_setRotationPoint_3_) {
        this.rotationPointX = p_setRotationPoint_1_;
        this.rotationPointY = p_setRotationPoint_2_;
        this.rotationPointZ = p_setRotationPoint_3_;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float p_render_1_) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(p_render_1_);
            }
            GlStateManager.translate(this.offsetX, this.offsetY, this.offsetZ);
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX == 0.0f && this.rotationPointY == 0.0f && this.rotationPointZ == 0.0f) {
                    GlStateManager.callList(this.displayList);
                    if (this.childModels != null) {
                        for (int k = 0; k < this.childModels.size(); ++k) {
                            this.childModels.get(k).render(p_render_1_);
                        }
                    }
                } else {
                    GlStateManager.translate(this.rotationPointX * p_render_1_, this.rotationPointY * p_render_1_, this.rotationPointZ * p_render_1_);
                    GlStateManager.callList(this.displayList);
                    if (this.childModels != null) {
                        for (int j = 0; j < this.childModels.size(); ++j) {
                            this.childModels.get(j).render(p_render_1_);
                        }
                    }
                    GlStateManager.translate(-this.rotationPointX * p_render_1_, -this.rotationPointY * p_render_1_, -this.rotationPointZ * p_render_1_);
                }
            } else {
                GlStateManager.pushMatrix();
                GlStateManager.translate(this.rotationPointX * p_render_1_, this.rotationPointY * p_render_1_, this.rotationPointZ * p_render_1_);
                if (this.rotateAngleZ != 0.0f) {
                    GlStateManager.rotate(this.rotateAngleZ * 57.295776f, 0.0f, 0.0f, 1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GlStateManager.rotate(this.rotateAngleY * 57.295776f, 0.0f, 1.0f, 0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GlStateManager.rotate(this.rotateAngleX * 57.295776f, 1.0f, 0.0f, 0.0f);
                }
                GlStateManager.callList(this.displayList);
                if (this.childModels != null) {
                    for (int i = 0; i < this.childModels.size(); ++i) {
                        this.childModels.get(i).render(p_render_1_);
                    }
                }
                GlStateManager.popMatrix();
            }
            GlStateManager.translate(-this.offsetX, -this.offsetY, -this.offsetZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderWithRotation(float p_renderWithRotation_1_) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(p_renderWithRotation_1_);
            }
            GlStateManager.pushMatrix();
            GlStateManager.translate(this.rotationPointX * p_renderWithRotation_1_, this.rotationPointY * p_renderWithRotation_1_, this.rotationPointZ * p_renderWithRotation_1_);
            if (this.rotateAngleY != 0.0f) {
                GlStateManager.rotate(this.rotateAngleY * 57.295776f, 0.0f, 1.0f, 0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GlStateManager.rotate(this.rotateAngleX * 57.295776f, 1.0f, 0.0f, 0.0f);
            }
            if (this.rotateAngleZ != 0.0f) {
                GlStateManager.rotate(this.rotateAngleZ * 57.295776f, 0.0f, 0.0f, 1.0f);
            }
            GlStateManager.callList(this.displayList);
            GlStateManager.popMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void postRender(float p_postRender_1_) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(p_postRender_1_);
            }
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
                    GlStateManager.translate(this.rotationPointX * p_postRender_1_, this.rotationPointY * p_postRender_1_, this.rotationPointZ * p_postRender_1_);
                }
            } else {
                GlStateManager.translate(this.rotationPointX * p_postRender_1_, this.rotationPointY * p_postRender_1_, this.rotationPointZ * p_postRender_1_);
                if (this.rotateAngleZ != 0.0f) {
                    GlStateManager.rotate(this.rotateAngleZ * 57.295776f, 0.0f, 0.0f, 1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GlStateManager.rotate(this.rotateAngleY * 57.295776f, 0.0f, 1.0f, 0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GlStateManager.rotate(this.rotateAngleX * 57.295776f, 1.0f, 0.0f, 0.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float p_compileDisplayList_1_) {
        this.displayList = GLAllocation.generateDisplayLists(1);
        GlStateManager.glNewList(this.displayList, 4864);
        VertexBuffer vertexbuffer = Tessellator.getInstance().getBuffer();
        for (int i = 0; i < this.cubeList.size(); ++i) {
            this.cubeList.get(i).render(vertexbuffer, p_compileDisplayList_1_);
        }
        GlStateManager.glEndList();
        this.compiled = true;
    }

    public ModelRenderer setTextureSize(int p_setTextureSize_1_, int p_setTextureSize_2_) {
        this.textureWidth = p_setTextureSize_1_;
        this.textureHeight = p_setTextureSize_2_;
        return this;
    }
}

