/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelShulker
extends ModelBase {
    public final ModelRenderer base;
    public final ModelRenderer lid;
    public ModelRenderer head;

    public ModelShulker() {
        this.textureHeight = 64;
        this.textureWidth = 64;
        this.lid = new ModelRenderer(this);
        this.base = new ModelRenderer(this);
        this.head = new ModelRenderer(this);
        this.lid.setTextureOffset(0, 0).addBox(-8.0f, -16.0f, -8.0f, 16, 12, 16);
        this.lid.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.base.setTextureOffset(0, 28).addBox(-8.0f, -8.0f, -8.0f, 16, 8, 16);
        this.base.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.head.setTextureOffset(0, 52).addBox(-3.0f, 0.0f, -3.0f, 6, 6, 6);
        this.head.setRotationPoint(0.0f, 12.0f, 0.0f);
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        EntityShulker lvt_8_1_ = (EntityShulker)p_setRotationAngles_7_;
        float lvt_9_1_ = p_setRotationAngles_3_ - (float)lvt_8_1_.ticksExisted;
        float lvt_10_1_ = (0.5f + lvt_8_1_.getClientPeekAmount(lvt_9_1_)) * (float)Math.PI;
        float lvt_11_1_ = -1.0f + MathHelper.sin(lvt_10_1_);
        float lvt_12_1_ = 0.0f;
        if (lvt_10_1_ > (float)Math.PI) {
            lvt_12_1_ = MathHelper.sin(p_setRotationAngles_3_ * 0.1f) * 0.7f;
        }
        this.lid.setRotationPoint(0.0f, 16.0f + MathHelper.sin(lvt_10_1_) * 8.0f + lvt_12_1_, 0.0f);
        this.lid.rotateAngleY = lvt_8_1_.getClientPeekAmount(lvt_9_1_) > 0.3f ? lvt_11_1_ * lvt_11_1_ * lvt_11_1_ * lvt_11_1_ * (float)Math.PI * 0.125f : 0.0f;
        this.head.rotateAngleX = p_setRotationAngles_5_ * ((float)Math.PI / 180);
        this.head.rotateAngleY = p_setRotationAngles_4_ * ((float)Math.PI / 180);
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        this.base.render(p_render_7_);
        this.lid.render(p_render_7_);
    }
}

