/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelSilverfish
extends ModelBase {
    private final ModelRenderer[] silverfishBodyParts;
    private final ModelRenderer[] silverfishWings;
    private final float[] zPlacement = new float[7];
    private static final int[][] SILVERFISH_BOX_LENGTH = new int[][]{{3, 2, 2}, {4, 3, 2}, {6, 4, 3}, {3, 3, 3}, {2, 2, 3}, {2, 1, 2}, {1, 1, 2}};
    private static final int[][] SILVERFISH_TEXTURE_POSITIONS = new int[][]{{0, 0}, {0, 4}, {0, 9}, {0, 16}, {0, 22}, {11, 0}, {13, 4}};

    public ModelSilverfish() {
        this.silverfishBodyParts = new ModelRenderer[7];
        float lvt_1_1_ = -3.5f;
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.silverfishBodyParts.length; ++lvt_2_1_) {
            this.silverfishBodyParts[lvt_2_1_] = new ModelRenderer(this, SILVERFISH_TEXTURE_POSITIONS[lvt_2_1_][0], SILVERFISH_TEXTURE_POSITIONS[lvt_2_1_][1]);
            this.silverfishBodyParts[lvt_2_1_].addBox((float)SILVERFISH_BOX_LENGTH[lvt_2_1_][0] * -0.5f, 0.0f, (float)SILVERFISH_BOX_LENGTH[lvt_2_1_][2] * -0.5f, SILVERFISH_BOX_LENGTH[lvt_2_1_][0], SILVERFISH_BOX_LENGTH[lvt_2_1_][1], SILVERFISH_BOX_LENGTH[lvt_2_1_][2]);
            this.silverfishBodyParts[lvt_2_1_].setRotationPoint(0.0f, 24 - SILVERFISH_BOX_LENGTH[lvt_2_1_][1], lvt_1_1_);
            this.zPlacement[lvt_2_1_] = lvt_1_1_;
            if (lvt_2_1_ >= this.silverfishBodyParts.length - 1) continue;
            lvt_1_1_ += (float)(SILVERFISH_BOX_LENGTH[lvt_2_1_][2] + SILVERFISH_BOX_LENGTH[lvt_2_1_ + 1][2]) * 0.5f;
        }
        this.silverfishWings = new ModelRenderer[3];
        this.silverfishWings[0] = new ModelRenderer(this, 20, 0);
        this.silverfishWings[0].addBox(-5.0f, 0.0f, (float)SILVERFISH_BOX_LENGTH[2][2] * -0.5f, 10, 8, SILVERFISH_BOX_LENGTH[2][2]);
        this.silverfishWings[0].setRotationPoint(0.0f, 16.0f, this.zPlacement[2]);
        this.silverfishWings[1] = new ModelRenderer(this, 20, 11);
        this.silverfishWings[1].addBox(-3.0f, 0.0f, (float)SILVERFISH_BOX_LENGTH[4][2] * -0.5f, 6, 4, SILVERFISH_BOX_LENGTH[4][2]);
        this.silverfishWings[1].setRotationPoint(0.0f, 20.0f, this.zPlacement[4]);
        this.silverfishWings[2] = new ModelRenderer(this, 20, 18);
        this.silverfishWings[2].addBox(-3.0f, 0.0f, (float)SILVERFISH_BOX_LENGTH[4][2] * -0.5f, 6, 5, SILVERFISH_BOX_LENGTH[1][2]);
        this.silverfishWings[2].setRotationPoint(0.0f, 19.0f, this.zPlacement[1]);
    }

    @Override
    public void render(Entity p_render_1_, float p_render_2_, float p_render_3_, float p_render_4_, float p_render_5_, float p_render_6_, float p_render_7_) {
        this.setRotationAngles(p_render_2_, p_render_3_, p_render_4_, p_render_5_, p_render_6_, p_render_7_, p_render_1_);
        for (ModelRenderer lvt_11_1_ : this.silverfishBodyParts) {
            lvt_11_1_.render(p_render_7_);
        }
        for (ModelRenderer lvt_11_2_ : this.silverfishWings) {
            lvt_11_2_.render(p_render_7_);
        }
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        for (int lvt_8_1_ = 0; lvt_8_1_ < this.silverfishBodyParts.length; ++lvt_8_1_) {
            this.silverfishBodyParts[lvt_8_1_].rotateAngleY = MathHelper.cos(p_setRotationAngles_3_ * 0.9f + (float)lvt_8_1_ * 0.15f * (float)Math.PI) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(lvt_8_1_ - 2));
            this.silverfishBodyParts[lvt_8_1_].rotationPointX = MathHelper.sin(p_setRotationAngles_3_ * 0.9f + (float)lvt_8_1_ * 0.15f * (float)Math.PI) * (float)Math.PI * 0.2f * (float)Math.abs(lvt_8_1_ - 2);
        }
        this.silverfishWings[0].rotateAngleY = this.silverfishBodyParts[2].rotateAngleY;
        this.silverfishWings[1].rotateAngleY = this.silverfishBodyParts[4].rotateAngleY;
        this.silverfishWings[1].rotationPointX = this.silverfishBodyParts[4].rotationPointX;
        this.silverfishWings[2].rotateAngleY = this.silverfishBodyParts[1].rotateAngleY;
        this.silverfishWings[2].rotationPointX = this.silverfishBodyParts[1].rotationPointX;
    }
}

