/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelSkeleton
extends ModelBiped {
    public ModelSkeleton() {
        this(0.0f, false);
    }

    public ModelSkeleton(float p_i46303_1_, boolean p_i46303_2_) {
        super(p_i46303_1_, 0.0f, 64, 32);
        if (!p_i46303_2_) {
            this.bipedRightArm = new ModelRenderer(this, 40, 16);
            this.bipedRightArm.addBox(-1.0f, -2.0f, -1.0f, 2, 12, 2, p_i46303_1_);
            this.bipedRightArm.setRotationPoint(-5.0f, 2.0f, 0.0f);
            this.bipedLeftArm = new ModelRenderer(this, 40, 16);
            this.bipedLeftArm.mirror = true;
            this.bipedLeftArm.addBox(-1.0f, -2.0f, -1.0f, 2, 12, 2, p_i46303_1_);
            this.bipedLeftArm.setRotationPoint(5.0f, 2.0f, 0.0f);
            this.bipedRightLeg = new ModelRenderer(this, 0, 16);
            this.bipedRightLeg.addBox(-1.0f, 0.0f, -1.0f, 2, 12, 2, p_i46303_1_);
            this.bipedRightLeg.setRotationPoint(-2.0f, 12.0f, 0.0f);
            this.bipedLeftLeg = new ModelRenderer(this, 0, 16);
            this.bipedLeftLeg.mirror = true;
            this.bipedLeftLeg.addBox(-1.0f, 0.0f, -1.0f, 2, 12, 2, p_i46303_1_);
            this.bipedLeftLeg.setRotationPoint(2.0f, 12.0f, 0.0f);
        }
    }

    @Override
    public void setLivingAnimations(EntityLivingBase p_setLivingAnimations_1_, float p_setLivingAnimations_2_, float p_setLivingAnimations_3_, float p_setLivingAnimations_4_) {
        this.rightArmPose = ModelBiped.ArmPose.EMPTY;
        this.leftArmPose = ModelBiped.ArmPose.EMPTY;
        ItemStack lvt_5_1_ = p_setLivingAnimations_1_.getHeldItem(EnumHand.MAIN_HAND);
        if (lvt_5_1_.getItem() == Items.BOW && ((AbstractSkeleton)p_setLivingAnimations_1_).isSwingingArms()) {
            if (p_setLivingAnimations_1_.getPrimaryHand() == EnumHandSide.RIGHT) {
                this.rightArmPose = ModelBiped.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = ModelBiped.ArmPose.BOW_AND_ARROW;
            }
        }
        super.setLivingAnimations(p_setLivingAnimations_1_, p_setLivingAnimations_2_, p_setLivingAnimations_3_, p_setLivingAnimations_4_);
    }

    @Override
    public void setRotationAngles(float p_setRotationAngles_1_, float p_setRotationAngles_2_, float p_setRotationAngles_3_, float p_setRotationAngles_4_, float p_setRotationAngles_5_, float p_setRotationAngles_6_, Entity p_setRotationAngles_7_) {
        super.setRotationAngles(p_setRotationAngles_1_, p_setRotationAngles_2_, p_setRotationAngles_3_, p_setRotationAngles_4_, p_setRotationAngles_5_, p_setRotationAngles_6_, p_setRotationAngles_7_);
        ItemStack lvt_8_1_ = ((EntityLivingBase)p_setRotationAngles_7_).getHeldItemMainhand();
        AbstractSkeleton lvt_9_1_ = (AbstractSkeleton)p_setRotationAngles_7_;
        if (lvt_9_1_.isSwingingArms() && (lvt_8_1_.isEmpty() || lvt_8_1_.getItem() != Items.BOW)) {
            float lvt_10_1_ = MathHelper.sin(this.swingProgress * (float)Math.PI);
            float lvt_11_1_ = MathHelper.sin((1.0f - (1.0f - this.swingProgress) * (1.0f - this.swingProgress)) * (float)Math.PI);
            this.bipedRightArm.rotateAngleZ = 0.0f;
            this.bipedLeftArm.rotateAngleZ = 0.0f;
            this.bipedRightArm.rotateAngleY = -(0.1f - lvt_10_1_ * 0.6f);
            this.bipedLeftArm.rotateAngleY = 0.1f - lvt_10_1_ * 0.6f;
            this.bipedRightArm.rotateAngleX = -1.5707964f;
            this.bipedLeftArm.rotateAngleX = -1.5707964f;
            this.bipedRightArm.rotateAngleX -= lvt_10_1_ * 1.2f - lvt_11_1_ * 0.4f;
            this.bipedLeftArm.rotateAngleX -= lvt_10_1_ * 1.2f - lvt_11_1_ * 0.4f;
            this.bipedRightArm.rotateAngleZ += MathHelper.cos(p_setRotationAngles_3_ * 0.09f) * 0.05f + 0.05f;
            this.bipedLeftArm.rotateAngleZ -= MathHelper.cos(p_setRotationAngles_3_ * 0.09f) * 0.05f + 0.05f;
            this.bipedRightArm.rotateAngleX += MathHelper.sin(p_setRotationAngles_3_ * 0.067f) * 0.05f;
            this.bipedLeftArm.rotateAngleX -= MathHelper.sin(p_setRotationAngles_3_ * 0.067f) * 0.05f;
        }
    }

    @Override
    public void postRenderArm(float p_postRenderArm_1_, EnumHandSide p_postRenderArm_2_) {
        float lvt_3_1_ = p_postRenderArm_2_ == EnumHandSide.RIGHT ? 1.0f : -1.0f;
        ModelRenderer lvt_4_1_ = this.getArmForSide(p_postRenderArm_2_);
        lvt_4_1_.rotationPointX += lvt_3_1_;
        lvt_4_1_.postRender(p_postRenderArm_1_);
        lvt_4_1_.rotationPointX -= lvt_3_1_;
    }
}

