/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.Objects;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ChunkProviderClient
implements IChunkProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Chunk blankChunk;
    private final Long2ObjectMap<Chunk> chunkMapping = new Long2ObjectOpenHashMap<Chunk>(8192){

        protected void rehash(int p_rehash_1_) {
            if (p_rehash_1_ > this.key.length) {
                super.rehash(p_rehash_1_);
            }
        }
    };
    private final World world;

    public ChunkProviderClient(World p_i1184_1_) {
        this.blankChunk = new EmptyChunk(p_i1184_1_, 0, 0);
        this.world = p_i1184_1_;
    }

    public void unloadChunk(int p_unloadChunk_1_, int p_unloadChunk_2_) {
        Chunk chunk = this.provideChunk(p_unloadChunk_1_, p_unloadChunk_2_);
        if (!chunk.isEmpty()) {
            chunk.onChunkUnload();
        }
        this.chunkMapping.remove(ChunkPos.asLong(p_unloadChunk_1_, p_unloadChunk_2_));
    }

    @Override
    @Nullable
    public Chunk getLoadedChunk(int p_getLoadedChunk_1_, int p_getLoadedChunk_2_) {
        return (Chunk)this.chunkMapping.get(ChunkPos.asLong(p_getLoadedChunk_1_, p_getLoadedChunk_2_));
    }

    public Chunk loadChunk(int p_loadChunk_1_, int p_loadChunk_2_) {
        Chunk chunk = new Chunk(this.world, p_loadChunk_1_, p_loadChunk_2_);
        this.chunkMapping.put(ChunkPos.asLong(p_loadChunk_1_, p_loadChunk_2_), (Object)chunk);
        MinecraftForge.EVENT_BUS.post(new ChunkEvent.Load(chunk));
        chunk.setChunkLoaded(true);
        return chunk;
    }

    @Override
    public Chunk provideChunk(int p_provideChunk_1_, int p_provideChunk_2_) {
        return (Chunk)Objects.firstNonNull((Object)this.getLoadedChunk(p_provideChunk_1_, p_provideChunk_2_), (Object)this.blankChunk);
    }

    @Override
    public boolean tick() {
        long i = System.currentTimeMillis();
        for (Chunk chunk : this.chunkMapping.values()) {
            chunk.onTick(System.currentTimeMillis() - i > 5L);
        }
        if (System.currentTimeMillis() - i > 100L) {
            LOGGER.info("Warning: Clientside chunk ticking took {} ms", new Object[]{System.currentTimeMillis() - i});
        }
        return false;
    }

    @Override
    public String makeString() {
        return "MultiplayerChunkCache: " + this.chunkMapping.size() + ", " + this.chunkMapping.size();
    }

    @Override
    public boolean isChunkGeneratedAt(int p_isChunkGeneratedAt_1_, int p_isChunkGeneratedAt_2_) {
        return this.chunkMapping.containsKey(ChunkPos.asLong(p_isChunkGeneratedAt_1_, p_isChunkGeneratedAt_2_));
    }
}

