/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketEnchantItem;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerControllerMP {
    private final Minecraft mc;
    private final NetHandlerPlayClient connection;
    private BlockPos currentBlock = new BlockPos(-1, -1, -1);
    private ItemStack currentItemHittingBlock = ItemStack.EMPTY;
    private float curBlockDamageMP;
    private float stepSoundTickCounter;
    private int blockHitDelay;
    private boolean isHittingBlock;
    private GameType currentGameType = GameType.SURVIVAL;
    private int currentPlayerItem;

    public PlayerControllerMP(Minecraft p_i45062_1_, NetHandlerPlayClient p_i45062_2_) {
        this.mc = p_i45062_1_;
        this.connection = p_i45062_2_;
    }

    public static void clickBlockCreative(Minecraft p_clickBlockCreative_0_, PlayerControllerMP p_clickBlockCreative_1_, BlockPos p_clickBlockCreative_2_, EnumFacing p_clickBlockCreative_3_) {
        if (!p_clickBlockCreative_0_.world.extinguishFire(p_clickBlockCreative_0_.player, p_clickBlockCreative_2_, p_clickBlockCreative_3_)) {
            p_clickBlockCreative_1_.onPlayerDestroyBlock(p_clickBlockCreative_2_);
        }
    }

    public void setPlayerCapabilities(EntityPlayer p_setPlayerCapabilities_1_) {
        this.currentGameType.configurePlayerCapabilities(p_setPlayerCapabilities_1_.capabilities);
    }

    public boolean isSpectator() {
        return this.currentGameType == GameType.SPECTATOR;
    }

    public void setGameType(GameType p_setGameType_1_) {
        this.currentGameType = p_setGameType_1_;
        this.currentGameType.configurePlayerCapabilities(this.mc.player.capabilities);
    }

    public void flipPlayer(EntityPlayer p_flipPlayer_1_) {
        p_flipPlayer_1_.rotationYaw = -180.0f;
    }

    public boolean shouldDrawHUD() {
        return this.currentGameType.isSurvivalOrAdventure();
    }

    public boolean onPlayerDestroyBlock(BlockPos p_onPlayerDestroyBlock_1_) {
        boolean flag;
        ItemStack stack;
        if (this.currentGameType.isAdventure()) {
            if (this.currentGameType == GameType.SPECTATOR) {
                return false;
            }
            if (!this.mc.player.isAllowEdit()) {
                ItemStack itemstack = this.mc.player.getHeldItemMainhand();
                if (itemstack.isEmpty()) {
                    return false;
                }
                if (!itemstack.canDestroy(this.mc.world.getBlockState(p_onPlayerDestroyBlock_1_).getBlock())) {
                    return false;
                }
            }
        }
        if (!(stack = this.mc.player.getHeldItemMainhand()).isEmpty() && stack.getItem().onBlockStartBreak(stack, p_onPlayerDestroyBlock_1_, this.mc.player)) {
            return false;
        }
        if (this.currentGameType.isCreative() && !this.mc.player.getHeldItemMainhand().isEmpty() && this.mc.player.getHeldItemMainhand().getItem() instanceof ItemSword) {
            return false;
        }
        WorldClient world = this.mc.world;
        IBlockState iblockstate = world.getBlockState(p_onPlayerDestroyBlock_1_);
        Block block = iblockstate.getBlock();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !this.mc.player.canUseCommandBlock()) {
            return false;
        }
        if (iblockstate.getMaterial() == Material.AIR) {
            return false;
        }
        world.playEvent(2001, p_onPlayerDestroyBlock_1_, Block.getStateId(iblockstate));
        this.currentBlock = new BlockPos(this.currentBlock.getX(), -1, this.currentBlock.getZ());
        if (!this.currentGameType.isCreative()) {
            ItemStack itemstack1 = this.mc.player.getHeldItemMainhand();
            ItemStack copyBeforeUse = itemstack1.copy();
            if (!itemstack1.isEmpty()) {
                itemstack1.onBlockDestroyed(world, iblockstate, p_onPlayerDestroyBlock_1_, this.mc.player);
                if (itemstack1.isEmpty()) {
                    ForgeEventFactory.onPlayerDestroyItem(this.mc.player, copyBeforeUse, EnumHand.MAIN_HAND);
                    this.mc.player.setHeldItem(EnumHand.MAIN_HAND, ItemStack.EMPTY);
                }
            }
        }
        if (flag = block.removedByPlayer(iblockstate, world, p_onPlayerDestroyBlock_1_, this.mc.player, false)) {
            block.onBlockDestroyedByPlayer(world, p_onPlayerDestroyBlock_1_, iblockstate);
        }
        return flag;
    }

    public boolean clickBlock(BlockPos p_clickBlock_1_, EnumFacing p_clickBlock_2_) {
        if (this.currentGameType.isAdventure()) {
            if (this.currentGameType == GameType.SPECTATOR) {
                return false;
            }
            if (!this.mc.player.isAllowEdit()) {
                ItemStack itemstack = this.mc.player.getHeldItemMainhand();
                if (itemstack.isEmpty()) {
                    return false;
                }
                if (!itemstack.canDestroy(this.mc.world.getBlockState(p_clickBlock_1_).getBlock())) {
                    return false;
                }
            }
        }
        if (!this.mc.world.getWorldBorder().contains(p_clickBlock_1_)) {
            return false;
        }
        if (this.currentGameType.isCreative()) {
            this.connection.sendPacket(new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, p_clickBlock_1_, p_clickBlock_2_));
            if (!ForgeHooks.onLeftClickBlock(this.mc.player, p_clickBlock_1_, p_clickBlock_2_, ForgeHooks.rayTraceEyeHitVec(this.mc.player, this.getBlockReachDistance() + 1.0f)).isCanceled()) {
                PlayerControllerMP.clickBlockCreative(this.mc, this, p_clickBlock_1_, p_clickBlock_2_);
            }
            this.blockHitDelay = 5;
        } else if (!this.isHittingBlock || !this.isHittingPosition(p_clickBlock_1_)) {
            boolean flag;
            if (this.isHittingBlock) {
                this.connection.sendPacket(new CPacketPlayerDigging(CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK, this.currentBlock, p_clickBlock_2_));
            }
            this.connection.sendPacket(new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, p_clickBlock_1_, p_clickBlock_2_));
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock(this.mc.player, p_clickBlock_1_, p_clickBlock_2_, ForgeHooks.rayTraceEyeHitVec(this.mc.player, this.getBlockReachDistance() + 1.0f));
            IBlockState iblockstate = this.mc.world.getBlockState(p_clickBlock_1_);
            boolean bl = flag = iblockstate.getMaterial() != Material.AIR;
            if (flag && this.curBlockDamageMP == 0.0f && event.getUseBlock() != Event.Result.DENY) {
                iblockstate.getBlock().onBlockClicked(this.mc.world, p_clickBlock_1_, this.mc.player);
            }
            if (event.getUseItem() == Event.Result.DENY) {
                return true;
            }
            if (flag && iblockstate.getPlayerRelativeBlockHardness(this.mc.player, this.mc.player.world, p_clickBlock_1_) >= 1.0f) {
                this.onPlayerDestroyBlock(p_clickBlock_1_);
            } else {
                this.isHittingBlock = true;
                this.currentBlock = p_clickBlock_1_;
                this.currentItemHittingBlock = this.mc.player.getHeldItemMainhand();
                this.curBlockDamageMP = 0.0f;
                this.stepSoundTickCounter = 0.0f;
                this.mc.world.sendBlockBreakProgress(this.mc.player.getEntityId(), this.currentBlock, (int)(this.curBlockDamageMP * 10.0f) - 1);
            }
        }
        return true;
    }

    public void resetBlockRemoving() {
        if (this.isHittingBlock) {
            this.connection.sendPacket(new CPacketPlayerDigging(CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK, this.currentBlock, EnumFacing.DOWN));
            this.isHittingBlock = false;
            this.curBlockDamageMP = 0.0f;
            this.mc.world.sendBlockBreakProgress(this.mc.player.getEntityId(), this.currentBlock, -1);
            this.mc.player.resetCooldown();
        }
    }

    public boolean onPlayerDamageBlock(BlockPos p_onPlayerDamageBlock_1_, EnumFacing p_onPlayerDamageBlock_2_) {
        this.syncCurrentPlayItem();
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
            return true;
        }
        if (this.currentGameType.isCreative() && this.mc.world.getWorldBorder().contains(p_onPlayerDamageBlock_1_)) {
            this.blockHitDelay = 5;
            this.connection.sendPacket(new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, p_onPlayerDamageBlock_1_, p_onPlayerDamageBlock_2_));
            PlayerControllerMP.clickBlockCreative(this.mc, this, p_onPlayerDamageBlock_1_, p_onPlayerDamageBlock_2_);
            return true;
        }
        if (this.isHittingPosition(p_onPlayerDamageBlock_1_)) {
            IBlockState iblockstate = this.mc.world.getBlockState(p_onPlayerDamageBlock_1_);
            Block block = iblockstate.getBlock();
            if (iblockstate.getMaterial() == Material.AIR) {
                this.isHittingBlock = false;
                return false;
            }
            this.curBlockDamageMP += iblockstate.getPlayerRelativeBlockHardness(this.mc.player, this.mc.player.world, p_onPlayerDamageBlock_1_);
            if (this.stepSoundTickCounter % 4.0f == 0.0f) {
                SoundType soundtype = block.getSoundType(iblockstate, this.mc.world, p_onPlayerDamageBlock_1_, this.mc.player);
                this.mc.getSoundHandler().playSound(new PositionedSoundRecord(soundtype.getHitSound(), SoundCategory.NEUTRAL, (soundtype.getVolume() + 1.0f) / 8.0f, soundtype.getPitch() * 0.5f, p_onPlayerDamageBlock_1_));
            }
            this.stepSoundTickCounter += 1.0f;
            if (this.curBlockDamageMP >= 1.0f) {
                this.isHittingBlock = false;
                this.connection.sendPacket(new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, p_onPlayerDamageBlock_1_, p_onPlayerDamageBlock_2_));
                this.onPlayerDestroyBlock(p_onPlayerDamageBlock_1_);
                this.curBlockDamageMP = 0.0f;
                this.stepSoundTickCounter = 0.0f;
                this.blockHitDelay = 5;
            }
            this.mc.world.sendBlockBreakProgress(this.mc.player.getEntityId(), this.currentBlock, (int)(this.curBlockDamageMP * 10.0f) - 1);
            return true;
        }
        return this.clickBlock(p_onPlayerDamageBlock_1_, p_onPlayerDamageBlock_2_);
    }

    public float getBlockReachDistance() {
        return this.currentGameType.isCreative() ? 5.0f : 4.5f;
    }

    public void updateController() {
        this.syncCurrentPlayItem();
        if (this.connection.getNetworkManager().isChannelOpen()) {
            this.connection.getNetworkManager().processReceivedPackets();
        } else {
            this.connection.getNetworkManager().checkDisconnected();
        }
    }

    private boolean isHittingPosition(BlockPos p_isHittingPosition_1_) {
        boolean flag;
        ItemStack itemstack = this.mc.player.getHeldItemMainhand();
        boolean bl = flag = this.currentItemHittingBlock.isEmpty() && itemstack.isEmpty();
        if (!this.currentItemHittingBlock.isEmpty() && !itemstack.isEmpty()) {
            flag = !ForgeHooksClient.shouldCauseBlockBreakReset(this.currentItemHittingBlock, itemstack);
        }
        return p_isHittingPosition_1_.equals(this.currentBlock) && flag;
    }

    private void syncCurrentPlayItem() {
        int i = this.mc.player.inventory.currentItem;
        if (i != this.currentPlayerItem) {
            this.currentPlayerItem = i;
            this.connection.sendPacket(new CPacketHeldItemChange(this.currentPlayerItem));
        }
    }

    public EnumActionResult processRightClickBlock(EntityPlayerSP p_processRightClickBlock_1_, WorldClient p_processRightClickBlock_2_, BlockPos p_processRightClickBlock_3_, EnumFacing p_processRightClickBlock_4_, Vec3d p_processRightClickBlock_5_, EnumHand p_processRightClickBlock_6_) {
        this.syncCurrentPlayItem();
        ItemStack itemstack = p_processRightClickBlock_1_.getHeldItem(p_processRightClickBlock_6_);
        float f = (float)(p_processRightClickBlock_5_.xCoord - (double)p_processRightClickBlock_3_.getX());
        float f1 = (float)(p_processRightClickBlock_5_.yCoord - (double)p_processRightClickBlock_3_.getY());
        float f2 = (float)(p_processRightClickBlock_5_.zCoord - (double)p_processRightClickBlock_3_.getZ());
        boolean flag = false;
        if (!this.mc.world.getWorldBorder().contains(p_processRightClickBlock_3_)) {
            return EnumActionResult.FAIL;
        }
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock(p_processRightClickBlock_1_, p_processRightClickBlock_6_, p_processRightClickBlock_3_, p_processRightClickBlock_4_, ForgeHooks.rayTraceEyeHitVec(p_processRightClickBlock_1_, this.getBlockReachDistance() + 1.0f));
        if (event.isCanceled()) {
            this.connection.sendPacket(new CPacketPlayerTryUseItemOnBlock(p_processRightClickBlock_3_, p_processRightClickBlock_4_, p_processRightClickBlock_6_, f, f1, f2));
            return EnumActionResult.PASS;
        }
        EnumActionResult result = EnumActionResult.PASS;
        if (this.currentGameType != GameType.SPECTATOR) {
            ItemBlock itemblock;
            EnumActionResult ret = itemstack.onItemUseFirst(p_processRightClickBlock_1_, p_processRightClickBlock_2_, p_processRightClickBlock_3_, p_processRightClickBlock_6_, p_processRightClickBlock_4_, f, f1, f2);
            if (ret != EnumActionResult.PASS) {
                return ret;
            }
            IBlockState iblockstate = p_processRightClickBlock_2_.getBlockState(p_processRightClickBlock_3_);
            boolean bypass = true;
            for (ItemStack s : new ItemStack[]{p_processRightClickBlock_1_.getHeldItemMainhand(), p_processRightClickBlock_1_.getHeldItemOffhand()}) {
                bypass = bypass && (s.isEmpty() || s.getItem().doesSneakBypassUse(s, p_processRightClickBlock_2_, p_processRightClickBlock_3_, p_processRightClickBlock_1_));
            }
            if (!p_processRightClickBlock_1_.isSneaking() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
                if (event.getUseBlock() != Event.Result.DENY) {
                    flag = iblockstate.getBlock().onBlockActivated(p_processRightClickBlock_2_, p_processRightClickBlock_3_, iblockstate, p_processRightClickBlock_1_, p_processRightClickBlock_6_, p_processRightClickBlock_4_, f, f1, f2);
                }
                if (flag) {
                    result = EnumActionResult.SUCCESS;
                }
            }
            if (!flag && itemstack.getItem() instanceof ItemBlock && !(itemblock = (ItemBlock)itemstack.getItem()).canPlaceBlockOnSide(p_processRightClickBlock_2_, p_processRightClickBlock_3_, p_processRightClickBlock_4_, p_processRightClickBlock_1_, itemstack)) {
                return EnumActionResult.FAIL;
            }
        }
        this.connection.sendPacket(new CPacketPlayerTryUseItemOnBlock(p_processRightClickBlock_3_, p_processRightClickBlock_4_, p_processRightClickBlock_6_, f, f1, f2));
        if (!flag && this.currentGameType != GameType.SPECTATOR || event.getUseItem() == Event.Result.ALLOW) {
            Block block;
            if (itemstack.isEmpty()) {
                return EnumActionResult.PASS;
            }
            if (p_processRightClickBlock_1_.getCooldownTracker().hasCooldown(itemstack.getItem())) {
                return EnumActionResult.PASS;
            }
            if (itemstack.getItem() instanceof ItemBlock && !p_processRightClickBlock_1_.canUseCommandBlock() && ((block = ((ItemBlock)itemstack.getItem()).getBlock()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
                return EnumActionResult.FAIL;
            }
            if (this.currentGameType.isCreative()) {
                int i = itemstack.getMetadata();
                int j = itemstack.getCount();
                if (event.getUseItem() != Event.Result.DENY) {
                    EnumActionResult enumactionresult = itemstack.onItemUse(p_processRightClickBlock_1_, p_processRightClickBlock_2_, p_processRightClickBlock_3_, p_processRightClickBlock_6_, p_processRightClickBlock_4_, f, f1, f2);
                    itemstack.setItemDamage(i);
                    itemstack.setCount(j);
                    return enumactionresult;
                }
                return result;
            }
            ItemStack copyForUse = itemstack.copy();
            if (event.getUseItem() != Event.Result.DENY) {
                result = itemstack.onItemUse(p_processRightClickBlock_1_, p_processRightClickBlock_2_, p_processRightClickBlock_3_, p_processRightClickBlock_6_, p_processRightClickBlock_4_, f, f1, f2);
            }
            if (itemstack.isEmpty()) {
                ForgeEventFactory.onPlayerDestroyItem(p_processRightClickBlock_1_, copyForUse, p_processRightClickBlock_6_);
            }
            return result;
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult processRightClick(EntityPlayer p_processRightClick_1_, World p_processRightClick_2_, EnumHand p_processRightClick_3_) {
        if (this.currentGameType == GameType.SPECTATOR) {
            return EnumActionResult.PASS;
        }
        this.syncCurrentPlayItem();
        this.connection.sendPacket(new CPacketPlayerTryUseItem(p_processRightClick_3_));
        ItemStack itemstack = p_processRightClick_1_.getHeldItem(p_processRightClick_3_);
        if (p_processRightClick_1_.getCooldownTracker().hasCooldown(itemstack.getItem())) {
            return EnumActionResult.PASS;
        }
        if (ForgeHooks.onItemRightClick(p_processRightClick_1_, p_processRightClick_3_)) {
            return EnumActionResult.PASS;
        }
        int i = itemstack.getCount();
        ActionResult<ItemStack> actionresult = itemstack.useItemRightClick(p_processRightClick_2_, p_processRightClick_1_, p_processRightClick_3_);
        ItemStack itemstack1 = actionresult.getResult();
        if (itemstack1 != itemstack || itemstack1.getCount() != i) {
            p_processRightClick_1_.setHeldItem(p_processRightClick_3_, itemstack1);
            if (itemstack1.isEmpty()) {
                ForgeEventFactory.onPlayerDestroyItem(p_processRightClick_1_, itemstack, p_processRightClick_3_);
            }
        }
        return actionresult.getType();
    }

    public EntityPlayerSP createClientPlayer(World p_createClientPlayer_1_, StatisticsManager p_createClientPlayer_2_) {
        return new EntityPlayerSP(this.mc, p_createClientPlayer_1_, this.connection, p_createClientPlayer_2_);
    }

    public void attackEntity(EntityPlayer p_attackEntity_1_, Entity p_attackEntity_2_) {
        this.syncCurrentPlayItem();
        this.connection.sendPacket(new CPacketUseEntity(p_attackEntity_2_));
        if (this.currentGameType != GameType.SPECTATOR) {
            p_attackEntity_1_.attackTargetEntityWithCurrentItem(p_attackEntity_2_);
            p_attackEntity_1_.resetCooldown();
        }
    }

    public EnumActionResult interactWithEntity(EntityPlayer p_interactWithEntity_1_, Entity p_interactWithEntity_2_, EnumHand p_interactWithEntity_3_) {
        this.syncCurrentPlayItem();
        this.connection.sendPacket(new CPacketUseEntity(p_interactWithEntity_2_, p_interactWithEntity_3_));
        return this.currentGameType == GameType.SPECTATOR ? EnumActionResult.PASS : p_interactWithEntity_1_.interactOn(p_interactWithEntity_2_, p_interactWithEntity_3_);
    }

    public EnumActionResult interactWithEntity(EntityPlayer p_interactWithEntity_1_, Entity p_interactWithEntity_2_, RayTraceResult p_interactWithEntity_3_, EnumHand p_interactWithEntity_4_) {
        this.syncCurrentPlayItem();
        Vec3d vec3d = new Vec3d(p_interactWithEntity_3_.hitVec.xCoord - p_interactWithEntity_2_.posX, p_interactWithEntity_3_.hitVec.yCoord - p_interactWithEntity_2_.posY, p_interactWithEntity_3_.hitVec.zCoord - p_interactWithEntity_2_.posZ);
        this.connection.sendPacket(new CPacketUseEntity(p_interactWithEntity_2_, p_interactWithEntity_4_, vec3d));
        if (ForgeHooks.onInteractEntityAt(p_interactWithEntity_1_, p_interactWithEntity_2_, p_interactWithEntity_3_, p_interactWithEntity_4_)) {
            return EnumActionResult.PASS;
        }
        return this.currentGameType == GameType.SPECTATOR ? EnumActionResult.PASS : p_interactWithEntity_2_.applyPlayerInteraction(p_interactWithEntity_1_, vec3d, p_interactWithEntity_4_);
    }

    public ItemStack windowClick(int p_windowClick_1_, int p_windowClick_2_, int p_windowClick_3_, ClickType p_windowClick_4_, EntityPlayer p_windowClick_5_) {
        short short1 = p_windowClick_5_.openContainer.getNextTransactionID(p_windowClick_5_.inventory);
        ItemStack itemstack = p_windowClick_5_.openContainer.slotClick(p_windowClick_2_, p_windowClick_3_, p_windowClick_4_, p_windowClick_5_);
        this.connection.sendPacket(new CPacketClickWindow(p_windowClick_1_, p_windowClick_2_, p_windowClick_3_, p_windowClick_4_, itemstack, short1));
        return itemstack;
    }

    public void sendEnchantPacket(int p_sendEnchantPacket_1_, int p_sendEnchantPacket_2_) {
        this.connection.sendPacket(new CPacketEnchantItem(p_sendEnchantPacket_1_, p_sendEnchantPacket_2_));
    }

    public void sendSlotPacket(ItemStack p_sendSlotPacket_1_, int p_sendSlotPacket_2_) {
        if (this.currentGameType.isCreative()) {
            this.connection.sendPacket(new CPacketCreativeInventoryAction(p_sendSlotPacket_2_, p_sendSlotPacket_1_));
        }
    }

    public void sendPacketDropItem(ItemStack p_sendPacketDropItem_1_) {
        if (this.currentGameType.isCreative() && !p_sendPacketDropItem_1_.isEmpty()) {
            this.connection.sendPacket(new CPacketCreativeInventoryAction(-1, p_sendPacketDropItem_1_));
        }
    }

    public void onStoppedUsingItem(EntityPlayer p_onStoppedUsingItem_1_) {
        this.syncCurrentPlayItem();
        this.connection.sendPacket(new CPacketPlayerDigging(CPacketPlayerDigging.Action.RELEASE_USE_ITEM, BlockPos.ORIGIN, EnumFacing.DOWN));
        p_onStoppedUsingItem_1_.stopActiveHand();
    }

    public boolean gameIsSurvivalOrAdventure() {
        return this.currentGameType.isSurvivalOrAdventure();
    }

    public boolean isNotCreative() {
        return !this.currentGameType.isCreative();
    }

    public boolean isInCreativeMode() {
        return this.currentGameType.isCreative();
    }

    public boolean extendedReach() {
        return this.currentGameType.isCreative();
    }

    public boolean isRidingHorse() {
        return this.mc.player.isRiding() && this.mc.player.getRidingEntity() instanceof AbstractHorse;
    }

    public boolean isSpectatorMode() {
        return this.currentGameType == GameType.SPECTATOR;
    }

    public GameType getCurrentGameType() {
        return this.currentGameType;
    }

    public boolean getIsHittingBlock() {
        return this.isHittingBlock;
    }

    public void pickItem(int p_pickItem_1_) {
        this.connection.sendPacket(new CPacketCustomPayload("MC|PickItem", new PacketBuffer(Unpooled.buffer()).writeVarInt(p_pickItem_1_)));
    }
}

