/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ServerData {
    public String serverName;
    public String serverIP;
    public String populationInfo;
    public String serverMOTD;
    public long pingToServer;
    public int version = 316;
    public String gameVersion = "1.11.2";
    public boolean pinged;
    public String playerList;
    private ServerResourceMode resourceMode = ServerResourceMode.PROMPT;
    private String serverIcon;
    private boolean lanServer;

    public ServerData(String p_i46420_1_, String p_i46420_2_, boolean p_i46420_3_) {
        this.serverName = p_i46420_1_;
        this.serverIP = p_i46420_2_;
        this.lanServer = p_i46420_3_;
    }

    public NBTTagCompound getNBTCompound() {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        lvt_1_1_.setString("name", this.serverName);
        lvt_1_1_.setString("ip", this.serverIP);
        if (this.serverIcon != null) {
            lvt_1_1_.setString("icon", this.serverIcon);
        }
        if (this.resourceMode == ServerResourceMode.ENABLED) {
            lvt_1_1_.setBoolean("acceptTextures", true);
        } else if (this.resourceMode == ServerResourceMode.DISABLED) {
            lvt_1_1_.setBoolean("acceptTextures", false);
        }
        return lvt_1_1_;
    }

    public ServerResourceMode getResourceMode() {
        return this.resourceMode;
    }

    public void setResourceMode(ServerResourceMode p_setResourceMode_1_) {
        this.resourceMode = p_setResourceMode_1_;
    }

    public static ServerData getServerDataFromNBTCompound(NBTTagCompound p_getServerDataFromNBTCompound_0_) {
        ServerData lvt_1_1_ = new ServerData(p_getServerDataFromNBTCompound_0_.getString("name"), p_getServerDataFromNBTCompound_0_.getString("ip"), false);
        if (p_getServerDataFromNBTCompound_0_.hasKey("icon", 8)) {
            lvt_1_1_.setBase64EncodedIconData(p_getServerDataFromNBTCompound_0_.getString("icon"));
        }
        if (p_getServerDataFromNBTCompound_0_.hasKey("acceptTextures", 1)) {
            if (p_getServerDataFromNBTCompound_0_.getBoolean("acceptTextures")) {
                lvt_1_1_.setResourceMode(ServerResourceMode.ENABLED);
            } else {
                lvt_1_1_.setResourceMode(ServerResourceMode.DISABLED);
            }
        } else {
            lvt_1_1_.setResourceMode(ServerResourceMode.PROMPT);
        }
        return lvt_1_1_;
    }

    public String getBase64EncodedIconData() {
        return this.serverIcon;
    }

    public void setBase64EncodedIconData(String p_setBase64EncodedIconData_1_) {
        this.serverIcon = p_setBase64EncodedIconData_1_;
    }

    public boolean isOnLAN() {
        return this.lanServer;
    }

    public void copyFrom(ServerData p_copyFrom_1_) {
        this.serverIP = p_copyFrom_1_.serverIP;
        this.serverName = p_copyFrom_1_.serverName;
        this.setResourceMode(p_copyFrom_1_.getResourceMode());
        this.serverIcon = p_copyFrom_1_.serverIcon;
        this.lanServer = p_copyFrom_1_.lanServer;
    }

    @SideOnly(value=Side.CLIENT)
    public static enum ServerResourceMode {
        ENABLED("enabled"),
        DISABLED("disabled"),
        PROMPT("prompt");

        private final ITextComponent motd;

        private ServerResourceMode(String p_i1053_3_) {
            this.motd = new TextComponentTranslation("addServer.resourcePack." + p_i1053_3_, new Object[0]);
        }

        public ITextComponent getMotd() {
            return this.motd;
        }
    }
}

