/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ServerList {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft mc;
    private final List<ServerData> servers = Lists.newArrayList();

    public ServerList(Minecraft p_i1194_1_) {
        this.mc = p_i1194_1_;
        this.loadServerList();
    }

    public void loadServerList() {
        try {
            this.servers.clear();
            NBTTagCompound lvt_1_1_ = CompressedStreamTools.read(new File(this.mc.mcDataDir, "servers.dat"));
            if (lvt_1_1_ == null) {
                return;
            }
            NBTTagList lvt_2_1_ = lvt_1_1_.getTagList("servers", 10);
            for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
                this.servers.add(ServerData.getServerDataFromNBTCompound(lvt_2_1_.getCompoundTagAt(lvt_3_1_)));
            }
        }
        catch (Exception lvt_1_2_) {
            LOGGER.error("Couldn't load server list", (Throwable)lvt_1_2_);
        }
    }

    public void saveServerList() {
        try {
            NBTTagList lvt_1_1_ = new NBTTagList();
            for (ServerData lvt_3_1_ : this.servers) {
                lvt_1_1_.appendTag(lvt_3_1_.getNBTCompound());
            }
            NBTTagCompound lvt_2_1_ = new NBTTagCompound();
            lvt_2_1_.setTag("servers", lvt_1_1_);
            CompressedStreamTools.safeWrite(lvt_2_1_, new File(this.mc.mcDataDir, "servers.dat"));
        }
        catch (Exception lvt_1_2_) {
            LOGGER.error("Couldn't save server list", (Throwable)lvt_1_2_);
        }
    }

    public ServerData getServerData(int p_getServerData_1_) {
        return this.servers.get(p_getServerData_1_);
    }

    public void removeServerData(int p_removeServerData_1_) {
        this.servers.remove(p_removeServerData_1_);
    }

    public void addServerData(ServerData p_addServerData_1_) {
        this.servers.add(p_addServerData_1_);
    }

    public int countServers() {
        return this.servers.size();
    }

    public void swapServers(int p_swapServers_1_, int p_swapServers_2_) {
        ServerData lvt_3_1_ = this.getServerData(p_swapServers_1_);
        this.servers.set(p_swapServers_1_, this.getServerData(p_swapServers_2_));
        this.servers.set(p_swapServers_2_, lvt_3_1_);
        this.saveServerList();
    }

    public void set(int p_set_1_, ServerData p_set_2_) {
        this.servers.set(p_set_1_, p_set_2_);
    }

    public static void saveSingleServer(ServerData p_saveSingleServer_0_) {
        ServerList lvt_1_1_ = new ServerList(Minecraft.getMinecraft());
        lvt_1_1_.loadServerList();
        for (int lvt_2_1_ = 0; lvt_2_1_ < lvt_1_1_.countServers(); ++lvt_2_1_) {
            ServerData lvt_3_1_ = lvt_1_1_.getServerData(lvt_2_1_);
            if (!lvt_3_1_.serverName.equals(p_saveSingleServer_0_.serverName) || !lvt_3_1_.serverIP.equals(p_saveSingleServer_0_.serverIP)) continue;
            lvt_1_1_.set(lvt_2_1_, p_saveSingleServer_0_);
            break;
        }
        lvt_1_1_.saveServerList();
    }
}

