/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class ThreadLanServerPing
extends Thread {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    private static final Logger LOGGER = LogManager.getLogger();
    private final String motd;
    private final DatagramSocket socket;
    private boolean isStopping = true;
    private final String address;

    public ThreadLanServerPing(String p_i1321_1_, String p_i1321_2_) throws IOException {
        super("LanServerPinger #" + UNIQUE_THREAD_ID.incrementAndGet());
        this.motd = p_i1321_1_;
        this.address = p_i1321_2_;
        this.setDaemon(true);
        this.socket = new DatagramSocket();
    }

    @Override
    public void run() {
        String lvt_1_1_ = ThreadLanServerPing.getPingResponse(this.motd, this.address);
        byte[] lvt_2_1_ = lvt_1_1_.getBytes();
        while (!this.isInterrupted() && this.isStopping) {
            try {
                InetAddress lvt_3_1_ = InetAddress.getByName("224.0.2.60");
                DatagramPacket lvt_4_1_ = new DatagramPacket(lvt_2_1_, lvt_2_1_.length, lvt_3_1_, 4445);
                this.socket.send(lvt_4_1_);
            }
            catch (IOException lvt_3_2_) {
                LOGGER.warn("LanServerPinger: {}", new Object[]{lvt_3_2_.getMessage()});
                break;
            }
            try {
                ThreadLanServerPing.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.isStopping = false;
    }

    public static String getPingResponse(String p_getPingResponse_0_, String p_getPingResponse_1_) {
        return "[MOTD]" + p_getPingResponse_0_ + "[/MOTD][AD]" + p_getPingResponse_1_ + "[/AD]";
    }

    public static String getMotdFromPingResponse(String p_getMotdFromPingResponse_0_) {
        int lvt_1_1_ = p_getMotdFromPingResponse_0_.indexOf("[MOTD]");
        if (lvt_1_1_ < 0) {
            return "missing no";
        }
        int lvt_2_1_ = p_getMotdFromPingResponse_0_.indexOf("[/MOTD]", lvt_1_1_ + "[MOTD]".length());
        if (lvt_2_1_ < lvt_1_1_) {
            return "missing no";
        }
        return p_getMotdFromPingResponse_0_.substring(lvt_1_1_ + "[MOTD]".length(), lvt_2_1_);
    }

    public static String getAdFromPingResponse(String p_getAdFromPingResponse_0_) {
        int lvt_1_1_ = p_getAdFromPingResponse_0_.indexOf("[/MOTD]");
        if (lvt_1_1_ < 0) {
            return null;
        }
        int lvt_2_1_ = p_getAdFromPingResponse_0_.indexOf("[/MOTD]", lvt_1_1_ + "[/MOTD]".length());
        if (lvt_2_1_ >= 0) {
            return null;
        }
        int lvt_3_1_ = p_getAdFromPingResponse_0_.indexOf("[AD]", lvt_1_1_ + "[/MOTD]".length());
        if (lvt_3_1_ < 0) {
            return null;
        }
        int lvt_4_1_ = p_getAdFromPingResponse_0_.indexOf("[/AD]", lvt_3_1_ + "[AD]".length());
        if (lvt_4_1_ < lvt_3_1_) {
            return null;
        }
        return p_getAdFromPingResponse_0_.substring(lvt_3_1_ + "[AD]".length(), lvt_4_1_);
    }
}

