/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MovingSoundMinecart;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.SaveDataMemoryStorage;
import net.minecraft.world.storage.SaveHandlerMP;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WorldClient
extends World {
    private final NetHandlerPlayClient connection;
    private ChunkProviderClient clientChunkProvider;
    private final Set<Entity> entityList = Sets.newHashSet();
    private final Set<Entity> entitySpawnQueue = Sets.newHashSet();
    private final Minecraft mc = Minecraft.getMinecraft();
    private final Set<ChunkPos> previousActiveChunkSet = Sets.newHashSet();
    private int ambienceTicks = this.rand.nextInt(12000);
    protected Set<ChunkPos> viewableChunks = Sets.newHashSet();

    public WorldClient(NetHandlerPlayClient p_i45063_1_, WorldSettings p_i45063_2_, int p_i45063_3_, EnumDifficulty p_i45063_4_, Profiler p_i45063_5_) {
        super(new SaveHandlerMP(), new WorldInfo(p_i45063_2_, "MpServer"), DimensionManager.createProviderFor(p_i45063_3_), p_i45063_5_, true);
        this.connection = p_i45063_1_;
        this.getWorldInfo().setDifficulty(p_i45063_4_);
        this.provider.setWorld(this);
        this.setSpawnPoint(new BlockPos(8, 64, 8));
        this.chunkProvider = this.createChunkProvider();
        this.mapStorage = new SaveDataMemoryStorage();
        this.calculateInitialSkylight();
        this.calculateInitialWeather();
        this.initCapabilities();
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(this));
    }

    @Override
    public void tick() {
        super.tick();
        this.setTotalWorldTime(this.getTotalWorldTime() + 1L);
        if (this.getGameRules().getBoolean("doDaylightCycle")) {
            this.setWorldTime(this.getWorldTime() + 1L);
        }
        this.theProfiler.startSection("reEntryProcessing");
        for (int i = 0; i < 10 && !this.entitySpawnQueue.isEmpty(); ++i) {
            Entity entity = this.entitySpawnQueue.iterator().next();
            this.entitySpawnQueue.remove(entity);
            if (this.loadedEntityList.contains(entity)) continue;
            this.spawnEntity(entity);
        }
        this.theProfiler.endStartSection("chunkCache");
        this.clientChunkProvider.tick();
        this.theProfiler.endStartSection("blocks");
        this.updateBlocks();
        this.theProfiler.endSection();
    }

    public void invalidateBlockReceiveRegion(int p_invalidateBlockReceiveRegion_1_, int p_invalidateBlockReceiveRegion_2_, int p_invalidateBlockReceiveRegion_3_, int p_invalidateBlockReceiveRegion_4_, int p_invalidateBlockReceiveRegion_5_, int p_invalidateBlockReceiveRegion_6_) {
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        this.clientChunkProvider = new ChunkProviderClient(this);
        return this.clientChunkProvider;
    }

    @Override
    protected boolean isChunkLoaded(int p_isChunkLoaded_1_, int p_isChunkLoaded_2_, boolean p_isChunkLoaded_3_) {
        return p_isChunkLoaded_3_ || !this.getChunkProvider().provideChunk(p_isChunkLoaded_1_, p_isChunkLoaded_2_).isEmpty();
    }

    protected void buildChunkCoordList() {
        this.viewableChunks.clear();
        int i = this.mc.gameSettings.renderDistanceChunks;
        this.theProfiler.startSection("buildList");
        int j = MathHelper.floor(this.mc.player.posX / 16.0);
        int k = MathHelper.floor(this.mc.player.posZ / 16.0);
        for (int l = -i; l <= i; ++l) {
            for (int i1 = -i; i1 <= i; ++i1) {
                this.viewableChunks.add(new ChunkPos(l + j, i1 + k));
            }
        }
        this.theProfiler.endSection();
    }

    @Override
    protected void updateBlocks() {
        this.buildChunkCoordList();
        if (this.ambienceTicks > 0) {
            --this.ambienceTicks;
        }
        this.previousActiveChunkSet.retainAll(this.viewableChunks);
        if (this.previousActiveChunkSet.size() == this.viewableChunks.size()) {
            this.previousActiveChunkSet.clear();
        }
        int i = 0;
        for (ChunkPos chunkpos : this.viewableChunks) {
            if (this.previousActiveChunkSet.contains(chunkpos)) continue;
            int j = chunkpos.chunkXPos * 16;
            int k = chunkpos.chunkZPos * 16;
            this.theProfiler.startSection("getChunk");
            Chunk chunk = this.getChunkFromChunkCoords(chunkpos.chunkXPos, chunkpos.chunkZPos);
            this.playMoodSoundAndCheckLight(j, k, chunk);
            this.theProfiler.endSection();
            this.previousActiveChunkSet.add(chunkpos);
            if (++i < 10) continue;
            return;
        }
    }

    public void doPreChunk(int p_doPreChunk_1_, int p_doPreChunk_2_, boolean p_doPreChunk_3_) {
        if (p_doPreChunk_3_) {
            this.clientChunkProvider.loadChunk(p_doPreChunk_1_, p_doPreChunk_2_);
        } else {
            this.clientChunkProvider.unloadChunk(p_doPreChunk_1_, p_doPreChunk_2_);
            this.markBlockRangeForRenderUpdate(p_doPreChunk_1_ * 16, 0, p_doPreChunk_2_ * 16, p_doPreChunk_1_ * 16 + 15, 256, p_doPreChunk_2_ * 16 + 15);
        }
    }

    @Override
    public boolean spawnEntity(Entity p_spawnEntity_1_) {
        boolean flag = super.spawnEntity(p_spawnEntity_1_);
        this.entityList.add(p_spawnEntity_1_);
        if (flag) {
            if (p_spawnEntity_1_ instanceof EntityMinecart) {
                this.mc.getSoundHandler().playSound(new MovingSoundMinecart((EntityMinecart)p_spawnEntity_1_));
            }
        } else {
            this.entitySpawnQueue.add(p_spawnEntity_1_);
        }
        return flag;
    }

    @Override
    public void removeEntity(Entity p_removeEntity_1_) {
        super.removeEntity(p_removeEntity_1_);
        this.entityList.remove(p_removeEntity_1_);
    }

    @Override
    public void onEntityAdded(Entity p_onEntityAdded_1_) {
        super.onEntityAdded(p_onEntityAdded_1_);
        if (this.entitySpawnQueue.contains(p_onEntityAdded_1_)) {
            this.entitySpawnQueue.remove(p_onEntityAdded_1_);
        }
    }

    @Override
    public void onEntityRemoved(Entity p_onEntityRemoved_1_) {
        super.onEntityRemoved(p_onEntityRemoved_1_);
        if (this.entityList.contains(p_onEntityRemoved_1_)) {
            if (p_onEntityRemoved_1_.isEntityAlive()) {
                this.entitySpawnQueue.add(p_onEntityRemoved_1_);
            } else {
                this.entityList.remove(p_onEntityRemoved_1_);
            }
        }
    }

    public void addEntityToWorld(int p_addEntityToWorld_1_, Entity p_addEntityToWorld_2_) {
        Entity entity = this.getEntityByID(p_addEntityToWorld_1_);
        if (entity != null) {
            this.removeEntity(entity);
        }
        this.entityList.add(p_addEntityToWorld_2_);
        p_addEntityToWorld_2_.setEntityId(p_addEntityToWorld_1_);
        if (!this.spawnEntity(p_addEntityToWorld_2_)) {
            this.entitySpawnQueue.add(p_addEntityToWorld_2_);
        }
        this.entitiesById.addKey(p_addEntityToWorld_1_, p_addEntityToWorld_2_);
    }

    @Override
    @Nullable
    public Entity getEntityByID(int p_getEntityByID_1_) {
        return p_getEntityByID_1_ == this.mc.player.getEntityId() ? this.mc.player : super.getEntityByID(p_getEntityByID_1_);
    }

    public Entity removeEntityFromWorld(int p_removeEntityFromWorld_1_) {
        Entity entity = (Entity)this.entitiesById.removeObject(p_removeEntityFromWorld_1_);
        if (entity != null) {
            this.entityList.remove(entity);
            this.removeEntity(entity);
        }
        return entity;
    }

    @Deprecated
    public boolean invalidateRegionAndSetBlock(BlockPos p_invalidateRegionAndSetBlock_1_, IBlockState p_invalidateRegionAndSetBlock_2_) {
        int i = p_invalidateRegionAndSetBlock_1_.getX();
        int j = p_invalidateRegionAndSetBlock_1_.getY();
        int k = p_invalidateRegionAndSetBlock_1_.getZ();
        this.invalidateBlockReceiveRegion(i, j, k, i, j, k);
        return super.setBlockState(p_invalidateRegionAndSetBlock_1_, p_invalidateRegionAndSetBlock_2_, 3);
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.connection.getNetworkManager().closeChannel(new TextComponentString("Quitting"));
    }

    @Override
    protected void updateWeather() {
    }

    @Override
    protected void playMoodSoundAndCheckLight(int p_playMoodSoundAndCheckLight_1_, int p_playMoodSoundAndCheckLight_2_, Chunk p_playMoodSoundAndCheckLight_3_) {
        super.playMoodSoundAndCheckLight(p_playMoodSoundAndCheckLight_1_, p_playMoodSoundAndCheckLight_2_, p_playMoodSoundAndCheckLight_3_);
        if (this.ambienceTicks == 0) {
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int i = this.updateLCG >> 2;
            int j = i & 0xF;
            int k = i >> 8 & 0xF;
            int l = i >> 16 & 0xFF;
            BlockPos blockpos = new BlockPos(j + p_playMoodSoundAndCheckLight_1_, l, k + p_playMoodSoundAndCheckLight_2_);
            IBlockState iblockstate = p_playMoodSoundAndCheckLight_3_.getBlockState(blockpos);
            j += p_playMoodSoundAndCheckLight_1_;
            k += p_playMoodSoundAndCheckLight_2_;
            if (iblockstate.getMaterial() == Material.AIR && this.getLight(blockpos) <= this.rand.nextInt(8) && this.getLightFor(EnumSkyBlock.SKY, blockpos) <= 0 && this.mc.player != null && this.mc.player.getDistanceSq((double)j + 0.5, (double)l + 0.5, (double)k + 0.5) > 4.0) {
                this.playSound((double)j + 0.5, (double)l + 0.5, (double)k + 0.5, SoundEvents.AMBIENT_CAVE, SoundCategory.AMBIENT, 0.7f, 0.8f + this.rand.nextFloat() * 0.2f, false);
                this.ambienceTicks = this.rand.nextInt(12000) + 6000;
            }
        }
    }

    public void doVoidFogParticles(int p_doVoidFogParticles_1_, int p_doVoidFogParticles_2_, int p_doVoidFogParticles_3_) {
        int i = 32;
        Random random = new Random();
        ItemStack itemstack = this.mc.player.getHeldItemMainhand();
        boolean flag = this.mc.playerController.getCurrentGameType() == GameType.CREATIVE && !itemstack.isEmpty() && itemstack.getItem() == Item.getItemFromBlock(Blocks.BARRIER);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = 0; j < 667; ++j) {
            this.showBarrierParticles(p_doVoidFogParticles_1_, p_doVoidFogParticles_2_, p_doVoidFogParticles_3_, 16, random, flag, blockpos$mutableblockpos);
            this.showBarrierParticles(p_doVoidFogParticles_1_, p_doVoidFogParticles_2_, p_doVoidFogParticles_3_, 32, random, flag, blockpos$mutableblockpos);
        }
    }

    public void showBarrierParticles(int p_showBarrierParticles_1_, int p_showBarrierParticles_2_, int p_showBarrierParticles_3_, int p_showBarrierParticles_4_, Random p_showBarrierParticles_5_, boolean p_showBarrierParticles_6_, BlockPos.MutableBlockPos p_showBarrierParticles_7_) {
        int i = p_showBarrierParticles_1_ + this.rand.nextInt(p_showBarrierParticles_4_) - this.rand.nextInt(p_showBarrierParticles_4_);
        int j = p_showBarrierParticles_2_ + this.rand.nextInt(p_showBarrierParticles_4_) - this.rand.nextInt(p_showBarrierParticles_4_);
        int k = p_showBarrierParticles_3_ + this.rand.nextInt(p_showBarrierParticles_4_) - this.rand.nextInt(p_showBarrierParticles_4_);
        p_showBarrierParticles_7_.setPos(i, j, k);
        IBlockState iblockstate = this.getBlockState(p_showBarrierParticles_7_);
        iblockstate.getBlock().randomDisplayTick(iblockstate, this, p_showBarrierParticles_7_, p_showBarrierParticles_5_);
        if (p_showBarrierParticles_6_ && iblockstate.getBlock() == Blocks.BARRIER) {
            this.spawnParticle(EnumParticleTypes.BARRIER, (float)i + 0.5f, (double)((float)j + 0.5f), (double)((float)k + 0.5f), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void removeAllEntities() {
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int i = 0; i < this.unloadedEntityList.size(); ++i) {
            Entity entity = (Entity)this.unloadedEntityList.get(i);
            int j = entity.chunkCoordX;
            int k = entity.chunkCoordZ;
            if (!entity.addedToChunk || !this.isChunkLoaded(j, k, true)) continue;
            this.getChunkFromChunkCoords(j, k).removeEntity(entity);
        }
        for (int i1 = 0; i1 < this.unloadedEntityList.size(); ++i1) {
            this.onEntityRemoved((Entity)this.unloadedEntityList.get(i1));
        }
        this.unloadedEntityList.clear();
        for (int j1 = 0; j1 < this.loadedEntityList.size(); ++j1) {
            Entity entity1 = (Entity)this.loadedEntityList.get(j1);
            Entity entity2 = entity1.getRidingEntity();
            if (entity2 != null) {
                if (!entity2.isDead && entity2.isPassenger(entity1)) continue;
                entity1.dismountRidingEntity();
            }
            if (!entity1.isDead) continue;
            int k1 = entity1.chunkCoordX;
            int l = entity1.chunkCoordZ;
            if (entity1.addedToChunk && this.isChunkLoaded(k1, l, true)) {
                this.getChunkFromChunkCoords(k1, l).removeEntity(entity1);
            }
            this.loadedEntityList.remove(j1--);
            this.onEntityRemoved(entity1);
        }
    }

    @Override
    public CrashReportCategory addWorldInfoToCrashReport(CrashReport p_addWorldInfoToCrashReport_1_) {
        CrashReportCategory crashreportcategory = super.addWorldInfoToCrashReport(p_addWorldInfoToCrashReport_1_);
        crashreportcategory.setDetail("Forced entities", new ICrashReportDetail<String>(){

            @Override
            public String call() {
                return WorldClient.this.entityList.size() + " total; " + WorldClient.this.entityList;
            }
        });
        crashreportcategory.setDetail("Retry entities", new ICrashReportDetail<String>(){

            @Override
            public String call() {
                return WorldClient.this.entitySpawnQueue.size() + " total; " + WorldClient.this.entitySpawnQueue;
            }
        });
        crashreportcategory.setDetail("Server brand", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return ((WorldClient)WorldClient.this).mc.player.getServerBrand();
            }
        });
        crashreportcategory.setDetail("Server type", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return WorldClient.this.mc.getIntegratedServer() == null ? "Non-integrated multiplayer server" : "Integrated singleplayer server";
            }
        });
        return crashreportcategory;
    }

    @Override
    public void playSound(EntityPlayer p_playSound_1_, double p_playSound_2_, double p_playSound_4_, double p_playSound_6_, SoundEvent p_playSound_8_, SoundCategory p_playSound_9_, float p_playSound_10_, float p_playSound_11_) {
        if (p_playSound_1_ == this.mc.player) {
            this.playSound(p_playSound_2_, p_playSound_4_, p_playSound_6_, p_playSound_8_, p_playSound_9_, p_playSound_10_, p_playSound_11_, false);
        }
    }

    public void playSound(BlockPos p_playSound_1_, SoundEvent p_playSound_2_, SoundCategory p_playSound_3_, float p_playSound_4_, float p_playSound_5_, boolean p_playSound_6_) {
        this.playSound((double)p_playSound_1_.getX() + 0.5, (double)p_playSound_1_.getY() + 0.5, (double)p_playSound_1_.getZ() + 0.5, p_playSound_2_, p_playSound_3_, p_playSound_4_, p_playSound_5_, p_playSound_6_);
    }

    @Override
    public void playSound(double p_playSound_1_, double p_playSound_3_, double p_playSound_5_, SoundEvent p_playSound_7_, SoundCategory p_playSound_8_, float p_playSound_9_, float p_playSound_10_, boolean p_playSound_11_) {
        double d0 = this.mc.getRenderViewEntity().getDistanceSq(p_playSound_1_, p_playSound_3_, p_playSound_5_);
        PositionedSoundRecord positionedsoundrecord = new PositionedSoundRecord(p_playSound_7_, p_playSound_8_, p_playSound_9_, p_playSound_10_, (float)p_playSound_1_, (float)p_playSound_3_, (float)p_playSound_5_);
        if (p_playSound_11_ && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            this.mc.getSoundHandler().playDelayedSound(positionedsoundrecord, (int)(d1 * 20.0));
        } else {
            this.mc.getSoundHandler().playSound(positionedsoundrecord);
        }
    }

    @Override
    public void makeFireworks(double p_makeFireworks_1_, double p_makeFireworks_3_, double p_makeFireworks_5_, double p_makeFireworks_7_, double p_makeFireworks_9_, double p_makeFireworks_11_, NBTTagCompound p_makeFireworks_13_) {
        this.mc.effectRenderer.addEffect(new ParticleFirework.Starter(this, p_makeFireworks_1_, p_makeFireworks_3_, p_makeFireworks_5_, p_makeFireworks_7_, p_makeFireworks_9_, p_makeFireworks_11_, this.mc.effectRenderer, p_makeFireworks_13_));
    }

    @Override
    public void sendPacketToServer(Packet<?> p_sendPacketToServer_1_) {
        this.connection.sendPacket(p_sendPacketToServer_1_);
    }

    public void setWorldScoreboard(Scoreboard p_setWorldScoreboard_1_) {
        this.worldScoreboard = p_setWorldScoreboard_1_;
    }

    @Override
    public void setWorldTime(long p_setWorldTime_1_) {
        if (p_setWorldTime_1_ < 0L) {
            p_setWorldTime_1_ = -p_setWorldTime_1_;
            this.getGameRules().setOrCreateGameRule("doDaylightCycle", "false");
        } else {
            this.getGameRules().setOrCreateGameRule("doDaylightCycle", "true");
        }
        super.setWorldTime(p_setWorldTime_1_);
    }

    @Override
    public ChunkProviderClient getChunkProvider() {
        return (ChunkProviderClient)super.getChunkProvider();
    }
}

