/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.multiplayer.ThreadLanServerPing;
import net.minecraft.client.network.LanServerInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class LanServerDetector {
    private static final AtomicInteger ATOMIC_COUNTER = new AtomicInteger(0);
    private static final Logger LOGGER = LogManager.getLogger();

    @SideOnly(value=Side.CLIENT)
    public static class ThreadLanServerFind
    extends Thread {
        private final LanServerList localServerList;
        private final InetAddress broadcastAddress;
        private final MulticastSocket socket;

        public ThreadLanServerFind(LanServerList p_i1320_1_) throws IOException {
            super("LanServerDetector #" + ATOMIC_COUNTER.incrementAndGet());
            this.localServerList = p_i1320_1_;
            this.setDaemon(true);
            this.socket = new MulticastSocket(4445);
            this.broadcastAddress = InetAddress.getByName("224.0.2.60");
            this.socket.setSoTimeout(5000);
            this.socket.joinGroup(this.broadcastAddress);
        }

        @Override
        public void run() {
            byte[] lvt_2_1_ = new byte[1024];
            while (!this.isInterrupted()) {
                DatagramPacket lvt_1_1_ = new DatagramPacket(lvt_2_1_, lvt_2_1_.length);
                try {
                    this.socket.receive(lvt_1_1_);
                }
                catch (SocketTimeoutException lvt_3_1_) {
                    continue;
                }
                catch (IOException lvt_3_2_) {
                    LOGGER.error("Couldn't ping server", (Throwable)lvt_3_2_);
                    break;
                }
                String lvt_3_3_ = new String(lvt_1_1_.getData(), lvt_1_1_.getOffset(), lvt_1_1_.getLength());
                LOGGER.debug("{}: {}", new Object[]{lvt_1_1_.getAddress(), lvt_3_3_});
                this.localServerList.addServer(lvt_3_3_, lvt_1_1_.getAddress());
            }
            try {
                this.socket.leaveGroup(this.broadcastAddress);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket.close();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LanServerList {
        private final List<LanServerInfo> listOfLanServers = Lists.newArrayList();
        boolean wasUpdated;

        public synchronized boolean getWasUpdated() {
            return this.wasUpdated;
        }

        public synchronized void setWasNotUpdated() {
            this.wasUpdated = false;
        }

        public synchronized List<LanServerInfo> getLanServers() {
            return Collections.unmodifiableList(this.listOfLanServers);
        }

        public synchronized void addServer(String p_addServer_1_, InetAddress p_addServer_2_) {
            String lvt_3_1_ = ThreadLanServerPing.getMotdFromPingResponse(p_addServer_1_);
            String lvt_4_1_ = ThreadLanServerPing.getAdFromPingResponse(p_addServer_1_);
            if (lvt_4_1_ == null) {
                return;
            }
            lvt_4_1_ = p_addServer_2_.getHostAddress() + ":" + lvt_4_1_;
            boolean lvt_5_1_ = false;
            for (LanServerInfo lvt_7_1_ : this.listOfLanServers) {
                if (!lvt_7_1_.getServerIpPort().equals(lvt_4_1_)) continue;
                lvt_7_1_.updateLastSeen();
                lvt_5_1_ = true;
                break;
            }
            if (!lvt_5_1_) {
                this.listOfLanServers.add(new LanServerInfo(lvt_3_1_, lvt_4_1_));
                this.wasUpdated = true;
            }
        }
    }
}

