/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.GuardianSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiCommandBlock;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.GuiScreenDemo;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.particle.ParticleItemPickup;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.client.player.inventory.LocalBlockIntercommunication;
import net.minecraft.client.renderer.debug.DebugRendererNeighborsUpdate;
import net.minecraft.client.renderer.debug.DebugRendererPathfinding;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.NpcMerchant;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketConfirmTeleport;
import net.minecraft.network.play.client.CPacketConfirmTransaction;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketKeepAlive;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketBlockAction;
import net.minecraft.network.play.server.SPacketBlockBreakAnim;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketCamera;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketCloseWindow;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.network.play.server.SPacketCombatEvent;
import net.minecraft.network.play.server.SPacketConfirmTransaction;
import net.minecraft.network.play.server.SPacketCooldown;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.network.play.server.SPacketDisplayObjective;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntity;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import net.minecraft.network.play.server.SPacketEntityHeadLook;
import net.minecraft.network.play.server.SPacketEntityMetadata;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketJoinGame;
import net.minecraft.network.play.server.SPacketKeepAlive;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.network.play.server.SPacketMoveVehicle;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerListHeaderFooter;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.network.play.server.SPacketResourcePackSend;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.network.play.server.SPacketServerDifficulty;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketSignEditorOpen;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.network.play.server.SPacketSpawnExperienceOrb;
import net.minecraft.network.play.server.SPacketSpawnGlobalEntity;
import net.minecraft.network.play.server.SPacketSpawnMob;
import net.minecraft.network.play.server.SPacketSpawnObject;
import net.minecraft.network.play.server.SPacketSpawnPainting;
import net.minecraft.network.play.server.SPacketSpawnPlayer;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.network.play.server.SPacketStatistics;
import net.minecraft.network.play.server.SPacketTabComplete;
import net.minecraft.network.play.server.SPacketTeams;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.network.play.server.SPacketUpdateBossInfo;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.network.play.server.SPacketUpdateScore;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.network.play.server.SPacketWindowItems;
import net.minecraft.network.play.server.SPacketWindowProperty;
import net.minecraft.network.play.server.SPacketWorldBorder;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITabCompleter;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class NetHandlerPlayClient
implements INetHandlerPlayClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NetworkManager netManager;
    private final GameProfile profile;
    private final GuiScreen guiScreenServer;
    private Minecraft gameController;
    private WorldClient clientWorldController;
    private boolean doneLoadingTerrain;
    private final Map<UUID, NetworkPlayerInfo> playerInfoMap = Maps.newHashMap();
    public int currentServerMaxPlayers = 20;
    private boolean hasStatistics;
    private final Random avRandomizer = new Random();

    public NetHandlerPlayClient(Minecraft p_i46300_1_, GuiScreen p_i46300_2_, NetworkManager p_i46300_3_, GameProfile p_i46300_4_) {
        this.gameController = p_i46300_1_;
        this.guiScreenServer = p_i46300_2_;
        this.netManager = p_i46300_3_;
        this.profile = p_i46300_4_;
    }

    public void cleanup() {
        this.clientWorldController = null;
    }

    @Override
    public void handleJoinGame(SPacketJoinGame p_handleJoinGame_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleJoinGame_1_, this, this.gameController);
        this.gameController.playerController = new PlayerControllerMP(this.gameController, this);
        this.clientWorldController = new WorldClient(this, new WorldSettings(0L, p_handleJoinGame_1_.getGameType(), false, p_handleJoinGame_1_.isHardcoreMode(), p_handleJoinGame_1_.getWorldType()), NetworkDispatcher.get(this.getNetworkManager()).getOverrideDimension(p_handleJoinGame_1_), p_handleJoinGame_1_.getDifficulty(), this.gameController.mcProfiler);
        this.gameController.gameSettings.difficulty = p_handleJoinGame_1_.getDifficulty();
        this.gameController.loadWorld(this.clientWorldController);
        this.gameController.player.dimension = p_handleJoinGame_1_.getDimension();
        this.gameController.displayGuiScreen(new GuiDownloadTerrain(this));
        this.gameController.player.setEntityId(p_handleJoinGame_1_.getPlayerId());
        this.currentServerMaxPlayers = p_handleJoinGame_1_.getMaxPlayers();
        this.gameController.player.setReducedDebug(p_handleJoinGame_1_.isReducedDebugInfo());
        this.gameController.playerController.setGameType(p_handleJoinGame_1_.getGameType());
        this.gameController.gameSettings.sendSettingsToServer();
        this.netManager.sendPacket(new CPacketCustomPayload("MC|Brand", new PacketBuffer(Unpooled.buffer()).writeString(ClientBrandRetriever.getClientModName())));
    }

    @Override
    public void handleSpawnObject(SPacketSpawnObject p_handleSpawnObject_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSpawnObject_1_, this, this.gameController);
        double d0 = p_handleSpawnObject_1_.getX();
        double d1 = p_handleSpawnObject_1_.getY();
        double d2 = p_handleSpawnObject_1_.getZ();
        Entity entity = null;
        if (p_handleSpawnObject_1_.getType() == 10) {
            entity = EntityMinecart.create(this.clientWorldController, d0, d1, d2, EntityMinecart.Type.getById(p_handleSpawnObject_1_.getData()));
        } else if (p_handleSpawnObject_1_.getType() == 90) {
            Entity entity1 = this.clientWorldController.getEntityByID(p_handleSpawnObject_1_.getData());
            if (entity1 instanceof EntityPlayer) {
                entity = new EntityFishHook(this.clientWorldController, (EntityPlayer)entity1, d0, d1, d2);
            }
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 60) {
            entity = new EntityTippedArrow(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 91) {
            entity = new EntitySpectralArrow(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 61) {
            entity = new EntitySnowball(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 68) {
            entity = new EntityLlamaSpit(this.clientWorldController, d0, d1, d2, (double)p_handleSpawnObject_1_.getSpeedX() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedY() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedZ() / 8000.0);
        } else if (p_handleSpawnObject_1_.getType() == 71) {
            entity = new EntityItemFrame(this.clientWorldController, new BlockPos(d0, d1, d2), EnumFacing.getHorizontal(p_handleSpawnObject_1_.getData()));
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 77) {
            entity = new EntityLeashKnot(this.clientWorldController, new BlockPos(MathHelper.floor(d0), MathHelper.floor(d1), MathHelper.floor(d2)));
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 65) {
            entity = new EntityEnderPearl(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 72) {
            entity = new EntityEnderEye(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 76) {
            entity = new EntityFireworkRocket(this.clientWorldController, d0, d1, d2, ItemStack.EMPTY);
        } else if (p_handleSpawnObject_1_.getType() == 63) {
            entity = new EntityLargeFireball(this.clientWorldController, d0, d1, d2, (double)p_handleSpawnObject_1_.getSpeedX() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedY() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedZ() / 8000.0);
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 93) {
            entity = new EntityDragonFireball(this.clientWorldController, d0, d1, d2, (double)p_handleSpawnObject_1_.getSpeedX() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedY() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedZ() / 8000.0);
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 64) {
            entity = new EntitySmallFireball(this.clientWorldController, d0, d1, d2, (double)p_handleSpawnObject_1_.getSpeedX() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedY() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedZ() / 8000.0);
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 66) {
            entity = new EntityWitherSkull(this.clientWorldController, d0, d1, d2, (double)p_handleSpawnObject_1_.getSpeedX() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedY() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedZ() / 8000.0);
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 67) {
            entity = new EntityShulkerBullet(this.clientWorldController, d0, d1, d2, (double)p_handleSpawnObject_1_.getSpeedX() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedY() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedZ() / 8000.0);
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 62) {
            entity = new EntityEgg(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 79) {
            entity = new EntityEvokerFangs(this.clientWorldController, d0, d1, d2, 0.0f, 0, null);
        } else if (p_handleSpawnObject_1_.getType() == 73) {
            entity = new EntityPotion(this.clientWorldController, d0, d1, d2, ItemStack.EMPTY);
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 75) {
            entity = new EntityExpBottle(this.clientWorldController, d0, d1, d2);
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 1) {
            entity = new EntityBoat(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 50) {
            entity = new EntityTNTPrimed(this.clientWorldController, d0, d1, d2, null);
        } else if (p_handleSpawnObject_1_.getType() == 78) {
            entity = new EntityArmorStand(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 51) {
            entity = new EntityEnderCrystal(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 2) {
            entity = new EntityItem(this.clientWorldController, d0, d1, d2);
        } else if (p_handleSpawnObject_1_.getType() == 70) {
            entity = new EntityFallingBlock(this.clientWorldController, d0, d1, d2, Block.getStateById(p_handleSpawnObject_1_.getData() & 0xFFFF));
            p_handleSpawnObject_1_.setData(0);
        } else if (p_handleSpawnObject_1_.getType() == 3) {
            entity = new EntityAreaEffectCloud(this.clientWorldController, d0, d1, d2);
        }
        if (entity != null) {
            EntityTracker.updateServerPosition(entity, d0, d1, d2);
            entity.rotationPitch = (float)(p_handleSpawnObject_1_.getPitch() * 360) / 256.0f;
            entity.rotationYaw = (float)(p_handleSpawnObject_1_.getYaw() * 360) / 256.0f;
            Entity[] aentity = entity.getParts();
            if (aentity != null) {
                int i = p_handleSpawnObject_1_.getEntityID() - entity.getEntityId();
                for (Entity entity2 : aentity) {
                    entity2.setEntityId(entity2.getEntityId() + i);
                }
            }
            entity.setEntityId(p_handleSpawnObject_1_.getEntityID());
            entity.setUniqueId(p_handleSpawnObject_1_.getUniqueId());
            this.clientWorldController.addEntityToWorld(p_handleSpawnObject_1_.getEntityID(), entity);
            if (p_handleSpawnObject_1_.getData() > 0) {
                Entity entity3;
                if ((p_handleSpawnObject_1_.getType() == 60 || p_handleSpawnObject_1_.getType() == 91) && (entity3 = this.clientWorldController.getEntityByID(p_handleSpawnObject_1_.getData() - 1)) instanceof EntityLivingBase && entity instanceof EntityArrow) {
                    ((EntityArrow)entity).shootingEntity = entity3;
                }
                entity.setVelocity((double)p_handleSpawnObject_1_.getSpeedX() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedY() / 8000.0, (double)p_handleSpawnObject_1_.getSpeedZ() / 8000.0);
            }
        }
    }

    @Override
    public void handleSpawnExperienceOrb(SPacketSpawnExperienceOrb p_handleSpawnExperienceOrb_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSpawnExperienceOrb_1_, this, this.gameController);
        double d0 = p_handleSpawnExperienceOrb_1_.getX();
        double d1 = p_handleSpawnExperienceOrb_1_.getY();
        double d2 = p_handleSpawnExperienceOrb_1_.getZ();
        EntityXPOrb entity = new EntityXPOrb(this.clientWorldController, d0, d1, d2, p_handleSpawnExperienceOrb_1_.getXPValue());
        EntityTracker.updateServerPosition(entity, d0, d1, d2);
        entity.rotationYaw = 0.0f;
        entity.rotationPitch = 0.0f;
        entity.setEntityId(p_handleSpawnExperienceOrb_1_.getEntityID());
        this.clientWorldController.addEntityToWorld(p_handleSpawnExperienceOrb_1_.getEntityID(), entity);
    }

    @Override
    public void handleSpawnGlobalEntity(SPacketSpawnGlobalEntity p_handleSpawnGlobalEntity_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSpawnGlobalEntity_1_, this, this.gameController);
        double d0 = p_handleSpawnGlobalEntity_1_.getX();
        double d1 = p_handleSpawnGlobalEntity_1_.getY();
        double d2 = p_handleSpawnGlobalEntity_1_.getZ();
        EntityLightningBolt entity = null;
        if (p_handleSpawnGlobalEntity_1_.getType() == 1) {
            entity = new EntityLightningBolt(this.clientWorldController, d0, d1, d2, false);
        }
        if (entity != null) {
            EntityTracker.updateServerPosition(entity, d0, d1, d2);
            entity.rotationYaw = 0.0f;
            entity.rotationPitch = 0.0f;
            entity.setEntityId(p_handleSpawnGlobalEntity_1_.getEntityId());
            this.clientWorldController.addWeatherEffect(entity);
        }
    }

    @Override
    public void handleSpawnPainting(SPacketSpawnPainting p_handleSpawnPainting_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSpawnPainting_1_, this, this.gameController);
        EntityPainting entitypainting = new EntityPainting(this.clientWorldController, p_handleSpawnPainting_1_.getPosition(), p_handleSpawnPainting_1_.getFacing(), p_handleSpawnPainting_1_.getTitle());
        entitypainting.setUniqueId(p_handleSpawnPainting_1_.getUniqueId());
        this.clientWorldController.addEntityToWorld(p_handleSpawnPainting_1_.getEntityID(), entitypainting);
    }

    @Override
    public void handleEntityVelocity(SPacketEntityVelocity p_handleEntityVelocity_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityVelocity_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleEntityVelocity_1_.getEntityID());
        if (entity != null) {
            entity.setVelocity((double)p_handleEntityVelocity_1_.getMotionX() / 8000.0, (double)p_handleEntityVelocity_1_.getMotionY() / 8000.0, (double)p_handleEntityVelocity_1_.getMotionZ() / 8000.0);
        }
    }

    @Override
    public void handleEntityMetadata(SPacketEntityMetadata p_handleEntityMetadata_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityMetadata_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleEntityMetadata_1_.getEntityId());
        if (entity != null && p_handleEntityMetadata_1_.getDataManagerEntries() != null) {
            entity.getDataManager().setEntryValues(p_handleEntityMetadata_1_.getDataManagerEntries());
        }
    }

    @Override
    public void handleSpawnPlayer(SPacketSpawnPlayer p_handleSpawnPlayer_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSpawnPlayer_1_, this, this.gameController);
        double d0 = p_handleSpawnPlayer_1_.getX();
        double d1 = p_handleSpawnPlayer_1_.getY();
        double d2 = p_handleSpawnPlayer_1_.getZ();
        float f = (float)(p_handleSpawnPlayer_1_.getYaw() * 360) / 256.0f;
        float f1 = (float)(p_handleSpawnPlayer_1_.getPitch() * 360) / 256.0f;
        EntityOtherPlayerMP entityotherplayermp = new EntityOtherPlayerMP(this.gameController.world, this.getPlayerInfo(p_handleSpawnPlayer_1_.getUniqueId()).getGameProfile());
        entityotherplayermp.prevPosX = d0;
        entityotherplayermp.lastTickPosX = d0;
        entityotherplayermp.prevPosY = d1;
        entityotherplayermp.lastTickPosY = d1;
        entityotherplayermp.prevPosZ = d2;
        entityotherplayermp.lastTickPosZ = d2;
        EntityTracker.updateServerPosition(entityotherplayermp, d0, d1, d2);
        entityotherplayermp.setPositionAndRotation(d0, d1, d2, f, f1);
        this.clientWorldController.addEntityToWorld(p_handleSpawnPlayer_1_.getEntityID(), entityotherplayermp);
        List<EntityDataManager.DataEntry<?>> list = p_handleSpawnPlayer_1_.getDataManagerEntries();
        if (list != null) {
            entityotherplayermp.getDataManager().setEntryValues(list);
        }
    }

    @Override
    public void handleEntityTeleport(SPacketEntityTeleport p_handleEntityTeleport_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityTeleport_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleEntityTeleport_1_.getEntityId());
        if (entity != null) {
            double d0 = p_handleEntityTeleport_1_.getX();
            double d1 = p_handleEntityTeleport_1_.getY();
            double d2 = p_handleEntityTeleport_1_.getZ();
            EntityTracker.updateServerPosition(entity, d0, d1, d2);
            if (!entity.canPassengerSteer()) {
                float f = (float)(p_handleEntityTeleport_1_.getYaw() * 360) / 256.0f;
                float f1 = (float)(p_handleEntityTeleport_1_.getPitch() * 360) / 256.0f;
                if (Math.abs(entity.posX - d0) < 0.03125 && Math.abs(entity.posY - d1) < 0.015625 && Math.abs(entity.posZ - d2) < 0.03125) {
                    entity.setPositionAndRotationDirect(entity.posX, entity.posY, entity.posZ, f, f1, 0, true);
                } else {
                    entity.setPositionAndRotationDirect(d0, d1, d2, f, f1, 3, true);
                }
                entity.onGround = p_handleEntityTeleport_1_.getOnGround();
            }
        }
    }

    @Override
    public void handleHeldItemChange(SPacketHeldItemChange p_handleHeldItemChange_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleHeldItemChange_1_, this, this.gameController);
        if (InventoryPlayer.isHotbar(p_handleHeldItemChange_1_.getHeldItemHotbarIndex())) {
            this.gameController.player.inventory.currentItem = p_handleHeldItemChange_1_.getHeldItemHotbarIndex();
        }
    }

    @Override
    public void handleEntityMovement(SPacketEntity p_handleEntityMovement_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityMovement_1_, this, this.gameController);
        Entity entity = p_handleEntityMovement_1_.getEntity(this.clientWorldController);
        if (entity != null) {
            entity.serverPosX += (long)p_handleEntityMovement_1_.getX();
            entity.serverPosY += (long)p_handleEntityMovement_1_.getY();
            entity.serverPosZ += (long)p_handleEntityMovement_1_.getZ();
            double d0 = (double)entity.serverPosX / 4096.0;
            double d1 = (double)entity.serverPosY / 4096.0;
            double d2 = (double)entity.serverPosZ / 4096.0;
            if (!entity.canPassengerSteer()) {
                float f = p_handleEntityMovement_1_.isRotating() ? (float)(p_handleEntityMovement_1_.getYaw() * 360) / 256.0f : entity.rotationYaw;
                float f1 = p_handleEntityMovement_1_.isRotating() ? (float)(p_handleEntityMovement_1_.getPitch() * 360) / 256.0f : entity.rotationPitch;
                entity.setPositionAndRotationDirect(d0, d1, d2, f, f1, 3, false);
                entity.onGround = p_handleEntityMovement_1_.getOnGround();
            }
        }
    }

    @Override
    public void handleEntityHeadLook(SPacketEntityHeadLook p_handleEntityHeadLook_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityHeadLook_1_, this, this.gameController);
        Entity entity = p_handleEntityHeadLook_1_.getEntity(this.clientWorldController);
        if (entity != null) {
            float f = (float)(p_handleEntityHeadLook_1_.getYaw() * 360) / 256.0f;
            entity.setRotationYawHead(f);
        }
    }

    @Override
    public void handleDestroyEntities(SPacketDestroyEntities p_handleDestroyEntities_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleDestroyEntities_1_, this, this.gameController);
        for (int i = 0; i < p_handleDestroyEntities_1_.getEntityIDs().length; ++i) {
            this.clientWorldController.removeEntityFromWorld(p_handleDestroyEntities_1_.getEntityIDs()[i]);
        }
    }

    @Override
    public void handlePlayerPosLook(SPacketPlayerPosLook p_handlePlayerPosLook_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handlePlayerPosLook_1_, this, this.gameController);
        EntityPlayerSP entityplayer = this.gameController.player;
        double d0 = p_handlePlayerPosLook_1_.getX();
        double d1 = p_handlePlayerPosLook_1_.getY();
        double d2 = p_handlePlayerPosLook_1_.getZ();
        float f = p_handlePlayerPosLook_1_.getYaw();
        float f1 = p_handlePlayerPosLook_1_.getPitch();
        if (p_handlePlayerPosLook_1_.getFlags().contains((Object)SPacketPlayerPosLook.EnumFlags.X)) {
            d0 += entityplayer.posX;
        } else {
            entityplayer.motionX = 0.0;
        }
        if (p_handlePlayerPosLook_1_.getFlags().contains((Object)SPacketPlayerPosLook.EnumFlags.Y)) {
            d1 += entityplayer.posY;
        } else {
            entityplayer.motionY = 0.0;
        }
        if (p_handlePlayerPosLook_1_.getFlags().contains((Object)SPacketPlayerPosLook.EnumFlags.Z)) {
            d2 += entityplayer.posZ;
        } else {
            entityplayer.motionZ = 0.0;
        }
        if (p_handlePlayerPosLook_1_.getFlags().contains((Object)SPacketPlayerPosLook.EnumFlags.X_ROT)) {
            f1 += entityplayer.rotationPitch;
        }
        if (p_handlePlayerPosLook_1_.getFlags().contains((Object)SPacketPlayerPosLook.EnumFlags.Y_ROT)) {
            f += entityplayer.rotationYaw;
        }
        entityplayer.setPositionAndRotation(d0, d1, d2, f, f1);
        this.netManager.sendPacket(new CPacketConfirmTeleport(p_handlePlayerPosLook_1_.getTeleportId()));
        this.netManager.sendPacket(new CPacketPlayer.PositionRotation(entityplayer.posX, entityplayer.getEntityBoundingBox().minY, entityplayer.posZ, entityplayer.rotationYaw, entityplayer.rotationPitch, false));
        if (!this.doneLoadingTerrain) {
            this.gameController.player.prevPosX = this.gameController.player.posX;
            this.gameController.player.prevPosY = this.gameController.player.posY;
            this.gameController.player.prevPosZ = this.gameController.player.posZ;
            this.doneLoadingTerrain = true;
            this.gameController.displayGuiScreen(null);
        }
    }

    @Override
    public void handleMultiBlockChange(SPacketMultiBlockChange p_handleMultiBlockChange_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleMultiBlockChange_1_, this, this.gameController);
        for (SPacketMultiBlockChange.BlockUpdateData spacketmultiblockchange$blockupdatedata : p_handleMultiBlockChange_1_.getChangedBlocks()) {
            this.clientWorldController.invalidateRegionAndSetBlock(spacketmultiblockchange$blockupdatedata.getPos(), spacketmultiblockchange$blockupdatedata.getBlockState());
        }
    }

    @Override
    public void handleChunkData(SPacketChunkData p_handleChunkData_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleChunkData_1_, this, this.gameController);
        if (p_handleChunkData_1_.doChunkLoad()) {
            this.clientWorldController.doPreChunk(p_handleChunkData_1_.getChunkX(), p_handleChunkData_1_.getChunkZ(), true);
        }
        this.clientWorldController.invalidateBlockReceiveRegion(p_handleChunkData_1_.getChunkX() << 4, 0, p_handleChunkData_1_.getChunkZ() << 4, (p_handleChunkData_1_.getChunkX() << 4) + 15, 256, (p_handleChunkData_1_.getChunkZ() << 4) + 15);
        Chunk chunk = this.clientWorldController.getChunkFromChunkCoords(p_handleChunkData_1_.getChunkX(), p_handleChunkData_1_.getChunkZ());
        chunk.fillChunk(p_handleChunkData_1_.getReadBuffer(), p_handleChunkData_1_.getExtractedSize(), p_handleChunkData_1_.doChunkLoad());
        this.clientWorldController.markBlockRangeForRenderUpdate(p_handleChunkData_1_.getChunkX() << 4, 0, p_handleChunkData_1_.getChunkZ() << 4, (p_handleChunkData_1_.getChunkX() << 4) + 15, 256, (p_handleChunkData_1_.getChunkZ() << 4) + 15);
        if (!p_handleChunkData_1_.doChunkLoad() || !(this.clientWorldController.provider instanceof WorldProviderSurface)) {
            chunk.resetRelightChecks();
        }
        for (NBTTagCompound nbttagcompound : p_handleChunkData_1_.getTileEntityTags()) {
            BlockPos blockpos = new BlockPos(nbttagcompound.getInteger("x"), nbttagcompound.getInteger("y"), nbttagcompound.getInteger("z"));
            TileEntity tileentity = this.clientWorldController.getTileEntity(blockpos);
            if (tileentity == null) continue;
            tileentity.handleUpdateTag(nbttagcompound);
        }
    }

    @Override
    public void processChunkUnload(SPacketUnloadChunk p_processChunkUnload_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processChunkUnload_1_, this, this.gameController);
        this.clientWorldController.doPreChunk(p_processChunkUnload_1_.getX(), p_processChunkUnload_1_.getZ(), false);
    }

    @Override
    public void handleBlockChange(SPacketBlockChange p_handleBlockChange_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleBlockChange_1_, this, this.gameController);
        this.clientWorldController.invalidateRegionAndSetBlock(p_handleBlockChange_1_.getBlockPosition(), p_handleBlockChange_1_.getBlockState());
    }

    @Override
    public void handleDisconnect(SPacketDisconnect p_handleDisconnect_1_) {
        this.netManager.closeChannel(p_handleDisconnect_1_.getReason());
    }

    @Override
    public void onDisconnect(ITextComponent p_onDisconnect_1_) {
        this.gameController.loadWorld(null);
        if (this.guiScreenServer != null) {
            if (this.guiScreenServer instanceof GuiScreenRealmsProxy) {
                this.gameController.displayGuiScreen(new DisconnectedRealmsScreen(((GuiScreenRealmsProxy)this.guiScreenServer).getProxy(), "disconnect.lost", p_onDisconnect_1_).getProxy());
            } else {
                this.gameController.displayGuiScreen(new GuiDisconnected(this.guiScreenServer, "disconnect.lost", p_onDisconnect_1_));
            }
        } else {
            this.gameController.displayGuiScreen(new GuiDisconnected(new GuiMultiplayer(new GuiMainMenu()), "disconnect.lost", p_onDisconnect_1_));
        }
    }

    public void sendPacket(Packet<?> p_sendPacket_1_) {
        this.netManager.sendPacket(p_sendPacket_1_);
    }

    @Override
    public void handleCollectItem(SPacketCollectItem p_handleCollectItem_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleCollectItem_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleCollectItem_1_.getCollectedItemEntityID());
        EntityLivingBase entitylivingbase = (EntityLivingBase)this.clientWorldController.getEntityByID(p_handleCollectItem_1_.getEntityID());
        if (entitylivingbase == null) {
            entitylivingbase = this.gameController.player;
        }
        if (entity != null) {
            if (entity instanceof EntityXPOrb) {
                this.clientWorldController.playSound(entity.posX, entity.posY, entity.posZ, SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, SoundCategory.PLAYERS, 0.1f, (this.avRandomizer.nextFloat() - this.avRandomizer.nextFloat()) * 0.35f + 0.9f, false);
            } else {
                this.clientWorldController.playSound(entity.posX, entity.posY, entity.posZ, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, (this.avRandomizer.nextFloat() - this.avRandomizer.nextFloat()) * 1.4f + 2.0f, false);
            }
            if (entity instanceof EntityItem) {
                ((EntityItem)entity).getEntityItem().setCount(p_handleCollectItem_1_.getAmount());
            }
            this.gameController.effectRenderer.addEffect(new ParticleItemPickup((World)this.clientWorldController, entity, entitylivingbase, 0.5f));
            this.clientWorldController.removeEntityFromWorld(p_handleCollectItem_1_.getCollectedItemEntityID());
        }
    }

    @Override
    public void handleChat(SPacketChat p_handleChat_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleChat_1_, this, this.gameController);
        ITextComponent message = ForgeEventFactory.onClientChat(p_handleChat_1_.getType(), p_handleChat_1_.getChatComponent());
        if (message == null) {
            return;
        }
        if (p_handleChat_1_.getType() == 2) {
            this.gameController.ingameGUI.setOverlayMessage(message, false);
        } else {
            this.gameController.ingameGUI.getChatGUI().printChatMessage(message);
        }
    }

    @Override
    public void handleAnimation(SPacketAnimation p_handleAnimation_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleAnimation_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleAnimation_1_.getEntityID());
        if (entity != null) {
            if (p_handleAnimation_1_.getAnimationType() == 0) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                entitylivingbase.swingArm(EnumHand.MAIN_HAND);
            } else if (p_handleAnimation_1_.getAnimationType() == 3) {
                EntityLivingBase entitylivingbase1 = (EntityLivingBase)entity;
                entitylivingbase1.swingArm(EnumHand.OFF_HAND);
            } else if (p_handleAnimation_1_.getAnimationType() == 1) {
                entity.performHurtAnimation();
            } else if (p_handleAnimation_1_.getAnimationType() == 2) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.wakeUpPlayer(false, false, false);
            } else if (p_handleAnimation_1_.getAnimationType() == 4) {
                this.gameController.effectRenderer.emitParticleAtEntity(entity, EnumParticleTypes.CRIT);
            } else if (p_handleAnimation_1_.getAnimationType() == 5) {
                this.gameController.effectRenderer.emitParticleAtEntity(entity, EnumParticleTypes.CRIT_MAGIC);
            }
        }
    }

    @Override
    public void handleUseBed(SPacketUseBed p_handleUseBed_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleUseBed_1_, this, this.gameController);
        p_handleUseBed_1_.getPlayer(this.clientWorldController).trySleep(p_handleUseBed_1_.getBedPosition());
    }

    @Override
    public void handleSpawnMob(SPacketSpawnMob p_handleSpawnMob_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSpawnMob_1_, this, this.gameController);
        double d0 = p_handleSpawnMob_1_.getX();
        double d1 = p_handleSpawnMob_1_.getY();
        double d2 = p_handleSpawnMob_1_.getZ();
        float f = (float)(p_handleSpawnMob_1_.getYaw() * 360) / 256.0f;
        float f1 = (float)(p_handleSpawnMob_1_.getPitch() * 360) / 256.0f;
        EntityLivingBase entitylivingbase = (EntityLivingBase)EntityList.createEntityByID(p_handleSpawnMob_1_.getEntityType(), this.gameController.world);
        if (entitylivingbase != null) {
            EntityTracker.updateServerPosition(entitylivingbase, d0, d1, d2);
            entitylivingbase.renderYawOffset = (float)(p_handleSpawnMob_1_.getHeadPitch() * 360) / 256.0f;
            entitylivingbase.rotationYawHead = (float)(p_handleSpawnMob_1_.getHeadPitch() * 360) / 256.0f;
            Entity[] aentity = entitylivingbase.getParts();
            if (aentity != null) {
                int i = p_handleSpawnMob_1_.getEntityID() - entitylivingbase.getEntityId();
                for (Entity entity : aentity) {
                    entity.setEntityId(entity.getEntityId() + i);
                }
            }
            entitylivingbase.setEntityId(p_handleSpawnMob_1_.getEntityID());
            entitylivingbase.setUniqueId(p_handleSpawnMob_1_.getUniqueId());
            entitylivingbase.setPositionAndRotation(d0, d1, d2, f, f1);
            entitylivingbase.motionX = (float)p_handleSpawnMob_1_.getVelocityX() / 8000.0f;
            entitylivingbase.motionY = (float)p_handleSpawnMob_1_.getVelocityY() / 8000.0f;
            entitylivingbase.motionZ = (float)p_handleSpawnMob_1_.getVelocityZ() / 8000.0f;
            this.clientWorldController.addEntityToWorld(p_handleSpawnMob_1_.getEntityID(), entitylivingbase);
            List<EntityDataManager.DataEntry<?>> list = p_handleSpawnMob_1_.getDataManagerEntries();
            if (list != null) {
                entitylivingbase.getDataManager().setEntryValues(list);
            }
        } else {
            LOGGER.warn("Skipping Entity with id {}", new Object[]{p_handleSpawnMob_1_.getEntityType()});
        }
    }

    @Override
    public void handleTimeUpdate(SPacketTimeUpdate p_handleTimeUpdate_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleTimeUpdate_1_, this, this.gameController);
        this.gameController.world.setTotalWorldTime(p_handleTimeUpdate_1_.getTotalWorldTime());
        this.gameController.world.setWorldTime(p_handleTimeUpdate_1_.getWorldTime());
    }

    @Override
    public void handleSpawnPosition(SPacketSpawnPosition p_handleSpawnPosition_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSpawnPosition_1_, this, this.gameController);
        this.gameController.player.setSpawnPoint(p_handleSpawnPosition_1_.getSpawnPos(), true);
        this.gameController.world.getWorldInfo().setSpawn(p_handleSpawnPosition_1_.getSpawnPos());
    }

    @Override
    public void handleSetPassengers(SPacketSetPassengers p_handleSetPassengers_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSetPassengers_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleSetPassengers_1_.getEntityId());
        if (entity == null) {
            LOGGER.warn("Received passengers for unknown entity");
        } else {
            boolean flag = entity.isRidingOrBeingRiddenBy(this.gameController.player);
            entity.removePassengers();
            for (int i : p_handleSetPassengers_1_.getPassengerIds()) {
                Entity entity1 = this.clientWorldController.getEntityByID(i);
                if (entity1 == null) continue;
                entity1.startRiding(entity, true);
                if (entity1 != this.gameController.player || flag) continue;
                this.gameController.ingameGUI.setOverlayMessage(I18n.format("mount.onboard", this.gameController.gameSettings.keyBindSneak.getDisplayName()), false);
            }
        }
    }

    @Override
    public void handleEntityAttach(SPacketEntityAttach p_handleEntityAttach_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityAttach_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleEntityAttach_1_.getEntityId());
        Entity entity1 = this.clientWorldController.getEntityByID(p_handleEntityAttach_1_.getVehicleEntityId());
        if (entity instanceof EntityLiving) {
            if (entity1 != null) {
                ((EntityLiving)entity).setLeashedToEntity(entity1, false);
            } else {
                ((EntityLiving)entity).clearLeashed(false, false);
            }
        }
    }

    @Override
    public void handleEntityStatus(SPacketEntityStatus p_handleEntityStatus_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityStatus_1_, this, this.gameController);
        Entity entity = p_handleEntityStatus_1_.getEntity(this.clientWorldController);
        if (entity != null) {
            if (p_handleEntityStatus_1_.getOpCode() == 21) {
                this.gameController.getSoundHandler().playSound(new GuardianSound((EntityGuardian)entity));
            } else if (p_handleEntityStatus_1_.getOpCode() == 35) {
                int i = 40;
                this.gameController.effectRenderer.emitParticleAtEntity(entity, EnumParticleTypes.TOTEM, 30);
                this.clientWorldController.playSound(entity.posX, entity.posY, entity.posZ, SoundEvents.ITEM_TOTEM_USE, entity.getSoundCategory(), 1.0f, 1.0f, false);
                if (entity == this.gameController.player) {
                    this.gameController.entityRenderer.displayItemActivation(new ItemStack(Items.TOTEM));
                }
            } else {
                entity.handleStatusUpdate(p_handleEntityStatus_1_.getOpCode());
            }
        }
    }

    @Override
    public void handleUpdateHealth(SPacketUpdateHealth p_handleUpdateHealth_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleUpdateHealth_1_, this, this.gameController);
        this.gameController.player.setPlayerSPHealth(p_handleUpdateHealth_1_.getHealth());
        this.gameController.player.getFoodStats().setFoodLevel(p_handleUpdateHealth_1_.getFoodLevel());
        this.gameController.player.getFoodStats().setFoodSaturationLevel(p_handleUpdateHealth_1_.getSaturationLevel());
    }

    @Override
    public void handleSetExperience(SPacketSetExperience p_handleSetExperience_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSetExperience_1_, this, this.gameController);
        this.gameController.player.setXPStats(p_handleSetExperience_1_.getExperienceBar(), p_handleSetExperience_1_.getTotalExperience(), p_handleSetExperience_1_.getLevel());
    }

    @Override
    public void handleRespawn(SPacketRespawn p_handleRespawn_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleRespawn_1_, this, this.gameController);
        if (p_handleRespawn_1_.getDimensionID() != this.gameController.player.dimension) {
            this.doneLoadingTerrain = false;
            Scoreboard scoreboard = this.clientWorldController.getScoreboard();
            this.clientWorldController = new WorldClient(this, new WorldSettings(0L, p_handleRespawn_1_.getGameType(), false, this.gameController.world.getWorldInfo().isHardcoreModeEnabled(), p_handleRespawn_1_.getWorldType()), p_handleRespawn_1_.getDimensionID(), p_handleRespawn_1_.getDifficulty(), this.gameController.mcProfiler);
            this.clientWorldController.setWorldScoreboard(scoreboard);
            this.gameController.loadWorld(this.clientWorldController);
            this.gameController.player.dimension = p_handleRespawn_1_.getDimensionID();
            this.gameController.displayGuiScreen(new GuiDownloadTerrain(this));
        }
        this.gameController.setDimensionAndSpawnPlayer(p_handleRespawn_1_.getDimensionID());
        this.gameController.playerController.setGameType(p_handleRespawn_1_.getGameType());
    }

    @Override
    public void handleExplosion(SPacketExplosion p_handleExplosion_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleExplosion_1_, this, this.gameController);
        Explosion explosion = new Explosion(this.gameController.world, null, p_handleExplosion_1_.getX(), p_handleExplosion_1_.getY(), p_handleExplosion_1_.getZ(), p_handleExplosion_1_.getStrength(), p_handleExplosion_1_.getAffectedBlockPositions());
        explosion.doExplosionB(true);
        this.gameController.player.motionX += (double)p_handleExplosion_1_.getMotionX();
        this.gameController.player.motionY += (double)p_handleExplosion_1_.getMotionY();
        this.gameController.player.motionZ += (double)p_handleExplosion_1_.getMotionZ();
    }

    @Override
    public void handleOpenWindow(SPacketOpenWindow p_handleOpenWindow_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleOpenWindow_1_, this, this.gameController);
        EntityPlayerSP entityplayersp = this.gameController.player;
        if ("minecraft:container".equals(p_handleOpenWindow_1_.getGuiId())) {
            entityplayersp.displayGUIChest(new InventoryBasic(p_handleOpenWindow_1_.getWindowTitle(), p_handleOpenWindow_1_.getSlotCount()));
            entityplayersp.openContainer.windowId = p_handleOpenWindow_1_.getWindowId();
        } else if ("minecraft:villager".equals(p_handleOpenWindow_1_.getGuiId())) {
            entityplayersp.displayVillagerTradeGui(new NpcMerchant(entityplayersp, p_handleOpenWindow_1_.getWindowTitle()));
            entityplayersp.openContainer.windowId = p_handleOpenWindow_1_.getWindowId();
        } else if ("EntityHorse".equals(p_handleOpenWindow_1_.getGuiId())) {
            Entity entity = this.clientWorldController.getEntityByID(p_handleOpenWindow_1_.getEntityId());
            if (entity instanceof AbstractHorse) {
                entityplayersp.openGuiHorseInventory((AbstractHorse)entity, new ContainerHorseChest(p_handleOpenWindow_1_.getWindowTitle(), p_handleOpenWindow_1_.getSlotCount()));
                entityplayersp.openContainer.windowId = p_handleOpenWindow_1_.getWindowId();
            }
        } else if (!p_handleOpenWindow_1_.hasSlots()) {
            entityplayersp.displayGui(new LocalBlockIntercommunication(p_handleOpenWindow_1_.getGuiId(), p_handleOpenWindow_1_.getWindowTitle()));
            entityplayersp.openContainer.windowId = p_handleOpenWindow_1_.getWindowId();
        } else {
            ContainerLocalMenu iinventory = new ContainerLocalMenu(p_handleOpenWindow_1_.getGuiId(), p_handleOpenWindow_1_.getWindowTitle(), p_handleOpenWindow_1_.getSlotCount());
            entityplayersp.displayGUIChest(iinventory);
            entityplayersp.openContainer.windowId = p_handleOpenWindow_1_.getWindowId();
        }
    }

    @Override
    public void handleSetSlot(SPacketSetSlot p_handleSetSlot_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSetSlot_1_, this, this.gameController);
        EntityPlayerSP entityplayer = this.gameController.player;
        ItemStack itemstack = p_handleSetSlot_1_.getStack();
        int i = p_handleSetSlot_1_.getSlot();
        if (p_handleSetSlot_1_.getWindowId() == -1) {
            entityplayer.inventory.setItemStack(itemstack);
        } else if (p_handleSetSlot_1_.getWindowId() == -2) {
            entityplayer.inventory.setInventorySlotContents(i, itemstack);
        } else {
            boolean flag = false;
            if (this.gameController.currentScreen instanceof GuiContainerCreative) {
                GuiContainerCreative guicontainercreative = (GuiContainerCreative)this.gameController.currentScreen;
                boolean bl = flag = guicontainercreative.getSelectedTabIndex() != CreativeTabs.INVENTORY.getTabIndex();
            }
            if (p_handleSetSlot_1_.getWindowId() == 0 && p_handleSetSlot_1_.getSlot() >= 36 && i < 45) {
                ItemStack itemstack1;
                if (!itemstack.isEmpty() && ((itemstack1 = entityplayer.inventoryContainer.getSlot(i).getStack()).isEmpty() || itemstack1.getCount() < itemstack.getCount())) {
                    itemstack.setAnimationsToGo(5);
                }
                entityplayer.inventoryContainer.putStackInSlot(i, itemstack);
            } else if (!(p_handleSetSlot_1_.getWindowId() != entityplayer.openContainer.windowId || p_handleSetSlot_1_.getWindowId() == 0 && flag)) {
                entityplayer.openContainer.putStackInSlot(i, itemstack);
            }
        }
    }

    @Override
    public void handleConfirmTransaction(SPacketConfirmTransaction p_handleConfirmTransaction_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleConfirmTransaction_1_, this, this.gameController);
        Container container = null;
        EntityPlayerSP entityplayer = this.gameController.player;
        if (p_handleConfirmTransaction_1_.getWindowId() == 0) {
            container = entityplayer.inventoryContainer;
        } else if (p_handleConfirmTransaction_1_.getWindowId() == entityplayer.openContainer.windowId) {
            container = entityplayer.openContainer;
        }
        if (container != null && !p_handleConfirmTransaction_1_.wasAccepted()) {
            this.sendPacket(new CPacketConfirmTransaction(p_handleConfirmTransaction_1_.getWindowId(), p_handleConfirmTransaction_1_.getActionNumber(), true));
        }
    }

    @Override
    public void handleWindowItems(SPacketWindowItems p_handleWindowItems_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleWindowItems_1_, this, this.gameController);
        EntityPlayerSP entityplayer = this.gameController.player;
        if (p_handleWindowItems_1_.getWindowId() == 0) {
            entityplayer.inventoryContainer.setAll(p_handleWindowItems_1_.getItemStacks());
        } else if (p_handleWindowItems_1_.getWindowId() == entityplayer.openContainer.windowId) {
            entityplayer.openContainer.setAll(p_handleWindowItems_1_.getItemStacks());
        }
    }

    @Override
    public void handleSignEditorOpen(SPacketSignEditorOpen p_handleSignEditorOpen_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSignEditorOpen_1_, this, this.gameController);
        TileEntity tileentity = this.clientWorldController.getTileEntity(p_handleSignEditorOpen_1_.getSignPosition());
        if (!(tileentity instanceof TileEntitySign)) {
            tileentity = new TileEntitySign();
            tileentity.setWorld(this.clientWorldController);
            tileentity.setPos(p_handleSignEditorOpen_1_.getSignPosition());
        }
        this.gameController.player.openEditSign((TileEntitySign)tileentity);
    }

    @Override
    public void handleUpdateTileEntity(SPacketUpdateTileEntity p_handleUpdateTileEntity_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleUpdateTileEntity_1_, this, this.gameController);
        if (this.gameController.world.isBlockLoaded(p_handleUpdateTileEntity_1_.getPos())) {
            boolean flag;
            TileEntity tileentity = this.gameController.world.getTileEntity(p_handleUpdateTileEntity_1_.getPos());
            int i = p_handleUpdateTileEntity_1_.getTileEntityType();
            boolean bl = flag = i == 2 && tileentity instanceof TileEntityCommandBlock;
            if (i == 1 && tileentity instanceof TileEntityMobSpawner || flag || i == 3 && tileentity instanceof TileEntityBeacon || i == 4 && tileentity instanceof TileEntitySkull || i == 5 && tileentity instanceof TileEntityFlowerPot || i == 6 && tileentity instanceof TileEntityBanner || i == 7 && tileentity instanceof TileEntityStructure || i == 8 && tileentity instanceof TileEntityEndGateway || i == 9 && tileentity instanceof TileEntitySign || i == 10 && tileentity instanceof TileEntityShulkerBox) {
                tileentity.readFromNBT(p_handleUpdateTileEntity_1_.getNbtCompound());
            } else {
                if (tileentity == null) {
                    LOGGER.error("Received invalid update packet for null tile entity at {} with data: {}", new Object[]{p_handleUpdateTileEntity_1_.getPos(), p_handleUpdateTileEntity_1_.getNbtCompound()});
                    return;
                }
                tileentity.onDataPacket(this.netManager, p_handleUpdateTileEntity_1_);
            }
            if (flag && this.gameController.currentScreen instanceof GuiCommandBlock) {
                ((GuiCommandBlock)this.gameController.currentScreen).updateGui();
            }
        }
    }

    @Override
    public void handleWindowProperty(SPacketWindowProperty p_handleWindowProperty_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleWindowProperty_1_, this, this.gameController);
        EntityPlayerSP entityplayer = this.gameController.player;
        if (entityplayer.openContainer != null && entityplayer.openContainer.windowId == p_handleWindowProperty_1_.getWindowId()) {
            entityplayer.openContainer.updateProgressBar(p_handleWindowProperty_1_.getProperty(), p_handleWindowProperty_1_.getValue());
        }
    }

    @Override
    public void handleEntityEquipment(SPacketEntityEquipment p_handleEntityEquipment_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityEquipment_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleEntityEquipment_1_.getEntityID());
        if (entity != null) {
            entity.setItemStackToSlot(p_handleEntityEquipment_1_.getEquipmentSlot(), p_handleEntityEquipment_1_.getItemStack());
        }
    }

    @Override
    public void handleCloseWindow(SPacketCloseWindow p_handleCloseWindow_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleCloseWindow_1_, this, this.gameController);
        this.gameController.player.closeScreenAndDropStack();
    }

    @Override
    public void handleBlockAction(SPacketBlockAction p_handleBlockAction_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleBlockAction_1_, this, this.gameController);
        this.gameController.world.addBlockEvent(p_handleBlockAction_1_.getBlockPosition(), p_handleBlockAction_1_.getBlockType(), p_handleBlockAction_1_.getData1(), p_handleBlockAction_1_.getData2());
    }

    @Override
    public void handleBlockBreakAnim(SPacketBlockBreakAnim p_handleBlockBreakAnim_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleBlockBreakAnim_1_, this, this.gameController);
        this.gameController.world.sendBlockBreakProgress(p_handleBlockBreakAnim_1_.getBreakerId(), p_handleBlockBreakAnim_1_.getPosition(), p_handleBlockBreakAnim_1_.getProgress());
    }

    @Override
    public void handleChangeGameState(SPacketChangeGameState p_handleChangeGameState_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleChangeGameState_1_, this, this.gameController);
        EntityPlayerSP entityplayer = this.gameController.player;
        int i = p_handleChangeGameState_1_.getGameState();
        float f = p_handleChangeGameState_1_.getValue();
        int j = MathHelper.floor(f + 0.5f);
        if (i >= 0 && i < SPacketChangeGameState.MESSAGE_NAMES.length && SPacketChangeGameState.MESSAGE_NAMES[i] != null) {
            ((EntityPlayer)entityplayer).sendStatusMessage(new TextComponentTranslation(SPacketChangeGameState.MESSAGE_NAMES[i], new Object[0]), false);
        }
        if (i == 1) {
            this.clientWorldController.getWorldInfo().setRaining(true);
            this.clientWorldController.setRainStrength(0.0f);
        } else if (i == 2) {
            this.clientWorldController.getWorldInfo().setRaining(false);
            this.clientWorldController.setRainStrength(1.0f);
        } else if (i == 3) {
            this.gameController.playerController.setGameType(GameType.getByID(j));
        } else if (i == 4) {
            if (j == 0) {
                this.gameController.player.connection.sendPacket(new CPacketClientStatus(CPacketClientStatus.State.PERFORM_RESPAWN));
                this.gameController.displayGuiScreen(new GuiDownloadTerrain(this));
            } else if (j == 1) {
                this.gameController.displayGuiScreen(new GuiWinGame());
            }
        } else if (i == 5) {
            GameSettings gamesettings = this.gameController.gameSettings;
            if (f == 0.0f) {
                this.gameController.displayGuiScreen(new GuiScreenDemo());
            } else if (f == 101.0f) {
                this.gameController.ingameGUI.getChatGUI().printChatMessage(new TextComponentTranslation("demo.help.movement", gamesettings.keyBindForward.getDisplayName(), gamesettings.keyBindLeft.getDisplayName(), gamesettings.keyBindBack.getDisplayName(), gamesettings.keyBindRight.getDisplayName()));
            } else if (f == 102.0f) {
                this.gameController.ingameGUI.getChatGUI().printChatMessage(new TextComponentTranslation("demo.help.jump", gamesettings.keyBindJump.getDisplayName()));
            } else if (f == 103.0f) {
                this.gameController.ingameGUI.getChatGUI().printChatMessage(new TextComponentTranslation("demo.help.inventory", gamesettings.keyBindInventory.getDisplayName()));
            }
        } else if (i == 6) {
            this.clientWorldController.playSound(entityplayer, entityplayer.posX, entityplayer.posY + (double)entityplayer.getEyeHeight(), entityplayer.posZ, SoundEvents.ENTITY_ARROW_HIT_PLAYER, SoundCategory.PLAYERS, 0.18f, 0.45f);
        } else if (i == 7) {
            this.clientWorldController.setRainStrength(f);
        } else if (i == 8) {
            this.clientWorldController.setThunderStrength(f);
        } else if (i == 10) {
            this.clientWorldController.spawnParticle(EnumParticleTypes.MOB_APPEARANCE, entityplayer.posX, entityplayer.posY, entityplayer.posZ, 0.0, 0.0, 0.0, new int[0]);
            this.clientWorldController.playSound(entityplayer, entityplayer.posX, entityplayer.posY, entityplayer.posZ, SoundEvents.ENTITY_ELDER_GUARDIAN_CURSE, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
    }

    @Override
    public void handleMaps(SPacketMaps p_handleMaps_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleMaps_1_, this, this.gameController);
        MapItemRenderer mapitemrenderer = this.gameController.entityRenderer.getMapItemRenderer();
        MapData mapdata = ItemMap.loadMapData(p_handleMaps_1_.getMapId(), this.gameController.world);
        if (mapdata == null) {
            MapData mapdata1;
            String s = "map_" + p_handleMaps_1_.getMapId();
            mapdata = new MapData(s);
            if (mapitemrenderer.getMapInstanceIfExists(s) != null && (mapdata1 = mapitemrenderer.getData(mapitemrenderer.getMapInstanceIfExists(s))) != null) {
                mapdata = mapdata1;
            }
            this.gameController.world.setData(s, mapdata);
        }
        p_handleMaps_1_.setMapdataTo(mapdata);
        mapitemrenderer.updateMapTexture(mapdata);
    }

    @Override
    public void handleEffect(SPacketEffect p_handleEffect_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEffect_1_, this, this.gameController);
        if (p_handleEffect_1_.isSoundServerwide()) {
            this.gameController.world.playBroadcastSound(p_handleEffect_1_.getSoundType(), p_handleEffect_1_.getSoundPos(), p_handleEffect_1_.getSoundData());
        } else {
            this.gameController.world.playEvent(p_handleEffect_1_.getSoundType(), p_handleEffect_1_.getSoundPos(), p_handleEffect_1_.getSoundData());
        }
    }

    @Override
    public void handleStatistics(SPacketStatistics p_handleStatistics_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleStatistics_1_, this, this.gameController);
        boolean flag = false;
        for (Map.Entry<StatBase, Integer> entry : p_handleStatistics_1_.getStatisticMap().entrySet()) {
            StatBase statbase = entry.getKey();
            int i = entry.getValue();
            if (statbase.isAchievement() && i > 0) {
                if (this.hasStatistics && this.gameController.player.getStatFileWriter().readStat(statbase) == 0) {
                    Achievement achievement = (Achievement)statbase;
                    this.gameController.guiAchievement.displayAchievement(achievement);
                    if (statbase == AchievementList.OPEN_INVENTORY) {
                        this.gameController.gameSettings.showInventoryAchievementHint = false;
                        this.gameController.gameSettings.saveOptions();
                    }
                }
                flag = true;
            }
            this.gameController.player.getStatFileWriter().unlockAchievement(this.gameController.player, statbase, i);
        }
        if (!this.hasStatistics && !flag && this.gameController.gameSettings.showInventoryAchievementHint) {
            this.gameController.guiAchievement.displayUnformattedAchievement(AchievementList.OPEN_INVENTORY);
        }
        this.hasStatistics = true;
        if (this.gameController.currentScreen instanceof IProgressMeter) {
            ((IProgressMeter)((Object)this.gameController.currentScreen)).doneLoading();
        }
    }

    @Override
    public void handleEntityEffect(SPacketEntityEffect p_handleEntityEffect_1_) {
        Potion potion;
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityEffect_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleEntityEffect_1_.getEntityId());
        if (entity instanceof EntityLivingBase && (potion = Potion.getPotionById(p_handleEntityEffect_1_.getEffectId() & 0xFF)) != null) {
            PotionEffect potioneffect = new PotionEffect(potion, p_handleEntityEffect_1_.getDuration(), p_handleEntityEffect_1_.getAmplifier(), p_handleEntityEffect_1_.getIsAmbient(), p_handleEntityEffect_1_.doesShowParticles());
            potioneffect.setPotionDurationMax(p_handleEntityEffect_1_.isMaxDuration());
            ((EntityLivingBase)entity).addPotionEffect(potioneffect);
        }
    }

    @Override
    public void handleCombatEvent(SPacketCombatEvent p_handleCombatEvent_1_) {
        Entity entity;
        PacketThreadUtil.checkThreadAndEnqueue(p_handleCombatEvent_1_, this, this.gameController);
        if (p_handleCombatEvent_1_.eventType == SPacketCombatEvent.Event.ENTITY_DIED && (entity = this.clientWorldController.getEntityByID(p_handleCombatEvent_1_.playerId)) == this.gameController.player) {
            this.gameController.displayGuiScreen(new GuiGameOver(p_handleCombatEvent_1_.deathMessage));
        }
    }

    @Override
    public void handleServerDifficulty(SPacketServerDifficulty p_handleServerDifficulty_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleServerDifficulty_1_, this, this.gameController);
        this.gameController.world.getWorldInfo().setDifficulty(p_handleServerDifficulty_1_.getDifficulty());
        this.gameController.world.getWorldInfo().setDifficultyLocked(p_handleServerDifficulty_1_.isDifficultyLocked());
    }

    @Override
    public void handleCamera(SPacketCamera p_handleCamera_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleCamera_1_, this, this.gameController);
        Entity entity = p_handleCamera_1_.getEntity(this.clientWorldController);
        if (entity != null) {
            this.gameController.setRenderViewEntity(entity);
        }
    }

    @Override
    public void handleWorldBorder(SPacketWorldBorder p_handleWorldBorder_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleWorldBorder_1_, this, this.gameController);
        p_handleWorldBorder_1_.apply(this.clientWorldController.getWorldBorder());
    }

    @Override
    public void handleTitle(SPacketTitle p_handleTitle_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleTitle_1_, this, this.gameController);
        SPacketTitle.Type spackettitle$type = p_handleTitle_1_.getType();
        String s = null;
        String s1 = null;
        String s2 = p_handleTitle_1_.getMessage() != null ? p_handleTitle_1_.getMessage().getFormattedText() : "";
        switch (spackettitle$type) {
            case TITLE: {
                s = s2;
                break;
            }
            case SUBTITLE: {
                s1 = s2;
                break;
            }
            case ACTIONBAR: {
                this.gameController.ingameGUI.setOverlayMessage(s2, false);
                return;
            }
            case RESET: {
                this.gameController.ingameGUI.displayTitle("", "", -1, -1, -1);
                this.gameController.ingameGUI.setDefaultTitlesTimes();
                return;
            }
        }
        this.gameController.ingameGUI.displayTitle(s, s1, p_handleTitle_1_.getFadeInTime(), p_handleTitle_1_.getDisplayTime(), p_handleTitle_1_.getFadeOutTime());
    }

    @Override
    public void handlePlayerListHeaderFooter(SPacketPlayerListHeaderFooter p_handlePlayerListHeaderFooter_1_) {
        this.gameController.ingameGUI.getTabList().setHeader(p_handlePlayerListHeaderFooter_1_.getHeader().getFormattedText().isEmpty() ? null : p_handlePlayerListHeaderFooter_1_.getHeader());
        this.gameController.ingameGUI.getTabList().setFooter(p_handlePlayerListHeaderFooter_1_.getFooter().getFormattedText().isEmpty() ? null : p_handlePlayerListHeaderFooter_1_.getFooter());
    }

    @Override
    public void handleRemoveEntityEffect(SPacketRemoveEntityEffect p_handleRemoveEntityEffect_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleRemoveEntityEffect_1_, this, this.gameController);
        Entity entity = p_handleRemoveEntityEffect_1_.getEntity(this.clientWorldController);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).removeActivePotionEffect(p_handleRemoveEntityEffect_1_.getPotion());
        }
    }

    @Override
    public void handlePlayerListItem(SPacketPlayerListItem p_handlePlayerListItem_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handlePlayerListItem_1_, this, this.gameController);
        for (SPacketPlayerListItem.AddPlayerData spacketplayerlistitem$addplayerdata : p_handlePlayerListItem_1_.getEntries()) {
            if (p_handlePlayerListItem_1_.getAction() == SPacketPlayerListItem.Action.REMOVE_PLAYER) {
                this.playerInfoMap.remove(spacketplayerlistitem$addplayerdata.getProfile().getId());
                continue;
            }
            NetworkPlayerInfo networkplayerinfo = this.playerInfoMap.get(spacketplayerlistitem$addplayerdata.getProfile().getId());
            if (p_handlePlayerListItem_1_.getAction() == SPacketPlayerListItem.Action.ADD_PLAYER) {
                networkplayerinfo = new NetworkPlayerInfo(spacketplayerlistitem$addplayerdata);
                this.playerInfoMap.put(networkplayerinfo.getGameProfile().getId(), networkplayerinfo);
            }
            if (networkplayerinfo == null) continue;
            switch (p_handlePlayerListItem_1_.getAction()) {
                case ADD_PLAYER: {
                    networkplayerinfo.setGameType(spacketplayerlistitem$addplayerdata.getGameMode());
                    networkplayerinfo.setResponseTime(spacketplayerlistitem$addplayerdata.getPing());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    networkplayerinfo.setGameType(spacketplayerlistitem$addplayerdata.getGameMode());
                    break;
                }
                case UPDATE_LATENCY: {
                    networkplayerinfo.setResponseTime(spacketplayerlistitem$addplayerdata.getPing());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    networkplayerinfo.setDisplayName(spacketplayerlistitem$addplayerdata.getDisplayName());
                }
            }
        }
    }

    @Override
    public void handleKeepAlive(SPacketKeepAlive p_handleKeepAlive_1_) {
        this.sendPacket(new CPacketKeepAlive(p_handleKeepAlive_1_.getId()));
    }

    @Override
    public void handlePlayerAbilities(SPacketPlayerAbilities p_handlePlayerAbilities_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handlePlayerAbilities_1_, this, this.gameController);
        EntityPlayerSP entityplayer = this.gameController.player;
        entityplayer.capabilities.isFlying = p_handlePlayerAbilities_1_.isFlying();
        entityplayer.capabilities.isCreativeMode = p_handlePlayerAbilities_1_.isCreativeMode();
        entityplayer.capabilities.disableDamage = p_handlePlayerAbilities_1_.isInvulnerable();
        entityplayer.capabilities.allowFlying = p_handlePlayerAbilities_1_.isAllowFlying();
        entityplayer.capabilities.setFlySpeed(p_handlePlayerAbilities_1_.getFlySpeed());
        entityplayer.capabilities.setPlayerWalkSpeed(p_handlePlayerAbilities_1_.getWalkSpeed());
    }

    @Override
    public void handleTabComplete(SPacketTabComplete p_handleTabComplete_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleTabComplete_1_, this, this.gameController);
        String[] astring = p_handleTabComplete_1_.getMatches();
        Arrays.sort(astring);
        if (this.gameController.currentScreen instanceof ITabCompleter) {
            ((ITabCompleter)((Object)this.gameController.currentScreen)).setCompletions(astring);
        }
    }

    @Override
    public void handleSoundEffect(SPacketSoundEffect p_handleSoundEffect_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSoundEffect_1_, this, this.gameController);
        this.gameController.world.playSound(this.gameController.player, p_handleSoundEffect_1_.getX(), p_handleSoundEffect_1_.getY(), p_handleSoundEffect_1_.getZ(), p_handleSoundEffect_1_.getSound(), p_handleSoundEffect_1_.getCategory(), p_handleSoundEffect_1_.getVolume(), p_handleSoundEffect_1_.getPitch());
    }

    @Override
    public void handleCustomSound(SPacketCustomSound p_handleCustomSound_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleCustomSound_1_, this, this.gameController);
        this.gameController.getSoundHandler().playSound(new PositionedSoundRecord(new ResourceLocation(p_handleCustomSound_1_.getSoundName()), p_handleCustomSound_1_.getCategory(), p_handleCustomSound_1_.getVolume(), p_handleCustomSound_1_.getPitch(), false, 0, ISound.AttenuationType.LINEAR, (float)p_handleCustomSound_1_.getX(), (float)p_handleCustomSound_1_.getY(), (float)p_handleCustomSound_1_.getZ()));
    }

    @Override
    public void handleResourcePack(SPacketResourcePackSend p_handleResourcePack_1_) {
        final String s = p_handleResourcePack_1_.getURL();
        final String s1 = p_handleResourcePack_1_.getHash();
        if (this.validateResourcePackUrl(s)) {
            if (s.startsWith("level://")) {
                try {
                    String s2 = URLDecoder.decode(s.substring("level://".length()), Charsets.UTF_8.toString());
                    File file1 = new File(this.gameController.mcDataDir, "saves");
                    File file2 = new File(file1, s2);
                    if (file2.isFile()) {
                        this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.ACCEPTED));
                        Futures.addCallback(this.gameController.getResourcePackRepository().setResourcePackInstance(file2), this.createDownloadCallback());
                        return;
                    }
                }
                catch (UnsupportedEncodingException s2) {
                    // empty catch block
                }
                this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.FAILED_DOWNLOAD));
            } else {
                ServerData serverdata = this.gameController.getCurrentServerData();
                if (serverdata != null && serverdata.getResourceMode() == ServerData.ServerResourceMode.ENABLED) {
                    this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.ACCEPTED));
                    Futures.addCallback(this.gameController.getResourcePackRepository().downloadResourcePack(s, s1), this.createDownloadCallback());
                } else if (serverdata != null && serverdata.getResourceMode() != ServerData.ServerResourceMode.PROMPT) {
                    this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.DECLINED));
                } else {
                    this.gameController.addScheduledTask(new Runnable(){

                        @Override
                        public void run() {
                            NetHandlerPlayClient.this.gameController.displayGuiScreen(new GuiYesNo(new GuiYesNoCallback(){

                                @Override
                                public void confirmClicked(boolean p_confirmClicked_1_, int p_confirmClicked_2_) {
                                    NetHandlerPlayClient.this.gameController = Minecraft.getMinecraft();
                                    ServerData serverdata1 = NetHandlerPlayClient.this.gameController.getCurrentServerData();
                                    if (p_confirmClicked_1_) {
                                        if (serverdata1 != null) {
                                            serverdata1.setResourceMode(ServerData.ServerResourceMode.ENABLED);
                                        }
                                        NetHandlerPlayClient.this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.ACCEPTED));
                                        Futures.addCallback(NetHandlerPlayClient.this.gameController.getResourcePackRepository().downloadResourcePack(s, s1), (FutureCallback)NetHandlerPlayClient.this.createDownloadCallback());
                                    } else {
                                        if (serverdata1 != null) {
                                            serverdata1.setResourceMode(ServerData.ServerResourceMode.DISABLED);
                                        }
                                        NetHandlerPlayClient.this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.DECLINED));
                                    }
                                    ServerList.saveSingleServer(serverdata1);
                                    NetHandlerPlayClient.this.gameController.displayGuiScreen(null);
                                }
                            }, I18n.format("multiplayer.texturePrompt.line1", new Object[0]), I18n.format("multiplayer.texturePrompt.line2", new Object[0]), 0));
                        }
                    });
                }
            }
        }
    }

    private boolean validateResourcePackUrl(String p_validateResourcePackUrl_1_) {
        try {
            URI uri = new URI(p_validateResourcePackUrl_1_);
            String s = uri.getScheme();
            boolean flag = "level".equals(s);
            if (!("http".equals(s) || "https".equals(s) || flag)) {
                throw new URISyntaxException(p_validateResourcePackUrl_1_, "Wrong protocol");
            }
            if (!flag || !p_validateResourcePackUrl_1_.contains("..") && p_validateResourcePackUrl_1_.endsWith("/resources.zip")) {
                return true;
            }
            throw new URISyntaxException(p_validateResourcePackUrl_1_, "Invalid levelstorage resourcepack path");
        }
        catch (URISyntaxException var5) {
            this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.FAILED_DOWNLOAD));
            return false;
        }
    }

    private FutureCallback<Object> createDownloadCallback() {
        return new FutureCallback<Object>(){

            public void onSuccess(Object p_onSuccess_1_) {
                NetHandlerPlayClient.this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.SUCCESSFULLY_LOADED));
            }

            public void onFailure(Throwable p_onFailure_1_) {
                NetHandlerPlayClient.this.netManager.sendPacket(new CPacketResourcePackStatus(CPacketResourcePackStatus.Action.FAILED_DOWNLOAD));
            }
        };
    }

    @Override
    public void handleUpdateBossInfo(SPacketUpdateBossInfo p_handleUpdateBossInfo_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleUpdateBossInfo_1_, this, this.gameController);
        this.gameController.ingameGUI.getBossOverlay().read(p_handleUpdateBossInfo_1_);
    }

    @Override
    public void handleCooldown(SPacketCooldown p_handleCooldown_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleCooldown_1_, this, this.gameController);
        if (p_handleCooldown_1_.getTicks() == 0) {
            this.gameController.player.getCooldownTracker().removeCooldown(p_handleCooldown_1_.getItem());
        } else {
            this.gameController.player.getCooldownTracker().setCooldown(p_handleCooldown_1_.getItem(), p_handleCooldown_1_.getTicks());
        }
    }

    @Override
    public void handleMoveVehicle(SPacketMoveVehicle p_handleMoveVehicle_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleMoveVehicle_1_, this, this.gameController);
        Entity entity = this.gameController.player.getLowestRidingEntity();
        if (entity != this.gameController.player && entity.canPassengerSteer()) {
            entity.setPositionAndRotation(p_handleMoveVehicle_1_.getX(), p_handleMoveVehicle_1_.getY(), p_handleMoveVehicle_1_.getZ(), p_handleMoveVehicle_1_.getYaw(), p_handleMoveVehicle_1_.getPitch());
            this.netManager.sendPacket(new CPacketVehicleMove(entity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleCustomPayload(SPacketCustomPayload p_handleCustomPayload_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleCustomPayload_1_, this, this.gameController);
        if ("MC|TrList".equals(p_handleCustomPayload_1_.getChannelName())) {
            PacketBuffer packetbuffer = p_handleCustomPayload_1_.getBufferData();
            try {
                int i = packetbuffer.readInt();
                GuiScreen guiscreen = this.gameController.currentScreen;
                if (guiscreen == null || !(guiscreen instanceof GuiMerchant) || i != this.gameController.player.openContainer.windowId) return;
                IMerchant imerchant = ((GuiMerchant)guiscreen).getMerchant();
                MerchantRecipeList merchantrecipelist = MerchantRecipeList.readFromBuf(packetbuffer);
                imerchant.setRecipes(merchantrecipelist);
                return;
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't load trade info", (Throwable)ioexception);
                return;
            }
            finally {
                packetbuffer.release();
            }
        } else if ("MC|Brand".equals(p_handleCustomPayload_1_.getChannelName())) {
            this.gameController.player.setServerBrand(p_handleCustomPayload_1_.getBufferData().readString(Short.MAX_VALUE));
            return;
        } else if ("MC|BOpen".equals(p_handleCustomPayload_1_.getChannelName())) {
            ItemStack itemstack;
            EnumHand enumhand = p_handleCustomPayload_1_.getBufferData().readEnumValue(EnumHand.class);
            ItemStack itemStack = itemstack = enumhand == EnumHand.OFF_HAND ? this.gameController.player.getHeldItemOffhand() : this.gameController.player.getHeldItemMainhand();
            if (itemstack.getItem() != Items.WRITTEN_BOOK) return;
            this.gameController.displayGuiScreen(new GuiScreenBook(this.gameController.player, itemstack, false));
            return;
        } else if ("MC|DebugPath".equals(p_handleCustomPayload_1_.getChannelName())) {
            PacketBuffer packetbuffer1 = p_handleCustomPayload_1_.getBufferData();
            int j = packetbuffer1.readInt();
            float f = packetbuffer1.readFloat();
            Path path = Path.read(packetbuffer1);
            ((DebugRendererPathfinding)this.gameController.debugRenderer.debugRendererPathfinding).addPath(j, path, f);
            return;
        } else if ("MC|DebugNeighborsUpdate".equals(p_handleCustomPayload_1_.getChannelName())) {
            PacketBuffer packetbuffer2 = p_handleCustomPayload_1_.getBufferData();
            long k = packetbuffer2.readVarLong();
            BlockPos blockpos = packetbuffer2.readBlockPos();
            ((DebugRendererNeighborsUpdate)this.gameController.debugRenderer.field_191557_f).func_191553_a(k, blockpos);
            return;
        } else {
            if (!"MC|StopSound".equals(p_handleCustomPayload_1_.getChannelName())) return;
            PacketBuffer packetbuffer3 = p_handleCustomPayload_1_.getBufferData();
            String s = packetbuffer3.readString(Short.MAX_VALUE);
            String s1 = packetbuffer3.readString(256);
            this.gameController.getSoundHandler().stop(s1, SoundCategory.getByName(s));
        }
    }

    @Override
    public void handleScoreboardObjective(SPacketScoreboardObjective p_handleScoreboardObjective_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleScoreboardObjective_1_, this, this.gameController);
        Scoreboard scoreboard = this.clientWorldController.getScoreboard();
        if (p_handleScoreboardObjective_1_.getAction() == 0) {
            ScoreObjective scoreobjective = scoreboard.addScoreObjective(p_handleScoreboardObjective_1_.getObjectiveName(), IScoreCriteria.DUMMY);
            scoreobjective.setDisplayName(p_handleScoreboardObjective_1_.getObjectiveValue());
            scoreobjective.setRenderType(p_handleScoreboardObjective_1_.getRenderType());
        } else {
            ScoreObjective scoreobjective1 = scoreboard.getObjective(p_handleScoreboardObjective_1_.getObjectiveName());
            if (p_handleScoreboardObjective_1_.getAction() == 1) {
                scoreboard.removeObjective(scoreobjective1);
            } else if (p_handleScoreboardObjective_1_.getAction() == 2) {
                scoreobjective1.setDisplayName(p_handleScoreboardObjective_1_.getObjectiveValue());
                scoreobjective1.setRenderType(p_handleScoreboardObjective_1_.getRenderType());
            }
        }
    }

    @Override
    public void handleUpdateScore(SPacketUpdateScore p_handleUpdateScore_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleUpdateScore_1_, this, this.gameController);
        Scoreboard scoreboard = this.clientWorldController.getScoreboard();
        ScoreObjective scoreobjective = scoreboard.getObjective(p_handleUpdateScore_1_.getObjectiveName());
        if (p_handleUpdateScore_1_.getScoreAction() == SPacketUpdateScore.Action.CHANGE) {
            Score score = scoreboard.getOrCreateScore(p_handleUpdateScore_1_.getPlayerName(), scoreobjective);
            score.setScorePoints(p_handleUpdateScore_1_.getScoreValue());
        } else if (p_handleUpdateScore_1_.getScoreAction() == SPacketUpdateScore.Action.REMOVE) {
            if (StringUtils.isNullOrEmpty(p_handleUpdateScore_1_.getObjectiveName())) {
                scoreboard.removeObjectiveFromEntity(p_handleUpdateScore_1_.getPlayerName(), null);
            } else if (scoreobjective != null) {
                scoreboard.removeObjectiveFromEntity(p_handleUpdateScore_1_.getPlayerName(), scoreobjective);
            }
        }
    }

    @Override
    public void handleDisplayObjective(SPacketDisplayObjective p_handleDisplayObjective_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleDisplayObjective_1_, this, this.gameController);
        Scoreboard scoreboard = this.clientWorldController.getScoreboard();
        if (p_handleDisplayObjective_1_.getName().isEmpty()) {
            scoreboard.setObjectiveInDisplaySlot(p_handleDisplayObjective_1_.getPosition(), null);
        } else {
            ScoreObjective scoreobjective = scoreboard.getObjective(p_handleDisplayObjective_1_.getName());
            scoreboard.setObjectiveInDisplaySlot(p_handleDisplayObjective_1_.getPosition(), scoreobjective);
        }
    }

    @Override
    public void handleTeams(SPacketTeams p_handleTeams_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleTeams_1_, this, this.gameController);
        Scoreboard scoreboard = this.clientWorldController.getScoreboard();
        ScorePlayerTeam scoreplayerteam = p_handleTeams_1_.getAction() == 0 ? scoreboard.createTeam(p_handleTeams_1_.getName()) : scoreboard.getTeam(p_handleTeams_1_.getName());
        if (p_handleTeams_1_.getAction() == 0 || p_handleTeams_1_.getAction() == 2) {
            Team.CollisionRule team$collisionrule;
            scoreplayerteam.setTeamName(p_handleTeams_1_.getDisplayName());
            scoreplayerteam.setNamePrefix(p_handleTeams_1_.getPrefix());
            scoreplayerteam.setNameSuffix(p_handleTeams_1_.getSuffix());
            scoreplayerteam.setChatFormat(TextFormatting.fromColorIndex(p_handleTeams_1_.getColor()));
            scoreplayerteam.setFriendlyFlags(p_handleTeams_1_.getFriendlyFlags());
            Team.EnumVisible team$enumvisible = Team.EnumVisible.getByName(p_handleTeams_1_.getNameTagVisibility());
            if (team$enumvisible != null) {
                scoreplayerteam.setNameTagVisibility(team$enumvisible);
            }
            if ((team$collisionrule = Team.CollisionRule.getByName(p_handleTeams_1_.getCollisionRule())) != null) {
                scoreplayerteam.setCollisionRule(team$collisionrule);
            }
        }
        if (p_handleTeams_1_.getAction() == 0 || p_handleTeams_1_.getAction() == 3) {
            for (String s : p_handleTeams_1_.getPlayers()) {
                scoreboard.addPlayerToTeam(s, p_handleTeams_1_.getName());
            }
        }
        if (p_handleTeams_1_.getAction() == 4) {
            for (String s1 : p_handleTeams_1_.getPlayers()) {
                scoreboard.removePlayerFromTeam(s1, scoreplayerteam);
            }
        }
        if (p_handleTeams_1_.getAction() == 1) {
            scoreboard.removeTeam(scoreplayerteam);
        }
    }

    @Override
    public void handleParticles(SPacketParticles p_handleParticles_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleParticles_1_, this, this.gameController);
        if (p_handleParticles_1_.getParticleCount() == 0) {
            double d0 = p_handleParticles_1_.getParticleSpeed() * p_handleParticles_1_.getXOffset();
            double d2 = p_handleParticles_1_.getParticleSpeed() * p_handleParticles_1_.getYOffset();
            double d4 = p_handleParticles_1_.getParticleSpeed() * p_handleParticles_1_.getZOffset();
            try {
                this.clientWorldController.spawnParticle(p_handleParticles_1_.getParticleType(), p_handleParticles_1_.isLongDistance(), p_handleParticles_1_.getXCoordinate(), p_handleParticles_1_.getYCoordinate(), p_handleParticles_1_.getZCoordinate(), d0, d2, d4, p_handleParticles_1_.getParticleArgs());
            }
            catch (Throwable var17) {
                LOGGER.warn("Could not spawn particle effect {}", new Object[]{p_handleParticles_1_.getParticleType()});
            }
        } else {
            for (int i = 0; i < p_handleParticles_1_.getParticleCount(); ++i) {
                double d1 = this.avRandomizer.nextGaussian() * (double)p_handleParticles_1_.getXOffset();
                double d3 = this.avRandomizer.nextGaussian() * (double)p_handleParticles_1_.getYOffset();
                double d5 = this.avRandomizer.nextGaussian() * (double)p_handleParticles_1_.getZOffset();
                double d6 = this.avRandomizer.nextGaussian() * (double)p_handleParticles_1_.getParticleSpeed();
                double d7 = this.avRandomizer.nextGaussian() * (double)p_handleParticles_1_.getParticleSpeed();
                double d8 = this.avRandomizer.nextGaussian() * (double)p_handleParticles_1_.getParticleSpeed();
                try {
                    this.clientWorldController.spawnParticle(p_handleParticles_1_.getParticleType(), p_handleParticles_1_.isLongDistance(), p_handleParticles_1_.getXCoordinate() + d1, p_handleParticles_1_.getYCoordinate() + d3, p_handleParticles_1_.getZCoordinate() + d5, d6, d7, d8, p_handleParticles_1_.getParticleArgs());
                    continue;
                }
                catch (Throwable var16) {
                    LOGGER.warn("Could not spawn particle effect {}", new Object[]{p_handleParticles_1_.getParticleType()});
                    return;
                }
            }
        }
    }

    @Override
    public void handleEntityProperties(SPacketEntityProperties p_handleEntityProperties_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleEntityProperties_1_, this, this.gameController);
        Entity entity = this.clientWorldController.getEntityByID(p_handleEntityProperties_1_.getEntityId());
        if (entity != null) {
            if (!(entity instanceof EntityLivingBase)) {
                throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + entity + ")");
            }
            AbstractAttributeMap abstractattributemap = ((EntityLivingBase)entity).getAttributeMap();
            for (SPacketEntityProperties.Snapshot spacketentityproperties$snapshot : p_handleEntityProperties_1_.getSnapshots()) {
                IAttributeInstance iattributeinstance = abstractattributemap.getAttributeInstanceByName(spacketentityproperties$snapshot.getName());
                if (iattributeinstance == null) {
                    iattributeinstance = abstractattributemap.registerAttribute(new RangedAttribute(null, spacketentityproperties$snapshot.getName(), 0.0, Double.MIN_NORMAL, Double.MAX_VALUE));
                }
                iattributeinstance.setBaseValue(spacketentityproperties$snapshot.getBaseValue());
                iattributeinstance.removeAllModifiers();
                for (AttributeModifier attributemodifier : spacketentityproperties$snapshot.getModifiers()) {
                    iattributeinstance.applyModifier(attributemodifier);
                }
            }
        }
    }

    public NetworkManager getNetworkManager() {
        return this.netManager;
    }

    public Collection<NetworkPlayerInfo> getPlayerInfoMap() {
        return this.playerInfoMap.values();
    }

    public NetworkPlayerInfo getPlayerInfo(UUID p_getPlayerInfo_1_) {
        return this.playerInfoMap.get(p_getPlayerInfo_1_);
    }

    @Nullable
    public NetworkPlayerInfo getPlayerInfo(String p_getPlayerInfo_1_) {
        for (NetworkPlayerInfo networkplayerinfo : this.playerInfoMap.values()) {
            if (!networkplayerinfo.getGameProfile().getName().equals(p_getPlayerInfo_1_)) continue;
            return networkplayerinfo;
        }
        return null;
    }

    public GameProfile getGameProfile() {
        return this.profile;
    }
}

