/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class NetworkPlayerInfo {
    private final GameProfile gameProfile;
    Map<MinecraftProfileTexture.Type, ResourceLocation> playerTextures = Maps.newEnumMap(MinecraftProfileTexture.Type.class);
    private GameType gameType;
    private int responseTime;
    private boolean playerTexturesLoaded;
    private String skinType;
    private ITextComponent displayName;
    private int lastHealth;
    private int displayHealth;
    private long lastHealthTime;
    private long healthBlinkTime;
    private long renderVisibilityId;

    public NetworkPlayerInfo(GameProfile p_i46294_1_) {
        this.gameProfile = p_i46294_1_;
    }

    public NetworkPlayerInfo(SPacketPlayerListItem.AddPlayerData p_i46583_1_) {
        this.gameProfile = p_i46583_1_.getProfile();
        this.gameType = p_i46583_1_.getGameMode();
        this.responseTime = p_i46583_1_.getPing();
        this.displayName = p_i46583_1_.getDisplayName();
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public GameType getGameType() {
        return this.gameType;
    }

    protected void setGameType(GameType p_setGameType_1_) {
        this.gameType = p_setGameType_1_;
    }

    public int getResponseTime() {
        return this.responseTime;
    }

    protected void setResponseTime(int p_setResponseTime_1_) {
        this.responseTime = p_setResponseTime_1_;
    }

    public boolean hasLocationSkin() {
        return this.getLocationSkin() != null;
    }

    public String getSkinType() {
        if (this.skinType == null) {
            return DefaultPlayerSkin.getSkinType(this.gameProfile.getId());
        }
        return this.skinType;
    }

    public ResourceLocation getLocationSkin() {
        this.loadPlayerTextures();
        return (ResourceLocation)Objects.firstNonNull((Object)this.playerTextures.get(MinecraftProfileTexture.Type.SKIN), (Object)DefaultPlayerSkin.getDefaultSkin(this.gameProfile.getId()));
    }

    @Nullable
    public ResourceLocation getLocationCape() {
        this.loadPlayerTextures();
        return this.playerTextures.get(MinecraftProfileTexture.Type.CAPE);
    }

    @Nullable
    public ResourceLocation getLocationElytra() {
        this.loadPlayerTextures();
        return this.playerTextures.get(MinecraftProfileTexture.Type.ELYTRA);
    }

    @Nullable
    public ScorePlayerTeam getPlayerTeam() {
        return Minecraft.getMinecraft().world.getScoreboard().getPlayersTeam(this.getGameProfile().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPlayerTextures() {
        NetworkPlayerInfo networkPlayerInfo = this;
        synchronized (networkPlayerInfo) {
            if (!this.playerTexturesLoaded) {
                this.playerTexturesLoaded = true;
                Minecraft.getMinecraft().getSkinManager().loadProfileTextures(this.gameProfile, new SkinManager.SkinAvailableCallback(){

                    @Override
                    public void skinAvailable(MinecraftProfileTexture.Type p_skinAvailable_1_, ResourceLocation p_skinAvailable_2_, MinecraftProfileTexture p_skinAvailable_3_) {
                        switch (p_skinAvailable_1_) {
                            case SKIN: {
                                NetworkPlayerInfo.this.playerTextures.put(MinecraftProfileTexture.Type.SKIN, p_skinAvailable_2_);
                                NetworkPlayerInfo.this.skinType = p_skinAvailable_3_.getMetadata("model");
                                if (NetworkPlayerInfo.this.skinType != null) break;
                                NetworkPlayerInfo.this.skinType = "default";
                                break;
                            }
                            case CAPE: {
                                NetworkPlayerInfo.this.playerTextures.put(MinecraftProfileTexture.Type.CAPE, p_skinAvailable_2_);
                                break;
                            }
                            case ELYTRA: {
                                NetworkPlayerInfo.this.playerTextures.put(MinecraftProfileTexture.Type.ELYTRA, p_skinAvailable_2_);
                            }
                        }
                    }
                }, true);
            }
        }
    }

    public void setDisplayName(ITextComponent p_setDisplayName_1_) {
        this.displayName = p_setDisplayName_1_;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public int getLastHealth() {
        return this.lastHealth;
    }

    public void setLastHealth(int p_setLastHealth_1_) {
        this.lastHealth = p_setLastHealth_1_;
    }

    public int getDisplayHealth() {
        return this.displayHealth;
    }

    public void setDisplayHealth(int p_setDisplayHealth_1_) {
        this.displayHealth = p_setDisplayHealth_1_;
    }

    public long getLastHealthTime() {
        return this.lastHealthTime;
    }

    public void setLastHealthTime(long p_setLastHealthTime_1_) {
        this.lastHealthTime = p_setLastHealthTime_1_;
    }

    public long getHealthBlinkTime() {
        return this.healthBlinkTime;
    }

    public void setHealthBlinkTime(long p_setHealthBlinkTime_1_) {
        this.healthBlinkTime = p_setHealthBlinkTime_1_;
    }

    public long getRenderVisibilityId() {
        return this.renderVisibilityId;
    }

    public void setRenderVisibilityId(long p_setRenderVisibilityId_1_) {
        this.renderVisibilityId = p_setRenderVisibilityId_1_;
    }
}

