/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Barrier
extends Particle {
    protected Barrier(World p_i46286_1_, double p_i46286_2_, double p_i46286_4_, double p_i46286_6_, Item p_i46286_8_) {
        super(p_i46286_1_, p_i46286_2_, p_i46286_4_, p_i46286_6_, 0.0, 0.0, 0.0);
        this.setParticleTexture(Minecraft.getMinecraft().getRenderItem().getItemModelMesher().getParticleIcon(p_i46286_8_));
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.particleGravity = 0.0f;
        this.particleMaxAge = 80;
    }

    @Override
    public int getFXLayer() {
        return 1;
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_9_1_ = this.particleTexture.getMinU();
        float lvt_10_1_ = this.particleTexture.getMaxU();
        float lvt_11_1_ = this.particleTexture.getMinV();
        float lvt_12_1_ = this.particleTexture.getMaxV();
        float lvt_13_1_ = 0.5f;
        float lvt_14_1_ = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)p_renderParticle_3_ - interpPosX);
        float lvt_15_1_ = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)p_renderParticle_3_ - interpPosY);
        float lvt_16_1_ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_renderParticle_3_ - interpPosZ);
        int lvt_17_1_ = this.getBrightnessForRender(p_renderParticle_3_);
        int lvt_18_1_ = lvt_17_1_ >> 16 & 0xFFFF;
        int lvt_19_1_ = lvt_17_1_ & 0xFFFF;
        p_renderParticle_1_.pos(lvt_14_1_ - p_renderParticle_4_ * 0.5f - p_renderParticle_7_ * 0.5f, lvt_15_1_ - p_renderParticle_5_ * 0.5f, lvt_16_1_ - p_renderParticle_6_ * 0.5f - p_renderParticle_8_ * 0.5f).tex(lvt_10_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ - p_renderParticle_4_ * 0.5f + p_renderParticle_7_ * 0.5f, lvt_15_1_ + p_renderParticle_5_ * 0.5f, lvt_16_1_ - p_renderParticle_6_ * 0.5f + p_renderParticle_8_ * 0.5f).tex(lvt_10_1_, lvt_11_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ + p_renderParticle_4_ * 0.5f + p_renderParticle_7_ * 0.5f, lvt_15_1_ + p_renderParticle_5_ * 0.5f, lvt_16_1_ + p_renderParticle_6_ * 0.5f + p_renderParticle_8_ * 0.5f).tex(lvt_9_1_, lvt_11_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ + p_renderParticle_4_ * 0.5f - p_renderParticle_7_ * 0.5f, lvt_15_1_ - p_renderParticle_5_ * 0.5f, lvt_16_1_ + p_renderParticle_6_ * 0.5f - p_renderParticle_8_ * 0.5f).tex(lvt_9_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new Barrier(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, Item.getItemFromBlock(Blocks.BARRIER));
        }
    }
}

