/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Particle {
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected World world;
    protected double prevPosX;
    protected double prevPosY;
    protected double prevPosZ;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    private AxisAlignedBB boundingBox = EMPTY_AABB;
    protected boolean onGround;
    protected boolean canCollide;
    protected boolean isExpired;
    protected float width = 0.6f;
    protected float height = 1.8f;
    protected Random rand = new Random();
    protected int particleTextureIndexX;
    protected int particleTextureIndexY;
    protected float particleTextureJitterX;
    protected float particleTextureJitterY;
    protected int particleAge;
    protected int particleMaxAge;
    protected float particleScale;
    protected float particleGravity;
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    protected float particleAlpha = 1.0f;
    protected TextureAtlasSprite particleTexture;
    protected float particleAngle;
    protected float prevParticleAngle;
    public static double interpPosX;
    public static double interpPosY;
    public static double interpPosZ;
    public static Vec3d cameraViewDir;

    protected Particle(World p_i46352_1_, double p_i46352_2_, double p_i46352_4_, double p_i46352_6_) {
        this.world = p_i46352_1_;
        this.setSize(0.2f, 0.2f);
        this.setPosition(p_i46352_2_, p_i46352_4_, p_i46352_6_);
        this.prevPosX = p_i46352_2_;
        this.prevPosY = p_i46352_4_;
        this.prevPosZ = p_i46352_6_;
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.particleTextureJitterX = this.rand.nextFloat() * 3.0f;
        this.particleTextureJitterY = this.rand.nextFloat() * 3.0f;
        this.particleScale = (this.rand.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.particleMaxAge = (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f));
        this.particleAge = 0;
        this.canCollide = true;
    }

    public Particle(World p_i1219_1_, double p_i1219_2_, double p_i1219_4_, double p_i1219_6_, double p_i1219_8_, double p_i1219_10_, double p_i1219_12_) {
        this(p_i1219_1_, p_i1219_2_, p_i1219_4_, p_i1219_6_);
        this.motionX = p_i1219_8_ + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.motionY = p_i1219_10_ + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.motionZ = p_i1219_12_ + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        float lvt_14_1_ = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float lvt_15_1_ = MathHelper.sqrt(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
        this.motionX = this.motionX / (double)lvt_15_1_ * (double)lvt_14_1_ * (double)0.4f;
        this.motionY = this.motionY / (double)lvt_15_1_ * (double)lvt_14_1_ * (double)0.4f + (double)0.1f;
        this.motionZ = this.motionZ / (double)lvt_15_1_ * (double)lvt_14_1_ * (double)0.4f;
    }

    public Particle multiplyVelocity(float p_multiplyVelocity_1_) {
        this.motionX *= (double)p_multiplyVelocity_1_;
        this.motionY = (this.motionY - (double)0.1f) * (double)p_multiplyVelocity_1_ + (double)0.1f;
        this.motionZ *= (double)p_multiplyVelocity_1_;
        return this;
    }

    public Particle multipleParticleScaleBy(float p_multipleParticleScaleBy_1_) {
        this.setSize(0.2f * p_multipleParticleScaleBy_1_, 0.2f * p_multipleParticleScaleBy_1_);
        this.particleScale *= p_multipleParticleScaleBy_1_;
        return this;
    }

    public void setRBGColorF(float p_setRBGColorF_1_, float p_setRBGColorF_2_, float p_setRBGColorF_3_) {
        this.particleRed = p_setRBGColorF_1_;
        this.particleGreen = p_setRBGColorF_2_;
        this.particleBlue = p_setRBGColorF_3_;
    }

    public void setAlphaF(float p_setAlphaF_1_) {
        this.particleAlpha = p_setAlphaF_1_;
    }

    public boolean isTransparent() {
        return false;
    }

    public float getRedColorF() {
        return this.particleRed;
    }

    public float getGreenColorF() {
        return this.particleGreen;
    }

    public float getBlueColorF() {
        return this.particleBlue;
    }

    public void setMaxAge(int p_setMaxAge_1_) {
        this.particleMaxAge = p_setMaxAge_1_;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        this.motionY -= 0.04 * (double)this.particleGravity;
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }

    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_9_1_ = (float)this.particleTextureIndexX / 16.0f;
        float lvt_10_1_ = lvt_9_1_ + 0.0624375f;
        float lvt_11_1_ = (float)this.particleTextureIndexY / 16.0f;
        float lvt_12_1_ = lvt_11_1_ + 0.0624375f;
        float lvt_13_1_ = 0.1f * this.particleScale;
        if (this.particleTexture != null) {
            lvt_9_1_ = this.particleTexture.getMinU();
            lvt_10_1_ = this.particleTexture.getMaxU();
            lvt_11_1_ = this.particleTexture.getMinV();
            lvt_12_1_ = this.particleTexture.getMaxV();
        }
        float lvt_14_1_ = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)p_renderParticle_3_ - interpPosX);
        float lvt_15_1_ = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)p_renderParticle_3_ - interpPosY);
        float lvt_16_1_ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_renderParticle_3_ - interpPosZ);
        int lvt_17_1_ = this.getBrightnessForRender(p_renderParticle_3_);
        int lvt_18_1_ = lvt_17_1_ >> 16 & 0xFFFF;
        int lvt_19_1_ = lvt_17_1_ & 0xFFFF;
        Vec3d[] lvt_20_1_ = new Vec3d[]{new Vec3d(-p_renderParticle_4_ * lvt_13_1_ - p_renderParticle_7_ * lvt_13_1_, -p_renderParticle_5_ * lvt_13_1_, -p_renderParticle_6_ * lvt_13_1_ - p_renderParticle_8_ * lvt_13_1_), new Vec3d(-p_renderParticle_4_ * lvt_13_1_ + p_renderParticle_7_ * lvt_13_1_, p_renderParticle_5_ * lvt_13_1_, -p_renderParticle_6_ * lvt_13_1_ + p_renderParticle_8_ * lvt_13_1_), new Vec3d(p_renderParticle_4_ * lvt_13_1_ + p_renderParticle_7_ * lvt_13_1_, p_renderParticle_5_ * lvt_13_1_, p_renderParticle_6_ * lvt_13_1_ + p_renderParticle_8_ * lvt_13_1_), new Vec3d(p_renderParticle_4_ * lvt_13_1_ - p_renderParticle_7_ * lvt_13_1_, -p_renderParticle_5_ * lvt_13_1_, p_renderParticle_6_ * lvt_13_1_ - p_renderParticle_8_ * lvt_13_1_)};
        if (this.particleAngle != 0.0f) {
            float lvt_21_1_ = this.particleAngle + (this.particleAngle - this.prevParticleAngle) * p_renderParticle_3_;
            float lvt_22_1_ = MathHelper.cos(lvt_21_1_ * 0.5f);
            float lvt_23_1_ = MathHelper.sin(lvt_21_1_ * 0.5f) * (float)Particle.cameraViewDir.xCoord;
            float lvt_24_1_ = MathHelper.sin(lvt_21_1_ * 0.5f) * (float)Particle.cameraViewDir.yCoord;
            float lvt_25_1_ = MathHelper.sin(lvt_21_1_ * 0.5f) * (float)Particle.cameraViewDir.zCoord;
            Vec3d lvt_26_1_ = new Vec3d(lvt_23_1_, lvt_24_1_, lvt_25_1_);
            for (int lvt_27_1_ = 0; lvt_27_1_ < 4; ++lvt_27_1_) {
                lvt_20_1_[lvt_27_1_] = lvt_26_1_.scale(2.0 * lvt_20_1_[lvt_27_1_].dotProduct(lvt_26_1_)).add(lvt_20_1_[lvt_27_1_].scale((double)(lvt_22_1_ * lvt_22_1_) - lvt_26_1_.dotProduct(lvt_26_1_))).add(lvt_26_1_.crossProduct(lvt_20_1_[lvt_27_1_]).scale(2.0f * lvt_22_1_));
            }
        }
        p_renderParticle_1_.pos((double)lvt_14_1_ + lvt_20_1_[0].xCoord, (double)lvt_15_1_ + lvt_20_1_[0].yCoord, (double)lvt_16_1_ + lvt_20_1_[0].zCoord).tex(lvt_10_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos((double)lvt_14_1_ + lvt_20_1_[1].xCoord, (double)lvt_15_1_ + lvt_20_1_[1].yCoord, (double)lvt_16_1_ + lvt_20_1_[1].zCoord).tex(lvt_10_1_, lvt_11_1_).color(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos((double)lvt_14_1_ + lvt_20_1_[2].xCoord, (double)lvt_15_1_ + lvt_20_1_[2].yCoord, (double)lvt_16_1_ + lvt_20_1_[2].zCoord).tex(lvt_9_1_, lvt_11_1_).color(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos((double)lvt_14_1_ + lvt_20_1_[3].xCoord, (double)lvt_15_1_ + lvt_20_1_[3].yCoord, (double)lvt_16_1_ + lvt_20_1_[3].zCoord).tex(lvt_9_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
    }

    public int getFXLayer() {
        return 0;
    }

    public void setParticleTexture(TextureAtlasSprite p_setParticleTexture_1_) {
        int lvt_2_1_ = this.getFXLayer();
        if (lvt_2_1_ != 1) {
            throw new RuntimeException("Invalid call to Particle.setTex, use coordinate methods");
        }
        this.particleTexture = p_setParticleTexture_1_;
    }

    public void setParticleTextureIndex(int p_setParticleTextureIndex_1_) {
        if (this.getFXLayer() != 0) {
            throw new RuntimeException("Invalid call to Particle.setMiscTex");
        }
        this.particleTextureIndexX = p_setParticleTextureIndex_1_ % 16;
        this.particleTextureIndexY = p_setParticleTextureIndex_1_ / 16;
    }

    public void nextTextureIndexX() {
        ++this.particleTextureIndexX;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", Pos (" + this.posX + "," + this.posY + "," + this.posZ + "), RGBA (" + this.particleRed + "," + this.particleGreen + "," + this.particleBlue + "," + this.particleAlpha + "), Age " + this.particleAge;
    }

    public void setExpired() {
        this.isExpired = true;
    }

    protected void setSize(float p_setSize_1_, float p_setSize_2_) {
        if (p_setSize_1_ != this.width || p_setSize_2_ != this.height) {
            this.width = p_setSize_1_;
            this.height = p_setSize_2_;
            AxisAlignedBB lvt_3_1_ = this.getBoundingBox();
            this.setBoundingBox(new AxisAlignedBB(lvt_3_1_.minX, lvt_3_1_.minY, lvt_3_1_.minZ, lvt_3_1_.minX + (double)this.width, lvt_3_1_.minY + (double)this.height, lvt_3_1_.minZ + (double)this.width));
        }
    }

    public void setPosition(double p_setPosition_1_, double p_setPosition_3_, double p_setPosition_5_) {
        this.posX = p_setPosition_1_;
        this.posY = p_setPosition_3_;
        this.posZ = p_setPosition_5_;
        float lvt_7_1_ = this.width / 2.0f;
        float lvt_8_1_ = this.height;
        this.setBoundingBox(new AxisAlignedBB(p_setPosition_1_ - (double)lvt_7_1_, p_setPosition_3_, p_setPosition_5_ - (double)lvt_7_1_, p_setPosition_1_ + (double)lvt_7_1_, p_setPosition_3_ + (double)lvt_8_1_, p_setPosition_5_ + (double)lvt_7_1_));
    }

    public void move(double p_move_1_, double p_move_3_, double p_move_5_) {
        double lvt_7_1_ = p_move_1_;
        double lvt_9_1_ = p_move_3_;
        double lvt_11_1_ = p_move_5_;
        if (this.canCollide) {
            List<AxisAlignedBB> lvt_13_1_ = this.world.getCollisionBoxes(null, this.getBoundingBox().addCoord(p_move_1_, p_move_3_, p_move_5_));
            for (AxisAlignedBB lvt_15_1_ : lvt_13_1_) {
                p_move_3_ = lvt_15_1_.calculateYOffset(this.getBoundingBox(), p_move_3_);
            }
            this.setBoundingBox(this.getBoundingBox().offset(0.0, p_move_3_, 0.0));
            for (AxisAlignedBB lvt_15_2_ : lvt_13_1_) {
                p_move_1_ = lvt_15_2_.calculateXOffset(this.getBoundingBox(), p_move_1_);
            }
            this.setBoundingBox(this.getBoundingBox().offset(p_move_1_, 0.0, 0.0));
            for (AxisAlignedBB lvt_15_3_ : lvt_13_1_) {
                p_move_5_ = lvt_15_3_.calculateZOffset(this.getBoundingBox(), p_move_5_);
            }
            this.setBoundingBox(this.getBoundingBox().offset(0.0, 0.0, p_move_5_));
        } else {
            this.setBoundingBox(this.getBoundingBox().offset(p_move_1_, p_move_3_, p_move_5_));
        }
        this.resetPositionToBB();
        boolean bl = this.onGround = lvt_9_1_ != p_move_3_ && lvt_9_1_ < 0.0;
        if (lvt_7_1_ != p_move_1_) {
            this.motionX = 0.0;
        }
        if (lvt_11_1_ != p_move_5_) {
            this.motionZ = 0.0;
        }
    }

    protected void resetPositionToBB() {
        AxisAlignedBB lvt_1_1_ = this.getBoundingBox();
        this.posX = (lvt_1_1_.minX + lvt_1_1_.maxX) / 2.0;
        this.posY = lvt_1_1_.minY;
        this.posZ = (lvt_1_1_.minZ + lvt_1_1_.maxZ) / 2.0;
    }

    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        BlockPos lvt_2_1_ = new BlockPos(this.posX, this.posY, this.posZ);
        if (this.world.isBlockLoaded(lvt_2_1_)) {
            return this.world.getCombinedLight(lvt_2_1_, 0);
        }
        return 0;
    }

    public boolean isAlive() {
        return !this.isExpired;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(AxisAlignedBB p_setBoundingBox_1_) {
        this.boundingBox = p_setBoundingBox_1_;
    }
}

