/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleBreaking
extends Particle {
    protected ParticleBreaking(World p_i1195_1_, double p_i1195_2_, double p_i1195_4_, double p_i1195_6_, Item p_i1195_8_) {
        this(p_i1195_1_, p_i1195_2_, p_i1195_4_, p_i1195_6_, p_i1195_8_, 0);
    }

    protected ParticleBreaking(World p_i1197_1_, double p_i1197_2_, double p_i1197_4_, double p_i1197_6_, double p_i1197_8_, double p_i1197_10_, double p_i1197_12_, Item p_i1197_14_, int p_i1197_15_) {
        this(p_i1197_1_, p_i1197_2_, p_i1197_4_, p_i1197_6_, p_i1197_14_, p_i1197_15_);
        this.motionX *= (double)0.1f;
        this.motionY *= (double)0.1f;
        this.motionZ *= (double)0.1f;
        this.motionX += p_i1197_8_;
        this.motionY += p_i1197_10_;
        this.motionZ += p_i1197_12_;
    }

    protected ParticleBreaking(World p_i1196_1_, double p_i1196_2_, double p_i1196_4_, double p_i1196_6_, Item p_i1196_8_, int p_i1196_9_) {
        super(p_i1196_1_, p_i1196_2_, p_i1196_4_, p_i1196_6_, 0.0, 0.0, 0.0);
        this.setParticleTexture(Minecraft.getMinecraft().getRenderItem().getItemModelMesher().getParticleIcon(p_i1196_8_, p_i1196_9_));
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.particleGravity = Blocks.SNOW.blockParticleGravity;
        this.particleScale /= 2.0f;
    }

    @Override
    public int getFXLayer() {
        return 1;
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_9_1_ = ((float)this.particleTextureIndexX + this.particleTextureJitterX / 4.0f) / 16.0f;
        float lvt_10_1_ = lvt_9_1_ + 0.015609375f;
        float lvt_11_1_ = ((float)this.particleTextureIndexY + this.particleTextureJitterY / 4.0f) / 16.0f;
        float lvt_12_1_ = lvt_11_1_ + 0.015609375f;
        float lvt_13_1_ = 0.1f * this.particleScale;
        if (this.particleTexture != null) {
            lvt_9_1_ = this.particleTexture.getInterpolatedU(this.particleTextureJitterX / 4.0f * 16.0f);
            lvt_10_1_ = this.particleTexture.getInterpolatedU((this.particleTextureJitterX + 1.0f) / 4.0f * 16.0f);
            lvt_11_1_ = this.particleTexture.getInterpolatedV(this.particleTextureJitterY / 4.0f * 16.0f);
            lvt_12_1_ = this.particleTexture.getInterpolatedV((this.particleTextureJitterY + 1.0f) / 4.0f * 16.0f);
        }
        float lvt_14_1_ = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)p_renderParticle_3_ - interpPosX);
        float lvt_15_1_ = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)p_renderParticle_3_ - interpPosY);
        float lvt_16_1_ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_renderParticle_3_ - interpPosZ);
        int lvt_17_1_ = this.getBrightnessForRender(p_renderParticle_3_);
        int lvt_18_1_ = lvt_17_1_ >> 16 & 0xFFFF;
        int lvt_19_1_ = lvt_17_1_ & 0xFFFF;
        p_renderParticle_1_.pos(lvt_14_1_ - p_renderParticle_4_ * lvt_13_1_ - p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ - p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ - p_renderParticle_6_ * lvt_13_1_ - p_renderParticle_8_ * lvt_13_1_).tex(lvt_9_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ - p_renderParticle_4_ * lvt_13_1_ + p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ + p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ - p_renderParticle_6_ * lvt_13_1_ + p_renderParticle_8_ * lvt_13_1_).tex(lvt_9_1_, lvt_11_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ + p_renderParticle_4_ * lvt_13_1_ + p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ + p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ + p_renderParticle_6_ * lvt_13_1_ + p_renderParticle_8_ * lvt_13_1_).tex(lvt_10_1_, lvt_11_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ + p_renderParticle_4_ * lvt_13_1_ - p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ - p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ + p_renderParticle_6_ * lvt_13_1_ - p_renderParticle_8_ * lvt_13_1_).tex(lvt_10_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
    }

    @SideOnly(value=Side.CLIENT)
    public static class SnowballFactory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleBreaking(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, Items.SNOWBALL);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class SlimeFactory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleBreaking(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, Items.SLIME_BALL);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            int lvt_16_1_ = p_createParticle_15_.length > 1 ? p_createParticle_15_[1] : 0;
            return new ParticleBreaking(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_, Item.getItemById(p_createParticle_15_[0]), lvt_16_1_);
        }
    }
}

