/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleDigging
extends Particle {
    private final IBlockState sourceState;
    private BlockPos sourcePos;

    protected ParticleDigging(World p_i46280_1_, double p_i46280_2_, double p_i46280_4_, double p_i46280_6_, double p_i46280_8_, double p_i46280_10_, double p_i46280_12_, IBlockState p_i46280_14_) {
        super(p_i46280_1_, p_i46280_2_, p_i46280_4_, p_i46280_6_, p_i46280_8_, p_i46280_10_, p_i46280_12_);
        this.sourceState = p_i46280_14_;
        this.setParticleTexture(Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getTexture(p_i46280_14_));
        this.particleGravity = p_i46280_14_.getBlock().blockParticleGravity;
        this.particleRed = 0.6f;
        this.particleGreen = 0.6f;
        this.particleBlue = 0.6f;
        this.particleScale /= 2.0f;
    }

    public ParticleDigging setBlockPos(BlockPos p_setBlockPos_1_) {
        this.sourcePos = p_setBlockPos_1_;
        if (this.sourceState.getBlock() == Blocks.GRASS) {
            return this;
        }
        this.multiplyColor(p_setBlockPos_1_);
        return this;
    }

    public ParticleDigging init() {
        this.sourcePos = new BlockPos(this.posX, this.posY, this.posZ);
        Block lvt_1_1_ = this.sourceState.getBlock();
        if (lvt_1_1_ == Blocks.GRASS) {
            return this;
        }
        this.multiplyColor(this.sourcePos);
        return this;
    }

    protected void multiplyColor(BlockPos p_multiplyColor_1_) {
        int lvt_2_1_ = Minecraft.getMinecraft().getBlockColors().colorMultiplier(this.sourceState, this.world, p_multiplyColor_1_, 0);
        this.particleRed *= (float)(lvt_2_1_ >> 16 & 0xFF) / 255.0f;
        this.particleGreen *= (float)(lvt_2_1_ >> 8 & 0xFF) / 255.0f;
        this.particleBlue *= (float)(lvt_2_1_ & 0xFF) / 255.0f;
    }

    @Override
    public int getFXLayer() {
        return 1;
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_9_1_ = ((float)this.particleTextureIndexX + this.particleTextureJitterX / 4.0f) / 16.0f;
        float lvt_10_1_ = lvt_9_1_ + 0.015609375f;
        float lvt_11_1_ = ((float)this.particleTextureIndexY + this.particleTextureJitterY / 4.0f) / 16.0f;
        float lvt_12_1_ = lvt_11_1_ + 0.015609375f;
        float lvt_13_1_ = 0.1f * this.particleScale;
        if (this.particleTexture != null) {
            lvt_9_1_ = this.particleTexture.getInterpolatedU(this.particleTextureJitterX / 4.0f * 16.0f);
            lvt_10_1_ = this.particleTexture.getInterpolatedU((this.particleTextureJitterX + 1.0f) / 4.0f * 16.0f);
            lvt_11_1_ = this.particleTexture.getInterpolatedV(this.particleTextureJitterY / 4.0f * 16.0f);
            lvt_12_1_ = this.particleTexture.getInterpolatedV((this.particleTextureJitterY + 1.0f) / 4.0f * 16.0f);
        }
        float lvt_14_1_ = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)p_renderParticle_3_ - interpPosX);
        float lvt_15_1_ = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)p_renderParticle_3_ - interpPosY);
        float lvt_16_1_ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_renderParticle_3_ - interpPosZ);
        int lvt_17_1_ = this.getBrightnessForRender(p_renderParticle_3_);
        int lvt_18_1_ = lvt_17_1_ >> 16 & 0xFFFF;
        int lvt_19_1_ = lvt_17_1_ & 0xFFFF;
        p_renderParticle_1_.pos(lvt_14_1_ - p_renderParticle_4_ * lvt_13_1_ - p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ - p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ - p_renderParticle_6_ * lvt_13_1_ - p_renderParticle_8_ * lvt_13_1_).tex(lvt_9_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ - p_renderParticle_4_ * lvt_13_1_ + p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ + p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ - p_renderParticle_6_ * lvt_13_1_ + p_renderParticle_8_ * lvt_13_1_).tex(lvt_9_1_, lvt_11_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ + p_renderParticle_4_ * lvt_13_1_ + p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ + p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ + p_renderParticle_6_ * lvt_13_1_ + p_renderParticle_8_ * lvt_13_1_).tex(lvt_10_1_, lvt_11_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        p_renderParticle_1_.pos(lvt_14_1_ + p_renderParticle_4_ * lvt_13_1_ - p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ - p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ + p_renderParticle_6_ * lvt_13_1_ - p_renderParticle_8_ * lvt_13_1_).tex(lvt_10_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
    }

    @Override
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        int lvt_2_1_ = super.getBrightnessForRender(p_getBrightnessForRender_1_);
        int lvt_3_1_ = 0;
        if (this.world.isBlockLoaded(this.sourcePos)) {
            lvt_3_1_ = this.world.getCombinedLight(this.sourcePos, 0);
        }
        return lvt_2_1_ == 0 ? lvt_3_1_ : lvt_2_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleDigging(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_, Block.getStateById(p_createParticle_15_[0])).init();
        }
    }
}

