/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleDrip
extends Particle {
    private final Material materialType;
    private int bobTimer;

    protected ParticleDrip(World p_i1203_1_, double p_i1203_2_, double p_i1203_4_, double p_i1203_6_, Material p_i1203_8_) {
        super(p_i1203_1_, p_i1203_2_, p_i1203_4_, p_i1203_6_, 0.0, 0.0, 0.0);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        if (p_i1203_8_ == Material.WATER) {
            this.particleRed = 0.0f;
            this.particleGreen = 0.0f;
            this.particleBlue = 1.0f;
        } else {
            this.particleRed = 1.0f;
            this.particleGreen = 0.0f;
            this.particleBlue = 0.0f;
        }
        this.setParticleTextureIndex(113);
        this.setSize(0.01f, 0.01f);
        this.particleGravity = 0.06f;
        this.materialType = p_i1203_8_;
        this.bobTimer = 40;
        this.particleMaxAge = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
    }

    @Override
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        if (this.materialType == Material.WATER) {
            return super.getBrightnessForRender(p_getBrightnessForRender_1_);
        }
        return 257;
    }

    @Override
    public void onUpdate() {
        BlockPos lvt_1_1_;
        IBlockState lvt_2_1_;
        Material lvt_3_1_;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.materialType == Material.WATER) {
            this.particleRed = 0.2f;
            this.particleGreen = 0.3f;
            this.particleBlue = 1.0f;
        } else {
            this.particleRed = 1.0f;
            this.particleGreen = 16.0f / (float)(40 - this.bobTimer + 16);
            this.particleBlue = 4.0f / (float)(40 - this.bobTimer + 8);
        }
        this.motionY -= (double)this.particleGravity;
        if (this.bobTimer-- > 0) {
            this.motionX *= 0.02;
            this.motionY *= 0.02;
            this.motionZ *= 0.02;
            this.setParticleTextureIndex(113);
        } else {
            this.setParticleTextureIndex(112);
        }
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.particleMaxAge-- <= 0) {
            this.setExpired();
        }
        if (this.onGround) {
            if (this.materialType == Material.WATER) {
                this.setExpired();
                this.world.spawnParticle(EnumParticleTypes.WATER_SPLASH, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0, new int[0]);
            } else {
                this.setParticleTextureIndex(114);
            }
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
        if ((lvt_3_1_ = (lvt_2_1_ = this.world.getBlockState(lvt_1_1_ = new BlockPos(this.posX, this.posY, this.posZ))).getMaterial()).isLiquid() || lvt_3_1_.isSolid()) {
            double lvt_6_1_;
            double lvt_4_1_ = 0.0;
            if (lvt_2_1_.getBlock() instanceof BlockLiquid) {
                lvt_4_1_ = BlockLiquid.getLiquidHeightPercent(lvt_2_1_.getValue(BlockLiquid.LEVEL));
            }
            if (this.posY < (lvt_6_1_ = (double)(MathHelper.floor(this.posY) + 1) - lvt_4_1_)) {
                this.setExpired();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LavaFactory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleDrip(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, Material.LAVA);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class WaterFactory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleDrip(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, Material.WATER);
        }
    }
}

