/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleEmitter
extends Particle {
    private final Entity attachedEntity;
    private int age;
    private final int lifetime;
    private final EnumParticleTypes particleTypes;

    public ParticleEmitter(World p_i46279_1_, Entity p_i46279_2_, EnumParticleTypes p_i46279_3_) {
        this(p_i46279_1_, p_i46279_2_, p_i46279_3_, 3);
    }

    public ParticleEmitter(World p_i47219_1_, Entity p_i47219_2_, EnumParticleTypes p_i47219_3_, int p_i47219_4_) {
        super(p_i47219_1_, p_i47219_2_.posX, p_i47219_2_.getEntityBoundingBox().minY + (double)(p_i47219_2_.height / 2.0f), p_i47219_2_.posZ, p_i47219_2_.motionX, p_i47219_2_.motionY, p_i47219_2_.motionZ);
        this.attachedEntity = p_i47219_2_;
        this.lifetime = p_i47219_4_;
        this.particleTypes = p_i47219_3_;
        this.onUpdate();
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
    }

    @Override
    public void onUpdate() {
        for (int lvt_1_1_ = 0; lvt_1_1_ < 16; ++lvt_1_1_) {
            double lvt_6_1_;
            double lvt_4_1_;
            double lvt_2_1_ = this.rand.nextFloat() * 2.0f - 1.0f;
            if (lvt_2_1_ * lvt_2_1_ + (lvt_4_1_ = (double)(this.rand.nextFloat() * 2.0f - 1.0f)) * lvt_4_1_ + (lvt_6_1_ = (double)(this.rand.nextFloat() * 2.0f - 1.0f)) * lvt_6_1_ > 1.0) continue;
            double lvt_8_1_ = this.attachedEntity.posX + lvt_2_1_ * (double)this.attachedEntity.width / 4.0;
            double lvt_10_1_ = this.attachedEntity.getEntityBoundingBox().minY + (double)(this.attachedEntity.height / 2.0f) + lvt_4_1_ * (double)this.attachedEntity.height / 4.0;
            double lvt_12_1_ = this.attachedEntity.posZ + lvt_6_1_ * (double)this.attachedEntity.width / 4.0;
            this.world.spawnParticle(this.particleTypes, false, lvt_8_1_, lvt_10_1_, lvt_12_1_, lvt_2_1_, lvt_4_1_ + 0.2, lvt_6_1_, new int[0]);
        }
        ++this.age;
        if (this.age >= this.lifetime) {
            this.setExpired();
        }
    }

    @Override
    public int getFXLayer() {
        return 3;
    }
}

