/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleEnchantmentTable
extends Particle {
    private final float oSize;
    private final double coordX;
    private final double coordY;
    private final double coordZ;

    protected ParticleEnchantmentTable(World p_i1204_1_, double p_i1204_2_, double p_i1204_4_, double p_i1204_6_, double p_i1204_8_, double p_i1204_10_, double p_i1204_12_) {
        super(p_i1204_1_, p_i1204_2_, p_i1204_4_, p_i1204_6_, p_i1204_8_, p_i1204_10_, p_i1204_12_);
        this.motionX = p_i1204_8_;
        this.motionY = p_i1204_10_;
        this.motionZ = p_i1204_12_;
        this.coordX = p_i1204_2_;
        this.coordY = p_i1204_4_;
        this.coordZ = p_i1204_6_;
        this.prevPosX = p_i1204_2_ + p_i1204_8_;
        this.prevPosY = p_i1204_4_ + p_i1204_10_;
        this.prevPosZ = p_i1204_6_ + p_i1204_12_;
        this.posX = this.prevPosX;
        this.posY = this.prevPosY;
        this.posZ = this.prevPosZ;
        float lvt_14_1_ = this.rand.nextFloat() * 0.6f + 0.4f;
        this.oSize = this.particleScale = this.rand.nextFloat() * 0.5f + 0.2f;
        this.particleRed = 0.9f * lvt_14_1_;
        this.particleGreen = 0.9f * lvt_14_1_;
        this.particleBlue = lvt_14_1_;
        this.particleMaxAge = (int)(Math.random() * 10.0) + 30;
        this.setParticleTextureIndex((int)(Math.random() * 26.0 + 1.0 + 224.0));
    }

    @Override
    public void move(double p_move_1_, double p_move_3_, double p_move_5_) {
        this.setBoundingBox(this.getBoundingBox().offset(p_move_1_, p_move_3_, p_move_5_));
        this.resetPositionToBB();
    }

    @Override
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        int lvt_2_1_ = super.getBrightnessForRender(p_getBrightnessForRender_1_);
        float lvt_3_1_ = (float)this.particleAge / (float)this.particleMaxAge;
        lvt_3_1_ *= lvt_3_1_;
        lvt_3_1_ *= lvt_3_1_;
        int lvt_4_1_ = lvt_2_1_ & 0xFF;
        int lvt_5_1_ = lvt_2_1_ >> 16 & 0xFF;
        if ((lvt_5_1_ += (int)(lvt_3_1_ * 15.0f * 16.0f)) > 240) {
            lvt_5_1_ = 240;
        }
        return lvt_4_1_ | lvt_5_1_ << 16;
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        float lvt_1_1_ = (float)this.particleAge / (float)this.particleMaxAge;
        lvt_1_1_ = 1.0f - lvt_1_1_;
        float lvt_2_1_ = 1.0f - lvt_1_1_;
        lvt_2_1_ *= lvt_2_1_;
        lvt_2_1_ *= lvt_2_1_;
        this.posX = this.coordX + this.motionX * (double)lvt_1_1_;
        this.posY = this.coordY + this.motionY * (double)lvt_1_1_ - (double)(lvt_2_1_ * 1.2f);
        this.posZ = this.coordZ + this.motionZ * (double)lvt_1_1_;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class EnchantmentTable
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleEnchantmentTable(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
        }
    }
}

