/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleExplosionHuge
extends Particle {
    private int timeSinceStart;
    private final int maximumTime;

    protected ParticleExplosionHuge(World p_i1214_1_, double p_i1214_2_, double p_i1214_4_, double p_i1214_6_, double p_i1214_8_, double p_i1214_10_, double p_i1214_12_) {
        super(p_i1214_1_, p_i1214_2_, p_i1214_4_, p_i1214_6_, 0.0, 0.0, 0.0);
        this.maximumTime = 8;
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
    }

    @Override
    public void onUpdate() {
        for (int lvt_1_1_ = 0; lvt_1_1_ < 6; ++lvt_1_1_) {
            double lvt_2_1_ = this.posX + (this.rand.nextDouble() - this.rand.nextDouble()) * 4.0;
            double lvt_4_1_ = this.posY + (this.rand.nextDouble() - this.rand.nextDouble()) * 4.0;
            double lvt_6_1_ = this.posZ + (this.rand.nextDouble() - this.rand.nextDouble()) * 4.0;
            this.world.spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, lvt_2_1_, lvt_4_1_, lvt_6_1_, (double)((float)this.timeSinceStart / (float)this.maximumTime), 0.0, 0.0, new int[0]);
        }
        ++this.timeSinceStart;
        if (this.timeSinceStart == this.maximumTime) {
            this.setExpired();
        }
    }

    @Override
    public int getFXLayer() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleExplosionHuge(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
        }
    }
}

