/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleFallingDust
extends Particle {
    float oSize;
    final float rotSpeed;

    protected ParticleFallingDust(World p_i47135_1_, double p_i47135_2_, double p_i47135_4_, double p_i47135_6_, float p_i47135_8_, float p_i47135_9_, float p_i47135_10_) {
        super(p_i47135_1_, p_i47135_2_, p_i47135_4_, p_i47135_6_, 0.0, 0.0, 0.0);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.particleRed = p_i47135_8_;
        this.particleGreen = p_i47135_9_;
        this.particleBlue = p_i47135_10_;
        float lvt_11_1_ = 0.9f;
        this.particleScale *= 0.75f;
        this.particleScale *= 0.9f;
        this.oSize = this.particleScale;
        this.particleMaxAge = (int)(32.0 / (Math.random() * 0.8 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * 0.9f);
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.particleAngle = (float)Math.random() * ((float)Math.PI * 2);
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_9_1_ = ((float)this.particleAge + p_renderParticle_3_) / (float)this.particleMaxAge * 32.0f;
        lvt_9_1_ = MathHelper.clamp(lvt_9_1_, 0.0f, 1.0f);
        this.particleScale = this.oSize * lvt_9_1_;
        super.renderParticle(p_renderParticle_1_, p_renderParticle_2_, p_renderParticle_3_, p_renderParticle_4_, p_renderParticle_5_, p_renderParticle_6_, p_renderParticle_7_, p_renderParticle_8_);
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        this.prevParticleAngle = this.particleAngle;
        this.particleAngle += (float)Math.PI * this.rotSpeed * 2.0f;
        if (this.onGround) {
            this.particleAngle = 0.0f;
            this.prevParticleAngle = 0.0f;
        }
        this.setParticleTextureIndex(7 - this.particleAge * 8 / this.particleMaxAge);
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionY -= (double)0.003f;
        this.motionY = Math.max(this.motionY, (double)-0.14f);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        @Nullable
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            IBlockState lvt_16_1_ = Block.getStateById(p_createParticle_15_[0]);
            if (lvt_16_1_.getBlock() != Blocks.AIR && lvt_16_1_.getRenderType() == EnumBlockRenderType.INVISIBLE) {
                return null;
            }
            int lvt_17_1_ = Minecraft.getMinecraft().getBlockColors().getColor(lvt_16_1_);
            if (lvt_16_1_.getBlock() instanceof BlockFalling) {
                lvt_17_1_ = ((BlockFalling)lvt_16_1_.getBlock()).getDustColor(lvt_16_1_);
            }
            float lvt_18_1_ = (float)(lvt_17_1_ >> 16 & 0xFF) / 255.0f;
            float lvt_19_1_ = (float)(lvt_17_1_ >> 8 & 0xFF) / 255.0f;
            float lvt_20_1_ = (float)(lvt_17_1_ & 0xFF) / 255.0f;
            return new ParticleFallingDust(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, lvt_18_1_, lvt_19_1_, lvt_20_1_);
        }
    }
}

