/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.particle.ParticleSimpleAnimated;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleFirework {

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            Spark lvt_16_1_ = new Spark(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_, Minecraft.getMinecraft().effectRenderer);
            lvt_16_1_.setAlphaF(0.99f);
            return lvt_16_1_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Overlay
    extends Particle {
        protected Overlay(World p_i46466_1_, double p_i46466_2_, double p_i46466_4_, double p_i46466_6_) {
            super(p_i46466_1_, p_i46466_2_, p_i46466_4_, p_i46466_6_);
            this.particleMaxAge = 4;
        }

        @Override
        public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
            float lvt_9_1_ = 0.25f;
            float lvt_10_1_ = 0.5f;
            float lvt_11_1_ = 0.125f;
            float lvt_12_1_ = 0.375f;
            float lvt_13_1_ = 7.1f * MathHelper.sin(((float)this.particleAge + p_renderParticle_3_ - 1.0f) * 0.25f * (float)Math.PI);
            this.setAlphaF(0.6f - ((float)this.particleAge + p_renderParticle_3_ - 1.0f) * 0.25f * 0.5f);
            float lvt_14_1_ = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)p_renderParticle_3_ - interpPosX);
            float lvt_15_1_ = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)p_renderParticle_3_ - interpPosY);
            float lvt_16_1_ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_renderParticle_3_ - interpPosZ);
            int lvt_17_1_ = this.getBrightnessForRender(p_renderParticle_3_);
            int lvt_18_1_ = lvt_17_1_ >> 16 & 0xFFFF;
            int lvt_19_1_ = lvt_17_1_ & 0xFFFF;
            p_renderParticle_1_.pos(lvt_14_1_ - p_renderParticle_4_ * lvt_13_1_ - p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ - p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ - p_renderParticle_6_ * lvt_13_1_ - p_renderParticle_8_ * lvt_13_1_).tex(0.5, 0.375).color(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
            p_renderParticle_1_.pos(lvt_14_1_ - p_renderParticle_4_ * lvt_13_1_ + p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ + p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ - p_renderParticle_6_ * lvt_13_1_ + p_renderParticle_8_ * lvt_13_1_).tex(0.5, 0.125).color(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
            p_renderParticle_1_.pos(lvt_14_1_ + p_renderParticle_4_ * lvt_13_1_ + p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ + p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ + p_renderParticle_6_ * lvt_13_1_ + p_renderParticle_8_ * lvt_13_1_).tex(0.25, 0.125).color(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
            p_renderParticle_1_.pos(lvt_14_1_ + p_renderParticle_4_ * lvt_13_1_ - p_renderParticle_7_ * lvt_13_1_, lvt_15_1_ - p_renderParticle_5_ * lvt_13_1_, lvt_16_1_ + p_renderParticle_6_ * lvt_13_1_ - p_renderParticle_8_ * lvt_13_1_).tex(0.25, 0.375).color(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).lightmap(lvt_18_1_, lvt_19_1_).endVertex();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Spark
    extends ParticleSimpleAnimated {
        private boolean trail;
        private boolean twinkle;
        private final ParticleManager effectRenderer;
        private float fadeColourRed;
        private float fadeColourGreen;
        private float fadeColourBlue;
        private boolean hasFadeColour;

        public Spark(World p_i46465_1_, double p_i46465_2_, double p_i46465_4_, double p_i46465_6_, double p_i46465_8_, double p_i46465_10_, double p_i46465_12_, ParticleManager p_i46465_14_) {
            super(p_i46465_1_, p_i46465_2_, p_i46465_4_, p_i46465_6_, 160, 8, -0.004f);
            this.motionX = p_i46465_8_;
            this.motionY = p_i46465_10_;
            this.motionZ = p_i46465_12_;
            this.effectRenderer = p_i46465_14_;
            this.particleScale *= 0.75f;
            this.particleMaxAge = 48 + this.rand.nextInt(12);
        }

        public void setTrail(boolean p_setTrail_1_) {
            this.trail = p_setTrail_1_;
        }

        public void setTwinkle(boolean p_setTwinkle_1_) {
            this.twinkle = p_setTwinkle_1_;
        }

        @Override
        public boolean isTransparent() {
            return true;
        }

        @Override
        public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
            if (!this.twinkle || this.particleAge < this.particleMaxAge / 3 || (this.particleAge + this.particleMaxAge) / 3 % 2 == 0) {
                super.renderParticle(p_renderParticle_1_, p_renderParticle_2_, p_renderParticle_3_, p_renderParticle_4_, p_renderParticle_5_, p_renderParticle_6_, p_renderParticle_7_, p_renderParticle_8_);
            }
        }

        @Override
        public void onUpdate() {
            super.onUpdate();
            if (this.trail && this.particleAge < this.particleMaxAge / 2 && (this.particleAge + this.particleMaxAge) % 2 == 0) {
                Spark lvt_1_1_ = new Spark(this.world, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0, this.effectRenderer);
                lvt_1_1_.setAlphaF(0.99f);
                lvt_1_1_.setRBGColorF(this.particleRed, this.particleGreen, this.particleBlue);
                lvt_1_1_.particleAge = lvt_1_1_.particleMaxAge / 2;
                if (this.hasFadeColour) {
                    lvt_1_1_.hasFadeColour = true;
                    lvt_1_1_.fadeColourRed = this.fadeColourRed;
                    lvt_1_1_.fadeColourGreen = this.fadeColourGreen;
                    lvt_1_1_.fadeColourBlue = this.fadeColourBlue;
                }
                lvt_1_1_.twinkle = this.twinkle;
                this.effectRenderer.addEffect(lvt_1_1_);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Starter
    extends Particle {
        private int fireworkAge;
        private final ParticleManager theEffectRenderer;
        private NBTTagList fireworkExplosions;
        boolean twinkle;

        public Starter(World p_i46464_1_, double p_i46464_2_, double p_i46464_4_, double p_i46464_6_, double p_i46464_8_, double p_i46464_10_, double p_i46464_12_, ParticleManager p_i46464_14_, NBTTagCompound p_i46464_15_) {
            super(p_i46464_1_, p_i46464_2_, p_i46464_4_, p_i46464_6_, 0.0, 0.0, 0.0);
            this.motionX = p_i46464_8_;
            this.motionY = p_i46464_10_;
            this.motionZ = p_i46464_12_;
            this.theEffectRenderer = p_i46464_14_;
            this.particleMaxAge = 8;
            if (p_i46464_15_ != null) {
                this.fireworkExplosions = p_i46464_15_.getTagList("Explosions", 10);
                if (this.fireworkExplosions.hasNoTags()) {
                    this.fireworkExplosions = null;
                } else {
                    this.particleMaxAge = this.fireworkExplosions.tagCount() * 2 - 1;
                    for (int lvt_16_1_ = 0; lvt_16_1_ < this.fireworkExplosions.tagCount(); ++lvt_16_1_) {
                        NBTTagCompound lvt_17_1_ = this.fireworkExplosions.getCompoundTagAt(lvt_16_1_);
                        if (!lvt_17_1_.getBoolean("Flicker")) continue;
                        this.twinkle = true;
                        this.particleMaxAge += 15;
                        break;
                    }
                }
            }
        }

        @Override
        public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        }

        @Override
        public void onUpdate() {
            if (this.fireworkAge == 0 && this.fireworkExplosions != null) {
                SoundEvent lvt_3_3_;
                boolean lvt_1_1_ = this.isFarFromCamera();
                boolean lvt_2_1_ = false;
                if (this.fireworkExplosions.tagCount() >= 3) {
                    lvt_2_1_ = true;
                } else {
                    for (int lvt_3_1_ = 0; lvt_3_1_ < this.fireworkExplosions.tagCount(); ++lvt_3_1_) {
                        NBTTagCompound lvt_4_1_ = this.fireworkExplosions.getCompoundTagAt(lvt_3_1_);
                        if (lvt_4_1_.getByte("Type") != 1) continue;
                        lvt_2_1_ = true;
                        break;
                    }
                }
                if (lvt_2_1_) {
                    SoundEvent lvt_3_2_ = lvt_1_1_ ? SoundEvents.ENTITY_FIREWORK_LARGE_BLAST_FAR : SoundEvents.ENTITY_FIREWORK_LARGE_BLAST;
                } else {
                    lvt_3_3_ = lvt_1_1_ ? SoundEvents.ENTITY_FIREWORK_BLAST_FAR : SoundEvents.ENTITY_FIREWORK_BLAST;
                }
                this.world.playSound(this.posX, this.posY, this.posZ, lvt_3_3_, SoundCategory.AMBIENT, 20.0f, 0.95f + this.rand.nextFloat() * 0.1f, true);
            }
            if (this.fireworkAge % 2 == 0 && this.fireworkExplosions != null && this.fireworkAge / 2 < this.fireworkExplosions.tagCount()) {
                int lvt_1_2_ = this.fireworkAge / 2;
                NBTTagCompound lvt_2_2_ = this.fireworkExplosions.getCompoundTagAt(lvt_1_2_);
                byte lvt_3_4_ = lvt_2_2_.getByte("Type");
                boolean lvt_4_2_ = lvt_2_2_.getBoolean("Trail");
                boolean lvt_5_1_ = lvt_2_2_.getBoolean("Flicker");
                int[] lvt_6_1_ = lvt_2_2_.getIntArray("Colors");
                int[] lvt_7_1_ = lvt_2_2_.getIntArray("FadeColors");
                if (lvt_6_1_.length == 0) {
                    lvt_6_1_ = new int[]{ItemDye.DYE_COLORS[0]};
                }
                if (lvt_3_4_ == 1) {
                    this.createBall(0.5, 4, lvt_6_1_, lvt_7_1_, lvt_4_2_, lvt_5_1_);
                } else if (lvt_3_4_ == 2) {
                    this.createShaped(0.5, new double[][]{{0.0, 1.0}, {0.3455, 0.309}, {0.9511, 0.309}, {0.3795918367346939, -0.12653061224489795}, {0.6122448979591837, -0.8040816326530612}, {0.0, -0.35918367346938773}}, lvt_6_1_, lvt_7_1_, lvt_4_2_, lvt_5_1_, false);
                } else if (lvt_3_4_ == 3) {
                    this.createShaped(0.5, new double[][]{{0.0, 0.2}, {0.2, 0.2}, {0.2, 0.6}, {0.6, 0.6}, {0.6, 0.2}, {0.2, 0.2}, {0.2, 0.0}, {0.4, 0.0}, {0.4, -0.6}, {0.2, -0.6}, {0.2, -0.4}, {0.0, -0.4}}, lvt_6_1_, lvt_7_1_, lvt_4_2_, lvt_5_1_, true);
                } else if (lvt_3_4_ == 4) {
                    this.createBurst(lvt_6_1_, lvt_7_1_, lvt_4_2_, lvt_5_1_);
                } else {
                    this.createBall(0.25, 2, lvt_6_1_, lvt_7_1_, lvt_4_2_, lvt_5_1_);
                }
                int lvt_8_1_ = lvt_6_1_[0];
                float lvt_9_1_ = (float)((lvt_8_1_ & 0xFF0000) >> 16) / 255.0f;
                float lvt_10_1_ = (float)((lvt_8_1_ & 0xFF00) >> 8) / 255.0f;
                float lvt_11_1_ = (float)((lvt_8_1_ & 0xFF) >> 0) / 255.0f;
                Overlay lvt_12_1_ = new Overlay(this.world, this.posX, this.posY, this.posZ);
                lvt_12_1_.setRBGColorF(lvt_9_1_, lvt_10_1_, lvt_11_1_);
                this.theEffectRenderer.addEffect(lvt_12_1_);
            }
            ++this.fireworkAge;
            if (this.fireworkAge > this.particleMaxAge) {
                if (this.twinkle) {
                    boolean lvt_1_3_ = this.isFarFromCamera();
                    SoundEvent lvt_2_3_ = lvt_1_3_ ? SoundEvents.ENTITY_FIREWORK_TWINKLE_FAR : SoundEvents.ENTITY_FIREWORK_TWINKLE;
                    this.world.playSound(this.posX, this.posY, this.posZ, lvt_2_3_, SoundCategory.AMBIENT, 20.0f, 0.9f + this.rand.nextFloat() * 0.15f, true);
                }
                this.setExpired();
            }
        }

        private boolean isFarFromCamera() {
            Minecraft lvt_1_1_ = Minecraft.getMinecraft();
            return lvt_1_1_ == null || lvt_1_1_.getRenderViewEntity() == null || !(lvt_1_1_.getRenderViewEntity().getDistanceSq(this.posX, this.posY, this.posZ) < 256.0);
        }

        private void createParticle(double p_createParticle_1_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, int[] p_createParticle_13_, int[] p_createParticle_14_, boolean p_createParticle_15_, boolean p_createParticle_16_) {
            Spark lvt_17_1_ = new Spark(this.world, p_createParticle_1_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, this.theEffectRenderer);
            lvt_17_1_.setAlphaF(0.99f);
            lvt_17_1_.setTrail(p_createParticle_15_);
            lvt_17_1_.setTwinkle(p_createParticle_16_);
            int lvt_18_1_ = this.rand.nextInt(p_createParticle_13_.length);
            lvt_17_1_.setColor(p_createParticle_13_[lvt_18_1_]);
            if (p_createParticle_14_ != null && p_createParticle_14_.length > 0) {
                lvt_17_1_.setColorFade(p_createParticle_14_[this.rand.nextInt(p_createParticle_14_.length)]);
            }
            this.theEffectRenderer.addEffect(lvt_17_1_);
        }

        private void createBall(double p_createBall_1_, int p_createBall_3_, int[] p_createBall_4_, int[] p_createBall_5_, boolean p_createBall_6_, boolean p_createBall_7_) {
            double lvt_8_1_ = this.posX;
            double lvt_10_1_ = this.posY;
            double lvt_12_1_ = this.posZ;
            for (int lvt_14_1_ = -p_createBall_3_; lvt_14_1_ <= p_createBall_3_; ++lvt_14_1_) {
                for (int lvt_15_1_ = -p_createBall_3_; lvt_15_1_ <= p_createBall_3_; ++lvt_15_1_) {
                    for (int lvt_16_1_ = -p_createBall_3_; lvt_16_1_ <= p_createBall_3_; ++lvt_16_1_) {
                        double lvt_17_1_ = (double)lvt_15_1_ + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                        double lvt_19_1_ = (double)lvt_14_1_ + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                        double lvt_21_1_ = (double)lvt_16_1_ + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                        double lvt_23_1_ = (double)MathHelper.sqrt(lvt_17_1_ * lvt_17_1_ + lvt_19_1_ * lvt_19_1_ + lvt_21_1_ * lvt_21_1_) / p_createBall_1_ + this.rand.nextGaussian() * 0.05;
                        this.createParticle(lvt_8_1_, lvt_10_1_, lvt_12_1_, lvt_17_1_ / lvt_23_1_, lvt_19_1_ / lvt_23_1_, lvt_21_1_ / lvt_23_1_, p_createBall_4_, p_createBall_5_, p_createBall_6_, p_createBall_7_);
                        if (lvt_14_1_ == -p_createBall_3_ || lvt_14_1_ == p_createBall_3_ || lvt_15_1_ == -p_createBall_3_ || lvt_15_1_ == p_createBall_3_) continue;
                        lvt_16_1_ += p_createBall_3_ * 2 - 1;
                    }
                }
            }
        }

        private void createShaped(double p_createShaped_1_, double[][] p_createShaped_3_, int[] p_createShaped_4_, int[] p_createShaped_5_, boolean p_createShaped_6_, boolean p_createShaped_7_, boolean p_createShaped_8_) {
            double lvt_9_1_ = p_createShaped_3_[0][0];
            double lvt_11_1_ = p_createShaped_3_[0][1];
            this.createParticle(this.posX, this.posY, this.posZ, lvt_9_1_ * p_createShaped_1_, lvt_11_1_ * p_createShaped_1_, 0.0, p_createShaped_4_, p_createShaped_5_, p_createShaped_6_, p_createShaped_7_);
            float lvt_13_1_ = this.rand.nextFloat() * (float)Math.PI;
            double lvt_14_1_ = p_createShaped_8_ ? 0.034 : 0.34;
            for (int lvt_16_1_ = 0; lvt_16_1_ < 3; ++lvt_16_1_) {
                double lvt_17_1_ = (double)lvt_13_1_ + (double)((float)lvt_16_1_ * (float)Math.PI) * lvt_14_1_;
                double lvt_19_1_ = lvt_9_1_;
                double lvt_21_1_ = lvt_11_1_;
                for (int lvt_23_1_ = 1; lvt_23_1_ < p_createShaped_3_.length; ++lvt_23_1_) {
                    double lvt_24_1_ = p_createShaped_3_[lvt_23_1_][0];
                    double lvt_26_1_ = p_createShaped_3_[lvt_23_1_][1];
                    for (double lvt_28_1_ = 0.25; lvt_28_1_ <= 1.0; lvt_28_1_ += 0.25) {
                        double lvt_30_1_ = (lvt_19_1_ + (lvt_24_1_ - lvt_19_1_) * lvt_28_1_) * p_createShaped_1_;
                        double lvt_32_1_ = (lvt_21_1_ + (lvt_26_1_ - lvt_21_1_) * lvt_28_1_) * p_createShaped_1_;
                        double lvt_34_1_ = lvt_30_1_ * Math.sin(lvt_17_1_);
                        lvt_30_1_ *= Math.cos(lvt_17_1_);
                        for (double lvt_36_1_ = -1.0; lvt_36_1_ <= 1.0; lvt_36_1_ += 2.0) {
                            this.createParticle(this.posX, this.posY, this.posZ, lvt_30_1_ * lvt_36_1_, lvt_32_1_, lvt_34_1_ * lvt_36_1_, p_createShaped_4_, p_createShaped_5_, p_createShaped_6_, p_createShaped_7_);
                        }
                    }
                    lvt_19_1_ = lvt_24_1_;
                    lvt_21_1_ = lvt_26_1_;
                }
            }
        }

        private void createBurst(int[] p_createBurst_1_, int[] p_createBurst_2_, boolean p_createBurst_3_, boolean p_createBurst_4_) {
            double lvt_5_1_ = this.rand.nextGaussian() * 0.05;
            double lvt_7_1_ = this.rand.nextGaussian() * 0.05;
            for (int lvt_9_1_ = 0; lvt_9_1_ < 70; ++lvt_9_1_) {
                double lvt_10_1_ = this.motionX * 0.5 + this.rand.nextGaussian() * 0.15 + lvt_5_1_;
                double lvt_12_1_ = this.motionZ * 0.5 + this.rand.nextGaussian() * 0.15 + lvt_7_1_;
                double lvt_14_1_ = this.motionY * 0.5 + this.rand.nextDouble() * 0.5;
                this.createParticle(this.posX, this.posY, this.posZ, lvt_10_1_, lvt_14_1_, lvt_12_1_, p_createBurst_1_, p_createBurst_2_, p_createBurst_3_, p_createBurst_4_);
            }
        }

        @Override
        public int getFXLayer() {
            return 0;
        }
    }
}

