/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleFlame
extends Particle {
    private final float flameScale;

    protected ParticleFlame(World p_i1209_1_, double p_i1209_2_, double p_i1209_4_, double p_i1209_6_, double p_i1209_8_, double p_i1209_10_, double p_i1209_12_) {
        super(p_i1209_1_, p_i1209_2_, p_i1209_4_, p_i1209_6_, p_i1209_8_, p_i1209_10_, p_i1209_12_);
        this.motionX = this.motionX * (double)0.01f + p_i1209_8_;
        this.motionY = this.motionY * (double)0.01f + p_i1209_10_;
        this.motionZ = this.motionZ * (double)0.01f + p_i1209_12_;
        this.posX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.05f);
        this.posY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.05f);
        this.posZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.05f);
        this.flameScale = this.particleScale;
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.setParticleTextureIndex(48);
    }

    @Override
    public void move(double p_move_1_, double p_move_3_, double p_move_5_) {
        this.setBoundingBox(this.getBoundingBox().offset(p_move_1_, p_move_3_, p_move_5_));
        this.resetPositionToBB();
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_9_1_ = ((float)this.particleAge + p_renderParticle_3_) / (float)this.particleMaxAge;
        this.particleScale = this.flameScale * (1.0f - lvt_9_1_ * lvt_9_1_ * 0.5f);
        super.renderParticle(p_renderParticle_1_, p_renderParticle_2_, p_renderParticle_3_, p_renderParticle_4_, p_renderParticle_5_, p_renderParticle_6_, p_renderParticle_7_, p_renderParticle_8_);
    }

    @Override
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        float lvt_2_1_ = ((float)this.particleAge + p_getBrightnessForRender_1_) / (float)this.particleMaxAge;
        lvt_2_1_ = MathHelper.clamp(lvt_2_1_, 0.0f, 1.0f);
        int lvt_3_1_ = super.getBrightnessForRender(p_getBrightnessForRender_1_);
        int lvt_4_1_ = lvt_3_1_ & 0xFF;
        int lvt_5_1_ = lvt_3_1_ >> 16 & 0xFF;
        if ((lvt_4_1_ += (int)(lvt_2_1_ * 15.0f * 16.0f)) > 240) {
            lvt_4_1_ = 240;
        }
        return lvt_4_1_ | lvt_5_1_ << 16;
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.96f;
        this.motionY *= (double)0.96f;
        this.motionZ *= (double)0.96f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleFlame(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
        }
    }
}

