/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleFootStep
extends Particle {
    private static final ResourceLocation FOOTPRINT_TEXTURE = new ResourceLocation("textures/particle/footprint.png");
    private int footstepAge;
    private final int footstepMaxAge;
    private final TextureManager currentFootSteps;

    protected ParticleFootStep(TextureManager p_i1210_1_, World p_i1210_2_, double p_i1210_3_, double p_i1210_5_, double p_i1210_7_) {
        super(p_i1210_2_, p_i1210_3_, p_i1210_5_, p_i1210_7_, 0.0, 0.0, 0.0);
        this.currentFootSteps = p_i1210_1_;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.footstepMaxAge = 200;
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_10_1_;
        float lvt_9_1_ = ((float)this.footstepAge + p_renderParticle_3_) / (float)this.footstepMaxAge;
        if ((lvt_10_1_ = 2.0f - (lvt_9_1_ *= lvt_9_1_) * 2.0f) > 1.0f) {
            lvt_10_1_ = 1.0f;
        }
        lvt_10_1_ *= 0.2f;
        GlStateManager.disableLighting();
        float lvt_11_1_ = 0.125f;
        float lvt_12_1_ = (float)(this.posX - interpPosX);
        float lvt_13_1_ = (float)(this.posY - interpPosY);
        float lvt_14_1_ = (float)(this.posZ - interpPosZ);
        float lvt_15_1_ = this.world.getLightBrightness(new BlockPos(this.posX, this.posY, this.posZ));
        this.currentFootSteps.bindTexture(FOOTPRINT_TEXTURE);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        p_renderParticle_1_.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
        p_renderParticle_1_.pos(lvt_12_1_ - 0.125f, lvt_13_1_, lvt_14_1_ + 0.125f).tex(0.0, 1.0).color(lvt_15_1_, lvt_15_1_, lvt_15_1_, lvt_10_1_).endVertex();
        p_renderParticle_1_.pos(lvt_12_1_ + 0.125f, lvt_13_1_, lvt_14_1_ + 0.125f).tex(1.0, 1.0).color(lvt_15_1_, lvt_15_1_, lvt_15_1_, lvt_10_1_).endVertex();
        p_renderParticle_1_.pos(lvt_12_1_ + 0.125f, lvt_13_1_, lvt_14_1_ - 0.125f).tex(1.0, 0.0).color(lvt_15_1_, lvt_15_1_, lvt_15_1_, lvt_10_1_).endVertex();
        p_renderParticle_1_.pos(lvt_12_1_ - 0.125f, lvt_13_1_, lvt_14_1_ - 0.125f).tex(0.0, 0.0).color(lvt_15_1_, lvt_15_1_, lvt_15_1_, lvt_10_1_).endVertex();
        Tessellator.getInstance().draw();
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
    }

    @Override
    public void onUpdate() {
        ++this.footstepAge;
        if (this.footstepAge == this.footstepMaxAge) {
            this.setExpired();
        }
    }

    @Override
    public int getFXLayer() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleFootStep(Minecraft.getMinecraft().getTextureManager(), p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_);
        }
    }
}

