/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleItemPickup
extends Particle {
    private final Entity item;
    private final Entity target;
    private int age;
    private final int maxAge;
    private final float yOffset;
    private final RenderManager renderManager = Minecraft.getMinecraft().getRenderManager();

    public ParticleItemPickup(World p_i1233_1_, Entity p_i1233_2_, Entity p_i1233_3_, float p_i1233_4_) {
        super(p_i1233_1_, p_i1233_2_.posX, p_i1233_2_.posY, p_i1233_2_.posZ, p_i1233_2_.motionX, p_i1233_2_.motionY, p_i1233_2_.motionZ);
        this.item = p_i1233_2_;
        this.target = p_i1233_3_;
        this.maxAge = 3;
        this.yOffset = p_i1233_4_;
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_9_1_ = ((float)this.age + p_renderParticle_3_) / (float)this.maxAge;
        lvt_9_1_ *= lvt_9_1_;
        double lvt_10_1_ = this.item.posX;
        double lvt_12_1_ = this.item.posY;
        double lvt_14_1_ = this.item.posZ;
        double lvt_16_1_ = this.target.lastTickPosX + (this.target.posX - this.target.lastTickPosX) * (double)p_renderParticle_3_;
        double lvt_18_1_ = this.target.lastTickPosY + (this.target.posY - this.target.lastTickPosY) * (double)p_renderParticle_3_ + (double)this.yOffset;
        double lvt_20_1_ = this.target.lastTickPosZ + (this.target.posZ - this.target.lastTickPosZ) * (double)p_renderParticle_3_;
        double lvt_22_1_ = lvt_10_1_ + (lvt_16_1_ - lvt_10_1_) * (double)lvt_9_1_;
        double lvt_24_1_ = lvt_12_1_ + (lvt_18_1_ - lvt_12_1_) * (double)lvt_9_1_;
        double lvt_26_1_ = lvt_14_1_ + (lvt_20_1_ - lvt_14_1_) * (double)lvt_9_1_;
        int lvt_28_1_ = this.getBrightnessForRender(p_renderParticle_3_);
        int lvt_29_1_ = lvt_28_1_ % 65536;
        int lvt_30_1_ = lvt_28_1_ / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, lvt_29_1_, lvt_30_1_);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableLighting();
        this.renderManager.doRenderEntity(this.item, lvt_22_1_ -= interpPosX, lvt_24_1_ -= interpPosY, lvt_26_1_ -= interpPosZ, this.item.rotationYaw, p_renderParticle_3_, false);
    }

    @Override
    public void onUpdate() {
        ++this.age;
        if (this.age == this.maxAge) {
            this.setExpired();
        }
    }

    @Override
    public int getFXLayer() {
        return 3;
    }
}

