/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Barrier;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBlockDust;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.client.particle.ParticleBubble;
import net.minecraft.client.particle.ParticleCloud;
import net.minecraft.client.particle.ParticleCrit;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleDragonBreath;
import net.minecraft.client.particle.ParticleDrip;
import net.minecraft.client.particle.ParticleEmitter;
import net.minecraft.client.particle.ParticleEnchantmentTable;
import net.minecraft.client.particle.ParticleEndRod;
import net.minecraft.client.particle.ParticleExplosion;
import net.minecraft.client.particle.ParticleExplosionHuge;
import net.minecraft.client.particle.ParticleExplosionLarge;
import net.minecraft.client.particle.ParticleFallingDust;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleFootStep;
import net.minecraft.client.particle.ParticleHeart;
import net.minecraft.client.particle.ParticleLava;
import net.minecraft.client.particle.ParticleMobAppearance;
import net.minecraft.client.particle.ParticleNote;
import net.minecraft.client.particle.ParticlePortal;
import net.minecraft.client.particle.ParticleRain;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.client.particle.ParticleSmokeLarge;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.particle.ParticleSnowShovel;
import net.minecraft.client.particle.ParticleSpell;
import net.minecraft.client.particle.ParticleSpit;
import net.minecraft.client.particle.ParticleSplash;
import net.minecraft.client.particle.ParticleSuspend;
import net.minecraft.client.particle.ParticleSuspendedTown;
import net.minecraft.client.particle.ParticleSweepAttack;
import net.minecraft.client.particle.ParticleTotem;
import net.minecraft.client.particle.ParticleWaterWake;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleManager {
    private static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    protected World world;
    private final ArrayDeque<Particle>[][] fxLayers = new ArrayDeque[4][];
    private final Queue<ParticleEmitter> particleEmitters = Queues.newArrayDeque();
    private final TextureManager renderer;
    private final Random rand = new Random();
    private final Map<Integer, IParticleFactory> particleTypes = Maps.newHashMap();
    private final Queue<Particle> queueEntityFX = Queues.newArrayDeque();

    public ParticleManager(World p_i1220_1_, TextureManager p_i1220_2_) {
        this.world = p_i1220_1_;
        this.renderer = p_i1220_2_;
        for (int i = 0; i < 4; ++i) {
            this.fxLayers[i] = new ArrayDeque[2];
            for (int j = 0; j < 2; ++j) {
                this.fxLayers[i][j] = Queues.newArrayDeque();
            }
        }
        this.registerVanillaParticles();
    }

    private void registerVanillaParticles() {
        this.registerParticle(EnumParticleTypes.EXPLOSION_NORMAL.getParticleID(), new ParticleExplosion.Factory());
        this.registerParticle(EnumParticleTypes.SPIT.getParticleID(), new ParticleSpit.Factory());
        this.registerParticle(EnumParticleTypes.WATER_BUBBLE.getParticleID(), new ParticleBubble.Factory());
        this.registerParticle(EnumParticleTypes.WATER_SPLASH.getParticleID(), new ParticleSplash.Factory());
        this.registerParticle(EnumParticleTypes.WATER_WAKE.getParticleID(), new ParticleWaterWake.Factory());
        this.registerParticle(EnumParticleTypes.WATER_DROP.getParticleID(), new ParticleRain.Factory());
        this.registerParticle(EnumParticleTypes.SUSPENDED.getParticleID(), new ParticleSuspend.Factory());
        this.registerParticle(EnumParticleTypes.SUSPENDED_DEPTH.getParticleID(), new ParticleSuspendedTown.Factory());
        this.registerParticle(EnumParticleTypes.CRIT.getParticleID(), new ParticleCrit.Factory());
        this.registerParticle(EnumParticleTypes.CRIT_MAGIC.getParticleID(), new ParticleCrit.MagicFactory());
        this.registerParticle(EnumParticleTypes.SMOKE_NORMAL.getParticleID(), new ParticleSmokeNormal.Factory());
        this.registerParticle(EnumParticleTypes.SMOKE_LARGE.getParticleID(), new ParticleSmokeLarge.Factory());
        this.registerParticle(EnumParticleTypes.SPELL.getParticleID(), new ParticleSpell.Factory());
        this.registerParticle(EnumParticleTypes.SPELL_INSTANT.getParticleID(), new ParticleSpell.InstantFactory());
        this.registerParticle(EnumParticleTypes.SPELL_MOB.getParticleID(), new ParticleSpell.MobFactory());
        this.registerParticle(EnumParticleTypes.SPELL_MOB_AMBIENT.getParticleID(), new ParticleSpell.AmbientMobFactory());
        this.registerParticle(EnumParticleTypes.SPELL_WITCH.getParticleID(), new ParticleSpell.WitchFactory());
        this.registerParticle(EnumParticleTypes.DRIP_WATER.getParticleID(), new ParticleDrip.WaterFactory());
        this.registerParticle(EnumParticleTypes.DRIP_LAVA.getParticleID(), new ParticleDrip.LavaFactory());
        this.registerParticle(EnumParticleTypes.VILLAGER_ANGRY.getParticleID(), new ParticleHeart.AngryVillagerFactory());
        this.registerParticle(EnumParticleTypes.VILLAGER_HAPPY.getParticleID(), new ParticleSuspendedTown.HappyVillagerFactory());
        this.registerParticle(EnumParticleTypes.TOWN_AURA.getParticleID(), new ParticleSuspendedTown.Factory());
        this.registerParticle(EnumParticleTypes.NOTE.getParticleID(), new ParticleNote.Factory());
        this.registerParticle(EnumParticleTypes.PORTAL.getParticleID(), new ParticlePortal.Factory());
        this.registerParticle(EnumParticleTypes.ENCHANTMENT_TABLE.getParticleID(), new ParticleEnchantmentTable.EnchantmentTable());
        this.registerParticle(EnumParticleTypes.FLAME.getParticleID(), new ParticleFlame.Factory());
        this.registerParticle(EnumParticleTypes.LAVA.getParticleID(), new ParticleLava.Factory());
        this.registerParticle(EnumParticleTypes.FOOTSTEP.getParticleID(), new ParticleFootStep.Factory());
        this.registerParticle(EnumParticleTypes.CLOUD.getParticleID(), new ParticleCloud.Factory());
        this.registerParticle(EnumParticleTypes.REDSTONE.getParticleID(), new ParticleRedstone.Factory());
        this.registerParticle(EnumParticleTypes.FALLING_DUST.getParticleID(), new ParticleFallingDust.Factory());
        this.registerParticle(EnumParticleTypes.SNOWBALL.getParticleID(), new ParticleBreaking.SnowballFactory());
        this.registerParticle(EnumParticleTypes.SNOW_SHOVEL.getParticleID(), new ParticleSnowShovel.Factory());
        this.registerParticle(EnumParticleTypes.SLIME.getParticleID(), new ParticleBreaking.SlimeFactory());
        this.registerParticle(EnumParticleTypes.HEART.getParticleID(), new ParticleHeart.Factory());
        this.registerParticle(EnumParticleTypes.BARRIER.getParticleID(), new Barrier.Factory());
        this.registerParticle(EnumParticleTypes.ITEM_CRACK.getParticleID(), new ParticleBreaking.Factory());
        this.registerParticle(EnumParticleTypes.BLOCK_CRACK.getParticleID(), new ParticleDigging.Factory());
        this.registerParticle(EnumParticleTypes.BLOCK_DUST.getParticleID(), new ParticleBlockDust.Factory());
        this.registerParticle(EnumParticleTypes.EXPLOSION_HUGE.getParticleID(), new ParticleExplosionHuge.Factory());
        this.registerParticle(EnumParticleTypes.EXPLOSION_LARGE.getParticleID(), new ParticleExplosionLarge.Factory());
        this.registerParticle(EnumParticleTypes.FIREWORKS_SPARK.getParticleID(), new ParticleFirework.Factory());
        this.registerParticle(EnumParticleTypes.MOB_APPEARANCE.getParticleID(), new ParticleMobAppearance.Factory());
        this.registerParticle(EnumParticleTypes.DRAGON_BREATH.getParticleID(), new ParticleDragonBreath.Factory());
        this.registerParticle(EnumParticleTypes.END_ROD.getParticleID(), new ParticleEndRod.Factory());
        this.registerParticle(EnumParticleTypes.DAMAGE_INDICATOR.getParticleID(), new ParticleCrit.DamageIndicatorFactory());
        this.registerParticle(EnumParticleTypes.SWEEP_ATTACK.getParticleID(), new ParticleSweepAttack.Factory());
        this.registerParticle(EnumParticleTypes.TOTEM.getParticleID(), new ParticleTotem.Factory());
    }

    public void registerParticle(int p_registerParticle_1_, IParticleFactory p_registerParticle_2_) {
        this.particleTypes.put(p_registerParticle_1_, p_registerParticle_2_);
    }

    public void emitParticleAtEntity(Entity p_emitParticleAtEntity_1_, EnumParticleTypes p_emitParticleAtEntity_2_) {
        this.particleEmitters.add(new ParticleEmitter(this.world, p_emitParticleAtEntity_1_, p_emitParticleAtEntity_2_));
    }

    public void emitParticleAtEntity(Entity p_emitParticleAtEntity_1_, EnumParticleTypes p_emitParticleAtEntity_2_, int p_emitParticleAtEntity_3_) {
        this.particleEmitters.add(new ParticleEmitter(this.world, p_emitParticleAtEntity_1_, p_emitParticleAtEntity_2_, p_emitParticleAtEntity_3_));
    }

    @Nullable
    public Particle spawnEffectParticle(int p_spawnEffectParticle_1_, double p_spawnEffectParticle_2_, double p_spawnEffectParticle_4_, double p_spawnEffectParticle_6_, double p_spawnEffectParticle_8_, double p_spawnEffectParticle_10_, double p_spawnEffectParticle_12_, int ... p_spawnEffectParticle_14_) {
        Particle particle;
        IParticleFactory iparticlefactory = this.particleTypes.get(p_spawnEffectParticle_1_);
        if (iparticlefactory != null && (particle = iparticlefactory.createParticle(p_spawnEffectParticle_1_, this.world, p_spawnEffectParticle_2_, p_spawnEffectParticle_4_, p_spawnEffectParticle_6_, p_spawnEffectParticle_8_, p_spawnEffectParticle_10_, p_spawnEffectParticle_12_, p_spawnEffectParticle_14_)) != null) {
            this.addEffect(particle);
            return particle;
        }
        return null;
    }

    public void addEffect(Particle p_addEffect_1_) {
        if (p_addEffect_1_ == null) {
            return;
        }
        this.queueEntityFX.add(p_addEffect_1_);
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            this.updateEffectLayer(i);
        }
        if (!this.particleEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (ParticleEmitter particleemitter : this.particleEmitters) {
                particleemitter.onUpdate();
                if (particleemitter.isAlive()) continue;
                list.add(particleemitter);
            }
            this.particleEmitters.removeAll(list);
        }
        if (!this.queueEntityFX.isEmpty()) {
            Particle particle = this.queueEntityFX.poll();
            while (particle != null) {
                int k;
                int j = particle.getFXLayer();
                int n = k = particle.isTransparent() ? 0 : 1;
                if (this.fxLayers[j][k].size() >= 16384) {
                    this.fxLayers[j][k].removeFirst();
                }
                this.fxLayers[j][k].add(particle);
                particle = this.queueEntityFX.poll();
            }
        }
    }

    private void updateEffectLayer(int p_updateEffectLayer_1_) {
        this.world.theProfiler.startSection(p_updateEffectLayer_1_ + "");
        for (int i = 0; i < 2; ++i) {
            this.world.theProfiler.startSection(i + "");
            this.tickParticleList(this.fxLayers[p_updateEffectLayer_1_][i]);
            this.world.theProfiler.endSection();
        }
        this.world.theProfiler.endSection();
    }

    private void tickParticleList(Queue<Particle> p_tickParticleList_1_) {
        if (!p_tickParticleList_1_.isEmpty()) {
            Iterator iterator = p_tickParticleList_1_.iterator();
            while (iterator.hasNext()) {
                Particle particle = (Particle)iterator.next();
                this.tickParticle(particle);
                if (particle.isAlive()) continue;
                iterator.remove();
            }
        }
    }

    private void tickParticle(final Particle p_tickParticle_1_) {
        try {
            p_tickParticle_1_.onUpdate();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Particle being ticked");
            final int i = p_tickParticle_1_.getFXLayer();
            crashreportcategory.setDetail("Particle", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return p_tickParticle_1_.toString();
                }
            });
            crashreportcategory.setDetail("Particle Type", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return i == 0 ? "MISC_TEXTURE" : (i == 1 ? "TERRAIN_TEXTURE" : (i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i));
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    public void renderParticles(Entity p_renderParticles_1_, float p_renderParticles_2_) {
        float f = ActiveRenderInfo.getRotationX();
        float f1 = ActiveRenderInfo.getRotationZ();
        float f2 = ActiveRenderInfo.getRotationYZ();
        float f3 = ActiveRenderInfo.getRotationXY();
        float f4 = ActiveRenderInfo.getRotationXZ();
        Particle.interpPosX = p_renderParticles_1_.lastTickPosX + (p_renderParticles_1_.posX - p_renderParticles_1_.lastTickPosX) * (double)p_renderParticles_2_;
        Particle.interpPosY = p_renderParticles_1_.lastTickPosY + (p_renderParticles_1_.posY - p_renderParticles_1_.lastTickPosY) * (double)p_renderParticles_2_;
        Particle.interpPosZ = p_renderParticles_1_.lastTickPosZ + (p_renderParticles_1_.posZ - p_renderParticles_1_.lastTickPosZ) * (double)p_renderParticles_2_;
        Particle.cameraViewDir = p_renderParticles_1_.getLook(p_renderParticles_2_);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.alphaFunc(516, 0.003921569f);
        for (int i_nf = 0; i_nf < 3; ++i_nf) {
            final int i = i_nf;
            for (int j = 0; j < 2; ++j) {
                if (this.fxLayers[i][j].isEmpty()) continue;
                switch (j) {
                    case 0: {
                        GlStateManager.depthMask(false);
                        break;
                    }
                    case 1: {
                        GlStateManager.depthMask(true);
                    }
                }
                switch (i) {
                    default: {
                        this.renderer.bindTexture(PARTICLE_TEXTURES);
                        break;
                    }
                    case 1: {
                        this.renderer.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                    }
                }
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                Tessellator tessellator = Tessellator.getInstance();
                VertexBuffer vertexbuffer = tessellator.getBuffer();
                vertexbuffer.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
                for (final Particle particle : this.fxLayers[i][j]) {
                    try {
                        particle.renderParticle(vertexbuffer, p_renderParticles_1_, p_renderParticles_2_, f, f4, f1, f2, f3);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Rendering Particle");
                        CrashReportCategory crashreportcategory = crashreport.makeCategory("Particle being rendered");
                        crashreportcategory.setDetail("Particle", new ICrashReportDetail<String>(){

                            @Override
                            public String call() throws Exception {
                                return particle.toString();
                            }
                        });
                        crashreportcategory.setDetail("Particle Type", new ICrashReportDetail<String>(){

                            @Override
                            public String call() throws Exception {
                                return i == 0 ? "MISC_TEXTURE" : (i == 1 ? "TERRAIN_TEXTURE" : (i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i));
                            }
                        });
                        throw new ReportedException(crashreport);
                    }
                }
                tessellator.draw();
            }
        }
        GlStateManager.depthMask(true);
        GlStateManager.disableBlend();
        GlStateManager.alphaFunc(516, 0.1f);
    }

    public void renderLitParticles(Entity p_renderLitParticles_1_, float p_renderLitParticles_2_) {
        float f = (float)Math.PI / 180;
        float f1 = MathHelper.cos(p_renderLitParticles_1_.rotationYaw * ((float)Math.PI / 180));
        float f2 = MathHelper.sin(p_renderLitParticles_1_.rotationYaw * ((float)Math.PI / 180));
        float f3 = -f2 * MathHelper.sin(p_renderLitParticles_1_.rotationPitch * ((float)Math.PI / 180));
        float f4 = f1 * MathHelper.sin(p_renderLitParticles_1_.rotationPitch * ((float)Math.PI / 180));
        float f5 = MathHelper.cos(p_renderLitParticles_1_.rotationPitch * ((float)Math.PI / 180));
        for (int i = 0; i < 2; ++i) {
            ArrayDeque<Particle> queue = this.fxLayers[3][i];
            if (queue.isEmpty()) continue;
            Tessellator tessellator = Tessellator.getInstance();
            VertexBuffer vertexbuffer = tessellator.getBuffer();
            for (Particle particle : queue) {
                particle.renderParticle(vertexbuffer, p_renderLitParticles_1_, p_renderLitParticles_2_, f1, f5, f2, f3, f4);
            }
        }
    }

    public void clearEffects(World p_clearEffects_1_) {
        this.world = p_clearEffects_1_;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.fxLayers[i][j].clear();
            }
        }
        this.particleEmitters.clear();
    }

    public void addBlockDestroyEffects(BlockPos p_addBlockDestroyEffects_1_, IBlockState p_addBlockDestroyEffects_2_) {
        if (!p_addBlockDestroyEffects_2_.getBlock().isAir(p_addBlockDestroyEffects_2_, this.world, p_addBlockDestroyEffects_1_) && !p_addBlockDestroyEffects_2_.getBlock().addDestroyEffects(this.world, p_addBlockDestroyEffects_1_, this)) {
            p_addBlockDestroyEffects_2_ = p_addBlockDestroyEffects_2_.getActualState(this.world, p_addBlockDestroyEffects_1_);
            int i = 4;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        this.addEffect(new ParticleDigging(this.world, (double)p_addBlockDestroyEffects_1_.getX() + d0, (double)p_addBlockDestroyEffects_1_.getY() + d1, (double)p_addBlockDestroyEffects_1_.getZ() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, p_addBlockDestroyEffects_2_).setBlockPos(p_addBlockDestroyEffects_1_));
                    }
                }
            }
        }
    }

    public void addBlockHitEffects(BlockPos p_addBlockHitEffects_1_, EnumFacing p_addBlockHitEffects_2_) {
        IBlockState iblockstate = this.world.getBlockState(p_addBlockHitEffects_1_);
        if (iblockstate.getRenderType() != EnumBlockRenderType.INVISIBLE) {
            int i = p_addBlockHitEffects_1_.getX();
            int j = p_addBlockHitEffects_1_.getY();
            int k = p_addBlockHitEffects_1_.getZ();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = iblockstate.getBoundingBox(this.world, p_addBlockHitEffects_1_);
            double d0 = (double)i + this.rand.nextDouble() * (axisalignedbb.maxX - axisalignedbb.minX - (double)0.2f) + (double)0.1f + axisalignedbb.minX;
            double d1 = (double)j + this.rand.nextDouble() * (axisalignedbb.maxY - axisalignedbb.minY - (double)0.2f) + (double)0.1f + axisalignedbb.minY;
            double d2 = (double)k + this.rand.nextDouble() * (axisalignedbb.maxZ - axisalignedbb.minZ - (double)0.2f) + (double)0.1f + axisalignedbb.minZ;
            if (p_addBlockHitEffects_2_ == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.minY - (double)0.1f;
            }
            if (p_addBlockHitEffects_2_ == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.maxY + (double)0.1f;
            }
            if (p_addBlockHitEffects_2_ == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.minZ - (double)0.1f;
            }
            if (p_addBlockHitEffects_2_ == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.maxZ + (double)0.1f;
            }
            if (p_addBlockHitEffects_2_ == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.minX - (double)0.1f;
            }
            if (p_addBlockHitEffects_2_ == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.maxX + (double)0.1f;
            }
            this.addEffect(new ParticleDigging(this.world, d0, d1, d2, 0.0, 0.0, 0.0, iblockstate).setBlockPos(p_addBlockHitEffects_1_).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f));
        }
    }

    public String getStatistics() {
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 2; ++k) {
                i += this.fxLayers[j][k].size();
            }
        }
        return "" + i;
    }

    public void addBlockHitEffects(BlockPos p_addBlockHitEffects_1_, RayTraceResult p_addBlockHitEffects_2_) {
        IBlockState state = this.world.getBlockState(p_addBlockHitEffects_1_);
        if (state != null && !state.getBlock().addHitEffects(state, this.world, p_addBlockHitEffects_2_, this)) {
            this.addBlockHitEffects(p_addBlockHitEffects_1_, p_addBlockHitEffects_2_.sideHit);
        }
    }
}

