/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleMobAppearance
extends Particle {
    private EntityLivingBase entity;

    protected ParticleMobAppearance(World p_i46283_1_, double p_i46283_2_, double p_i46283_4_, double p_i46283_6_) {
        super(p_i46283_1_, p_i46283_2_, p_i46283_4_, p_i46283_6_, 0.0, 0.0, 0.0);
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.particleGravity = 0.0f;
        this.particleMaxAge = 30;
    }

    @Override
    public int getFXLayer() {
        return 3;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.entity == null) {
            EntityElderGuardian lvt_1_1_ = new EntityElderGuardian(this.world);
            lvt_1_1_.setGhost();
            this.entity = lvt_1_1_;
        }
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        if (this.entity == null) {
            return;
        }
        RenderManager lvt_9_1_ = Minecraft.getMinecraft().getRenderManager();
        lvt_9_1_.setRenderPosition(Particle.interpPosX, Particle.interpPosY, Particle.interpPosZ);
        float lvt_10_1_ = 0.42553192f;
        float lvt_11_1_ = ((float)this.particleAge + p_renderParticle_3_) / (float)this.particleMaxAge;
        GlStateManager.depthMask(true);
        GlStateManager.enableBlend();
        GlStateManager.enableDepth();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float lvt_12_1_ = 240.0f;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, 240.0f, 240.0f);
        GlStateManager.pushMatrix();
        float lvt_13_1_ = 0.05f + 0.5f * MathHelper.sin(lvt_11_1_ * (float)Math.PI);
        GlStateManager.color(1.0f, 1.0f, 1.0f, lvt_13_1_);
        GlStateManager.translate(0.0f, 1.8f, 0.0f);
        GlStateManager.rotate(180.0f - p_renderParticle_2_.rotationYaw, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate(60.0f - 150.0f * lvt_11_1_ - p_renderParticle_2_.rotationPitch, 1.0f, 0.0f, 0.0f);
        GlStateManager.translate(0.0f, -0.4f, -1.5f);
        GlStateManager.scale(0.42553192f, 0.42553192f, 0.42553192f);
        this.entity.rotationYaw = 0.0f;
        this.entity.rotationYawHead = 0.0f;
        this.entity.prevRotationYaw = 0.0f;
        this.entity.prevRotationYawHead = 0.0f;
        lvt_9_1_.doRenderEntity(this.entity, 0.0, 0.0, 0.0, 0.0f, p_renderParticle_3_, false);
        GlStateManager.popMatrix();
        GlStateManager.enableDepth();
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleMobAppearance(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_);
        }
    }
}

