/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleRain
extends Particle {
    protected ParticleRain(World p_i1235_1_, double p_i1235_2_, double p_i1235_4_, double p_i1235_6_) {
        super(p_i1235_1_, p_i1235_2_, p_i1235_4_, p_i1235_6_, 0.0, 0.0, 0.0);
        this.motionX *= (double)0.3f;
        this.motionY = Math.random() * (double)0.2f + (double)0.1f;
        this.motionZ *= (double)0.3f;
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.setParticleTextureIndex(19 + this.rand.nextInt(4));
        this.setSize(0.01f, 0.01f);
        this.particleGravity = 0.06f;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public void onUpdate() {
        BlockPos lvt_1_1_;
        IBlockState lvt_2_1_;
        Material lvt_3_1_;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)this.particleGravity;
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.particleMaxAge-- <= 0) {
            this.setExpired();
        }
        if (this.onGround) {
            if (Math.random() < 0.5) {
                this.setExpired();
            }
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
        if ((lvt_3_1_ = (lvt_2_1_ = this.world.getBlockState(lvt_1_1_ = new BlockPos(this.posX, this.posY, this.posZ))).getMaterial()).isLiquid() || lvt_3_1_.isSolid()) {
            double lvt_4_2_;
            if (lvt_2_1_.getBlock() instanceof BlockLiquid) {
                double lvt_4_1_ = 1.0f - BlockLiquid.getLiquidHeightPercent(lvt_2_1_.getValue(BlockLiquid.LEVEL));
            } else {
                lvt_4_2_ = lvt_2_1_.getBoundingBox((IBlockAccess)this.world, (BlockPos)lvt_1_1_).maxY;
            }
            double lvt_6_1_ = (double)MathHelper.floor(this.posY) + lvt_4_2_;
            if (this.posY < lvt_6_1_) {
                this.setExpired();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleRain(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_);
        }
    }
}

