/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleSimpleAnimated
extends Particle {
    private final int textureIdx;
    private final int numAgingFrames;
    private final float yAccel;
    private float baseAirFriction = 0.91f;
    private float fadeTargetRed;
    private float fadeTargetGreen;
    private float fadeTargetBlue;
    private boolean fadingColor;

    public ParticleSimpleAnimated(World p_i46578_1_, double p_i46578_2_, double p_i46578_4_, double p_i46578_6_, int p_i46578_8_, int p_i46578_9_, float p_i46578_10_) {
        super(p_i46578_1_, p_i46578_2_, p_i46578_4_, p_i46578_6_);
        this.textureIdx = p_i46578_8_;
        this.numAgingFrames = p_i46578_9_;
        this.yAccel = p_i46578_10_;
    }

    public void setColor(int p_setColor_1_) {
        float lvt_2_1_ = (float)((p_setColor_1_ & 0xFF0000) >> 16) / 255.0f;
        float lvt_3_1_ = (float)((p_setColor_1_ & 0xFF00) >> 8) / 255.0f;
        float lvt_4_1_ = (float)((p_setColor_1_ & 0xFF) >> 0) / 255.0f;
        float lvt_5_1_ = 1.0f;
        this.setRBGColorF(lvt_2_1_ * 1.0f, lvt_3_1_ * 1.0f, lvt_4_1_ * 1.0f);
    }

    public void setColorFade(int p_setColorFade_1_) {
        this.fadeTargetRed = (float)((p_setColorFade_1_ & 0xFF0000) >> 16) / 255.0f;
        this.fadeTargetGreen = (float)((p_setColorFade_1_ & 0xFF00) >> 8) / 255.0f;
        this.fadeTargetBlue = (float)((p_setColorFade_1_ & 0xFF) >> 0) / 255.0f;
        this.fadingColor = true;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        if (this.particleAge > this.particleMaxAge / 2) {
            this.setAlphaF(1.0f - ((float)this.particleAge - (float)(this.particleMaxAge / 2)) / (float)this.particleMaxAge);
            if (this.fadingColor) {
                this.particleRed += (this.fadeTargetRed - this.particleRed) * 0.2f;
                this.particleGreen += (this.fadeTargetGreen - this.particleGreen) * 0.2f;
                this.particleBlue += (this.fadeTargetBlue - this.particleBlue) * 0.2f;
            }
        }
        this.setParticleTextureIndex(this.textureIdx + (this.numAgingFrames - 1 - this.particleAge * this.numAgingFrames / this.particleMaxAge));
        this.motionY += (double)this.yAccel;
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)this.baseAirFriction;
        this.motionY *= (double)this.baseAirFriction;
        this.motionZ *= (double)this.baseAirFriction;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }

    @Override
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        return 0xF000F0;
    }

    protected void setBaseAirFriction(float p_setBaseAirFriction_1_) {
        this.baseAirFriction = p_setBaseAirFriction_1_;
    }
}

