/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleSmokeNormal
extends Particle {
    float smokeParticleScale;

    private ParticleSmokeNormal(World p_i46347_1_, double p_i46347_2_, double p_i46347_4_, double p_i46347_6_, double p_i46347_8_, double p_i46347_10_, double p_i46347_12_) {
        this(p_i46347_1_, p_i46347_2_, p_i46347_4_, p_i46347_6_, p_i46347_8_, p_i46347_10_, p_i46347_12_, 1.0f);
    }

    protected ParticleSmokeNormal(World p_i46348_1_, double p_i46348_2_, double p_i46348_4_, double p_i46348_6_, double p_i46348_8_, double p_i46348_10_, double p_i46348_12_, float p_i46348_14_) {
        super(p_i46348_1_, p_i46348_2_, p_i46348_4_, p_i46348_6_, 0.0, 0.0, 0.0);
        float lvt_15_1_;
        this.motionX *= (double)0.1f;
        this.motionY *= (double)0.1f;
        this.motionZ *= (double)0.1f;
        this.motionX += p_i46348_8_;
        this.motionY += p_i46348_10_;
        this.motionZ += p_i46348_12_;
        this.particleRed = lvt_15_1_ = (float)(Math.random() * (double)0.3f);
        this.particleGreen = lvt_15_1_;
        this.particleBlue = lvt_15_1_;
        this.particleScale *= 0.75f;
        this.particleScale *= p_i46348_14_;
        this.smokeParticleScale = this.particleScale;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * p_i46348_14_);
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        float lvt_9_1_ = ((float)this.particleAge + p_renderParticle_3_) / (float)this.particleMaxAge * 32.0f;
        lvt_9_1_ = MathHelper.clamp(lvt_9_1_, 0.0f, 1.0f);
        this.particleScale = this.smokeParticleScale * lvt_9_1_;
        super.renderParticle(p_renderParticle_1_, p_renderParticle_2_, p_renderParticle_3_, p_renderParticle_4_, p_renderParticle_5_, p_renderParticle_6_, p_renderParticle_7_, p_renderParticle_8_);
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        this.setParticleTextureIndex(7 - this.particleAge * 8 / this.particleMaxAge);
        this.motionY += 0.004;
        this.move(this.motionX, this.motionY, this.motionZ);
        if (this.posY == this.prevPosY) {
            this.motionX *= 1.1;
            this.motionZ *= 1.1;
        }
        this.motionX *= (double)0.96f;
        this.motionY *= (double)0.96f;
        this.motionZ *= (double)0.96f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleSmokeNormal(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
        }
    }
}

