/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.Random;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleSpell
extends Particle {
    private static final Random RANDOM = new Random();
    private int baseSpellTextureIndex = 128;

    protected ParticleSpell(World p_i1229_1_, double p_i1229_2_, double p_i1229_4_, double p_i1229_6_, double p_i1229_8_, double p_i1229_10_, double p_i1229_12_) {
        super(p_i1229_1_, p_i1229_2_, p_i1229_4_, p_i1229_6_, 0.5 - RANDOM.nextDouble(), p_i1229_10_, 0.5 - RANDOM.nextDouble());
        this.motionY *= (double)0.2f;
        if (p_i1229_8_ == 0.0 && p_i1229_12_ == 0.0) {
            this.motionX *= (double)0.1f;
            this.motionZ *= (double)0.1f;
        }
        this.particleScale *= 0.75f;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        this.setParticleTextureIndex(this.baseSpellTextureIndex + (7 - this.particleAge * 8 / this.particleMaxAge));
        this.motionY += 0.004;
        this.move(this.motionX, this.motionY, this.motionZ);
        if (this.posY == this.prevPosY) {
            this.motionX *= 1.1;
            this.motionZ *= 1.1;
        }
        this.motionX *= (double)0.96f;
        this.motionY *= (double)0.96f;
        this.motionZ *= (double)0.96f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }

    public void setBaseSpellTextureIndex(int p_setBaseSpellTextureIndex_1_) {
        this.baseSpellTextureIndex = p_setBaseSpellTextureIndex_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public static class InstantFactory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            ParticleSpell lvt_16_1_ = new ParticleSpell(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
            lvt_16_1_.setBaseSpellTextureIndex(144);
            return lvt_16_1_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class WitchFactory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            ParticleSpell lvt_16_1_ = new ParticleSpell(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
            lvt_16_1_.setBaseSpellTextureIndex(144);
            float lvt_17_1_ = p_createParticle_2_.rand.nextFloat() * 0.5f + 0.35f;
            lvt_16_1_.setRBGColorF(1.0f * lvt_17_1_, 0.0f * lvt_17_1_, 1.0f * lvt_17_1_);
            return lvt_16_1_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class AmbientMobFactory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            ParticleSpell lvt_16_1_ = new ParticleSpell(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
            lvt_16_1_.setAlphaF(0.15f);
            lvt_16_1_.setRBGColorF((float)p_createParticle_9_, (float)p_createParticle_11_, (float)p_createParticle_13_);
            return lvt_16_1_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class MobFactory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            ParticleSpell lvt_16_1_ = new ParticleSpell(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
            lvt_16_1_.setRBGColorF((float)p_createParticle_9_, (float)p_createParticle_11_, (float)p_createParticle_13_);
            return lvt_16_1_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleSpell(p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
        }
    }
}

