/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleSweepAttack
extends Particle {
    private static final ResourceLocation SWEEP_TEXTURE = new ResourceLocation("textures/entity/sweep.png");
    private static final VertexFormat VERTEX_FORMAT = new VertexFormat().addElement(DefaultVertexFormats.POSITION_3F).addElement(DefaultVertexFormats.TEX_2F).addElement(DefaultVertexFormats.COLOR_4UB).addElement(DefaultVertexFormats.TEX_2S).addElement(DefaultVertexFormats.NORMAL_3B).addElement(DefaultVertexFormats.PADDING_1B);
    private int life;
    private final int lifeTime;
    private final TextureManager textureManager;
    private final float size;

    protected ParticleSweepAttack(TextureManager p_i46582_1_, World p_i46582_2_, double p_i46582_3_, double p_i46582_5_, double p_i46582_7_, double p_i46582_9_, double p_i46582_11_, double p_i46582_13_) {
        super(p_i46582_2_, p_i46582_3_, p_i46582_5_, p_i46582_7_, 0.0, 0.0, 0.0);
        float lvt_15_1_;
        this.textureManager = p_i46582_1_;
        this.lifeTime = 4;
        this.particleRed = lvt_15_1_ = this.rand.nextFloat() * 0.6f + 0.4f;
        this.particleGreen = lvt_15_1_;
        this.particleBlue = lvt_15_1_;
        this.size = 1.0f - (float)p_i46582_9_ * 0.5f;
    }

    @Override
    public void renderParticle(VertexBuffer p_renderParticle_1_, Entity p_renderParticle_2_, float p_renderParticle_3_, float p_renderParticle_4_, float p_renderParticle_5_, float p_renderParticle_6_, float p_renderParticle_7_, float p_renderParticle_8_) {
        int lvt_9_1_ = (int)(((float)this.life + p_renderParticle_3_) * 3.0f / (float)this.lifeTime);
        if (lvt_9_1_ > 7) {
            return;
        }
        this.textureManager.bindTexture(SWEEP_TEXTURE);
        float lvt_10_1_ = (float)(lvt_9_1_ % 4) / 4.0f;
        float lvt_11_1_ = lvt_10_1_ + 0.24975f;
        float lvt_12_1_ = (float)(lvt_9_1_ / 2) / 2.0f;
        float lvt_13_1_ = lvt_12_1_ + 0.4995f;
        float lvt_14_1_ = 1.0f * this.size;
        float lvt_15_1_ = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)p_renderParticle_3_ - interpPosX);
        float lvt_16_1_ = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)p_renderParticle_3_ - interpPosY);
        float lvt_17_1_ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_renderParticle_3_ - interpPosZ);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableLighting();
        RenderHelper.disableStandardItemLighting();
        p_renderParticle_1_.begin(7, VERTEX_FORMAT);
        p_renderParticle_1_.pos(lvt_15_1_ - p_renderParticle_4_ * lvt_14_1_ - p_renderParticle_7_ * lvt_14_1_, lvt_16_1_ - p_renderParticle_5_ * lvt_14_1_ * 0.5f, lvt_17_1_ - p_renderParticle_6_ * lvt_14_1_ - p_renderParticle_8_ * lvt_14_1_).tex(lvt_11_1_, lvt_13_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(0, 240).normal(0.0f, 1.0f, 0.0f).endVertex();
        p_renderParticle_1_.pos(lvt_15_1_ - p_renderParticle_4_ * lvt_14_1_ + p_renderParticle_7_ * lvt_14_1_, lvt_16_1_ + p_renderParticle_5_ * lvt_14_1_ * 0.5f, lvt_17_1_ - p_renderParticle_6_ * lvt_14_1_ + p_renderParticle_8_ * lvt_14_1_).tex(lvt_11_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(0, 240).normal(0.0f, 1.0f, 0.0f).endVertex();
        p_renderParticle_1_.pos(lvt_15_1_ + p_renderParticle_4_ * lvt_14_1_ + p_renderParticle_7_ * lvt_14_1_, lvt_16_1_ + p_renderParticle_5_ * lvt_14_1_ * 0.5f, lvt_17_1_ + p_renderParticle_6_ * lvt_14_1_ + p_renderParticle_8_ * lvt_14_1_).tex(lvt_10_1_, lvt_12_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(0, 240).normal(0.0f, 1.0f, 0.0f).endVertex();
        p_renderParticle_1_.pos(lvt_15_1_ + p_renderParticle_4_ * lvt_14_1_ - p_renderParticle_7_ * lvt_14_1_, lvt_16_1_ - p_renderParticle_5_ * lvt_14_1_ * 0.5f, lvt_17_1_ + p_renderParticle_6_ * lvt_14_1_ - p_renderParticle_8_ * lvt_14_1_).tex(lvt_10_1_, lvt_13_1_).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(0, 240).normal(0.0f, 1.0f, 0.0f).endVertex();
        Tessellator.getInstance().draw();
        GlStateManager.enableLighting();
    }

    @Override
    public int getBrightnessForRender(float p_getBrightnessForRender_1_) {
        return 61680;
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        ++this.life;
        if (this.life == this.lifeTime) {
            this.setExpired();
        }
    }

    @Override
    public int getFXLayer() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Override
        public Particle createParticle(int p_createParticle_1_, World p_createParticle_2_, double p_createParticle_3_, double p_createParticle_5_, double p_createParticle_7_, double p_createParticle_9_, double p_createParticle_11_, double p_createParticle_13_, int ... p_createParticle_15_) {
            return new ParticleSweepAttack(Minecraft.getMinecraft().getTextureManager(), p_createParticle_2_, p_createParticle_3_, p_createParticle_5_, p_createParticle_7_, p_createParticle_9_, p_createParticle_11_, p_createParticle_13_);
        }
    }
}

