/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.GLU;

@SideOnly(value=Side.CLIENT)
public class ActiveRenderInfo {
    private static final IntBuffer VIEWPORT = GLAllocation.createDirectIntBuffer(16);
    private static final FloatBuffer MODELVIEW = GLAllocation.createDirectFloatBuffer(16);
    private static final FloatBuffer PROJECTION = GLAllocation.createDirectFloatBuffer(16);
    private static final FloatBuffer OBJECTCOORDS = GLAllocation.createDirectFloatBuffer(3);
    private static Vec3d position = new Vec3d(0.0, 0.0, 0.0);
    private static float rotationX;
    private static float rotationXZ;
    private static float rotationZ;
    private static float rotationYZ;
    private static float rotationXY;

    public static void updateRenderInfo(EntityPlayer p_updateRenderInfo_0_, boolean p_updateRenderInfo_1_) {
        GlStateManager.getFloat(2982, MODELVIEW);
        GlStateManager.getFloat(2983, PROJECTION);
        GlStateManager.glGetInteger(2978, VIEWPORT);
        float lvt_2_1_ = (VIEWPORT.get(0) + VIEWPORT.get(2)) / 2;
        float lvt_3_1_ = (VIEWPORT.get(1) + VIEWPORT.get(3)) / 2;
        GLU.gluUnProject((float)lvt_2_1_, (float)lvt_3_1_, (float)0.0f, (FloatBuffer)MODELVIEW, (FloatBuffer)PROJECTION, (IntBuffer)VIEWPORT, (FloatBuffer)OBJECTCOORDS);
        position = new Vec3d(OBJECTCOORDS.get(0), OBJECTCOORDS.get(1), OBJECTCOORDS.get(2));
        int lvt_4_1_ = p_updateRenderInfo_1_ ? 1 : 0;
        float lvt_5_1_ = p_updateRenderInfo_0_.rotationPitch;
        float lvt_6_1_ = p_updateRenderInfo_0_.rotationYaw;
        rotationX = MathHelper.cos(lvt_6_1_ * ((float)Math.PI / 180)) * (float)(1 - lvt_4_1_ * 2);
        rotationZ = MathHelper.sin(lvt_6_1_ * ((float)Math.PI / 180)) * (float)(1 - lvt_4_1_ * 2);
        rotationYZ = -rotationZ * MathHelper.sin(lvt_5_1_ * ((float)Math.PI / 180)) * (float)(1 - lvt_4_1_ * 2);
        rotationXY = rotationX * MathHelper.sin(lvt_5_1_ * ((float)Math.PI / 180)) * (float)(1 - lvt_4_1_ * 2);
        rotationXZ = MathHelper.cos(lvt_5_1_ * ((float)Math.PI / 180));
    }

    public static Vec3d projectViewFromEntity(Entity p_projectViewFromEntity_0_, double p_projectViewFromEntity_1_) {
        double lvt_3_1_ = p_projectViewFromEntity_0_.prevPosX + (p_projectViewFromEntity_0_.posX - p_projectViewFromEntity_0_.prevPosX) * p_projectViewFromEntity_1_;
        double lvt_5_1_ = p_projectViewFromEntity_0_.prevPosY + (p_projectViewFromEntity_0_.posY - p_projectViewFromEntity_0_.prevPosY) * p_projectViewFromEntity_1_;
        double lvt_7_1_ = p_projectViewFromEntity_0_.prevPosZ + (p_projectViewFromEntity_0_.posZ - p_projectViewFromEntity_0_.prevPosZ) * p_projectViewFromEntity_1_;
        double lvt_9_1_ = lvt_3_1_ + ActiveRenderInfo.position.xCoord;
        double lvt_11_1_ = lvt_5_1_ + ActiveRenderInfo.position.yCoord;
        double lvt_13_1_ = lvt_7_1_ + ActiveRenderInfo.position.zCoord;
        return new Vec3d(lvt_9_1_, lvt_11_1_, lvt_13_1_);
    }

    public static IBlockState getBlockStateAtEntityViewpoint(World p_getBlockStateAtEntityViewpoint_0_, Entity p_getBlockStateAtEntityViewpoint_1_, float p_getBlockStateAtEntityViewpoint_2_) {
        Vec3d lvt_3_1_ = ActiveRenderInfo.projectViewFromEntity(p_getBlockStateAtEntityViewpoint_1_, p_getBlockStateAtEntityViewpoint_2_);
        BlockPos lvt_4_1_ = new BlockPos(lvt_3_1_);
        IBlockState lvt_5_1_ = p_getBlockStateAtEntityViewpoint_0_.getBlockState(lvt_4_1_);
        if (lvt_5_1_.getMaterial().isLiquid()) {
            float lvt_7_1_;
            float lvt_6_1_ = 0.0f;
            if (lvt_5_1_.getBlock() instanceof BlockLiquid) {
                lvt_6_1_ = BlockLiquid.getLiquidHeightPercent(lvt_5_1_.getValue(BlockLiquid.LEVEL)) - 0.11111111f;
            }
            if (lvt_3_1_.yCoord >= (double)(lvt_7_1_ = (float)(lvt_4_1_.getY() + 1) - lvt_6_1_)) {
                lvt_5_1_ = p_getBlockStateAtEntityViewpoint_0_.getBlockState(lvt_4_1_.up());
            }
        }
        return lvt_5_1_;
    }

    public static float getRotationX() {
        return rotationX;
    }

    public static float getRotationXZ() {
        return rotationXZ;
    }

    public static float getRotationZ() {
        return rotationZ;
    }

    public static float getRotationYZ() {
        return rotationYZ;
    }

    public static float getRotationXY() {
        return rotationXY;
    }
}

