/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.LayeredColorMaskTexture;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BannerTextures {
    public static final Cache BANNER_DESIGNS = new Cache("B", new ResourceLocation("textures/entity/banner_base.png"), "textures/entity/banner/");
    public static final Cache SHIELD_DESIGNS = new Cache("S", new ResourceLocation("textures/entity/shield_base.png"), "textures/entity/shield/");
    public static final ResourceLocation SHIELD_BASE_TEXTURE = new ResourceLocation("textures/entity/shield_base_nopattern.png");
    public static final ResourceLocation BANNER_BASE_TEXTURE = new ResourceLocation("textures/entity/banner/base.png");

    @SideOnly(value=Side.CLIENT)
    static class CacheEntry {
        public long lastUseMillis;
        public ResourceLocation textureLocation;

        private CacheEntry() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Cache {
        private final Map<String, CacheEntry> cacheMap = Maps.newLinkedHashMap();
        private final ResourceLocation cacheResourceLocation;
        private final String cacheResourceBase;
        private final String cacheId;

        public Cache(String p_i46998_1_, ResourceLocation p_i46998_2_, String p_i46998_3_) {
            this.cacheId = p_i46998_1_;
            this.cacheResourceLocation = p_i46998_2_;
            this.cacheResourceBase = p_i46998_3_;
        }

        @Nullable
        public ResourceLocation getResourceLocation(String p_getResourceLocation_1_, List<BannerPattern> p_getResourceLocation_2_, List<EnumDyeColor> p_getResourceLocation_3_) {
            if (p_getResourceLocation_1_.isEmpty()) {
                return null;
            }
            p_getResourceLocation_1_ = this.cacheId + p_getResourceLocation_1_;
            CacheEntry lvt_4_1_ = this.cacheMap.get(p_getResourceLocation_1_);
            if (lvt_4_1_ == null) {
                if (this.cacheMap.size() >= 256 && !this.freeCacheSlot()) {
                    return BANNER_BASE_TEXTURE;
                }
                ArrayList lvt_5_1_ = Lists.newArrayList();
                for (BannerPattern lvt_7_1_ : p_getResourceLocation_2_) {
                    lvt_5_1_.add(this.cacheResourceBase + lvt_7_1_.getFileName() + ".png");
                }
                lvt_4_1_ = new CacheEntry();
                lvt_4_1_.textureLocation = new ResourceLocation(p_getResourceLocation_1_);
                Minecraft.getMinecraft().getTextureManager().loadTexture(lvt_4_1_.textureLocation, new LayeredColorMaskTexture(this.cacheResourceLocation, lvt_5_1_, p_getResourceLocation_3_));
                this.cacheMap.put(p_getResourceLocation_1_, lvt_4_1_);
            }
            lvt_4_1_.lastUseMillis = System.currentTimeMillis();
            return lvt_4_1_.textureLocation;
        }

        private boolean freeCacheSlot() {
            long lvt_1_1_ = System.currentTimeMillis();
            Iterator<String> lvt_3_1_ = this.cacheMap.keySet().iterator();
            while (lvt_3_1_.hasNext()) {
                String lvt_4_1_ = lvt_3_1_.next();
                CacheEntry lvt_5_1_ = this.cacheMap.get(lvt_4_1_);
                if (lvt_1_1_ - lvt_5_1_.lastUseMillis <= 5000L) continue;
                Minecraft.getMinecraft().getTextureManager().deleteTexture(lvt_5_1_.textureLocation);
                lvt_3_1_.remove();
                return true;
            }
            return this.cacheMap.size() < 256;
        }
    }
}

