/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockFluidRenderer {
    private final BlockColors blockColors;
    private final TextureAtlasSprite[] atlasSpritesLava = new TextureAtlasSprite[2];
    private final TextureAtlasSprite[] atlasSpritesWater = new TextureAtlasSprite[2];
    private TextureAtlasSprite atlasSpriteWaterOverlay;

    public BlockFluidRenderer(BlockColors p_i46576_1_) {
        this.blockColors = p_i46576_1_;
        this.initAtlasSprites();
    }

    protected void initAtlasSprites() {
        TextureMap lvt_1_1_ = Minecraft.getMinecraft().getTextureMapBlocks();
        this.atlasSpritesLava[0] = lvt_1_1_.getAtlasSprite("minecraft:blocks/lava_still");
        this.atlasSpritesLava[1] = lvt_1_1_.getAtlasSprite("minecraft:blocks/lava_flow");
        this.atlasSpritesWater[0] = lvt_1_1_.getAtlasSprite("minecraft:blocks/water_still");
        this.atlasSpritesWater[1] = lvt_1_1_.getAtlasSprite("minecraft:blocks/water_flow");
        this.atlasSpriteWaterOverlay = lvt_1_1_.getAtlasSprite("minecraft:blocks/water_overlay");
    }

    public boolean renderFluid(IBlockAccess p_renderFluid_1_, IBlockState p_renderFluid_2_, BlockPos p_renderFluid_3_, VertexBuffer p_renderFluid_4_) {
        BlockLiquid lvt_5_1_ = (BlockLiquid)p_renderFluid_2_.getBlock();
        boolean lvt_6_1_ = p_renderFluid_2_.getMaterial() == Material.LAVA;
        TextureAtlasSprite[] lvt_7_1_ = lvt_6_1_ ? this.atlasSpritesLava : this.atlasSpritesWater;
        int lvt_8_1_ = this.blockColors.colorMultiplier(p_renderFluid_2_, p_renderFluid_1_, p_renderFluid_3_, 0);
        float lvt_9_1_ = (float)(lvt_8_1_ >> 16 & 0xFF) / 255.0f;
        float lvt_10_1_ = (float)(lvt_8_1_ >> 8 & 0xFF) / 255.0f;
        float lvt_11_1_ = (float)(lvt_8_1_ & 0xFF) / 255.0f;
        boolean lvt_12_1_ = p_renderFluid_2_.shouldSideBeRendered(p_renderFluid_1_, p_renderFluid_3_, EnumFacing.UP);
        boolean lvt_13_1_ = p_renderFluid_2_.shouldSideBeRendered(p_renderFluid_1_, p_renderFluid_3_, EnumFacing.DOWN);
        boolean[] lvt_14_1_ = new boolean[]{p_renderFluid_2_.shouldSideBeRendered(p_renderFluid_1_, p_renderFluid_3_, EnumFacing.NORTH), p_renderFluid_2_.shouldSideBeRendered(p_renderFluid_1_, p_renderFluid_3_, EnumFacing.SOUTH), p_renderFluid_2_.shouldSideBeRendered(p_renderFluid_1_, p_renderFluid_3_, EnumFacing.WEST), p_renderFluid_2_.shouldSideBeRendered(p_renderFluid_1_, p_renderFluid_3_, EnumFacing.EAST)};
        if (!(lvt_12_1_ || lvt_13_1_ || lvt_14_1_[0] || lvt_14_1_[1] || lvt_14_1_[2] || lvt_14_1_[3])) {
            return false;
        }
        boolean lvt_15_1_ = false;
        float lvt_16_1_ = 0.5f;
        float lvt_17_1_ = 1.0f;
        float lvt_18_1_ = 0.8f;
        float lvt_19_1_ = 0.6f;
        Material lvt_20_1_ = p_renderFluid_2_.getMaterial();
        float lvt_21_1_ = this.getFluidHeight(p_renderFluid_1_, p_renderFluid_3_, lvt_20_1_);
        float lvt_22_1_ = this.getFluidHeight(p_renderFluid_1_, p_renderFluid_3_.south(), lvt_20_1_);
        float lvt_23_1_ = this.getFluidHeight(p_renderFluid_1_, p_renderFluid_3_.east().south(), lvt_20_1_);
        float lvt_24_1_ = this.getFluidHeight(p_renderFluid_1_, p_renderFluid_3_.east(), lvt_20_1_);
        double lvt_25_1_ = p_renderFluid_3_.getX();
        double lvt_27_1_ = p_renderFluid_3_.getY();
        double lvt_29_1_ = p_renderFluid_3_.getZ();
        float lvt_31_1_ = 0.001f;
        if (lvt_12_1_) {
            float lvt_41_2_;
            float lvt_37_2_;
            float lvt_40_2_;
            float lvt_36_2_;
            float lvt_39_2_;
            float lvt_35_2_;
            float lvt_38_2_;
            float lvt_34_2_;
            lvt_15_1_ = true;
            float lvt_32_1_ = BlockLiquid.getSlopeAngle(p_renderFluid_1_, p_renderFluid_3_, lvt_20_1_, p_renderFluid_2_);
            TextureAtlasSprite lvt_33_1_ = lvt_32_1_ > -999.0f ? lvt_7_1_[1] : lvt_7_1_[0];
            lvt_21_1_ -= 0.001f;
            lvt_22_1_ -= 0.001f;
            lvt_23_1_ -= 0.001f;
            lvt_24_1_ -= 0.001f;
            if (lvt_32_1_ < -999.0f) {
                float lvt_34_1_ = lvt_33_1_.getInterpolatedU(0.0);
                float lvt_38_1_ = lvt_33_1_.getInterpolatedV(0.0);
                float lvt_35_1_ = lvt_34_1_;
                float lvt_39_1_ = lvt_33_1_.getInterpolatedV(16.0);
                float lvt_36_1_ = lvt_33_1_.getInterpolatedU(16.0);
                float lvt_40_1_ = lvt_39_1_;
                float lvt_37_1_ = lvt_36_1_;
                float lvt_41_1_ = lvt_38_1_;
            } else {
                float lvt_42_1_ = MathHelper.sin(lvt_32_1_) * 0.25f;
                float lvt_43_1_ = MathHelper.cos(lvt_32_1_) * 0.25f;
                float lvt_44_1_ = 8.0f;
                lvt_34_2_ = lvt_33_1_.getInterpolatedU(8.0f + (-lvt_43_1_ - lvt_42_1_) * 16.0f);
                lvt_38_2_ = lvt_33_1_.getInterpolatedV(8.0f + (-lvt_43_1_ + lvt_42_1_) * 16.0f);
                lvt_35_2_ = lvt_33_1_.getInterpolatedU(8.0f + (-lvt_43_1_ + lvt_42_1_) * 16.0f);
                lvt_39_2_ = lvt_33_1_.getInterpolatedV(8.0f + (lvt_43_1_ + lvt_42_1_) * 16.0f);
                lvt_36_2_ = lvt_33_1_.getInterpolatedU(8.0f + (lvt_43_1_ + lvt_42_1_) * 16.0f);
                lvt_40_2_ = lvt_33_1_.getInterpolatedV(8.0f + (lvt_43_1_ - lvt_42_1_) * 16.0f);
                lvt_37_2_ = lvt_33_1_.getInterpolatedU(8.0f + (lvt_43_1_ - lvt_42_1_) * 16.0f);
                lvt_41_2_ = lvt_33_1_.getInterpolatedV(8.0f + (-lvt_43_1_ - lvt_42_1_) * 16.0f);
            }
            int lvt_42_2_ = p_renderFluid_2_.getPackedLightmapCoords(p_renderFluid_1_, p_renderFluid_3_);
            int lvt_43_2_ = lvt_42_2_ >> 16 & 0xFFFF;
            int lvt_44_2_ = lvt_42_2_ & 0xFFFF;
            float lvt_45_1_ = 1.0f * lvt_9_1_;
            float lvt_46_1_ = 1.0f * lvt_10_1_;
            float lvt_47_1_ = 1.0f * lvt_11_1_;
            p_renderFluid_4_.pos(lvt_25_1_ + 0.0, lvt_27_1_ + (double)lvt_21_1_, lvt_29_1_ + 0.0).color(lvt_45_1_, lvt_46_1_, lvt_47_1_, 1.0f).tex(lvt_34_2_, lvt_38_2_).lightmap(lvt_43_2_, lvt_44_2_).endVertex();
            p_renderFluid_4_.pos(lvt_25_1_ + 0.0, lvt_27_1_ + (double)lvt_22_1_, lvt_29_1_ + 1.0).color(lvt_45_1_, lvt_46_1_, lvt_47_1_, 1.0f).tex(lvt_35_2_, lvt_39_2_).lightmap(lvt_43_2_, lvt_44_2_).endVertex();
            p_renderFluid_4_.pos(lvt_25_1_ + 1.0, lvt_27_1_ + (double)lvt_23_1_, lvt_29_1_ + 1.0).color(lvt_45_1_, lvt_46_1_, lvt_47_1_, 1.0f).tex(lvt_36_2_, lvt_40_2_).lightmap(lvt_43_2_, lvt_44_2_).endVertex();
            p_renderFluid_4_.pos(lvt_25_1_ + 1.0, lvt_27_1_ + (double)lvt_24_1_, lvt_29_1_ + 0.0).color(lvt_45_1_, lvt_46_1_, lvt_47_1_, 1.0f).tex(lvt_37_2_, lvt_41_2_).lightmap(lvt_43_2_, lvt_44_2_).endVertex();
            if (lvt_5_1_.shouldRenderSides(p_renderFluid_1_, p_renderFluid_3_.up())) {
                p_renderFluid_4_.pos(lvt_25_1_ + 0.0, lvt_27_1_ + (double)lvt_21_1_, lvt_29_1_ + 0.0).color(lvt_45_1_, lvt_46_1_, lvt_47_1_, 1.0f).tex(lvt_34_2_, lvt_38_2_).lightmap(lvt_43_2_, lvt_44_2_).endVertex();
                p_renderFluid_4_.pos(lvt_25_1_ + 1.0, lvt_27_1_ + (double)lvt_24_1_, lvt_29_1_ + 0.0).color(lvt_45_1_, lvt_46_1_, lvt_47_1_, 1.0f).tex(lvt_37_2_, lvt_41_2_).lightmap(lvt_43_2_, lvt_44_2_).endVertex();
                p_renderFluid_4_.pos(lvt_25_1_ + 1.0, lvt_27_1_ + (double)lvt_23_1_, lvt_29_1_ + 1.0).color(lvt_45_1_, lvt_46_1_, lvt_47_1_, 1.0f).tex(lvt_36_2_, lvt_40_2_).lightmap(lvt_43_2_, lvt_44_2_).endVertex();
                p_renderFluid_4_.pos(lvt_25_1_ + 0.0, lvt_27_1_ + (double)lvt_22_1_, lvt_29_1_ + 1.0).color(lvt_45_1_, lvt_46_1_, lvt_47_1_, 1.0f).tex(lvt_35_2_, lvt_39_2_).lightmap(lvt_43_2_, lvt_44_2_).endVertex();
            }
        }
        if (lvt_13_1_) {
            float lvt_32_2_ = lvt_7_1_[0].getMinU();
            float lvt_33_2_ = lvt_7_1_[0].getMaxU();
            float lvt_34_3_ = lvt_7_1_[0].getMinV();
            float lvt_35_3_ = lvt_7_1_[0].getMaxV();
            int lvt_36_3_ = p_renderFluid_2_.getPackedLightmapCoords(p_renderFluid_1_, p_renderFluid_3_.down());
            int lvt_37_3_ = lvt_36_3_ >> 16 & 0xFFFF;
            int lvt_38_3_ = lvt_36_3_ & 0xFFFF;
            p_renderFluid_4_.pos(lvt_25_1_, lvt_27_1_, lvt_29_1_ + 1.0).color(0.5f, 0.5f, 0.5f, 1.0f).tex(lvt_32_2_, lvt_35_3_).lightmap(lvt_37_3_, lvt_38_3_).endVertex();
            p_renderFluid_4_.pos(lvt_25_1_, lvt_27_1_, lvt_29_1_).color(0.5f, 0.5f, 0.5f, 1.0f).tex(lvt_32_2_, lvt_34_3_).lightmap(lvt_37_3_, lvt_38_3_).endVertex();
            p_renderFluid_4_.pos(lvt_25_1_ + 1.0, lvt_27_1_, lvt_29_1_).color(0.5f, 0.5f, 0.5f, 1.0f).tex(lvt_33_2_, lvt_34_3_).lightmap(lvt_37_3_, lvt_38_3_).endVertex();
            p_renderFluid_4_.pos(lvt_25_1_ + 1.0, lvt_27_1_, lvt_29_1_ + 1.0).color(0.5f, 0.5f, 0.5f, 1.0f).tex(lvt_33_2_, lvt_35_3_).lightmap(lvt_37_3_, lvt_38_3_).endVertex();
            lvt_15_1_ = true;
        }
        for (int lvt_32_3_ = 0; lvt_32_3_ < 4; ++lvt_32_3_) {
            double lvt_45_5_;
            double lvt_41_6_;
            double lvt_43_6_;
            double lvt_39_6_;
            float lvt_38_7_;
            float lvt_37_8_;
            Block lvt_37_4_;
            int lvt_33_3_ = 0;
            int lvt_34_4_ = 0;
            if (lvt_32_3_ == 0) {
                --lvt_34_4_;
            }
            if (lvt_32_3_ == 1) {
                ++lvt_34_4_;
            }
            if (lvt_32_3_ == 2) {
                --lvt_33_3_;
            }
            if (lvt_32_3_ == 3) {
                ++lvt_33_3_;
            }
            BlockPos lvt_35_4_ = p_renderFluid_3_.add(lvt_33_3_, 0, lvt_34_4_);
            TextureAtlasSprite lvt_36_4_ = lvt_7_1_[1];
            if (!(lvt_6_1_ || (lvt_37_4_ = p_renderFluid_1_.getBlockState(lvt_35_4_).getBlock()) != Blocks.GLASS && lvt_37_4_ != Blocks.STAINED_GLASS)) {
                lvt_36_4_ = this.atlasSpriteWaterOverlay;
            }
            if (!lvt_14_1_[lvt_32_3_]) continue;
            if (lvt_32_3_ == 0) {
                float lvt_37_5_ = lvt_21_1_;
                float lvt_38_4_ = lvt_24_1_;
                double lvt_39_3_ = lvt_25_1_;
                double lvt_43_3_ = lvt_25_1_ + 1.0;
                double lvt_41_3_ = lvt_29_1_ + (double)0.001f;
                double lvt_45_2_ = lvt_29_1_ + (double)0.001f;
            } else if (lvt_32_3_ == 1) {
                float lvt_37_6_ = lvt_23_1_;
                float lvt_38_5_ = lvt_22_1_;
                double lvt_39_4_ = lvt_25_1_ + 1.0;
                double lvt_43_4_ = lvt_25_1_;
                double lvt_41_4_ = lvt_29_1_ + 1.0 - (double)0.001f;
                double lvt_45_3_ = lvt_29_1_ + 1.0 - (double)0.001f;
            } else if (lvt_32_3_ == 2) {
                float lvt_37_7_ = lvt_22_1_;
                float lvt_38_6_ = lvt_21_1_;
                double lvt_39_5_ = lvt_25_1_ + (double)0.001f;
                double lvt_43_5_ = lvt_25_1_ + (double)0.001f;
                double lvt_41_5_ = lvt_29_1_ + 1.0;
                double lvt_45_4_ = lvt_29_1_;
            } else {
                lvt_37_8_ = lvt_24_1_;
                lvt_38_7_ = lvt_23_1_;
                lvt_39_6_ = lvt_25_1_ + 1.0 - (double)0.001f;
                lvt_43_6_ = lvt_25_1_ + 1.0 - (double)0.001f;
                lvt_41_6_ = lvt_29_1_;
                lvt_45_5_ = lvt_29_1_ + 1.0;
            }
            lvt_15_1_ = true;
            float lvt_47_2_ = lvt_36_4_.getInterpolatedU(0.0);
            float lvt_48_1_ = lvt_36_4_.getInterpolatedU(8.0);
            float lvt_49_1_ = lvt_36_4_.getInterpolatedV((1.0f - lvt_37_8_) * 16.0f * 0.5f);
            float lvt_50_1_ = lvt_36_4_.getInterpolatedV((1.0f - lvt_38_7_) * 16.0f * 0.5f);
            float lvt_51_1_ = lvt_36_4_.getInterpolatedV(8.0);
            int lvt_52_1_ = p_renderFluid_2_.getPackedLightmapCoords(p_renderFluid_1_, lvt_35_4_);
            int lvt_53_1_ = lvt_52_1_ >> 16 & 0xFFFF;
            int lvt_54_1_ = lvt_52_1_ & 0xFFFF;
            float lvt_55_1_ = lvt_32_3_ < 2 ? 0.8f : 0.6f;
            float lvt_56_1_ = 1.0f * lvt_55_1_ * lvt_9_1_;
            float lvt_57_1_ = 1.0f * lvt_55_1_ * lvt_10_1_;
            float lvt_58_1_ = 1.0f * lvt_55_1_ * lvt_11_1_;
            p_renderFluid_4_.pos(lvt_39_6_, lvt_27_1_ + (double)lvt_37_8_, lvt_41_6_).color(lvt_56_1_, lvt_57_1_, lvt_58_1_, 1.0f).tex(lvt_47_2_, lvt_49_1_).lightmap(lvt_53_1_, lvt_54_1_).endVertex();
            p_renderFluid_4_.pos(lvt_43_6_, lvt_27_1_ + (double)lvt_38_7_, lvt_45_5_).color(lvt_56_1_, lvt_57_1_, lvt_58_1_, 1.0f).tex(lvt_48_1_, lvt_50_1_).lightmap(lvt_53_1_, lvt_54_1_).endVertex();
            p_renderFluid_4_.pos(lvt_43_6_, lvt_27_1_ + 0.0, lvt_45_5_).color(lvt_56_1_, lvt_57_1_, lvt_58_1_, 1.0f).tex(lvt_48_1_, lvt_51_1_).lightmap(lvt_53_1_, lvt_54_1_).endVertex();
            p_renderFluid_4_.pos(lvt_39_6_, lvt_27_1_ + 0.0, lvt_41_6_).color(lvt_56_1_, lvt_57_1_, lvt_58_1_, 1.0f).tex(lvt_47_2_, lvt_51_1_).lightmap(lvt_53_1_, lvt_54_1_).endVertex();
            if (lvt_36_4_ == this.atlasSpriteWaterOverlay) continue;
            p_renderFluid_4_.pos(lvt_39_6_, lvt_27_1_ + 0.0, lvt_41_6_).color(lvt_56_1_, lvt_57_1_, lvt_58_1_, 1.0f).tex(lvt_47_2_, lvt_51_1_).lightmap(lvt_53_1_, lvt_54_1_).endVertex();
            p_renderFluid_4_.pos(lvt_43_6_, lvt_27_1_ + 0.0, lvt_45_5_).color(lvt_56_1_, lvt_57_1_, lvt_58_1_, 1.0f).tex(lvt_48_1_, lvt_51_1_).lightmap(lvt_53_1_, lvt_54_1_).endVertex();
            p_renderFluid_4_.pos(lvt_43_6_, lvt_27_1_ + (double)lvt_38_7_, lvt_45_5_).color(lvt_56_1_, lvt_57_1_, lvt_58_1_, 1.0f).tex(lvt_48_1_, lvt_50_1_).lightmap(lvt_53_1_, lvt_54_1_).endVertex();
            p_renderFluid_4_.pos(lvt_39_6_, lvt_27_1_ + (double)lvt_37_8_, lvt_41_6_).color(lvt_56_1_, lvt_57_1_, lvt_58_1_, 1.0f).tex(lvt_47_2_, lvt_49_1_).lightmap(lvt_53_1_, lvt_54_1_).endVertex();
        }
        return lvt_15_1_;
    }

    private float getFluidHeight(IBlockAccess p_getFluidHeight_1_, BlockPos p_getFluidHeight_2_, Material p_getFluidHeight_3_) {
        int lvt_4_1_ = 0;
        float lvt_5_1_ = 0.0f;
        for (int lvt_6_1_ = 0; lvt_6_1_ < 4; ++lvt_6_1_) {
            BlockPos lvt_7_1_ = p_getFluidHeight_2_.add(-(lvt_6_1_ & 1), 0, -(lvt_6_1_ >> 1 & 1));
            if (p_getFluidHeight_1_.getBlockState(lvt_7_1_.up()).getMaterial() == p_getFluidHeight_3_) {
                return 1.0f;
            }
            IBlockState lvt_8_1_ = p_getFluidHeight_1_.getBlockState(lvt_7_1_);
            Material lvt_9_1_ = lvt_8_1_.getMaterial();
            if (lvt_9_1_ == p_getFluidHeight_3_) {
                int lvt_10_1_ = lvt_8_1_.getValue(BlockLiquid.LEVEL);
                if (lvt_10_1_ >= 8 || lvt_10_1_ == 0) {
                    lvt_5_1_ += BlockLiquid.getLiquidHeightPercent(lvt_10_1_) * 10.0f;
                    lvt_4_1_ += 10;
                }
                lvt_5_1_ += BlockLiquid.getLiquidHeightPercent(lvt_10_1_);
                ++lvt_4_1_;
                continue;
            }
            if (lvt_9_1_.isSolid()) continue;
            lvt_5_1_ += 1.0f;
            ++lvt_4_1_;
        }
        return 1.0f - lvt_5_1_ / (float)lvt_4_1_;
    }
}

