/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.BitSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockModelRenderer {
    private final BlockColors blockColors;

    public BlockModelRenderer(BlockColors p_i46575_1_) {
        this.blockColors = p_i46575_1_;
    }

    public boolean renderModel(IBlockAccess p_renderModel_1_, IBakedModel p_renderModel_2_, IBlockState p_renderModel_3_, BlockPos p_renderModel_4_, VertexBuffer p_renderModel_5_, boolean p_renderModel_6_) {
        return this.renderModel(p_renderModel_1_, p_renderModel_2_, p_renderModel_3_, p_renderModel_4_, p_renderModel_5_, p_renderModel_6_, MathHelper.getPositionRandom(p_renderModel_4_));
    }

    public boolean renderModel(IBlockAccess p_renderModel_1_, IBakedModel p_renderModel_2_, IBlockState p_renderModel_3_, BlockPos p_renderModel_4_, VertexBuffer p_renderModel_5_, boolean p_renderModel_6_, long p_renderModel_7_) {
        boolean flag = Minecraft.isAmbientOcclusionEnabled() && p_renderModel_3_.getLightValue() == 0 && p_renderModel_2_.isAmbientOcclusion();
        try {
            return flag ? this.renderModelSmooth(p_renderModel_1_, p_renderModel_2_, p_renderModel_3_, p_renderModel_4_, p_renderModel_5_, p_renderModel_6_, p_renderModel_7_) : this.renderModelFlat(p_renderModel_1_, p_renderModel_2_, p_renderModel_3_, p_renderModel_4_, p_renderModel_5_, p_renderModel_6_, p_renderModel_7_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block model being tesselated");
            CrashReportCategory.addBlockInfo(crashreportcategory, p_renderModel_4_, p_renderModel_3_);
            crashreportcategory.addCrashSection("Using AO", flag);
            throw new ReportedException(crashreport);
        }
    }

    public boolean renderModelSmooth(IBlockAccess p_renderModelSmooth_1_, IBakedModel p_renderModelSmooth_2_, IBlockState p_renderModelSmooth_3_, BlockPos p_renderModelSmooth_4_, VertexBuffer p_renderModelSmooth_5_, boolean p_renderModelSmooth_6_, long p_renderModelSmooth_7_) {
        boolean flag = false;
        float[] afloat = new float[EnumFacing.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
        for (EnumFacing enumfacing : EnumFacing.values()) {
            List<BakedQuad> list = p_renderModelSmooth_2_.getQuads(p_renderModelSmooth_3_, enumfacing, p_renderModelSmooth_7_);
            if (list.isEmpty() || p_renderModelSmooth_6_ && !p_renderModelSmooth_3_.shouldSideBeRendered(p_renderModelSmooth_1_, p_renderModelSmooth_4_, enumfacing)) continue;
            this.renderQuadsSmooth(p_renderModelSmooth_1_, p_renderModelSmooth_3_, p_renderModelSmooth_4_, p_renderModelSmooth_5_, list, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        List<BakedQuad> list1 = p_renderModelSmooth_2_.getQuads(p_renderModelSmooth_3_, null, p_renderModelSmooth_7_);
        if (!list1.isEmpty()) {
            this.renderQuadsSmooth(p_renderModelSmooth_1_, p_renderModelSmooth_3_, p_renderModelSmooth_4_, p_renderModelSmooth_5_, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        return flag;
    }

    public boolean renderModelFlat(IBlockAccess p_renderModelFlat_1_, IBakedModel p_renderModelFlat_2_, IBlockState p_renderModelFlat_3_, BlockPos p_renderModelFlat_4_, VertexBuffer p_renderModelFlat_5_, boolean p_renderModelFlat_6_, long p_renderModelFlat_7_) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            List<BakedQuad> list = p_renderModelFlat_2_.getQuads(p_renderModelFlat_3_, enumfacing, p_renderModelFlat_7_);
            if (list.isEmpty() || p_renderModelFlat_6_ && !p_renderModelFlat_3_.shouldSideBeRendered(p_renderModelFlat_1_, p_renderModelFlat_4_, enumfacing)) continue;
            int i = p_renderModelFlat_3_.getPackedLightmapCoords(p_renderModelFlat_1_, p_renderModelFlat_4_.offset(enumfacing));
            this.renderQuadsFlat(p_renderModelFlat_1_, p_renderModelFlat_3_, p_renderModelFlat_4_, i, false, p_renderModelFlat_5_, list, bitset);
            flag = true;
        }
        List<BakedQuad> list1 = p_renderModelFlat_2_.getQuads(p_renderModelFlat_3_, null, p_renderModelFlat_7_);
        if (!list1.isEmpty()) {
            this.renderQuadsFlat(p_renderModelFlat_1_, p_renderModelFlat_3_, p_renderModelFlat_4_, -1, true, p_renderModelFlat_5_, list1, bitset);
            flag = true;
        }
        return flag;
    }

    private void renderQuadsSmooth(IBlockAccess p_renderQuadsSmooth_1_, IBlockState p_renderQuadsSmooth_2_, BlockPos p_renderQuadsSmooth_3_, VertexBuffer p_renderQuadsSmooth_4_, List<BakedQuad> p_renderQuadsSmooth_5_, float[] p_renderQuadsSmooth_6_, BitSet p_renderQuadsSmooth_7_, AmbientOcclusionFace p_renderQuadsSmooth_8_) {
        Vec3d vec3d = p_renderQuadsSmooth_2_.getOffset(p_renderQuadsSmooth_1_, p_renderQuadsSmooth_3_);
        double d0 = (double)p_renderQuadsSmooth_3_.getX() + vec3d.xCoord;
        double d1 = (double)p_renderQuadsSmooth_3_.getY() + vec3d.yCoord;
        double d2 = (double)p_renderQuadsSmooth_3_.getZ() + vec3d.zCoord;
        int j = p_renderQuadsSmooth_5_.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = p_renderQuadsSmooth_5_.get(i);
            this.fillQuadBounds(p_renderQuadsSmooth_2_, bakedquad.getVertexData(), bakedquad.getFace(), p_renderQuadsSmooth_6_, p_renderQuadsSmooth_7_);
            p_renderQuadsSmooth_8_.updateVertexBrightness(p_renderQuadsSmooth_1_, p_renderQuadsSmooth_2_, p_renderQuadsSmooth_3_, bakedquad.getFace(), p_renderQuadsSmooth_6_, p_renderQuadsSmooth_7_);
            p_renderQuadsSmooth_4_.addVertexData(bakedquad.getVertexData());
            p_renderQuadsSmooth_4_.putBrightness4(p_renderQuadsSmooth_8_.vertexBrightness[0], p_renderQuadsSmooth_8_.vertexBrightness[1], p_renderQuadsSmooth_8_.vertexBrightness[2], p_renderQuadsSmooth_8_.vertexBrightness[3]);
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight(bakedquad.getFace());
                float[] fArray = p_renderQuadsSmooth_8_.vertexColorMultiplier;
                fArray[0] = fArray[0] * diffuse;
                float[] fArray2 = p_renderQuadsSmooth_8_.vertexColorMultiplier;
                fArray2[1] = fArray2[1] * diffuse;
                float[] fArray3 = p_renderQuadsSmooth_8_.vertexColorMultiplier;
                fArray3[2] = fArray3[2] * diffuse;
                float[] fArray4 = p_renderQuadsSmooth_8_.vertexColorMultiplier;
                fArray4[3] = fArray4[3] * diffuse;
            }
            if (bakedquad.hasTintIndex()) {
                int k = this.blockColors.colorMultiplier(p_renderQuadsSmooth_2_, p_renderQuadsSmooth_1_, p_renderQuadsSmooth_3_, bakedquad.getTintIndex());
                if (EntityRenderer.anaglyphEnable) {
                    k = TextureUtil.anaglyphColor(k);
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                p_renderQuadsSmooth_4_.putColorMultiplier(p_renderQuadsSmooth_8_.vertexColorMultiplier[0] * f, p_renderQuadsSmooth_8_.vertexColorMultiplier[0] * f1, p_renderQuadsSmooth_8_.vertexColorMultiplier[0] * f2, 4);
                p_renderQuadsSmooth_4_.putColorMultiplier(p_renderQuadsSmooth_8_.vertexColorMultiplier[1] * f, p_renderQuadsSmooth_8_.vertexColorMultiplier[1] * f1, p_renderQuadsSmooth_8_.vertexColorMultiplier[1] * f2, 3);
                p_renderQuadsSmooth_4_.putColorMultiplier(p_renderQuadsSmooth_8_.vertexColorMultiplier[2] * f, p_renderQuadsSmooth_8_.vertexColorMultiplier[2] * f1, p_renderQuadsSmooth_8_.vertexColorMultiplier[2] * f2, 2);
                p_renderQuadsSmooth_4_.putColorMultiplier(p_renderQuadsSmooth_8_.vertexColorMultiplier[3] * f, p_renderQuadsSmooth_8_.vertexColorMultiplier[3] * f1, p_renderQuadsSmooth_8_.vertexColorMultiplier[3] * f2, 1);
            } else {
                p_renderQuadsSmooth_4_.putColorMultiplier(p_renderQuadsSmooth_8_.vertexColorMultiplier[0], p_renderQuadsSmooth_8_.vertexColorMultiplier[0], p_renderQuadsSmooth_8_.vertexColorMultiplier[0], 4);
                p_renderQuadsSmooth_4_.putColorMultiplier(p_renderQuadsSmooth_8_.vertexColorMultiplier[1], p_renderQuadsSmooth_8_.vertexColorMultiplier[1], p_renderQuadsSmooth_8_.vertexColorMultiplier[1], 3);
                p_renderQuadsSmooth_4_.putColorMultiplier(p_renderQuadsSmooth_8_.vertexColorMultiplier[2], p_renderQuadsSmooth_8_.vertexColorMultiplier[2], p_renderQuadsSmooth_8_.vertexColorMultiplier[2], 2);
                p_renderQuadsSmooth_4_.putColorMultiplier(p_renderQuadsSmooth_8_.vertexColorMultiplier[3], p_renderQuadsSmooth_8_.vertexColorMultiplier[3], p_renderQuadsSmooth_8_.vertexColorMultiplier[3], 1);
            }
            p_renderQuadsSmooth_4_.putPosition(d0, d1, d2);
        }
    }

    private void fillQuadBounds(IBlockState p_fillQuadBounds_1_, int[] p_fillQuadBounds_2_, EnumFacing p_fillQuadBounds_3_, float[] p_fillQuadBounds_4_, BitSet p_fillQuadBounds_5_) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(p_fillQuadBounds_2_[i * 7]);
            float f7 = Float.intBitsToFloat(p_fillQuadBounds_2_[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(p_fillQuadBounds_2_[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (p_fillQuadBounds_4_ != null) {
            p_fillQuadBounds_4_[EnumFacing.WEST.getIndex()] = f;
            p_fillQuadBounds_4_[EnumFacing.EAST.getIndex()] = f3;
            p_fillQuadBounds_4_[EnumFacing.DOWN.getIndex()] = f1;
            p_fillQuadBounds_4_[EnumFacing.UP.getIndex()] = f4;
            p_fillQuadBounds_4_[EnumFacing.NORTH.getIndex()] = f2;
            p_fillQuadBounds_4_[EnumFacing.SOUTH.getIndex()] = f5;
            int j = EnumFacing.values().length;
            p_fillQuadBounds_4_[EnumFacing.WEST.getIndex() + j] = 1.0f - f;
            p_fillQuadBounds_4_[EnumFacing.EAST.getIndex() + j] = 1.0f - f3;
            p_fillQuadBounds_4_[EnumFacing.DOWN.getIndex() + j] = 1.0f - f1;
            p_fillQuadBounds_4_[EnumFacing.UP.getIndex() + j] = 1.0f - f4;
            p_fillQuadBounds_4_[EnumFacing.NORTH.getIndex() + j] = 1.0f - f2;
            p_fillQuadBounds_4_[EnumFacing.SOUTH.getIndex() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (p_fillQuadBounds_3_) {
            case DOWN: {
                p_fillQuadBounds_5_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_fillQuadBounds_5_.set(0, (f1 < 1.0E-4f || p_fillQuadBounds_1_.isFullCube()) && f1 == f4);
                break;
            }
            case UP: {
                p_fillQuadBounds_5_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_fillQuadBounds_5_.set(0, (f4 > 0.9999f || p_fillQuadBounds_1_.isFullCube()) && f1 == f4);
                break;
            }
            case NORTH: {
                p_fillQuadBounds_5_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_fillQuadBounds_5_.set(0, (f2 < 1.0E-4f || p_fillQuadBounds_1_.isFullCube()) && f2 == f5);
                break;
            }
            case SOUTH: {
                p_fillQuadBounds_5_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_fillQuadBounds_5_.set(0, (f5 > 0.9999f || p_fillQuadBounds_1_.isFullCube()) && f2 == f5);
                break;
            }
            case WEST: {
                p_fillQuadBounds_5_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_fillQuadBounds_5_.set(0, (f < 1.0E-4f || p_fillQuadBounds_1_.isFullCube()) && f == f3);
                break;
            }
            case EAST: {
                p_fillQuadBounds_5_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_fillQuadBounds_5_.set(0, (f3 > 0.9999f || p_fillQuadBounds_1_.isFullCube()) && f == f3);
            }
        }
    }

    private void renderQuadsFlat(IBlockAccess p_renderQuadsFlat_1_, IBlockState p_renderQuadsFlat_2_, BlockPos p_renderQuadsFlat_3_, int p_renderQuadsFlat_4_, boolean p_renderQuadsFlat_5_, VertexBuffer p_renderQuadsFlat_6_, List<BakedQuad> p_renderQuadsFlat_7_, BitSet p_renderQuadsFlat_8_) {
        Vec3d vec3d = p_renderQuadsFlat_2_.getOffset(p_renderQuadsFlat_1_, p_renderQuadsFlat_3_);
        double d0 = (double)p_renderQuadsFlat_3_.getX() + vec3d.xCoord;
        double d1 = (double)p_renderQuadsFlat_3_.getY() + vec3d.yCoord;
        double d2 = (double)p_renderQuadsFlat_3_.getZ() + vec3d.zCoord;
        int j = p_renderQuadsFlat_7_.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = p_renderQuadsFlat_7_.get(i);
            if (p_renderQuadsFlat_5_) {
                this.fillQuadBounds(p_renderQuadsFlat_2_, bakedquad.getVertexData(), bakedquad.getFace(), null, p_renderQuadsFlat_8_);
                BlockPos blockpos = p_renderQuadsFlat_8_.get(0) ? p_renderQuadsFlat_3_.offset(bakedquad.getFace()) : p_renderQuadsFlat_3_;
                p_renderQuadsFlat_4_ = p_renderQuadsFlat_2_.getPackedLightmapCoords(p_renderQuadsFlat_1_, blockpos);
            }
            p_renderQuadsFlat_6_.addVertexData(bakedquad.getVertexData());
            p_renderQuadsFlat_6_.putBrightness4(p_renderQuadsFlat_4_, p_renderQuadsFlat_4_, p_renderQuadsFlat_4_, p_renderQuadsFlat_4_);
            if (bakedquad.hasTintIndex()) {
                int k = this.blockColors.colorMultiplier(p_renderQuadsFlat_2_, p_renderQuadsFlat_1_, p_renderQuadsFlat_3_, bakedquad.getTintIndex());
                if (EntityRenderer.anaglyphEnable) {
                    k = TextureUtil.anaglyphColor(k);
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                if (bakedquad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight(bakedquad.getFace());
                    f *= diffuse;
                    f1 *= diffuse;
                    f2 *= diffuse;
                }
                p_renderQuadsFlat_6_.putColorMultiplier(f, f1, f2, 4);
                p_renderQuadsFlat_6_.putColorMultiplier(f, f1, f2, 3);
                p_renderQuadsFlat_6_.putColorMultiplier(f, f1, f2, 2);
                p_renderQuadsFlat_6_.putColorMultiplier(f, f1, f2, 1);
            } else if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight(bakedquad.getFace());
                p_renderQuadsFlat_6_.putColorMultiplier(diffuse, diffuse, diffuse, 4);
                p_renderQuadsFlat_6_.putColorMultiplier(diffuse, diffuse, diffuse, 3);
                p_renderQuadsFlat_6_.putColorMultiplier(diffuse, diffuse, diffuse, 2);
                p_renderQuadsFlat_6_.putColorMultiplier(diffuse, diffuse, diffuse, 1);
            }
            p_renderQuadsFlat_6_.putPosition(d0, d1, d2);
        }
    }

    public void renderModelBrightnessColor(IBakedModel p_renderModelBrightnessColor_1_, float p_renderModelBrightnessColor_2_, float p_renderModelBrightnessColor_3_, float p_renderModelBrightnessColor_4_, float p_renderModelBrightnessColor_5_) {
        this.renderModelBrightnessColor(null, p_renderModelBrightnessColor_1_, p_renderModelBrightnessColor_2_, p_renderModelBrightnessColor_3_, p_renderModelBrightnessColor_4_, p_renderModelBrightnessColor_5_);
    }

    public void renderModelBrightnessColor(IBlockState p_renderModelBrightnessColor_1_, IBakedModel p_renderModelBrightnessColor_2_, float p_renderModelBrightnessColor_3_, float p_renderModelBrightnessColor_4_, float p_renderModelBrightnessColor_5_, float p_renderModelBrightnessColor_6_) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderModelBrightnessColorQuads(p_renderModelBrightnessColor_3_, p_renderModelBrightnessColor_4_, p_renderModelBrightnessColor_5_, p_renderModelBrightnessColor_6_, p_renderModelBrightnessColor_2_.getQuads(p_renderModelBrightnessColor_1_, enumfacing, 0L));
        }
        this.renderModelBrightnessColorQuads(p_renderModelBrightnessColor_3_, p_renderModelBrightnessColor_4_, p_renderModelBrightnessColor_5_, p_renderModelBrightnessColor_6_, p_renderModelBrightnessColor_2_.getQuads(p_renderModelBrightnessColor_1_, null, 0L));
    }

    public void renderModelBrightness(IBakedModel p_renderModelBrightness_1_, IBlockState p_renderModelBrightness_2_, float p_renderModelBrightness_3_, boolean p_renderModelBrightness_4_) {
        Block block = p_renderModelBrightness_2_.getBlock();
        GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        int i = this.blockColors.colorMultiplier(p_renderModelBrightness_2_, null, null, 0);
        if (EntityRenderer.anaglyphEnable) {
            i = TextureUtil.anaglyphColor(i);
        }
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (!p_renderModelBrightness_4_) {
            GlStateManager.color(p_renderModelBrightness_3_, p_renderModelBrightness_3_, p_renderModelBrightness_3_, 1.0f);
        }
        this.renderModelBrightnessColor(p_renderModelBrightness_2_, p_renderModelBrightness_1_, p_renderModelBrightness_3_, f, f1, f2);
    }

    private void renderModelBrightnessColorQuads(float p_renderModelBrightnessColorQuads_1_, float p_renderModelBrightnessColorQuads_2_, float p_renderModelBrightnessColorQuads_3_, float p_renderModelBrightnessColorQuads_4_, List<BakedQuad> p_renderModelBrightnessColorQuads_5_) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        int j = p_renderModelBrightnessColorQuads_5_.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = p_renderModelBrightnessColorQuads_5_.get(i);
            vertexbuffer.begin(7, DefaultVertexFormats.ITEM);
            vertexbuffer.addVertexData(bakedquad.getVertexData());
            if (bakedquad.hasTintIndex()) {
                vertexbuffer.putColorRGB_F4(p_renderModelBrightnessColorQuads_2_ * p_renderModelBrightnessColorQuads_1_, p_renderModelBrightnessColorQuads_3_ * p_renderModelBrightnessColorQuads_1_, p_renderModelBrightnessColorQuads_4_ * p_renderModelBrightnessColorQuads_1_);
            } else {
                vertexbuffer.putColorRGB_F4(p_renderModelBrightnessColorQuads_1_, p_renderModelBrightnessColorQuads_1_, p_renderModelBrightnessColorQuads_1_);
            }
            Vec3i vec3i = bakedquad.getFace().getDirectionVec();
            vertexbuffer.putNormal(vec3i.getX(), vec3i.getY(), vec3i.getZ());
            tessellator.draw();
        }
    }

    @SideOnly(value=Side.CLIENT)
    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int vert0;
        private final int vert1;
        private final int vert2;
        private final int vert3;
        private static final VertexTranslations[] VALUES;

        private VertexTranslations(int p_i46234_3_, int p_i46234_4_, int p_i46234_5_, int p_i46234_6_) {
            this.vert0 = p_i46234_3_;
            this.vert1 = p_i46234_4_;
            this.vert2 = p_i46234_5_;
            this.vert3 = p_i46234_6_;
        }

        public static VertexTranslations getVertexTranslations(EnumFacing p_getVertexTranslations_0_) {
            return VALUES[p_getVertexTranslations_0_.getIndex()];
        }

        static {
            VALUES = new VertexTranslations[6];
            VertexTranslations.VALUES[EnumFacing.DOWN.getIndex()] = DOWN;
            VertexTranslations.VALUES[EnumFacing.UP.getIndex()] = UP;
            VertexTranslations.VALUES[EnumFacing.NORTH.getIndex()] = NORTH;
            VertexTranslations.VALUES[EnumFacing.SOUTH.getIndex()] = SOUTH;
            VertexTranslations.VALUES[EnumFacing.WEST.getIndex()] = WEST;
            VertexTranslations.VALUES[EnumFacing.EAST.getIndex()] = EAST;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum Orientation {
        DOWN(EnumFacing.DOWN, false),
        UP(EnumFacing.UP, false),
        NORTH(EnumFacing.NORTH, false),
        SOUTH(EnumFacing.SOUTH, false),
        WEST(EnumFacing.WEST, false),
        EAST(EnumFacing.EAST, false),
        FLIP_DOWN(EnumFacing.DOWN, true),
        FLIP_UP(EnumFacing.UP, true),
        FLIP_NORTH(EnumFacing.NORTH, true),
        FLIP_SOUTH(EnumFacing.SOUTH, true),
        FLIP_WEST(EnumFacing.WEST, true),
        FLIP_EAST(EnumFacing.EAST, true);

        private final int shape;

        private Orientation(EnumFacing p_i46233_3_, boolean p_i46233_4_) {
            this.shape = p_i46233_3_.getIndex() + (p_i46233_4_ ? EnumFacing.values().length : 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum EnumNeighborInfo {
        DOWN(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final EnumFacing[] corners;
        private final float shadeWeight;
        private final boolean doNonCubicWeight;
        private final Orientation[] vert0Weights;
        private final Orientation[] vert1Weights;
        private final Orientation[] vert2Weights;
        private final Orientation[] vert3Weights;
        private static final EnumNeighborInfo[] VALUES;

        private EnumNeighborInfo(EnumFacing[] p_i46236_3_, float p_i46236_4_, boolean p_i46236_5_, Orientation[] p_i46236_6_, Orientation[] p_i46236_7_, Orientation[] p_i46236_8_, Orientation[] p_i46236_9_) {
            this.corners = p_i46236_3_;
            this.shadeWeight = p_i46236_4_;
            this.doNonCubicWeight = p_i46236_5_;
            this.vert0Weights = p_i46236_6_;
            this.vert1Weights = p_i46236_7_;
            this.vert2Weights = p_i46236_8_;
            this.vert3Weights = p_i46236_9_;
        }

        public static EnumNeighborInfo getNeighbourInfo(EnumFacing p_getNeighbourInfo_0_) {
            return VALUES[p_getNeighbourInfo_0_.getIndex()];
        }

        static {
            VALUES = new EnumNeighborInfo[6];
            EnumNeighborInfo.VALUES[EnumFacing.DOWN.getIndex()] = DOWN;
            EnumNeighborInfo.VALUES[EnumFacing.UP.getIndex()] = UP;
            EnumNeighborInfo.VALUES[EnumFacing.NORTH.getIndex()] = NORTH;
            EnumNeighborInfo.VALUES[EnumFacing.SOUTH.getIndex()] = SOUTH;
            EnumNeighborInfo.VALUES[EnumFacing.WEST.getIndex()] = WEST;
            EnumNeighborInfo.VALUES[EnumFacing.EAST.getIndex()] = EAST;
        }
    }

    @SideOnly(value=Side.CLIENT)
    class AmbientOcclusionFace {
        private final float[] vertexColorMultiplier = new float[4];
        private final int[] vertexBrightness = new int[4];

        AmbientOcclusionFace() {
        }

        public void updateVertexBrightness(IBlockAccess p_updateVertexBrightness_1_, IBlockState p_updateVertexBrightness_2_, BlockPos p_updateVertexBrightness_3_, EnumFacing p_updateVertexBrightness_4_, float[] p_updateVertexBrightness_5_, BitSet p_updateVertexBrightness_6_) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            BlockPos blockpos = p_updateVertexBrightness_6_.get(0) ? p_updateVertexBrightness_3_.offset(p_updateVertexBrightness_4_) : p_updateVertexBrightness_3_;
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
            EnumNeighborInfo blockmodelrenderer$enumneighborinfo = EnumNeighborInfo.getNeighbourInfo(p_updateVertexBrightness_4_);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.retain(blockpos).move(blockmodelrenderer$enumneighborinfo.corners[0]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.retain(blockpos).move(blockmodelrenderer$enumneighborinfo.corners[1]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos3 = BlockPos.PooledMutableBlockPos.retain(blockpos).move(blockmodelrenderer$enumneighborinfo.corners[2]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos4 = BlockPos.PooledMutableBlockPos.retain(blockpos).move(blockmodelrenderer$enumneighborinfo.corners[3]);
            int i = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, blockpos$pooledmutableblockpos1);
            int j = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, blockpos$pooledmutableblockpos2);
            int k = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, blockpos$pooledmutableblockpos3);
            int l = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, blockpos$pooledmutableblockpos4);
            float f = p_updateVertexBrightness_1_.getBlockState(blockpos$pooledmutableblockpos1).getAmbientOcclusionLightValue();
            float f1 = p_updateVertexBrightness_1_.getBlockState(blockpos$pooledmutableblockpos2).getAmbientOcclusionLightValue();
            float f2 = p_updateVertexBrightness_1_.getBlockState(blockpos$pooledmutableblockpos3).getAmbientOcclusionLightValue();
            float f3 = p_updateVertexBrightness_1_.getBlockState(blockpos$pooledmutableblockpos4).getAmbientOcclusionLightValue();
            boolean flag = p_updateVertexBrightness_1_.getBlockState(blockpos$pooledmutableblockpos.setPos(blockpos$pooledmutableblockpos1).move(p_updateVertexBrightness_4_)).isTranslucent();
            boolean flag1 = p_updateVertexBrightness_1_.getBlockState(blockpos$pooledmutableblockpos.setPos(blockpos$pooledmutableblockpos2).move(p_updateVertexBrightness_4_)).isTranslucent();
            boolean flag2 = p_updateVertexBrightness_1_.getBlockState(blockpos$pooledmutableblockpos.setPos(blockpos$pooledmutableblockpos3).move(p_updateVertexBrightness_4_)).isTranslucent();
            boolean flag3 = p_updateVertexBrightness_1_.getBlockState(blockpos$pooledmutableblockpos.setPos(blockpos$pooledmutableblockpos4).move(p_updateVertexBrightness_4_)).isTranslucent();
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                BlockPos.PooledMutableBlockPos blockpos1 = blockpos$pooledmutableblockpos.setPos(blockpos$pooledmutableblockpos1).move(blockmodelrenderer$enumneighborinfo.corners[2]);
                f4 = p_updateVertexBrightness_1_.getBlockState(blockpos1).getAmbientOcclusionLightValue();
                i1 = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, blockpos1);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                BlockPos.PooledMutableBlockPos blockpos2 = blockpos$pooledmutableblockpos.setPos(blockpos$pooledmutableblockpos1).move(blockmodelrenderer$enumneighborinfo.corners[3]);
                f5 = p_updateVertexBrightness_1_.getBlockState(blockpos2).getAmbientOcclusionLightValue();
                j1 = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, blockpos2);
            }
            if (!flag2 && !flag1) {
                f6 = f1;
                k1 = j;
            } else {
                BlockPos.PooledMutableBlockPos blockpos3 = blockpos$pooledmutableblockpos.setPos(blockpos$pooledmutableblockpos2).move(blockmodelrenderer$enumneighborinfo.corners[2]);
                f6 = p_updateVertexBrightness_1_.getBlockState(blockpos3).getAmbientOcclusionLightValue();
                k1 = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, blockpos3);
            }
            if (!flag3 && !flag1) {
                f7 = f1;
                l1 = j;
            } else {
                BlockPos.PooledMutableBlockPos blockpos4 = blockpos$pooledmutableblockpos.setPos(blockpos$pooledmutableblockpos2).move(blockmodelrenderer$enumneighborinfo.corners[3]);
                f7 = p_updateVertexBrightness_1_.getBlockState(blockpos4).getAmbientOcclusionLightValue();
                l1 = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, blockpos4);
            }
            int i3 = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, p_updateVertexBrightness_3_);
            if (p_updateVertexBrightness_6_.get(0) || !p_updateVertexBrightness_1_.getBlockState(p_updateVertexBrightness_3_.offset(p_updateVertexBrightness_4_)).isOpaqueCube()) {
                i3 = p_updateVertexBrightness_2_.getPackedLightmapCoords(p_updateVertexBrightness_1_, p_updateVertexBrightness_3_.offset(p_updateVertexBrightness_4_));
            }
            float f8 = p_updateVertexBrightness_6_.get(0) ? p_updateVertexBrightness_1_.getBlockState(blockpos).getAmbientOcclusionLightValue() : p_updateVertexBrightness_1_.getBlockState(p_updateVertexBrightness_3_).getAmbientOcclusionLightValue();
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.getVertexTranslations(p_updateVertexBrightness_4_);
            blockpos$pooledmutableblockpos.release();
            blockpos$pooledmutableblockpos1.release();
            blockpos$pooledmutableblockpos2.release();
            blockpos$pooledmutableblockpos3.release();
            blockpos$pooledmutableblockpos4.release();
            if (p_updateVertexBrightness_6_.get(1) && blockmodelrenderer$enumneighborinfo.doNonCubicWeight) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f30 = (f2 + f + f4 + f8) * 0.25f;
                float f31 = (f2 + f1 + f6 + f8) * 0.25f;
                float f32 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert0Weights[0].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert0Weights[1].shape];
                float f14 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert0Weights[2].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert0Weights[3].shape];
                float f15 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert0Weights[4].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert0Weights[5].shape];
                float f16 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert0Weights[6].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert0Weights[7].shape];
                float f17 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert1Weights[0].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert1Weights[1].shape];
                float f18 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert1Weights[2].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert1Weights[3].shape];
                float f19 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert1Weights[4].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert1Weights[5].shape];
                float f20 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert1Weights[6].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert1Weights[7].shape];
                float f21 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert2Weights[0].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert2Weights[1].shape];
                float f22 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert2Weights[2].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert2Weights[3].shape];
                float f23 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert2Weights[4].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert2Weights[5].shape];
                float f24 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert2Weights[6].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert2Weights[7].shape];
                float f25 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert3Weights[0].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert3Weights[1].shape];
                float f26 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert3Weights[2].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert3Weights[3].shape];
                float f27 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert3Weights[4].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert3Weights[5].shape];
                float f28 = p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert3Weights[6].shape] * p_updateVertexBrightness_5_[blockmodelrenderer$enumneighborinfo.vert3Weights[7].shape];
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = f29 * f13 + f30 * f14 + f31 * f15 + f32 * f16;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = f29 * f17 + f30 * f18 + f31 * f19 + f32 * f20;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = f29 * f21 + f30 * f22 + f31 * f23 + f32 * f24;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = f29 * f25 + f30 * f26 + f31 * f27 + f32 * f28;
                int i2 = this.getAoBrightness(l, i, j1, i3);
                int j2 = this.getAoBrightness(k, i, i1, i3);
                int k2 = this.getAoBrightness(k, j, k1, i3);
                int l2 = this.getAoBrightness(l, j, l1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = this.getVertexBrightness(i2, j2, k2, l2, f13, f14, f15, f16);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = this.getVertexBrightness(i2, j2, k2, l2, f17, f18, f19, f20);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = this.getVertexBrightness(i2, j2, k2, l2, f21, f22, f23, f24);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = this.getVertexBrightness(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = this.getAoBrightness(l, i, j1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = this.getAoBrightness(k, i, i1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = this.getAoBrightness(k, j, k1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = this.getAoBrightness(l, j, l1, i3);
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = f9;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = f10;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = f11;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = f12;
            }
        }

        private int getAoBrightness(int p_getAoBrightness_1_, int p_getAoBrightness_2_, int p_getAoBrightness_3_, int p_getAoBrightness_4_) {
            if (p_getAoBrightness_1_ == 0) {
                p_getAoBrightness_1_ = p_getAoBrightness_4_;
            }
            if (p_getAoBrightness_2_ == 0) {
                p_getAoBrightness_2_ = p_getAoBrightness_4_;
            }
            if (p_getAoBrightness_3_ == 0) {
                p_getAoBrightness_3_ = p_getAoBrightness_4_;
            }
            return p_getAoBrightness_1_ + p_getAoBrightness_2_ + p_getAoBrightness_3_ + p_getAoBrightness_4_ >> 2 & 0xFF00FF;
        }

        private int getVertexBrightness(int p_getVertexBrightness_1_, int p_getVertexBrightness_2_, int p_getVertexBrightness_3_, int p_getVertexBrightness_4_, float p_getVertexBrightness_5_, float p_getVertexBrightness_6_, float p_getVertexBrightness_7_, float p_getVertexBrightness_8_) {
            int i = (int)((float)(p_getVertexBrightness_1_ >> 16 & 0xFF) * p_getVertexBrightness_5_ + (float)(p_getVertexBrightness_2_ >> 16 & 0xFF) * p_getVertexBrightness_6_ + (float)(p_getVertexBrightness_3_ >> 16 & 0xFF) * p_getVertexBrightness_7_ + (float)(p_getVertexBrightness_4_ >> 16 & 0xFF) * p_getVertexBrightness_8_) & 0xFF;
            int j = (int)((float)(p_getVertexBrightness_1_ & 0xFF) * p_getVertexBrightness_5_ + (float)(p_getVertexBrightness_2_ & 0xFF) * p_getVertexBrightness_6_ + (float)(p_getVertexBrightness_3_ & 0xFF) * p_getVertexBrightness_7_ + (float)(p_getVertexBrightness_4_ & 0xFF) * p_getVertexBrightness_8_) & 0xFF;
            return i << 16 | j;
        }
    }
}

