/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockRendererDispatcher
implements IResourceManagerReloadListener {
    private final BlockModelShapes blockModelShapes;
    private final BlockModelRenderer blockModelRenderer;
    private final ChestRenderer chestRenderer = new ChestRenderer();
    private final BlockFluidRenderer fluidRenderer;

    public BlockRendererDispatcher(BlockModelShapes p_i46577_1_, BlockColors p_i46577_2_) {
        this.blockModelShapes = p_i46577_1_;
        this.blockModelRenderer = new ForgeBlockModelRenderer(p_i46577_2_);
        this.fluidRenderer = new BlockFluidRenderer(p_i46577_2_);
    }

    public BlockModelShapes getBlockModelShapes() {
        return this.blockModelShapes;
    }

    public void renderBlockDamage(IBlockState p_renderBlockDamage_1_, BlockPos p_renderBlockDamage_2_, TextureAtlasSprite p_renderBlockDamage_3_, IBlockAccess p_renderBlockDamage_4_) {
        if (p_renderBlockDamage_1_.getRenderType() == EnumBlockRenderType.MODEL) {
            p_renderBlockDamage_1_ = p_renderBlockDamage_1_.getActualState(p_renderBlockDamage_4_, p_renderBlockDamage_2_);
            IBakedModel ibakedmodel = this.blockModelShapes.getModelForState(p_renderBlockDamage_1_);
            IBakedModel ibakedmodel1 = ForgeHooksClient.getDamageModel(ibakedmodel, p_renderBlockDamage_3_, p_renderBlockDamage_1_, p_renderBlockDamage_4_, p_renderBlockDamage_2_);
            this.blockModelRenderer.renderModel(p_renderBlockDamage_4_, ibakedmodel1, p_renderBlockDamage_1_, p_renderBlockDamage_2_, Tessellator.getInstance().getBuffer(), true);
        }
    }

    public boolean renderBlock(IBlockState p_renderBlock_1_, BlockPos p_renderBlock_2_, IBlockAccess p_renderBlock_3_, VertexBuffer p_renderBlock_4_) {
        try {
            EnumBlockRenderType enumblockrendertype = p_renderBlock_1_.getRenderType();
            if (enumblockrendertype == EnumBlockRenderType.INVISIBLE) {
                return false;
            }
            if (p_renderBlock_3_.getWorldType() != WorldType.DEBUG_WORLD) {
                try {
                    p_renderBlock_1_ = p_renderBlock_1_.getActualState(p_renderBlock_3_, p_renderBlock_2_);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (enumblockrendertype) {
                case MODEL: {
                    IBakedModel model = this.getModelForState(p_renderBlock_1_);
                    p_renderBlock_1_ = p_renderBlock_1_.getBlock().getExtendedState(p_renderBlock_1_, p_renderBlock_3_, p_renderBlock_2_);
                    return this.blockModelRenderer.renderModel(p_renderBlock_3_, model, p_renderBlock_1_, p_renderBlock_2_, p_renderBlock_4_, true);
                }
                case ENTITYBLOCK_ANIMATED: {
                    return false;
                }
                case LIQUID: {
                    return this.fluidRenderer.renderFluid(p_renderBlock_3_, p_renderBlock_1_, p_renderBlock_2_, p_renderBlock_4_);
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being tesselated");
            CrashReportCategory.addBlockInfo(crashreportcategory, p_renderBlock_2_, p_renderBlock_1_.getBlock(), p_renderBlock_1_.getBlock().getMetaFromState(p_renderBlock_1_));
            throw new ReportedException(crashreport);
        }
    }

    public BlockModelRenderer getBlockModelRenderer() {
        return this.blockModelRenderer;
    }

    public IBakedModel getModelForState(IBlockState p_getModelForState_1_) {
        return this.blockModelShapes.getModelForState(p_getModelForState_1_);
    }

    public void renderBlockBrightness(IBlockState p_renderBlockBrightness_1_, float p_renderBlockBrightness_2_) {
        EnumBlockRenderType enumblockrendertype = p_renderBlockBrightness_1_.getRenderType();
        if (enumblockrendertype != EnumBlockRenderType.INVISIBLE) {
            switch (enumblockrendertype) {
                case MODEL: {
                    IBakedModel ibakedmodel = this.getModelForState(p_renderBlockBrightness_1_);
                    this.blockModelRenderer.renderModelBrightness(ibakedmodel, p_renderBlockBrightness_1_, p_renderBlockBrightness_2_, true);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    this.chestRenderer.renderChestBrightness(p_renderBlockBrightness_1_.getBlock(), p_renderBlockBrightness_2_);
                }
            }
        }
    }

    @Override
    public void onResourceManagerReload(IResourceManager p_onResourceManagerReload_1_) {
        this.fluidRenderer.initAtlasSprites();
    }
}

