/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class ChunkRenderContainer {
    private double viewEntityX;
    private double viewEntityY;
    private double viewEntityZ;
    protected List<RenderChunk> renderChunks = Lists.newArrayListWithCapacity((int)17424);
    protected boolean initialized;

    public void initialize(double p_initialize_1_, double p_initialize_3_, double p_initialize_5_) {
        this.initialized = true;
        this.renderChunks.clear();
        this.viewEntityX = p_initialize_1_;
        this.viewEntityY = p_initialize_3_;
        this.viewEntityZ = p_initialize_5_;
    }

    public void preRenderChunk(RenderChunk p_preRenderChunk_1_) {
        BlockPos lvt_2_1_ = p_preRenderChunk_1_.getPosition();
        GlStateManager.translate((float)((double)lvt_2_1_.getX() - this.viewEntityX), (float)((double)lvt_2_1_.getY() - this.viewEntityY), (float)((double)lvt_2_1_.getZ() - this.viewEntityZ));
    }

    public void addRenderChunk(RenderChunk p_addRenderChunk_1_, BlockRenderLayer p_addRenderChunk_2_) {
        this.renderChunks.add(p_addRenderChunk_1_);
    }

    public abstract void renderChunkLayer(BlockRenderLayer var1);
}

