/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.vector.Quaternion;

@SideOnly(value=Side.CLIENT)
public class GlStateManager {
    public static final FloatBuffer BUF_FLOAT_16 = BufferUtils.createFloatBuffer((int)16);
    public static final FloatBuffer BUF_FLOAT_4 = BufferUtils.createFloatBuffer((int)4);
    public static final AlphaState alphaState = new AlphaState();
    public static final BooleanState lightingState = new BooleanState(2896);
    public static final BooleanState[] lightState = new BooleanState[8];
    public static final ColorMaterialState colorMaterialState;
    public static final BlendState blendState;
    public static final DepthState depthState;
    public static final FogState fogState;
    public static final CullState cullState;
    public static final PolygonOffsetState polygonOffsetState;
    public static final ColorLogicState colorLogicState;
    public static final TexGenState texGenState;
    public static final ClearState clearState;
    public static final StencilState stencilState;
    public static final BooleanState normalizeState;
    public static int activeTextureUnit;
    public static final TextureState[] textureState;
    public static int activeShadeModel;
    public static final BooleanState rescaleNormalState;
    public static final ColorMask colorMaskState;
    public static final Color colorState;

    public static void pushAttrib() {
        GL11.glPushAttrib((int)8256);
    }

    public static void popAttrib() {
        GL11.glPopAttrib();
    }

    public static void disableAlpha() {
        GlStateManager.alphaState.alphaTest.setDisabled();
    }

    public static void enableAlpha() {
        GlStateManager.alphaState.alphaTest.setEnabled();
    }

    public static void alphaFunc(int p_alphaFunc_0_, float p_alphaFunc_1_) {
        if (p_alphaFunc_0_ != GlStateManager.alphaState.func || p_alphaFunc_1_ != GlStateManager.alphaState.ref) {
            GlStateManager.alphaState.func = p_alphaFunc_0_;
            GlStateManager.alphaState.ref = p_alphaFunc_1_;
            GL11.glAlphaFunc((int)p_alphaFunc_0_, (float)p_alphaFunc_1_);
        }
    }

    public static void enableLighting() {
        lightingState.setEnabled();
    }

    public static void disableLighting() {
        lightingState.setDisabled();
    }

    public static void enableLight(int p_enableLight_0_) {
        lightState[p_enableLight_0_].setEnabled();
    }

    public static void disableLight(int p_disableLight_0_) {
        lightState[p_disableLight_0_].setDisabled();
    }

    public static void enableColorMaterial() {
        GlStateManager.colorMaterialState.colorMaterial.setEnabled();
    }

    public static void disableColorMaterial() {
        GlStateManager.colorMaterialState.colorMaterial.setDisabled();
    }

    public static void colorMaterial(int p_colorMaterial_0_, int p_colorMaterial_1_) {
        if (p_colorMaterial_0_ != GlStateManager.colorMaterialState.face || p_colorMaterial_1_ != GlStateManager.colorMaterialState.mode) {
            GlStateManager.colorMaterialState.face = p_colorMaterial_0_;
            GlStateManager.colorMaterialState.mode = p_colorMaterial_1_;
            GL11.glColorMaterial((int)p_colorMaterial_0_, (int)p_colorMaterial_1_);
        }
    }

    public static void glLight(int p_glLight_0_, int p_glLight_1_, FloatBuffer p_glLight_2_) {
        GL11.glLight((int)p_glLight_0_, (int)p_glLight_1_, (FloatBuffer)p_glLight_2_);
    }

    public static void glLightModel(int p_glLightModel_0_, FloatBuffer p_glLightModel_1_) {
        GL11.glLightModel((int)p_glLightModel_0_, (FloatBuffer)p_glLightModel_1_);
    }

    public static void glNormal3f(float p_glNormal3f_0_, float p_glNormal3f_1_, float p_glNormal3f_2_) {
        GL11.glNormal3f((float)p_glNormal3f_0_, (float)p_glNormal3f_1_, (float)p_glNormal3f_2_);
    }

    public static void disableDepth() {
        GlStateManager.depthState.depthTest.setDisabled();
    }

    public static void enableDepth() {
        GlStateManager.depthState.depthTest.setEnabled();
    }

    public static void depthFunc(int p_depthFunc_0_) {
        if (p_depthFunc_0_ != GlStateManager.depthState.depthFunc) {
            GlStateManager.depthState.depthFunc = p_depthFunc_0_;
            GL11.glDepthFunc((int)p_depthFunc_0_);
        }
    }

    public static void depthMask(boolean p_depthMask_0_) {
        if (p_depthMask_0_ != GlStateManager.depthState.maskEnabled) {
            GlStateManager.depthState.maskEnabled = p_depthMask_0_;
            GL11.glDepthMask((boolean)p_depthMask_0_);
        }
    }

    public static void disableBlend() {
        GlStateManager.blendState.blend.setDisabled();
    }

    public static void enableBlend() {
        GlStateManager.blendState.blend.setEnabled();
    }

    public static void blendFunc(SourceFactor p_blendFunc_0_, DestFactor p_blendFunc_1_) {
        GlStateManager.blendFunc(p_blendFunc_0_.factor, p_blendFunc_1_.factor);
    }

    public static void blendFunc(int p_blendFunc_0_, int p_blendFunc_1_) {
        if (p_blendFunc_0_ != GlStateManager.blendState.srcFactor || p_blendFunc_1_ != GlStateManager.blendState.dstFactor) {
            GlStateManager.blendState.srcFactor = p_blendFunc_0_;
            GlStateManager.blendState.dstFactor = p_blendFunc_1_;
            GL11.glBlendFunc((int)p_blendFunc_0_, (int)p_blendFunc_1_);
        }
    }

    public static void tryBlendFuncSeparate(SourceFactor p_tryBlendFuncSeparate_0_, DestFactor p_tryBlendFuncSeparate_1_, SourceFactor p_tryBlendFuncSeparate_2_, DestFactor p_tryBlendFuncSeparate_3_) {
        GlStateManager.tryBlendFuncSeparate(p_tryBlendFuncSeparate_0_.factor, p_tryBlendFuncSeparate_1_.factor, p_tryBlendFuncSeparate_2_.factor, p_tryBlendFuncSeparate_3_.factor);
    }

    public static void tryBlendFuncSeparate(int p_tryBlendFuncSeparate_0_, int p_tryBlendFuncSeparate_1_, int p_tryBlendFuncSeparate_2_, int p_tryBlendFuncSeparate_3_) {
        if (p_tryBlendFuncSeparate_0_ != GlStateManager.blendState.srcFactor || p_tryBlendFuncSeparate_1_ != GlStateManager.blendState.dstFactor || p_tryBlendFuncSeparate_2_ != GlStateManager.blendState.srcFactorAlpha || p_tryBlendFuncSeparate_3_ != GlStateManager.blendState.dstFactorAlpha) {
            GlStateManager.blendState.srcFactor = p_tryBlendFuncSeparate_0_;
            GlStateManager.blendState.dstFactor = p_tryBlendFuncSeparate_1_;
            GlStateManager.blendState.srcFactorAlpha = p_tryBlendFuncSeparate_2_;
            GlStateManager.blendState.dstFactorAlpha = p_tryBlendFuncSeparate_3_;
            OpenGlHelper.glBlendFunc(p_tryBlendFuncSeparate_0_, p_tryBlendFuncSeparate_1_, p_tryBlendFuncSeparate_2_, p_tryBlendFuncSeparate_3_);
        }
    }

    public static void glBlendEquation(int p_glBlendEquation_0_) {
        GL14.glBlendEquation((int)p_glBlendEquation_0_);
    }

    public static void enableOutlineMode(int p_enableOutlineMode_0_) {
        BUF_FLOAT_4.put(0, (float)(p_enableOutlineMode_0_ >> 16 & 0xFF) / 255.0f);
        BUF_FLOAT_4.put(1, (float)(p_enableOutlineMode_0_ >> 8 & 0xFF) / 255.0f);
        BUF_FLOAT_4.put(2, (float)(p_enableOutlineMode_0_ >> 0 & 0xFF) / 255.0f);
        BUF_FLOAT_4.put(3, (float)(p_enableOutlineMode_0_ >> 24 & 0xFF) / 255.0f);
        GlStateManager.glTexEnv(8960, 8705, BUF_FLOAT_4);
        GlStateManager.glTexEnvi(8960, 8704, 34160);
        GlStateManager.glTexEnvi(8960, 34161, 7681);
        GlStateManager.glTexEnvi(8960, 34176, 34166);
        GlStateManager.glTexEnvi(8960, 34192, 768);
        GlStateManager.glTexEnvi(8960, 34162, 7681);
        GlStateManager.glTexEnvi(8960, 34184, 5890);
        GlStateManager.glTexEnvi(8960, 34200, 770);
    }

    public static void disableOutlineMode() {
        GlStateManager.glTexEnvi(8960, 8704, 8448);
        GlStateManager.glTexEnvi(8960, 34161, 8448);
        GlStateManager.glTexEnvi(8960, 34162, 8448);
        GlStateManager.glTexEnvi(8960, 34176, 5890);
        GlStateManager.glTexEnvi(8960, 34184, 5890);
        GlStateManager.glTexEnvi(8960, 34192, 768);
        GlStateManager.glTexEnvi(8960, 34200, 770);
    }

    public static void enableFog() {
        GlStateManager.fogState.fog.setEnabled();
    }

    public static void disableFog() {
        GlStateManager.fogState.fog.setDisabled();
    }

    public static void setFog(FogMode p_setFog_0_) {
        GlStateManager.setFog(p_setFog_0_.capabilityId);
    }

    private static void setFog(int p_setFog_0_) {
        if (p_setFog_0_ != GlStateManager.fogState.mode) {
            GlStateManager.fogState.mode = p_setFog_0_;
            GL11.glFogi((int)2917, (int)p_setFog_0_);
        }
    }

    public static void setFogDensity(float p_setFogDensity_0_) {
        if (p_setFogDensity_0_ != GlStateManager.fogState.density) {
            GlStateManager.fogState.density = p_setFogDensity_0_;
            GL11.glFogf((int)2914, (float)p_setFogDensity_0_);
        }
    }

    public static void setFogStart(float p_setFogStart_0_) {
        if (p_setFogStart_0_ != GlStateManager.fogState.start) {
            GlStateManager.fogState.start = p_setFogStart_0_;
            GL11.glFogf((int)2915, (float)p_setFogStart_0_);
        }
    }

    public static void setFogEnd(float p_setFogEnd_0_) {
        if (p_setFogEnd_0_ != GlStateManager.fogState.end) {
            GlStateManager.fogState.end = p_setFogEnd_0_;
            GL11.glFogf((int)2916, (float)p_setFogEnd_0_);
        }
    }

    public static void glFog(int p_glFog_0_, FloatBuffer p_glFog_1_) {
        GL11.glFog((int)p_glFog_0_, (FloatBuffer)p_glFog_1_);
    }

    public static void glFogi(int p_glFogi_0_, int p_glFogi_1_) {
        GL11.glFogi((int)p_glFogi_0_, (int)p_glFogi_1_);
    }

    public static void enableCull() {
        GlStateManager.cullState.cullFace.setEnabled();
    }

    public static void disableCull() {
        GlStateManager.cullState.cullFace.setDisabled();
    }

    public static void cullFace(CullFace p_cullFace_0_) {
        GlStateManager.cullFace(p_cullFace_0_.mode);
    }

    private static void cullFace(int p_cullFace_0_) {
        if (p_cullFace_0_ != GlStateManager.cullState.mode) {
            GlStateManager.cullState.mode = p_cullFace_0_;
            GL11.glCullFace((int)p_cullFace_0_);
        }
    }

    public static void glPolygonMode(int p_glPolygonMode_0_, int p_glPolygonMode_1_) {
        GL11.glPolygonMode((int)p_glPolygonMode_0_, (int)p_glPolygonMode_1_);
    }

    public static void enablePolygonOffset() {
        GlStateManager.polygonOffsetState.polygonOffsetFill.setEnabled();
    }

    public static void disablePolygonOffset() {
        GlStateManager.polygonOffsetState.polygonOffsetFill.setDisabled();
    }

    public static void doPolygonOffset(float p_doPolygonOffset_0_, float p_doPolygonOffset_1_) {
        if (p_doPolygonOffset_0_ != GlStateManager.polygonOffsetState.factor || p_doPolygonOffset_1_ != GlStateManager.polygonOffsetState.units) {
            GlStateManager.polygonOffsetState.factor = p_doPolygonOffset_0_;
            GlStateManager.polygonOffsetState.units = p_doPolygonOffset_1_;
            GL11.glPolygonOffset((float)p_doPolygonOffset_0_, (float)p_doPolygonOffset_1_);
        }
    }

    public static void enableColorLogic() {
        GlStateManager.colorLogicState.colorLogicOp.setEnabled();
    }

    public static void disableColorLogic() {
        GlStateManager.colorLogicState.colorLogicOp.setDisabled();
    }

    public static void colorLogicOp(LogicOp p_colorLogicOp_0_) {
        GlStateManager.colorLogicOp(p_colorLogicOp_0_.opcode);
    }

    public static void colorLogicOp(int p_colorLogicOp_0_) {
        if (p_colorLogicOp_0_ != GlStateManager.colorLogicState.opcode) {
            GlStateManager.colorLogicState.opcode = p_colorLogicOp_0_;
            GL11.glLogicOp((int)p_colorLogicOp_0_);
        }
    }

    public static void enableTexGenCoord(TexGen p_enableTexGenCoord_0_) {
        GlStateManager.texGenCoord((TexGen)p_enableTexGenCoord_0_).textureGen.setEnabled();
    }

    public static void disableTexGenCoord(TexGen p_disableTexGenCoord_0_) {
        GlStateManager.texGenCoord((TexGen)p_disableTexGenCoord_0_).textureGen.setDisabled();
    }

    public static void texGen(TexGen p_texGen_0_, int p_texGen_1_) {
        TexGenCoord lvt_2_1_ = GlStateManager.texGenCoord(p_texGen_0_);
        if (p_texGen_1_ != lvt_2_1_.param) {
            lvt_2_1_.param = p_texGen_1_;
            GL11.glTexGeni((int)lvt_2_1_.coord, (int)9472, (int)p_texGen_1_);
        }
    }

    public static void texGen(TexGen p_texGen_0_, int p_texGen_1_, FloatBuffer p_texGen_2_) {
        GL11.glTexGen((int)GlStateManager.texGenCoord((TexGen)p_texGen_0_).coord, (int)p_texGen_1_, (FloatBuffer)p_texGen_2_);
    }

    private static TexGenCoord texGenCoord(TexGen p_texGenCoord_0_) {
        switch (p_texGenCoord_0_) {
            case S: {
                return GlStateManager.texGenState.s;
            }
            case T: {
                return GlStateManager.texGenState.t;
            }
            case R: {
                return GlStateManager.texGenState.r;
            }
            case Q: {
                return GlStateManager.texGenState.q;
            }
        }
        return GlStateManager.texGenState.s;
    }

    public static void setActiveTexture(int p_setActiveTexture_0_) {
        if (activeTextureUnit != p_setActiveTexture_0_ - OpenGlHelper.defaultTexUnit) {
            activeTextureUnit = p_setActiveTexture_0_ - OpenGlHelper.defaultTexUnit;
            OpenGlHelper.setActiveTexture(p_setActiveTexture_0_);
        }
    }

    public static void enableTexture2D() {
        GlStateManager.textureState[GlStateManager.activeTextureUnit].texture2DState.setEnabled();
    }

    public static void disableTexture2D() {
        GlStateManager.textureState[GlStateManager.activeTextureUnit].texture2DState.setDisabled();
    }

    public static void glTexEnv(int p_glTexEnv_0_, int p_glTexEnv_1_, FloatBuffer p_glTexEnv_2_) {
        GL11.glTexEnv((int)p_glTexEnv_0_, (int)p_glTexEnv_1_, (FloatBuffer)p_glTexEnv_2_);
    }

    public static void glTexEnvi(int p_glTexEnvi_0_, int p_glTexEnvi_1_, int p_glTexEnvi_2_) {
        GL11.glTexEnvi((int)p_glTexEnvi_0_, (int)p_glTexEnvi_1_, (int)p_glTexEnvi_2_);
    }

    public static void glTexEnvf(int p_glTexEnvf_0_, int p_glTexEnvf_1_, float p_glTexEnvf_2_) {
        GL11.glTexEnvf((int)p_glTexEnvf_0_, (int)p_glTexEnvf_1_, (float)p_glTexEnvf_2_);
    }

    public static void glTexParameterf(int p_glTexParameterf_0_, int p_glTexParameterf_1_, float p_glTexParameterf_2_) {
        GL11.glTexParameterf((int)p_glTexParameterf_0_, (int)p_glTexParameterf_1_, (float)p_glTexParameterf_2_);
    }

    public static void glTexParameteri(int p_glTexParameteri_0_, int p_glTexParameteri_1_, int p_glTexParameteri_2_) {
        GL11.glTexParameteri((int)p_glTexParameteri_0_, (int)p_glTexParameteri_1_, (int)p_glTexParameteri_2_);
    }

    public static int glGetTexLevelParameteri(int p_glGetTexLevelParameteri_0_, int p_glGetTexLevelParameteri_1_, int p_glGetTexLevelParameteri_2_) {
        return GL11.glGetTexLevelParameteri((int)p_glGetTexLevelParameteri_0_, (int)p_glGetTexLevelParameteri_1_, (int)p_glGetTexLevelParameteri_2_);
    }

    public static int generateTexture() {
        return GL11.glGenTextures();
    }

    public static void deleteTexture(int p_deleteTexture_0_) {
        GL11.glDeleteTextures((int)p_deleteTexture_0_);
        for (TextureState lvt_4_1_ : textureState) {
            if (lvt_4_1_.textureName != p_deleteTexture_0_) continue;
            lvt_4_1_.textureName = -1;
        }
    }

    public static void bindTexture(int p_bindTexture_0_) {
        if (p_bindTexture_0_ != GlStateManager.textureState[GlStateManager.activeTextureUnit].textureName) {
            GlStateManager.textureState[GlStateManager.activeTextureUnit].textureName = p_bindTexture_0_;
            GL11.glBindTexture((int)3553, (int)p_bindTexture_0_);
        }
    }

    public static void glTexImage2D(int p_glTexImage2D_0_, int p_glTexImage2D_1_, int p_glTexImage2D_2_, int p_glTexImage2D_3_, int p_glTexImage2D_4_, int p_glTexImage2D_5_, int p_glTexImage2D_6_, int p_glTexImage2D_7_, IntBuffer p_glTexImage2D_8_) {
        GL11.glTexImage2D((int)p_glTexImage2D_0_, (int)p_glTexImage2D_1_, (int)p_glTexImage2D_2_, (int)p_glTexImage2D_3_, (int)p_glTexImage2D_4_, (int)p_glTexImage2D_5_, (int)p_glTexImage2D_6_, (int)p_glTexImage2D_7_, (IntBuffer)p_glTexImage2D_8_);
    }

    public static void glTexSubImage2D(int p_glTexSubImage2D_0_, int p_glTexSubImage2D_1_, int p_glTexSubImage2D_2_, int p_glTexSubImage2D_3_, int p_glTexSubImage2D_4_, int p_glTexSubImage2D_5_, int p_glTexSubImage2D_6_, int p_glTexSubImage2D_7_, IntBuffer p_glTexSubImage2D_8_) {
        GL11.glTexSubImage2D((int)p_glTexSubImage2D_0_, (int)p_glTexSubImage2D_1_, (int)p_glTexSubImage2D_2_, (int)p_glTexSubImage2D_3_, (int)p_glTexSubImage2D_4_, (int)p_glTexSubImage2D_5_, (int)p_glTexSubImage2D_6_, (int)p_glTexSubImage2D_7_, (IntBuffer)p_glTexSubImage2D_8_);
    }

    public static void glCopyTexSubImage2D(int p_glCopyTexSubImage2D_0_, int p_glCopyTexSubImage2D_1_, int p_glCopyTexSubImage2D_2_, int p_glCopyTexSubImage2D_3_, int p_glCopyTexSubImage2D_4_, int p_glCopyTexSubImage2D_5_, int p_glCopyTexSubImage2D_6_, int p_glCopyTexSubImage2D_7_) {
        GL11.glCopyTexSubImage2D((int)p_glCopyTexSubImage2D_0_, (int)p_glCopyTexSubImage2D_1_, (int)p_glCopyTexSubImage2D_2_, (int)p_glCopyTexSubImage2D_3_, (int)p_glCopyTexSubImage2D_4_, (int)p_glCopyTexSubImage2D_5_, (int)p_glCopyTexSubImage2D_6_, (int)p_glCopyTexSubImage2D_7_);
    }

    public static void glGetTexImage(int p_glGetTexImage_0_, int p_glGetTexImage_1_, int p_glGetTexImage_2_, int p_glGetTexImage_3_, IntBuffer p_glGetTexImage_4_) {
        GL11.glGetTexImage((int)p_glGetTexImage_0_, (int)p_glGetTexImage_1_, (int)p_glGetTexImage_2_, (int)p_glGetTexImage_3_, (IntBuffer)p_glGetTexImage_4_);
    }

    public static void enableNormalize() {
        normalizeState.setEnabled();
    }

    public static void disableNormalize() {
        normalizeState.setDisabled();
    }

    public static void shadeModel(int p_shadeModel_0_) {
        if (p_shadeModel_0_ != activeShadeModel) {
            activeShadeModel = p_shadeModel_0_;
            GL11.glShadeModel((int)p_shadeModel_0_);
        }
    }

    public static void enableRescaleNormal() {
        rescaleNormalState.setEnabled();
    }

    public static void disableRescaleNormal() {
        rescaleNormalState.setDisabled();
    }

    public static void viewport(int p_viewport_0_, int p_viewport_1_, int p_viewport_2_, int p_viewport_3_) {
        GL11.glViewport((int)p_viewport_0_, (int)p_viewport_1_, (int)p_viewport_2_, (int)p_viewport_3_);
    }

    public static void colorMask(boolean p_colorMask_0_, boolean p_colorMask_1_, boolean p_colorMask_2_, boolean p_colorMask_3_) {
        if (p_colorMask_0_ != GlStateManager.colorMaskState.red || p_colorMask_1_ != GlStateManager.colorMaskState.green || p_colorMask_2_ != GlStateManager.colorMaskState.blue || p_colorMask_3_ != GlStateManager.colorMaskState.alpha) {
            GlStateManager.colorMaskState.red = p_colorMask_0_;
            GlStateManager.colorMaskState.green = p_colorMask_1_;
            GlStateManager.colorMaskState.blue = p_colorMask_2_;
            GlStateManager.colorMaskState.alpha = p_colorMask_3_;
            GL11.glColorMask((boolean)p_colorMask_0_, (boolean)p_colorMask_1_, (boolean)p_colorMask_2_, (boolean)p_colorMask_3_);
        }
    }

    public static void clearDepth(double p_clearDepth_0_) {
        if (p_clearDepth_0_ != GlStateManager.clearState.depth) {
            GlStateManager.clearState.depth = p_clearDepth_0_;
            GL11.glClearDepth((double)p_clearDepth_0_);
        }
    }

    public static void clearColor(float p_clearColor_0_, float p_clearColor_1_, float p_clearColor_2_, float p_clearColor_3_) {
        if (p_clearColor_0_ != GlStateManager.clearState.color.red || p_clearColor_1_ != GlStateManager.clearState.color.green || p_clearColor_2_ != GlStateManager.clearState.color.blue || p_clearColor_3_ != GlStateManager.clearState.color.alpha) {
            GlStateManager.clearState.color.red = p_clearColor_0_;
            GlStateManager.clearState.color.green = p_clearColor_1_;
            GlStateManager.clearState.color.blue = p_clearColor_2_;
            GlStateManager.clearState.color.alpha = p_clearColor_3_;
            GL11.glClearColor((float)p_clearColor_0_, (float)p_clearColor_1_, (float)p_clearColor_2_, (float)p_clearColor_3_);
        }
    }

    public static void clear(int p_clear_0_) {
        GL11.glClear((int)p_clear_0_);
    }

    public static void matrixMode(int p_matrixMode_0_) {
        GL11.glMatrixMode((int)p_matrixMode_0_);
    }

    public static void loadIdentity() {
        GL11.glLoadIdentity();
    }

    public static void pushMatrix() {
        GL11.glPushMatrix();
    }

    public static void popMatrix() {
        GL11.glPopMatrix();
    }

    public static void getFloat(int p_getFloat_0_, FloatBuffer p_getFloat_1_) {
        GL11.glGetFloat((int)p_getFloat_0_, (FloatBuffer)p_getFloat_1_);
    }

    public static void ortho(double p_ortho_0_, double p_ortho_2_, double p_ortho_4_, double p_ortho_6_, double p_ortho_8_, double p_ortho_10_) {
        GL11.glOrtho((double)p_ortho_0_, (double)p_ortho_2_, (double)p_ortho_4_, (double)p_ortho_6_, (double)p_ortho_8_, (double)p_ortho_10_);
    }

    public static void rotate(float p_rotate_0_, float p_rotate_1_, float p_rotate_2_, float p_rotate_3_) {
        GL11.glRotatef((float)p_rotate_0_, (float)p_rotate_1_, (float)p_rotate_2_, (float)p_rotate_3_);
    }

    public static void scale(float p_scale_0_, float p_scale_1_, float p_scale_2_) {
        GL11.glScalef((float)p_scale_0_, (float)p_scale_1_, (float)p_scale_2_);
    }

    public static void scale(double p_scale_0_, double p_scale_2_, double p_scale_4_) {
        GL11.glScaled((double)p_scale_0_, (double)p_scale_2_, (double)p_scale_4_);
    }

    public static void translate(float p_translate_0_, float p_translate_1_, float p_translate_2_) {
        GL11.glTranslatef((float)p_translate_0_, (float)p_translate_1_, (float)p_translate_2_);
    }

    public static void translate(double p_translate_0_, double p_translate_2_, double p_translate_4_) {
        GL11.glTranslated((double)p_translate_0_, (double)p_translate_2_, (double)p_translate_4_);
    }

    public static void multMatrix(FloatBuffer p_multMatrix_0_) {
        GL11.glMultMatrix((FloatBuffer)p_multMatrix_0_);
    }

    public static void rotate(Quaternion p_rotate_0_) {
        GlStateManager.multMatrix(GlStateManager.quatToGlMatrix(BUF_FLOAT_16, p_rotate_0_));
    }

    public static FloatBuffer quatToGlMatrix(FloatBuffer p_quatToGlMatrix_0_, Quaternion p_quatToGlMatrix_1_) {
        p_quatToGlMatrix_0_.clear();
        float lvt_2_1_ = p_quatToGlMatrix_1_.x * p_quatToGlMatrix_1_.x;
        float lvt_3_1_ = p_quatToGlMatrix_1_.x * p_quatToGlMatrix_1_.y;
        float lvt_4_1_ = p_quatToGlMatrix_1_.x * p_quatToGlMatrix_1_.z;
        float lvt_5_1_ = p_quatToGlMatrix_1_.x * p_quatToGlMatrix_1_.w;
        float lvt_6_1_ = p_quatToGlMatrix_1_.y * p_quatToGlMatrix_1_.y;
        float lvt_7_1_ = p_quatToGlMatrix_1_.y * p_quatToGlMatrix_1_.z;
        float lvt_8_1_ = p_quatToGlMatrix_1_.y * p_quatToGlMatrix_1_.w;
        float lvt_9_1_ = p_quatToGlMatrix_1_.z * p_quatToGlMatrix_1_.z;
        float lvt_10_1_ = p_quatToGlMatrix_1_.z * p_quatToGlMatrix_1_.w;
        p_quatToGlMatrix_0_.put(1.0f - 2.0f * (lvt_6_1_ + lvt_9_1_));
        p_quatToGlMatrix_0_.put(2.0f * (lvt_3_1_ + lvt_10_1_));
        p_quatToGlMatrix_0_.put(2.0f * (lvt_4_1_ - lvt_8_1_));
        p_quatToGlMatrix_0_.put(0.0f);
        p_quatToGlMatrix_0_.put(2.0f * (lvt_3_1_ - lvt_10_1_));
        p_quatToGlMatrix_0_.put(1.0f - 2.0f * (lvt_2_1_ + lvt_9_1_));
        p_quatToGlMatrix_0_.put(2.0f * (lvt_7_1_ + lvt_5_1_));
        p_quatToGlMatrix_0_.put(0.0f);
        p_quatToGlMatrix_0_.put(2.0f * (lvt_4_1_ + lvt_8_1_));
        p_quatToGlMatrix_0_.put(2.0f * (lvt_7_1_ - lvt_5_1_));
        p_quatToGlMatrix_0_.put(1.0f - 2.0f * (lvt_2_1_ + lvt_6_1_));
        p_quatToGlMatrix_0_.put(0.0f);
        p_quatToGlMatrix_0_.put(0.0f);
        p_quatToGlMatrix_0_.put(0.0f);
        p_quatToGlMatrix_0_.put(0.0f);
        p_quatToGlMatrix_0_.put(1.0f);
        p_quatToGlMatrix_0_.rewind();
        return p_quatToGlMatrix_0_;
    }

    public static void color(float p_color_0_, float p_color_1_, float p_color_2_, float p_color_3_) {
        if (p_color_0_ != GlStateManager.colorState.red || p_color_1_ != GlStateManager.colorState.green || p_color_2_ != GlStateManager.colorState.blue || p_color_3_ != GlStateManager.colorState.alpha) {
            GlStateManager.colorState.red = p_color_0_;
            GlStateManager.colorState.green = p_color_1_;
            GlStateManager.colorState.blue = p_color_2_;
            GlStateManager.colorState.alpha = p_color_3_;
            GL11.glColor4f((float)p_color_0_, (float)p_color_1_, (float)p_color_2_, (float)p_color_3_);
        }
    }

    public static void color(float p_color_0_, float p_color_1_, float p_color_2_) {
        GlStateManager.color(p_color_0_, p_color_1_, p_color_2_, 1.0f);
    }

    public static void glTexCoord2f(float p_glTexCoord2f_0_, float p_glTexCoord2f_1_) {
        GL11.glTexCoord2f((float)p_glTexCoord2f_0_, (float)p_glTexCoord2f_1_);
    }

    public static void glVertex3f(float p_glVertex3f_0_, float p_glVertex3f_1_, float p_glVertex3f_2_) {
        GL11.glVertex3f((float)p_glVertex3f_0_, (float)p_glVertex3f_1_, (float)p_glVertex3f_2_);
    }

    public static void resetColor() {
        GlStateManager.colorState.red = -1.0f;
        GlStateManager.colorState.green = -1.0f;
        GlStateManager.colorState.blue = -1.0f;
        GlStateManager.colorState.alpha = -1.0f;
    }

    public static void glNormalPointer(int p_glNormalPointer_0_, int p_glNormalPointer_1_, ByteBuffer p_glNormalPointer_2_) {
        GL11.glNormalPointer((int)p_glNormalPointer_0_, (int)p_glNormalPointer_1_, (ByteBuffer)p_glNormalPointer_2_);
    }

    public static void glTexCoordPointer(int p_glTexCoordPointer_0_, int p_glTexCoordPointer_1_, int p_glTexCoordPointer_2_, int p_glTexCoordPointer_3_) {
        GL11.glTexCoordPointer((int)p_glTexCoordPointer_0_, (int)p_glTexCoordPointer_1_, (int)p_glTexCoordPointer_2_, (long)p_glTexCoordPointer_3_);
    }

    public static void glTexCoordPointer(int p_glTexCoordPointer_0_, int p_glTexCoordPointer_1_, int p_glTexCoordPointer_2_, ByteBuffer p_glTexCoordPointer_3_) {
        GL11.glTexCoordPointer((int)p_glTexCoordPointer_0_, (int)p_glTexCoordPointer_1_, (int)p_glTexCoordPointer_2_, (ByteBuffer)p_glTexCoordPointer_3_);
    }

    public static void glVertexPointer(int p_glVertexPointer_0_, int p_glVertexPointer_1_, int p_glVertexPointer_2_, int p_glVertexPointer_3_) {
        GL11.glVertexPointer((int)p_glVertexPointer_0_, (int)p_glVertexPointer_1_, (int)p_glVertexPointer_2_, (long)p_glVertexPointer_3_);
    }

    public static void glVertexPointer(int p_glVertexPointer_0_, int p_glVertexPointer_1_, int p_glVertexPointer_2_, ByteBuffer p_glVertexPointer_3_) {
        GL11.glVertexPointer((int)p_glVertexPointer_0_, (int)p_glVertexPointer_1_, (int)p_glVertexPointer_2_, (ByteBuffer)p_glVertexPointer_3_);
    }

    public static void glColorPointer(int p_glColorPointer_0_, int p_glColorPointer_1_, int p_glColorPointer_2_, int p_glColorPointer_3_) {
        GL11.glColorPointer((int)p_glColorPointer_0_, (int)p_glColorPointer_1_, (int)p_glColorPointer_2_, (long)p_glColorPointer_3_);
    }

    public static void glColorPointer(int p_glColorPointer_0_, int p_glColorPointer_1_, int p_glColorPointer_2_, ByteBuffer p_glColorPointer_3_) {
        GL11.glColorPointer((int)p_glColorPointer_0_, (int)p_glColorPointer_1_, (int)p_glColorPointer_2_, (ByteBuffer)p_glColorPointer_3_);
    }

    public static void glDisableClientState(int p_glDisableClientState_0_) {
        GL11.glDisableClientState((int)p_glDisableClientState_0_);
    }

    public static void glEnableClientState(int p_glEnableClientState_0_) {
        GL11.glEnableClientState((int)p_glEnableClientState_0_);
    }

    public static void glBegin(int p_glBegin_0_) {
        GL11.glBegin((int)p_glBegin_0_);
    }

    public static void glEnd() {
        GL11.glEnd();
    }

    public static void glDrawArrays(int p_glDrawArrays_0_, int p_glDrawArrays_1_, int p_glDrawArrays_2_) {
        GL11.glDrawArrays((int)p_glDrawArrays_0_, (int)p_glDrawArrays_1_, (int)p_glDrawArrays_2_);
    }

    public static void glLineWidth(float p_glLineWidth_0_) {
        GL11.glLineWidth((float)p_glLineWidth_0_);
    }

    public static void callList(int p_callList_0_) {
        GL11.glCallList((int)p_callList_0_);
    }

    public static void glDeleteLists(int p_glDeleteLists_0_, int p_glDeleteLists_1_) {
        GL11.glDeleteLists((int)p_glDeleteLists_0_, (int)p_glDeleteLists_1_);
    }

    public static void glNewList(int p_glNewList_0_, int p_glNewList_1_) {
        GL11.glNewList((int)p_glNewList_0_, (int)p_glNewList_1_);
    }

    public static void glEndList() {
        GL11.glEndList();
    }

    public static int glGenLists(int p_glGenLists_0_) {
        return GL11.glGenLists((int)p_glGenLists_0_);
    }

    public static void glPixelStorei(int p_glPixelStorei_0_, int p_glPixelStorei_1_) {
        GL11.glPixelStorei((int)p_glPixelStorei_0_, (int)p_glPixelStorei_1_);
    }

    public static void glReadPixels(int p_glReadPixels_0_, int p_glReadPixels_1_, int p_glReadPixels_2_, int p_glReadPixels_3_, int p_glReadPixels_4_, int p_glReadPixels_5_, IntBuffer p_glReadPixels_6_) {
        GL11.glReadPixels((int)p_glReadPixels_0_, (int)p_glReadPixels_1_, (int)p_glReadPixels_2_, (int)p_glReadPixels_3_, (int)p_glReadPixels_4_, (int)p_glReadPixels_5_, (IntBuffer)p_glReadPixels_6_);
    }

    public static int glGetError() {
        return GL11.glGetError();
    }

    public static String glGetString(int p_glGetString_0_) {
        return GL11.glGetString((int)p_glGetString_0_);
    }

    public static void glGetInteger(int p_glGetInteger_0_, IntBuffer p_glGetInteger_1_) {
        GL11.glGetInteger((int)p_glGetInteger_0_, (IntBuffer)p_glGetInteger_1_);
    }

    public static int glGetInteger(int p_glGetInteger_0_) {
        return GL11.glGetInteger((int)p_glGetInteger_0_);
    }

    public static void enableBlendProfile(Profile p_enableBlendProfile_0_) {
        p_enableBlendProfile_0_.apply();
    }

    public static void disableBlendProfile(Profile p_disableBlendProfile_0_) {
        p_disableBlendProfile_0_.clean();
    }

    static {
        for (int lvt_0_1_ = 0; lvt_0_1_ < 8; ++lvt_0_1_) {
            GlStateManager.lightState[lvt_0_1_] = new BooleanState(16384 + lvt_0_1_);
        }
        colorMaterialState = new ColorMaterialState();
        blendState = new BlendState();
        depthState = new DepthState();
        fogState = new FogState();
        cullState = new CullState();
        polygonOffsetState = new PolygonOffsetState();
        colorLogicState = new ColorLogicState();
        texGenState = new TexGenState();
        clearState = new ClearState();
        stencilState = new StencilState();
        normalizeState = new BooleanState(2977);
        textureState = new TextureState[8];
        for (int lvt_0_2_ = 0; lvt_0_2_ < 8; ++lvt_0_2_) {
            GlStateManager.textureState[lvt_0_2_] = new TextureState();
        }
        activeShadeModel = 7425;
        rescaleNormalState = new BooleanState(32826);
        colorMaskState = new ColorMask();
        colorState = new Color();
    }

    @SideOnly(value=Side.CLIENT)
    public static enum Profile {
        DEFAULT{

            @Override
            public void apply() {
                GlStateManager.disableAlpha();
                GlStateManager.alphaFunc(519, 0.0f);
                GlStateManager.disableLighting();
                GlStateManager.glLightModel(2899, RenderHelper.setColorBuffer(0.2f, 0.2f, 0.2f, 1.0f));
                for (int lvt_1_1_ = 0; lvt_1_1_ < 8; ++lvt_1_1_) {
                    GlStateManager.disableLight(lvt_1_1_);
                    GlStateManager.glLight(16384 + lvt_1_1_, 4608, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.glLight(16384 + lvt_1_1_, 4611, RenderHelper.setColorBuffer(0.0f, 0.0f, 1.0f, 0.0f));
                    if (lvt_1_1_ == 0) {
                        GlStateManager.glLight(16384 + lvt_1_1_, 4609, RenderHelper.setColorBuffer(1.0f, 1.0f, 1.0f, 1.0f));
                        GlStateManager.glLight(16384 + lvt_1_1_, 4610, RenderHelper.setColorBuffer(1.0f, 1.0f, 1.0f, 1.0f));
                        continue;
                    }
                    GlStateManager.glLight(16384 + lvt_1_1_, 4609, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.glLight(16384 + lvt_1_1_, 4610, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                }
                GlStateManager.disableColorMaterial();
                GlStateManager.colorMaterial(1032, 5634);
                GlStateManager.disableDepth();
                GlStateManager.depthFunc(513);
                GlStateManager.depthMask(true);
                GlStateManager.disableBlend();
                GlStateManager.blendFunc(SourceFactor.ONE, DestFactor.ZERO);
                GlStateManager.tryBlendFuncSeparate(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
                GlStateManager.glBlendEquation(32774);
                GlStateManager.disableFog();
                GlStateManager.glFogi(2917, 2048);
                GlStateManager.setFogDensity(1.0f);
                GlStateManager.setFogStart(0.0f);
                GlStateManager.setFogEnd(1.0f);
                GlStateManager.glFog(2918, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 0.0f));
                if (GLContext.getCapabilities().GL_NV_fog_distance) {
                    GlStateManager.glFogi(2917, 34140);
                }
                GlStateManager.doPolygonOffset(0.0f, 0.0f);
                GlStateManager.disableColorLogic();
                GlStateManager.colorLogicOp(5379);
                GlStateManager.disableTexGenCoord(TexGen.S);
                GlStateManager.texGen(TexGen.S, 9216);
                GlStateManager.texGen(TexGen.S, 9474, RenderHelper.setColorBuffer(1.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGen(TexGen.S, 9217, RenderHelper.setColorBuffer(1.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGenCoord(TexGen.T);
                GlStateManager.texGen(TexGen.T, 9216);
                GlStateManager.texGen(TexGen.T, 9474, RenderHelper.setColorBuffer(0.0f, 1.0f, 0.0f, 0.0f));
                GlStateManager.texGen(TexGen.T, 9217, RenderHelper.setColorBuffer(0.0f, 1.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGenCoord(TexGen.R);
                GlStateManager.texGen(TexGen.R, 9216);
                GlStateManager.texGen(TexGen.R, 9474, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGen(TexGen.R, 9217, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGenCoord(TexGen.Q);
                GlStateManager.texGen(TexGen.Q, 9216);
                GlStateManager.texGen(TexGen.Q, 9474, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGen(TexGen.Q, 9217, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.setActiveTexture(0);
                GlStateManager.glTexParameteri(3553, 10240, 9729);
                GlStateManager.glTexParameteri(3553, 10241, 9986);
                GlStateManager.glTexParameteri(3553, 10242, 10497);
                GlStateManager.glTexParameteri(3553, 10243, 10497);
                GlStateManager.glTexParameteri(3553, 33085, 1000);
                GlStateManager.glTexParameteri(3553, 33083, 1000);
                GlStateManager.glTexParameteri(3553, 33082, -1000);
                GlStateManager.glTexParameterf(3553, 34049, 0.0f);
                GlStateManager.glTexEnvi(8960, 8704, 8448);
                GlStateManager.glTexEnv(8960, 8705, RenderHelper.setColorBuffer(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.glTexEnvi(8960, 34161, 8448);
                GlStateManager.glTexEnvi(8960, 34162, 8448);
                GlStateManager.glTexEnvi(8960, 34176, 5890);
                GlStateManager.glTexEnvi(8960, 34177, 34168);
                GlStateManager.glTexEnvi(8960, 34178, 34166);
                GlStateManager.glTexEnvi(8960, 34184, 5890);
                GlStateManager.glTexEnvi(8960, 34185, 34168);
                GlStateManager.glTexEnvi(8960, 34186, 34166);
                GlStateManager.glTexEnvi(8960, 34192, 768);
                GlStateManager.glTexEnvi(8960, 34193, 768);
                GlStateManager.glTexEnvi(8960, 34194, 770);
                GlStateManager.glTexEnvi(8960, 34200, 770);
                GlStateManager.glTexEnvi(8960, 34201, 770);
                GlStateManager.glTexEnvi(8960, 34202, 770);
                GlStateManager.glTexEnvf(8960, 34163, 1.0f);
                GlStateManager.glTexEnvf(8960, 3356, 1.0f);
                GlStateManager.disableNormalize();
                GlStateManager.shadeModel(7425);
                GlStateManager.disableRescaleNormal();
                GlStateManager.colorMask(true, true, true, true);
                GlStateManager.clearDepth(1.0);
                GlStateManager.glLineWidth(1.0f);
                GlStateManager.glNormal3f(0.0f, 0.0f, 1.0f);
                GlStateManager.glPolygonMode(1028, 6914);
                GlStateManager.glPolygonMode(1029, 6914);
            }

            @Override
            public void clean() {
            }
        }
        ,
        PLAYER_SKIN{

            @Override
            public void apply() {
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
            }

            @Override
            public void clean() {
                GlStateManager.disableBlend();
            }
        }
        ,
        TRANSPARENT_MODEL{

            @Override
            public void apply() {
                GlStateManager.color(1.0f, 1.0f, 1.0f, 0.15f);
                GlStateManager.depthMask(false);
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.alphaFunc(516, 0.003921569f);
            }

            @Override
            public void clean() {
                GlStateManager.disableBlend();
                GlStateManager.alphaFunc(516, 0.1f);
                GlStateManager.depthMask(true);
            }
        };


        public abstract void apply();

        public abstract void clean();
    }

    @SideOnly(value=Side.CLIENT)
    public static enum DestFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int factor;

        private DestFactor(int p_i46519_3_) {
            this.factor = p_i46519_3_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum SourceFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int factor;

        private SourceFactor(int p_i46514_3_) {
            this.factor = p_i46514_3_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class BooleanState {
        public final int capability;
        public boolean currentState;

        public BooleanState(int p_i46267_1_) {
            this.capability = p_i46267_1_;
        }

        public void setDisabled() {
            this.setState(false);
        }

        public void setEnabled() {
            this.setState(true);
        }

        public void setState(boolean p_setState_1_) {
            if (p_setState_1_ != this.currentState) {
                this.currentState = p_setState_1_;
                if (p_setState_1_) {
                    GL11.glEnable((int)this.capability);
                } else {
                    GL11.glDisable((int)this.capability);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class Color {
        public float red = 1.0f;
        public float green = 1.0f;
        public float blue = 1.0f;
        public float alpha = 1.0f;

        public Color() {
            this(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public Color(float p_i46265_1_, float p_i46265_2_, float p_i46265_3_, float p_i46265_4_) {
            this.red = p_i46265_1_;
            this.green = p_i46265_2_;
            this.blue = p_i46265_3_;
            this.alpha = p_i46265_4_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class ColorMask {
        public boolean red = true;
        public boolean green = true;
        public boolean blue = true;
        public boolean alpha = true;

        private ColorMask() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum TexGen {
        S,
        T,
        R,
        Q;

    }

    @SideOnly(value=Side.CLIENT)
    static class TexGenCoord {
        public BooleanState textureGen;
        public int coord;
        public int param = -1;

        public TexGenCoord(int p_i46254_1_, int p_i46254_2_) {
            this.coord = p_i46254_1_;
            this.textureGen = new BooleanState(p_i46254_2_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class TexGenState {
        public TexGenCoord s = new TexGenCoord(8192, 3168);
        public TexGenCoord t = new TexGenCoord(8193, 3169);
        public TexGenCoord r = new TexGenCoord(8194, 3170);
        public TexGenCoord q = new TexGenCoord(8195, 3171);

        private TexGenState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class StencilState {
        public StencilFunc func = new StencilFunc();
        public int mask = -1;
        public int fail = 7680;
        public int zfail = 7680;
        public int zpass = 7680;

        private StencilState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class StencilFunc {
        public int func = 519;
        public int mask = -1;

        private StencilFunc() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class ClearState {
        public double depth = 1.0;
        public Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);

        private ClearState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class ColorLogicState {
        public BooleanState colorLogicOp = new BooleanState(3058);
        public int opcode = 5379;

        private ColorLogicState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class PolygonOffsetState {
        public BooleanState polygonOffsetFill = new BooleanState(32823);
        public BooleanState polygonOffsetLine = new BooleanState(10754);
        public float factor;
        public float units;

        private PolygonOffsetState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class CullState {
        public BooleanState cullFace = new BooleanState(2884);
        public int mode = 1029;

        private CullState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class FogState {
        public BooleanState fog = new BooleanState(2912);
        public int mode = 2048;
        public float density = 1.0f;
        public float start;
        public float end = 1.0f;

        private FogState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class DepthState {
        public BooleanState depthTest = new BooleanState(2929);
        public boolean maskEnabled = true;
        public int depthFunc = 513;

        private DepthState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class BlendState {
        public BooleanState blend = new BooleanState(3042);
        public int srcFactor = 1;
        public int dstFactor = 0;
        public int srcFactorAlpha = 1;
        public int dstFactorAlpha = 0;

        private BlendState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class ColorMaterialState {
        public BooleanState colorMaterial = new BooleanState(2903);
        public int face = 1032;
        public int mode = 5634;

        private ColorMaterialState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class AlphaState {
        public BooleanState alphaTest = new BooleanState(3008);
        public int func = 519;
        public float ref = -1.0f;

        private AlphaState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class TextureState {
        public BooleanState texture2DState = new BooleanState(3553);
        public int textureName;

        private TextureState() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum LogicOp {
        AND(5377),
        AND_INVERTED(5380),
        AND_REVERSE(5378),
        CLEAR(5376),
        COPY(5379),
        COPY_INVERTED(5388),
        EQUIV(5385),
        INVERT(5386),
        NAND(5390),
        NOOP(5381),
        NOR(5384),
        OR(5383),
        OR_INVERTED(5389),
        OR_REVERSE(5387),
        SET(5391),
        XOR(5382);

        public final int opcode;

        private LogicOp(int p_i46517_3_) {
            this.opcode = p_i46517_3_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum CullFace {
        FRONT(1028),
        BACK(1029),
        FRONT_AND_BACK(1032);

        public final int mode;

        private CullFace(int p_i46520_3_) {
            this.mode = p_i46520_3_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum FogMode {
        LINEAR(9729),
        EXP(2048),
        EXP2(2049);

        public final int capabilityId;

        private FogMode(int p_i46518_3_) {
            this.capabilityId = p_i46518_3_;
        }
    }
}

