/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ImageBufferDownload
implements IImageBuffer {
    private int[] imageData;
    private int imageWidth;
    private int imageHeight;

    @Override
    @Nullable
    public BufferedImage parseUserSkin(BufferedImage p_parseUserSkin_1_) {
        boolean lvt_4_1_;
        if (p_parseUserSkin_1_ == null) {
            return null;
        }
        this.imageWidth = 64;
        this.imageHeight = 64;
        BufferedImage lvt_2_1_ = new BufferedImage(this.imageWidth, this.imageHeight, 2);
        Graphics lvt_3_1_ = lvt_2_1_.getGraphics();
        lvt_3_1_.drawImage(p_parseUserSkin_1_, 0, 0, null);
        boolean bl = lvt_4_1_ = p_parseUserSkin_1_.getHeight() == 32;
        if (lvt_4_1_) {
            lvt_3_1_.setColor(new Color(0, 0, 0, 0));
            lvt_3_1_.fillRect(0, 32, 64, 32);
            lvt_3_1_.drawImage(lvt_2_1_, 24, 48, 20, 52, 4, 16, 8, 20, null);
            lvt_3_1_.drawImage(lvt_2_1_, 28, 48, 24, 52, 8, 16, 12, 20, null);
            lvt_3_1_.drawImage(lvt_2_1_, 20, 52, 16, 64, 8, 20, 12, 32, null);
            lvt_3_1_.drawImage(lvt_2_1_, 24, 52, 20, 64, 4, 20, 8, 32, null);
            lvt_3_1_.drawImage(lvt_2_1_, 28, 52, 24, 64, 0, 20, 4, 32, null);
            lvt_3_1_.drawImage(lvt_2_1_, 32, 52, 28, 64, 12, 20, 16, 32, null);
            lvt_3_1_.drawImage(lvt_2_1_, 40, 48, 36, 52, 44, 16, 48, 20, null);
            lvt_3_1_.drawImage(lvt_2_1_, 44, 48, 40, 52, 48, 16, 52, 20, null);
            lvt_3_1_.drawImage(lvt_2_1_, 36, 52, 32, 64, 48, 20, 52, 32, null);
            lvt_3_1_.drawImage(lvt_2_1_, 40, 52, 36, 64, 44, 20, 48, 32, null);
            lvt_3_1_.drawImage(lvt_2_1_, 44, 52, 40, 64, 40, 20, 44, 32, null);
            lvt_3_1_.drawImage(lvt_2_1_, 48, 52, 44, 64, 52, 20, 56, 32, null);
        }
        lvt_3_1_.dispose();
        this.imageData = ((DataBufferInt)lvt_2_1_.getRaster().getDataBuffer()).getData();
        this.setAreaOpaque(0, 0, 32, 16);
        if (lvt_4_1_) {
            this.setAreaTransparent(32, 0, 64, 32);
        }
        this.setAreaOpaque(0, 16, 64, 32);
        this.setAreaOpaque(16, 48, 48, 64);
        return lvt_2_1_;
    }

    @Override
    public void skinAvailable() {
    }

    private void setAreaTransparent(int p_setAreaTransparent_1_, int p_setAreaTransparent_2_, int p_setAreaTransparent_3_, int p_setAreaTransparent_4_) {
        for (int lvt_5_1_ = p_setAreaTransparent_1_; lvt_5_1_ < p_setAreaTransparent_3_; ++lvt_5_1_) {
            for (int lvt_6_1_ = p_setAreaTransparent_2_; lvt_6_1_ < p_setAreaTransparent_4_; ++lvt_6_1_) {
                int lvt_7_1_ = this.imageData[lvt_5_1_ + lvt_6_1_ * this.imageWidth];
                if ((lvt_7_1_ >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int lvt_5_2_ = p_setAreaTransparent_1_; lvt_5_2_ < p_setAreaTransparent_3_; ++lvt_5_2_) {
            for (int lvt_6_2_ = p_setAreaTransparent_2_; lvt_6_2_ < p_setAreaTransparent_4_; ++lvt_6_2_) {
                int n = lvt_5_2_ + lvt_6_2_ * this.imageWidth;
                this.imageData[n] = this.imageData[n] & 0xFFFFFF;
            }
        }
    }

    private void setAreaOpaque(int p_setAreaOpaque_1_, int p_setAreaOpaque_2_, int p_setAreaOpaque_3_, int p_setAreaOpaque_4_) {
        for (int lvt_5_1_ = p_setAreaOpaque_1_; lvt_5_1_ < p_setAreaOpaque_3_; ++lvt_5_1_) {
            for (int lvt_6_1_ = p_setAreaOpaque_2_; lvt_6_1_ < p_setAreaOpaque_4_; ++lvt_6_1_) {
                int n = lvt_5_1_ + lvt_6_1_ * this.imageWidth;
                this.imageData[n] = this.imageData[n] | 0xFF000000;
            }
        }
    }
}

